# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: udpa/core/v1/authority.proto, udpa/core/v1/context_params.proto, udpa/core/v1/resource_locator.proto, udpa/core/v1/collection_entry.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto

import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


class ResourceLocatorScheme(betterproto.Enum):
    UDPA = 0
    HTTP = 1
    FILE = 2


@dataclass
class Authority(betterproto.Message):
    """UDPA authority information."""

    name: str = betterproto.string_field(1)


@dataclass
class ContextParams(betterproto.Message):
    """Additional parameters that can be used to select resource variants."""

    params: Dict[str, str] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


@dataclass
class ResourceLocator(betterproto.Message):
    """
    UDPA resource locators identify a UDPA resource name and instruct the data-
    plane load balancer on how the resource may be located. Resource locators
    have a canonical udpa:// URI representation:
    udpa://{authority}/{type_url}/{id/*}?{context_params}{#directive,*} where
    context_params take the form of URI query parameters. Resource locators
    have a similar canonical http:// URI representation:
    http://{authority}/{type_url}/{id/*}?{context_params}{#directive,*}
    Resource locators also have a simplified file:// URI representation:
    file:///{id/*}{#directive,*}
    """

    # URI scheme.
    scheme: "ResourceLocatorScheme" = betterproto.enum_field(1)
    # Opaque identifiers for the resource. These are effectively concatenated
    # with ‘/’ to form the non-query param path as resource ID. This may end with
    # ‘*’ for glob collection references.
    id: List[str] = betterproto.string_field(2)
    # Logical authority for resource (not necessarily transport network address).
    # Authorities are opaque in the UDPA API, data-plane load balancers will map
    # them to concrete network transports such as an xDS management server, e.g.
    # via envoy.config.core.v3.ConfigSource.
    authority: str = betterproto.string_field(3)
    # Fully qualified resource type (as in type URL without types.googleapis.com/
    # prefix).
    resource_type: str = betterproto.string_field(4)
    # Additional parameters that can be used to select resource variants. Matches
    # must be exact, i.e. all context parameters must match exactly and there
    # must be no additional context parameters set on the matched resource.
    exact_context: "ContextParams" = betterproto.message_field(
        5, group="context_param_specifier"
    )
    # A list of directives that appear in the UDPA resource locator #fragment.
    # When encoding to URI form, directives are percent encoded with comma
    # separation.
    directives: List["ResourceLocatorDirective"] = betterproto.message_field(6)


@dataclass
class ResourceLocatorDirective(betterproto.Message):
    """
    Directives provide information to data-plane load balancers on how UDPA
    resource names are to be interpreted and potentially further resolved. For
    example, they may provide alternative resource locators for when primary
    resolution fails. Directives are not part of resource names and do not
    appear in a xDS transport discovery request. When encoding to URIs,
    directives take the form: <directive name>=<string representation of
    directive value> For example, we can have alt=udpa://foo/bar or
    entry=some%20thing. Each directive value type may have its own string
    encoding, in the case of ResourceLocator there is a recursive URI encoding.
    Percent encoding applies to the URI encoding of the directive value.
    Multiple directives are comma-separated, so the reserved characters that
    require percent encoding in a directive value are [',', '#', '[', ']',
    '%']. These are the RFC3986 fragment reserved characters with the addition
    of the UDPA scheme specific ','. See
    https://tools.ietf.org/html/rfc3986#page-49 for further details on URI ABNF
    and reserved characters.
    """

    # An alternative resource locator for fallback if the resource is
    # unavailable. For example, take the resource locator:   udpa://foo/some-
    # type/some-route-table#alt=udpa://bar/some-type/another-route-table If the
    # data-plane load balancer is unable to reach `foo` to fetch the resource, it
    # will fallback to `bar`. Alternative resources do not need to have
    # equivalent content, but they should be functional substitutes.
    alt: "ResourceLocator" = betterproto.message_field(1, group="directive")
    # List collections support inlining of resources via the entry field in
    # Resource. These inlined Resource objects may have an optional name field
    # specified. When specified, the entry directive allows UdpaResourceLocator
    # to directly reference these inlined resources, e.g.
    # udpa://.../foo#entry=bar.
    entry: str = betterproto.string_field(2, group="directive")


@dataclass
class CollectionEntry(betterproto.Message):
    """
    UDPA collection resource wrapper. This encapsulates a UDPA resource when
    appearing inside a list collection resource. List collection resources are
    regular Resource messages of type: message <T>Collection {   repeated
    CollectionEntry resources = 1; }
    """

    # A resource locator describing how the member resource is to be located.
    locator: "ResourceLocator" = betterproto.message_field(
        1, group="resource_specifier"
    )
    # The resource is inlined in the list collection.
    inline_entry: "CollectionEntryInlineEntry" = betterproto.message_field(
        2, group="resource_specifier"
    )


@dataclass
class CollectionEntryInlineEntry(betterproto.Message):
    """Inlined resource entry."""

    # Optional name to describe the inlined resource. Resource names must
    # [a-zA-Z0-9_-\./]+ (TODO(htuch): turn this into a PGV constraint once
    # finalized, probably should be a RFC3986 pchar). This name allows reference
    # via the #entry directive in ResourceLocator.
    name: str = betterproto.string_field(1)
    # The resource's logical version. It is illegal to have the same named UDPA
    # resource name at a given version with different resource payloads.
    version: str = betterproto.string_field(2)
    # The resource payload, including type URL.
    resource: betterproto_lib_google_protobuf.Any = betterproto.message_field(3)
