# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/tap/v3/tap.proto, envoy/service/tap/v3/tapds.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterable, AsyncIterator, Iterable, Optional, Union

import betterproto
import grpclib

from ....config.core import v3 as ___config_core_v3__
from ....config.tap import v3 as ___config_tap_v3__
from ....data.tap import v3 as ___data_tap_v3__
from ...discovery import v3 as __discovery_v3__


@dataclass
class StreamTapsRequest(betterproto.Message):
    """
    [#not-implemented-hide:] Stream message for the Tap API. Envoy will open a
    stream to the server and stream taps without ever expecting a response.
    """

    # Identifier data effectively is a structured metadata. As a performance
    # optimization this will only be sent in the first message on the stream.
    identifier: "StreamTapsRequestIdentifier" = betterproto.message_field(1)
    # The trace id. this can be used to merge together a streaming trace. Note
    # that the trace_id is not guaranteed to be spatially or temporally unique.
    trace_id: int = betterproto.uint64_field(2)
    # The trace data.
    trace: ___data_tap_v3__.TraceWrapper = betterproto.message_field(3)


@dataclass
class StreamTapsRequestIdentifier(betterproto.Message):
    # The node sending taps over the stream.
    node: ___config_core_v3__.Node = betterproto.message_field(1)
    # The opaque identifier that was set in the :ref:`output config
    # <envoy_api_field_config.tap.v3.StreamingGrpcSink.tap_id>`.
    tap_id: str = betterproto.string_field(2)


@dataclass
class StreamTapsResponse(betterproto.Message):
    """[#not-implemented-hide:]"""

    pass


@dataclass
class TapResource(betterproto.Message):
    """
    [#not-implemented-hide:] A tap resource is essentially a tap configuration
    with a name The filter TapDS config references this name.
    """

    # The name of the tap configuration.
    name: str = betterproto.string_field(1)
    # Tap config to apply
    config: ___config_tap_v3__.TapConfig = betterproto.message_field(2)


class TapSinkServiceStub(betterproto.ServiceStub):
    """
    [#not-implemented-hide:] A tap service to receive incoming taps. Envoy will
    call StreamTaps to deliver captured taps to the server
    """

    async def stream_taps(
        self,
        request_iterator: Union[
            AsyncIterable["StreamTapsRequest"], Iterable["StreamTapsRequest"]
        ],
    ) -> StreamTapsResponse:
        """
        Envoy will connect and send StreamTapsRequest messages forever. It does
        not expect any response to be sent as nothing would be done in the case
        of failure. The server should disconnect if it expects Envoy to
        reconnect.
        """

        return await self._stream_unary(
            "/envoy.service.tap.v3.TapSinkService/StreamTaps",
            request_iterator,
            StreamTapsRequest,
            StreamTapsResponse,
        )


class TapDiscoveryServiceStub(betterproto.ServiceStub):
    """[#not-implemented-hide:] Tap discovery service."""

    async def stream_tap_configs(
        self,
        request_iterator: Union[
            AsyncIterable["__discovery_v3__.DiscoveryRequest"],
            Iterable["__discovery_v3__.DiscoveryRequest"],
        ],
    ) -> AsyncIterator[__discovery_v3__.DiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.tap.v3.TapDiscoveryService/StreamTapConfigs",
            request_iterator,
            __discovery_v3__.DiscoveryRequest,
            __discovery_v3__.DiscoveryResponse,
        ):
            yield response

    async def delta_tap_configs(
        self,
        request_iterator: Union[
            AsyncIterable["__discovery_v3__.DeltaDiscoveryRequest"],
            Iterable["__discovery_v3__.DeltaDiscoveryRequest"],
        ],
    ) -> AsyncIterator[__discovery_v3__.DeltaDiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.tap.v3.TapDiscoveryService/DeltaTapConfigs",
            request_iterator,
            __discovery_v3__.DeltaDiscoveryRequest,
            __discovery_v3__.DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_tap_configs(self) -> __discovery_v3__.DiscoveryResponse:
        request = __discovery_v3__.DiscoveryRequest()

        return await self._unary_unary(
            "/envoy.service.tap.v3.TapDiscoveryService/FetchTapConfigs",
            request,
            __discovery_v3__.DiscoveryResponse,
        )
