# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/discovery/v2/hds.proto, envoy/service/discovery/v2/rtds.proto, envoy/service/discovery/v2/sds.proto, envoy/service/discovery/v2/ads.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import AsyncIterable, AsyncIterator, Iterable, List, Optional, Union

import betterproto
import grpclib

from ....api import v2 as ___api_v2__
from ....api.v2 import core as ___api_v2_core__
from ....api.v2 import endpoint as ___api_v2_endpoint__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


class CapabilityProtocol(betterproto.Enum):
    HTTP = 0
    TCP = 1
    REDIS = 2


@dataclass
class Capability(betterproto.Message):
    """
    Defines supported protocols etc, so the management server can assign proper
    endpoints to healthcheck.
    """

    health_check_protocols: List["CapabilityProtocol"] = betterproto.enum_field(1)


@dataclass
class HealthCheckRequest(betterproto.Message):
    node: ___api_v2_core__.Node = betterproto.message_field(1)
    capability: "Capability" = betterproto.message_field(2)


@dataclass
class EndpointHealth(betterproto.Message):
    endpoint: ___api_v2_endpoint__.Endpoint = betterproto.message_field(1)
    health_status: ___api_v2_core__.HealthStatus = betterproto.enum_field(2)


@dataclass
class EndpointHealthResponse(betterproto.Message):
    endpoints_health: List["EndpointHealth"] = betterproto.message_field(1)


@dataclass
class HealthCheckRequestOrEndpointHealthResponse(betterproto.Message):
    health_check_request: "HealthCheckRequest" = betterproto.message_field(
        1, group="request_type"
    )
    endpoint_health_response: "EndpointHealthResponse" = betterproto.message_field(
        2, group="request_type"
    )


@dataclass
class LocalityEndpoints(betterproto.Message):
    locality: ___api_v2_core__.Locality = betterproto.message_field(1)
    endpoints: List[___api_v2_endpoint__.Endpoint] = betterproto.message_field(2)


@dataclass
class ClusterHealthCheck(betterproto.Message):
    """
    The cluster name and locality is provided to Envoy for the endpoints that
    it health checks to support statistics reporting, logging and debugging by
    the Envoy instance (outside of HDS). For maximum usefulness, it should
    match the same cluster structure as that provided by EDS.
    """

    cluster_name: str = betterproto.string_field(1)
    health_checks: List[___api_v2_core__.HealthCheck] = betterproto.message_field(2)
    locality_endpoints: List["LocalityEndpoints"] = betterproto.message_field(3)


@dataclass
class HealthCheckSpecifier(betterproto.Message):
    cluster_health_checks: List["ClusterHealthCheck"] = betterproto.message_field(1)
    # The default is 1 second.
    interval: timedelta = betterproto.message_field(2)


@dataclass
class RtdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


@dataclass
class Runtime(betterproto.Message):
    """
    RTDS resource type. This describes a layer in the runtime virtual
    filesystem.
    """

    # Runtime resource name. This makes the Runtime a self-describing xDS
    # resource.
    name: str = betterproto.string_field(1)
    layer: betterproto_lib_google_protobuf.Struct = betterproto.message_field(2)


@dataclass
class SdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


@dataclass
class AdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


class HealthDiscoveryServiceStub(betterproto.ServiceStub):
    """
    HDS is Health Discovery Service. It compliments Envoy’s health checking
    service by designating this Envoy to be a healthchecker for a subset of
    hosts in the cluster. The status of these health checks will be reported to
    the management server, where it can be aggregated etc and redistributed
    back to Envoy through EDS.
    """

    async def stream_health_check(
        self,
        request_iterator: Union[
            AsyncIterable["HealthCheckRequestOrEndpointHealthResponse"],
            Iterable["HealthCheckRequestOrEndpointHealthResponse"],
        ],
    ) -> AsyncIterator[HealthCheckSpecifier]:
        """
        1. Envoy starts up and if its can_healthcheck option in the static
        bootstrap config is enabled, sends HealthCheckRequest to the management
        server. It supplies its capabilities (which protocol it can health
        check    with, what zone it resides in, etc.). 2. In response to (1),
        the management server designates this Envoy as a    healthchecker to
        health check a subset of all upstream hosts for a given    cluster (for
        example upstream Host 1 and Host 2). It streams    HealthCheckSpecifier
        messages with cluster related configuration for all    clusters this
        Envoy is designated to health check. Subsequent    HealthCheckSpecifier
        message will be sent on changes to:    a. Endpoints to health checks
        b. Per cluster configuration change 3. Envoy creates a health probe
        based on the HealthCheck config and sends    it to endpoint(ip:port) of
        Host 1 and 2. Based on the HealthCheck    configuration Envoy waits
        upon the arrival of the probe response and    looks at the content of
        the response to decide whether the endpoint is    healthy or not. If a
        response hasn't been received within the timeout    interval, the
        endpoint health status is considered TIMEOUT. 4. Envoy reports results
        back in an EndpointHealthResponse message.    Envoy streams responses
        as often as the interval configured by the    management server in
        HealthCheckSpecifier. 5. The management Server collects health statuses
        for all endpoints in the    cluster (for all clusters) and uses this
        information to construct    EndpointDiscoveryResponse messages. 6. Once
        Envoy has a list of upstream endpoints to send traffic to, it load
        balances traffic to them without additional health checking. It may
        use inline healthcheck (i.e. consider endpoint UNHEALTHY if connection
        failed to a particular endpoint to account for health status
        propagation    delay between HDS and EDS). By default, can_healthcheck
        is true. If can_healthcheck is false, Cluster configuration may not
        contain HealthCheck message. TODO(htuch): How is can_healthcheck
        communicated to CDS to ensure the above invariant? TODO(htuch): Add
        @amb67's diagram.
        """

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.HealthDiscoveryService/StreamHealthCheck",
            request_iterator,
            HealthCheckRequestOrEndpointHealthResponse,
            HealthCheckSpecifier,
        ):
            yield response

    async def fetch_health_check(
        self,
        *,
        health_check_request: Optional["HealthCheckRequest"] = None,
        endpoint_health_response: Optional["EndpointHealthResponse"] = None,
    ) -> HealthCheckSpecifier:
        """
        TODO(htuch): Unlike the gRPC version, there is no stream-based binding
        of request/response. Should we add an identifier to the
        HealthCheckSpecifier to bind with the response?
        """

        request = HealthCheckRequestOrEndpointHealthResponse()
        if health_check_request is not None:
            request.health_check_request = health_check_request
        if endpoint_health_response is not None:
            request.endpoint_health_response = endpoint_health_response

        return await self._unary_unary(
            "/envoy.service.discovery.v2.HealthDiscoveryService/FetchHealthCheck",
            request,
            HealthCheckSpecifier,
        )


class RuntimeDiscoveryServiceStub(betterproto.ServiceStub):
    """Discovery service for Runtime resources."""

    async def stream_runtime(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/StreamRuntime",
            request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
        ):
            yield response

    async def delta_runtime(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DeltaDiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/DeltaRuntime",
            request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
        ):
            yield response

    async def fetch_runtime(self) -> ___api_v2__.DiscoveryResponse:
        request = ___api_v2__.DiscoveryRequest()

        return await self._unary_unary(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/FetchRuntime",
            request,
            ___api_v2__.DiscoveryResponse,
        )


class SecretDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_secrets(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DeltaDiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.SecretDiscoveryService/DeltaSecrets",
            request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
        ):
            yield response

    async def stream_secrets(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.SecretDiscoveryService/StreamSecrets",
            request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
        ):
            yield response

    async def fetch_secrets(self) -> ___api_v2__.DiscoveryResponse:
        request = ___api_v2__.DiscoveryRequest()

        return await self._unary_unary(
            "/envoy.service.discovery.v2.SecretDiscoveryService/FetchSecrets",
            request,
            ___api_v2__.DiscoveryResponse,
        )


class AggregatedDiscoveryServiceStub(betterproto.ServiceStub):
    """
    See https://github.com/lyft/envoy-api#apis for a description of the role of
    ADS and how it is intended to be used by a management server. ADS requests
    have the same structure as their singleton xDS counterparts, but can
    multiplex many resource types on a single stream. The type_url in the
    DiscoveryRequest/DiscoveryResponse provides sufficient information to
    recover the multiplexed singleton APIs at the Envoy instance and management
    server.
    """

    async def stream_aggregated_resources(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DiscoveryResponse]:
        """This is a gRPC-only API."""

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/StreamAggregatedResources",
            request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
        ):
            yield response

    async def delta_aggregated_resources(
        self,
        request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
    ) -> AsyncIterator[___api_v2__.DeltaDiscoveryResponse]:

        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/DeltaAggregatedResources",
            request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
        ):
            yield response
