# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/core/socket_option.proto, envoy/api/v2/core/address.proto, envoy/api/v2/core/backoff.proto, envoy/api/v2/core/http_uri.proto, envoy/api/v2/core/base.proto, envoy/api/v2/core/grpc_service.proto, envoy/api/v2/core/config_source.proto, envoy/api/v2/core/event_service_config.proto, envoy/api/v2/core/health_check.proto, envoy/api/v2/core/protocol.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Dict, List, Optional

import betterproto

from .... import type as ___type__
from ....type import matcher as ___type_matcher__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


class SocketOptionSocketState(betterproto.Enum):
    STATE_PREBIND = 0
    STATE_BOUND = 1
    STATE_LISTENING = 2


class SocketAddressProtocol(betterproto.Enum):
    TCP = 0
    UDP = 1


class RoutingPriority(betterproto.Enum):
    """
    Envoy supports :ref:`upstream priority routing
    <arch_overview_http_routing_priority>` both at the route and the virtual
    cluster level. The current priority implementation uses different
    connection pool and circuit breaking settings for each priority level. This
    means that even for HTTP/2 requests, two physical connections will be used
    to an upstream host. In the future Envoy will likely support true HTTP/2
    priority over a single upstream connection.
    """

    DEFAULT = 0
    HIGH = 1


class RequestMethod(betterproto.Enum):
    """HTTP request method."""

    METHOD_UNSPECIFIED = 0
    GET = 1
    HEAD = 2
    POST = 3
    PUT = 4
    DELETE = 5
    CONNECT = 6
    OPTIONS = 7
    TRACE = 8
    PATCH = 9


class TrafficDirection(betterproto.Enum):
    """Identifies the direction of the traffic relative to the local Envoy."""

    # Default option is unspecified.
    UNSPECIFIED = 0
    # The transport is used for incoming traffic.
    INBOUND = 1
    # The transport is used for outgoing traffic.
    OUTBOUND = 2


class ApiVersion(betterproto.Enum):
    """
    xDS API version. This is used to describe both resource and transport
    protocol versions (in distinct configuration fields).
    """

    # When not specified, we assume v2, to ease migration to Envoy's stable API
    # versioning. If a client does not support v2 (e.g. due to deprecation), this
    # is an invalid value.
    AUTO = 0
    # Use xDS v2 API.
    V2 = 1
    # Use xDS v3 API.
    V3 = 2


class ApiConfigSourceApiType(betterproto.Enum):
    UNSUPPORTED_REST_LEGACY = 0
    REST = 1
    GRPC = 2
    DELTA_GRPC = 3


class HealthStatus(betterproto.Enum):
    """Endpoint health status."""

    # The health status is not known. This is interpreted by Envoy as *HEALTHY*.
    UNKNOWN = 0
    # Healthy.
    HEALTHY = 1
    # Unhealthy.
    UNHEALTHY = 2
    # Connection draining in progress. E.g.,
    # `<https://aws.amazon.com/blogs/aws/elb-connection-draining-remove-
    # instances-from-service-with-care/>`_ or
    # `<https://cloud.google.com/compute/docs/load-balancing/enabling-connection-
    # draining>`_. This is interpreted by Envoy as *UNHEALTHY*.
    DRAINING = 3
    # Health check timed out. This is part of HDS and is interpreted by Envoy as
    # *UNHEALTHY*.
    TIMEOUT = 4
    # Degraded.
    DEGRADED = 5


class HttpProtocolOptionsHeadersWithUnderscoresAction(betterproto.Enum):
    ALLOW = 0
    REJECT_REQUEST = 1
    DROP_HEADER = 2


@dataclass
class SocketOption(betterproto.Message):
    """
    Generic socket option message. This would be used to set socket options
    that might not exist in upstream kernels or precompiled Envoy binaries.
    [#next-free-field: 7]
    """

    # An optional name to give this socket option for debugging, etc. Uniqueness
    # is not required and no special meaning is assumed.
    description: str = betterproto.string_field(1)
    # Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
    level: int = betterproto.int64_field(2)
    # The numeric name as passed to setsockopt
    name: int = betterproto.int64_field(3)
    # Because many sockopts take an int value.
    int_value: int = betterproto.int64_field(4, group="value")
    # Otherwise it's a byte buffer.
    buf_value: bytes = betterproto.bytes_field(5, group="value")
    # The state in which the option will be applied. When used in BindConfig
    # STATE_PREBIND is currently the only valid value.
    state: "SocketOptionSocketState" = betterproto.enum_field(6)


@dataclass
class Pipe(betterproto.Message):
    # Unix Domain Socket path. On Linux, paths starting with '@' will use the
    # abstract namespace. The starting '@' is replaced by a null byte by Envoy.
    # Paths starting with '@' will result in an error in environments other than
    # Linux.
    path: str = betterproto.string_field(1)
    # The mode for the Pipe. Not applicable for abstract sockets.
    mode: int = betterproto.uint32_field(2)


@dataclass
class SocketAddress(betterproto.Message):
    """[#next-free-field: 7]"""

    protocol: "SocketAddressProtocol" = betterproto.enum_field(1)
    # The address for this socket. :ref:`Listeners <config_listeners>` will bind
    # to the address. An empty address is not allowed. Specify ``0.0.0.0`` or
    # ``::`` to bind to any address. [#comment:TODO(zuercher) reinstate when
    # implemented: It is possible to distinguish a Listener address via the
    # prefix/suffix matching in :ref:`FilterChainMatch
    # <envoy_api_msg_listener.FilterChainMatch>`.] When used within an upstream
    # :ref:`BindConfig <envoy_api_msg_core.BindConfig>`, the address controls the
    # source address of outbound connections. For :ref:`clusters
    # <envoy_api_msg_Cluster>`, the cluster type determines whether the address
    # must be an IP (*STATIC* or *EDS* clusters) or a hostname resolved by DNS
    # (*STRICT_DNS* or *LOGICAL_DNS* clusters). Address resolution can be
    # customized via :ref:`resolver_name
    # <envoy_api_field_core.SocketAddress.resolver_name>`.
    address: str = betterproto.string_field(2)
    port_value: int = betterproto.uint32_field(3, group="port_specifier")
    # This is only valid if :ref:`resolver_name
    # <envoy_api_field_core.SocketAddress.resolver_name>` is specified below and
    # the named resolver is capable of named port resolution.
    named_port: str = betterproto.string_field(4, group="port_specifier")
    # The name of the custom resolver. This must have been registered with Envoy.
    # If this is empty, a context dependent default applies. If the address is a
    # concrete IP address, no resolution will occur. If address is a hostname
    # this should be set for resolution other than DNS. Specifying a custom
    # resolver with *STRICT_DNS* or *LOGICAL_DNS* will generate an error at
    # runtime.
    resolver_name: str = betterproto.string_field(5)
    # When binding to an IPv6 address above, this enables `IPv4 compatibility
    # <https://tools.ietf.org/html/rfc3493#page-11>`_. Binding to ``::`` will
    # allow both IPv4 and IPv6 connections, with peer IPv4 addresses mapped into
    # IPv6 space as ``::FFFF:<IPv4-address>``.
    ipv4_compat: bool = betterproto.bool_field(6)


@dataclass
class TcpKeepalive(betterproto.Message):
    # Maximum number of keepalive probes to send without response before deciding
    # the connection is dead. Default is to use the OS level configuration
    # (unless overridden, Linux defaults to 9.)
    keepalive_probes: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # The number of seconds a connection needs to be idle before keep-alive
    # probes start being sent. Default is to use the OS level configuration
    # (unless overridden, Linux defaults to 7200s (i.e., 2 hours.)
    keepalive_time: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # The number of seconds between keep-alive probes. Default is to use the OS
    # level configuration (unless overridden, Linux defaults to 75s.)
    keepalive_interval: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )


@dataclass
class BindConfig(betterproto.Message):
    # The address to bind to when creating a socket.
    source_address: "SocketAddress" = betterproto.message_field(1)
    # Whether to set the *IP_FREEBIND* option when creating the socket. When this
    # flag is set to true, allows the :ref:`source_address
    # <envoy_api_field_UpstreamBindConfig.source_address>` to be an IP address
    # that is not configured on the system running Envoy. When this flag is set
    # to false, the option *IP_FREEBIND* is disabled on the socket. When this
    # flag is not set (default), the socket is not modified, i.e. the option is
    # neither enabled nor disabled.
    freebind: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)
    # Additional socket options that may not be present in Envoy source code or
    # precompiled binaries.
    socket_options: List["SocketOption"] = betterproto.message_field(3)


@dataclass
class Address(betterproto.Message):
    """
    Addresses specify either a logical or physical address and port, which are
    used to tell Envoy where to bind/listen, connect to upstream and find
    management servers.
    """

    socket_address: "SocketAddress" = betterproto.message_field(1, group="address")
    pipe: "Pipe" = betterproto.message_field(2, group="address")


@dataclass
class CidrRange(betterproto.Message):
    """
    CidrRange specifies an IP Address and a prefix length to construct the
    subnet mask for a `CIDR <https://tools.ietf.org/html/rfc4632>`_ range.
    """

    # IPv4 or IPv6 address, e.g. ``192.0.0.0`` or ``2001:db8::``.
    address_prefix: str = betterproto.string_field(1)
    # Length of prefix, e.g. 0, 32.
    prefix_len: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )


@dataclass
class BackoffStrategy(betterproto.Message):
    """Configuration defining a jittered exponential back off strategy."""

    # The base interval to be used for the next back off computation. It should
    # be greater than zero and less than or equal to :ref:`max_interval
    # <envoy_api_field_core.BackoffStrategy.max_interval>`.
    base_interval: timedelta = betterproto.message_field(1)
    # Specifies the maximum interval between retries. This parameter is optional,
    # but must be greater than or equal to the :ref:`base_interval
    # <envoy_api_field_core.BackoffStrategy.base_interval>` if set. The default
    # is 10 times the :ref:`base_interval
    # <envoy_api_field_core.BackoffStrategy.base_interval>`.
    max_interval: timedelta = betterproto.message_field(2)


@dataclass
class HttpUri(betterproto.Message):
    """Envoy external URI descriptor"""

    # The HTTP server URI. It should be a full FQDN with protocol, host and path.
    # Example: .. code-block:: yaml    uri:
    # https://www.googleapis.com/oauth2/v1/certs
    uri: str = betterproto.string_field(1)
    # A cluster is created in the Envoy "cluster_manager" config section. This
    # field specifies the cluster name. Example: .. code-block:: yaml    cluster:
    # jwks_cluster
    cluster: str = betterproto.string_field(2, group="http_upstream_type")
    # Sets the maximum duration in milliseconds that a response can take to
    # arrive upon request.
    timeout: timedelta = betterproto.message_field(3)


@dataclass
class Locality(betterproto.Message):
    """
    Identifies location of where either Envoy runs or where upstream hosts run.
    """

    # Region this :ref:`zone <envoy_api_field_core.Locality.zone>` belongs to.
    region: str = betterproto.string_field(1)
    # Defines the local service zone where Envoy is running. Though optional, it
    # should be set if discovery service routing is used and the discovery
    # service exposes :ref:`zone data
    # <envoy_api_field_endpoint.LocalityLbEndpoints.locality>`, either in this
    # message or via :option:`--service-zone`. The meaning of zone is context
    # dependent, e.g. `Availability Zone (AZ)
    # <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-
    # availability-zones.html>`_ on AWS, `Zone
    # <https://cloud.google.com/compute/docs/regions-zones/>`_ on GCP, etc.
    zone: str = betterproto.string_field(2)
    # When used for locality of upstream hosts, this field further splits zone
    # into smaller chunks of sub-zones so they can be load balanced
    # independently.
    sub_zone: str = betterproto.string_field(3)


@dataclass
class BuildVersion(betterproto.Message):
    """
    BuildVersion combines SemVer version of extension with free-form build
    information (i.e. 'alpha', 'private-build') as a set of strings.
    """

    # SemVer version of extension.
    version: ___type__.SemanticVersion = betterproto.message_field(1)
    # Free-form build information. Envoy defines several well known keys in the
    # source/common/version/version.h file
    metadata: betterproto_lib_google_protobuf.Struct = betterproto.message_field(2)


@dataclass
class Extension(betterproto.Message):
    """
    Version and identification for an Envoy extension. [#next-free-field: 6]
    """

    # This is the name of the Envoy filter as specified in the Envoy
    # configuration, e.g. envoy.filters.http.router, com.acme.widget.
    name: str = betterproto.string_field(1)
    # Category of the extension. Extension category names use reverse DNS
    # notation. For instance "envoy.filters.listener" for Envoy's built-in
    # listener filters or "com.acme.filters.http" for HTTP filters from acme.com
    # vendor. [#comment:TODO(yanavlasov): Link to the doc with existing envoy
    # category names.]
    category: str = betterproto.string_field(2)
    # [#not-implemented-hide:] Type descriptor of extension configuration proto.
    # [#comment:TODO(yanavlasov): Link to the doc with existing configuration
    # protos.] [#comment:TODO(yanavlasov): Add tests when PR #9391 lands.]
    type_descriptor: str = betterproto.string_field(3)
    # The version is a property of the extension and maintained independently of
    # other extensions and the Envoy API. This field is not set when extension
    # did not provide version information.
    version: "BuildVersion" = betterproto.message_field(4)
    # Indicates that the extension is present but was disabled via dynamic
    # configuration.
    disabled: bool = betterproto.bool_field(5)


@dataclass
class Node(betterproto.Message):
    """
    Identifies a specific Envoy instance. The node identifier is presented to
    the management server, which may use this identifier to distinguish per
    Envoy configuration for serving. [#next-free-field: 12]
    """

    # An opaque node identifier for the Envoy node. This also provides the local
    # service node name. It should be set if any of the following features are
    # used: :ref:`statsd <arch_overview_statistics>`, :ref:`CDS
    # <config_cluster_manager_cds>`, and :ref:`HTTP tracing
    # <arch_overview_tracing>`, either in this message or via :option:`--service-
    # node`.
    id: str = betterproto.string_field(1)
    # Defines the local service cluster name where Envoy is running. Though
    # optional, it should be set if any of the following features are used:
    # :ref:`statsd <arch_overview_statistics>`, :ref:`health check cluster
    # verification
    # <envoy_api_field_core.HealthCheck.HttpHealthCheck.service_name_matcher>`,
    # :ref:`runtime override directory
    # <envoy_api_msg_config.bootstrap.v2.Runtime>`, :ref:`user agent addition <en
    # voy_api_field_config.filter.network.http_connection_manager.v2.HttpConnecti
    # onManager.add_user_agent>`, :ref:`HTTP global rate limiting
    # <config_http_filters_rate_limit>`, :ref:`CDS <config_cluster_manager_cds>`,
    # and :ref:`HTTP tracing <arch_overview_tracing>`, either in this message or
    # via :option:`--service-cluster`.
    cluster: str = betterproto.string_field(2)
    # Opaque metadata extending the node identifier. Envoy will pass this
    # directly to the management server.
    metadata: betterproto_lib_google_protobuf.Struct = betterproto.message_field(3)
    # Locality specifying where the Envoy instance is running.
    locality: "Locality" = betterproto.message_field(4)
    # This is motivated by informing a management server during canary which
    # version of Envoy is being tested in a heterogeneous fleet. This will be set
    # by Envoy in management server RPCs. This field is deprecated in favor of
    # the user_agent_name and user_agent_version values.
    build_version: str = betterproto.string_field(5)
    # Free-form string that identifies the entity requesting config. E.g. "envoy"
    # or "grpc"
    user_agent_name: str = betterproto.string_field(6)
    # Free-form string that identifies the version of the entity requesting
    # config. E.g. "1.12.2" or "abcd1234", or "SpecialEnvoyBuild"
    user_agent_version: str = betterproto.string_field(
        7, group="user_agent_version_type"
    )
    # Structured version of the entity requesting config.
    user_agent_build_version: "BuildVersion" = betterproto.message_field(
        8, group="user_agent_version_type"
    )
    # List of extensions and their versions supported by the node.
    extensions: List["Extension"] = betterproto.message_field(9)
    # Client feature support list. These are well known features described in the
    # Envoy API repository for a given major version of an API. Client features
    # use reverse DNS naming scheme, for example `com.acme.feature`. See
    # :ref:`the list of features <client_features>` that xDS client may support.
    client_features: List[str] = betterproto.string_field(10)
    # Known listening ports on the node as a generic hint to the management
    # server for filtering :ref:`listeners <config_listeners>` to be returned.
    # For example, if there is a listener bound to port 80, the list can
    # optionally contain the SocketAddress `(0.0.0.0,80)`. The field is optional
    # and just a hint.
    listening_addresses: List["Address"] = betterproto.message_field(11)


@dataclass
class Metadata(betterproto.Message):
    """
    Metadata provides additional inputs to filters based on matched listeners,
    filter chains, routes and endpoints. It is structured as a map, usually
    from filter name (in reverse DNS format) to metadata specific to the
    filter. Metadata key-values for a filter are merged as connection and
    request handling occurs, with later values for the same key overriding
    earlier values. An example use of metadata is providing additional values
    to http_connection_manager in the envoy.http_connection_manager.access_log
    namespace. Another example use of metadata is to per service config info in
    cluster metadata, which may get consumed by multiple filters. For load
    balancing, Metadata provides a means to subset cluster endpoints. Endpoints
    have a Metadata object associated and routes contain a Metadata object to
    match against. There are some well defined metadata used today for this
    purpose: * ``{"envoy.lb": {"canary": <bool> }}`` This indicates the canary
    status of an   endpoint and is also used during header processing
    (x-envoy-upstream-canary) and for stats purposes. [#next-major-version:
    move to type/metadata/v2]
    """

    # Key is the reverse DNS filter name, e.g. com.acme.widget. The envoy.*
    # namespace is reserved for Envoy's built-in filters.
    filter_metadata: Dict[
        str, betterproto_lib_google_protobuf.Struct
    ] = betterproto.map_field(1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)


@dataclass
class RuntimeUInt32(betterproto.Message):
    """Runtime derived uint32 with a default when not specified."""

    # Default value if runtime value is not available.
    default_value: int = betterproto.uint32_field(2)
    # Runtime key to get value for comparison. This value is used if defined.
    runtime_key: str = betterproto.string_field(3)


@dataclass
class RuntimeDouble(betterproto.Message):
    """Runtime derived double with a default when not specified."""

    # Default value if runtime value is not available.
    default_value: float = betterproto.double_field(1)
    # Runtime key to get value for comparison. This value is used if defined.
    runtime_key: str = betterproto.string_field(2)


@dataclass
class RuntimeFeatureFlag(betterproto.Message):
    """Runtime derived bool with a default when not specified."""

    # Default value if runtime value is not available.
    default_value: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    # Runtime key to get value for comparison. This value is used if defined. The
    # boolean value must be represented via its `canonical JSON encoding
    # <https://developers.google.com/protocol-buffers/docs/proto3#json>`_.
    runtime_key: str = betterproto.string_field(2)


@dataclass
class HeaderValue(betterproto.Message):
    """Header name/value pair."""

    # Header name.
    key: str = betterproto.string_field(1)
    # Header value. The same :ref:`format specifier <config_access_log_format>`
    # as used for :ref:`HTTP access logging <config_access_log>` applies here,
    # however unknown header values are replaced with the empty string instead of
    # `-`.
    value: str = betterproto.string_field(2)


@dataclass
class HeaderValueOption(betterproto.Message):
    """Header name/value pair plus option to control append behavior."""

    # Header name/value pair that this option applies to.
    header: "HeaderValue" = betterproto.message_field(1)
    # Should the value be appended? If true (default), the value is appended to
    # existing values.
    append: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)


@dataclass
class HeaderMap(betterproto.Message):
    """Wrapper for a set of headers."""

    headers: List["HeaderValue"] = betterproto.message_field(1)


@dataclass
class DataSource(betterproto.Message):
    """Data source consisting of either a file or an inline value."""

    # Local filesystem data source.
    filename: str = betterproto.string_field(1, group="specifier")
    # Bytes inlined in the configuration.
    inline_bytes: bytes = betterproto.bytes_field(2, group="specifier")
    # String inlined in the configuration.
    inline_string: str = betterproto.string_field(3, group="specifier")


@dataclass
class RetryPolicy(betterproto.Message):
    """
    The message specifies the retry policy of remote data source when fetching
    fails.
    """

    # Specifies parameters that control :ref:`retry backoff strategy
    # <envoy_api_msg_core.BackoffStrategy>`. This parameter is optional, in which
    # case the default base interval is 1000 milliseconds. The default maximum
    # interval is 10 times the base interval.
    retry_back_off: "BackoffStrategy" = betterproto.message_field(1)
    # Specifies the allowed number of retries. This parameter is optional and
    # defaults to 1.
    num_retries: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )


@dataclass
class RemoteDataSource(betterproto.Message):
    """
    The message specifies how to fetch data from remote and how to verify it.
    """

    # The HTTP URI to fetch the remote data.
    http_uri: "HttpUri" = betterproto.message_field(1)
    # SHA256 string for verifying data.
    sha256: str = betterproto.string_field(2)
    # Retry policy for fetching remote data.
    retry_policy: "RetryPolicy" = betterproto.message_field(3)


@dataclass
class AsyncDataSource(betterproto.Message):
    """Async data source which support async data fetch."""

    # Local async data source.
    local: "DataSource" = betterproto.message_field(1, group="specifier")
    # Remote async data source.
    remote: "RemoteDataSource" = betterproto.message_field(2, group="specifier")


@dataclass
class TransportSocket(betterproto.Message):
    """
    Configuration for transport socket in :ref:`listeners <config_listeners>`
    and :ref:`clusters <envoy_api_msg_Cluster>`. If the configuration is empty,
    a default transport socket implementation and configuration will be chosen
    based on the platform and existence of tls_context.
    """

    # The name of the transport socket to instantiate. The name must match a
    # supported transport socket implementation.
    name: str = betterproto.string_field(1)
    config: betterproto_lib_google_protobuf.Struct = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: betterproto_lib_google_protobuf.Any = betterproto.message_field(
        3, group="config_type"
    )


@dataclass
class RuntimeFractionalPercent(betterproto.Message):
    """
    Runtime derived FractionalPercent with defaults for when the numerator or
    denominator is not specified via a runtime key. .. note::   Parsing of the
    runtime key's data is implemented such that it may be represented as a
    :ref:`FractionalPercent <envoy_api_msg_type.FractionalPercent>` proto
    represented as JSON/YAML   and may also be represented as an integer with
    the assumption that the value is an integral   percentage out of 100. For
    instance, a runtime key lookup returning the value "42" would parse   as a
    `FractionalPercent` whose numerator is 42 and denominator is HUNDRED.
    """

    # Default value if the runtime value's for the numerator/denominator keys are
    # not available.
    default_value: ___type__.FractionalPercent = betterproto.message_field(1)
    # Runtime key for a YAML representation of a FractionalPercent.
    runtime_key: str = betterproto.string_field(2)


@dataclass
class ControlPlane(betterproto.Message):
    """
    Identifies a specific ControlPlane instance that Envoy is connected to.
    """

    # An opaque control plane identifier that uniquely identifies an instance of
    # control plane. This can be used to identify which control plane instance,
    # the Envoy is connected to.
    identifier: str = betterproto.string_field(1)


@dataclass
class GrpcService(betterproto.Message):
    """
    gRPC service configuration. This is used by :ref:`ApiConfigSource
    <envoy_api_msg_core.ApiConfigSource>` and filter configurations. [#next-
    free-field: 6]
    """

    # Envoy's in-built gRPC client. See the :ref:`gRPC services overview
    # <arch_overview_grpc_services>` documentation for discussion on gRPC client
    # selection.
    envoy_grpc: "GrpcServiceEnvoyGrpc" = betterproto.message_field(
        1, group="target_specifier"
    )
    # `Google C++ gRPC client <https://github.com/grpc/grpc>`_ See the :ref:`gRPC
    # services overview <arch_overview_grpc_services>` documentation for
    # discussion on gRPC client selection.
    google_grpc: "GrpcServiceGoogleGrpc" = betterproto.message_field(
        2, group="target_specifier"
    )
    # The timeout for the gRPC request. This is the timeout for a specific
    # request.
    timeout: timedelta = betterproto.message_field(3)
    # Additional metadata to include in streams initiated to the GrpcService.
    # This can be used for scenarios in which additional ad hoc authorization
    # headers (e.g. ``x-foo-bar: baz-key``) are to be injected.
    initial_metadata: List["HeaderValue"] = betterproto.message_field(5)


@dataclass
class GrpcServiceEnvoyGrpc(betterproto.Message):
    # The name of the upstream gRPC cluster. SSL credentials will be supplied in
    # the :ref:`Cluster <envoy_api_msg_Cluster>` :ref:`transport_socket
    # <envoy_api_field_Cluster.transport_socket>`.
    cluster_name: str = betterproto.string_field(1)


@dataclass
class GrpcServiceGoogleGrpc(betterproto.Message):
    """[#next-free-field: 7]"""

    # The target URI when using the `Google C++ gRPC client
    # <https://github.com/grpc/grpc>`_. SSL credentials will be supplied in
    # :ref:`channel_credentials
    # <envoy_api_field_core.GrpcService.GoogleGrpc.channel_credentials>`.
    target_uri: str = betterproto.string_field(1)
    channel_credentials: "GrpcServiceGoogleGrpcChannelCredentials" = betterproto.message_field(
        2
    )
    # A set of call credentials that can be composed with `channel credentials
    # <https://grpc.io/docs/guides/auth.html#credential-types>`_.
    call_credentials: List[
        "GrpcServiceGoogleGrpcCallCredentials"
    ] = betterproto.message_field(3)
    # The human readable prefix to use when emitting statistics for the gRPC
    # service. .. csv-table::    :header: Name, Type, Description    :widths: 1,
    # 1, 2    streams_total, Counter, Total number of streams opened
    # streams_closed_<gRPC status code>, Counter, Total streams closed with <gRPC
    # status code>
    stat_prefix: str = betterproto.string_field(4)
    # The name of the Google gRPC credentials factory to use. This must have been
    # registered with Envoy. If this is empty, a default credentials factory will
    # be used that sets up channel credentials based on other configuration
    # parameters.
    credentials_factory_name: str = betterproto.string_field(5)
    # Additional configuration for site-specific customizations of the Google
    # gRPC library.
    config: betterproto_lib_google_protobuf.Struct = betterproto.message_field(6)


@dataclass
class GrpcServiceGoogleGrpcSslCredentials(betterproto.Message):
    """
    See https://grpc.io/grpc/cpp/structgrpc_1_1_ssl_credentials_options.html.
    """

    # PEM encoded server root certificates.
    root_certs: "DataSource" = betterproto.message_field(1)
    # PEM encoded client private key.
    private_key: "DataSource" = betterproto.message_field(2)
    # PEM encoded client certificate chain.
    cert_chain: "DataSource" = betterproto.message_field(3)


@dataclass
class GrpcServiceGoogleGrpcGoogleLocalCredentials(betterproto.Message):
    """
    Local channel credentials. Only UDS is supported for now. See
    https://github.com/grpc/grpc/pull/15909.
    """

    pass


@dataclass
class GrpcServiceGoogleGrpcChannelCredentials(betterproto.Message):
    """
    See https://grpc.io/docs/guides/auth.html#credential-types to understand
    Channel and Call credential types.
    """

    ssl_credentials: "GrpcServiceGoogleGrpcSslCredentials" = betterproto.message_field(
        1, group="credential_specifier"
    )
    # https://grpc.io/grpc/cpp/namespacegrpc.html#a6beb3ac70ff94bd2ebbd89b8f21d1f
    # 61
    google_default: betterproto_lib_google_protobuf.Empty = betterproto.message_field(
        2, group="credential_specifier"
    )
    local_credentials: "GrpcServiceGoogleGrpcGoogleLocalCredentials" = betterproto.message_field(
        3, group="credential_specifier"
    )


@dataclass
class GrpcServiceGoogleGrpcCallCredentials(betterproto.Message):
    """[#next-free-field: 8]"""

    # Access token credentials. https://grpc.io/grpc/cpp/namespacegrpc.html#ad3a8
    # 0da696ffdaea943f0f858d7a360d.
    access_token: str = betterproto.string_field(1, group="credential_specifier")
    # Google Compute Engine credentials. https://grpc.io/grpc/cpp/namespacegrpc.h
    # tml#a6beb3ac70ff94bd2ebbd89b8f21d1f61
    google_compute_engine: betterproto_lib_google_protobuf.Empty = betterproto.message_field(
        2, group="credential_specifier"
    )
    # Google refresh token credentials. https://grpc.io/grpc/cpp/namespacegrpc.ht
    # ml#a96901c997b91bc6513b08491e0dca37c.
    google_refresh_token: str = betterproto.string_field(
        3, group="credential_specifier"
    )
    # Service Account JWT Access credentials. https://grpc.io/grpc/cpp/namespaceg
    # rpc.html#a92a9f959d6102461f66ee973d8e9d3aa.
    service_account_jwt_access: "GrpcServiceGoogleGrpcCallCredentialsServiceAccountJwtAccessCredentials" = betterproto.message_field(
        4, group="credential_specifier"
    )
    # Google IAM credentials. https://grpc.io/grpc/cpp/namespacegrpc.html#a9fc1fc
    # 101b41e680d47028166e76f9d0.
    google_iam: "GrpcServiceGoogleGrpcCallCredentialsGoogleIamCredentials" = betterproto.message_field(
        5, group="credential_specifier"
    )
    # Custom authenticator credentials. https://grpc.io/grpc/cpp/namespacegrpc.ht
    # ml#a823c6a4b19ffc71fb33e90154ee2ad07.
    # https://grpc.io/docs/guides/auth.html#extending-grpc-to-support-other-
    # authentication-mechanisms.
    from_plugin: "GrpcServiceGoogleGrpcCallCredentialsMetadataCredentialsFromPlugin" = betterproto.message_field(
        6, group="credential_specifier"
    )
    # Custom security token service which implements OAuth 2.0 token exchange.
    # https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-16 See
    # https://github.com/grpc/grpc/pull/19587.
    sts_service: "GrpcServiceGoogleGrpcCallCredentialsStsService" = betterproto.message_field(
        7, group="credential_specifier"
    )


@dataclass
class GrpcServiceGoogleGrpcCallCredentialsServiceAccountJwtAccessCredentials(
    betterproto.Message
):
    json_key: str = betterproto.string_field(1)
    token_lifetime_seconds: int = betterproto.uint64_field(2)


@dataclass
class GrpcServiceGoogleGrpcCallCredentialsGoogleIamCredentials(betterproto.Message):
    authorization_token: str = betterproto.string_field(1)
    authority_selector: str = betterproto.string_field(2)


@dataclass
class GrpcServiceGoogleGrpcCallCredentialsMetadataCredentialsFromPlugin(
    betterproto.Message
):
    name: str = betterproto.string_field(1)
    config: betterproto_lib_google_protobuf.Struct = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: betterproto_lib_google_protobuf.Any = betterproto.message_field(
        3, group="config_type"
    )


@dataclass
class GrpcServiceGoogleGrpcCallCredentialsStsService(betterproto.Message):
    """
    Security token service configuration that allows Google gRPC to fetch
    security token from an OAuth 2.0 authorization server. See
    https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-16 and
    https://github.com/grpc/grpc/pull/19587. [#next-free-field: 10]
    """

    # URI of the token exchange service that handles token exchange requests.
    # [#comment:TODO(asraa): Add URI validation when implemented. Tracked by
    # https://github.com/envoyproxy/protoc-gen-validate/issues/303]
    token_exchange_service_uri: str = betterproto.string_field(1)
    # Location of the target service or resource where the client intends to use
    # the requested security token.
    resource: str = betterproto.string_field(2)
    # Logical name of the target service where the client intends to use the
    # requested security token.
    audience: str = betterproto.string_field(3)
    # The desired scope of the requested security token in the context of the
    # service or resource where the token will be used.
    scope: str = betterproto.string_field(4)
    # Type of the requested security token.
    requested_token_type: str = betterproto.string_field(5)
    # The path of subject token, a security token that represents the identity of
    # the party on behalf of whom the request is being made.
    subject_token_path: str = betterproto.string_field(6)
    # Type of the subject token.
    subject_token_type: str = betterproto.string_field(7)
    # The path of actor token, a security token that represents the identity of
    # the acting party. The acting party is authorized to use the requested
    # security token and act on behalf of the subject.
    actor_token_path: str = betterproto.string_field(8)
    # Type of the actor token.
    actor_token_type: str = betterproto.string_field(9)


@dataclass
class ApiConfigSource(betterproto.Message):
    """
    API configuration source. This identifies the API type and cluster that
    Envoy will use to fetch an xDS API. [#next-free-field: 9]
    """

    # API type (gRPC, REST, delta gRPC)
    api_type: "ApiConfigSourceApiType" = betterproto.enum_field(1)
    # API version for xDS transport protocol. This describes the xDS gRPC/REST
    # endpoint and version of [Delta]DiscoveryRequest/Response used on the wire.
    transport_api_version: "ApiVersion" = betterproto.enum_field(8)
    # Cluster names should be used only with REST. If > 1 cluster is defined,
    # clusters will be cycled through if any kind of failure occurs. .. note::
    # The cluster with name ``cluster_name`` must be statically defined and its
    # type must not be ``EDS``.
    cluster_names: List[str] = betterproto.string_field(2)
    # Multiple gRPC services be provided for GRPC. If > 1 cluster is defined,
    # services will be cycled through if any kind of failure occurs.
    grpc_services: List["GrpcService"] = betterproto.message_field(4)
    # For REST APIs, the delay between successive polls.
    refresh_delay: timedelta = betterproto.message_field(3)
    # For REST APIs, the request timeout. If not set, a default value of 1s will
    # be used.
    request_timeout: timedelta = betterproto.message_field(5)
    # For GRPC APIs, the rate limit settings. If present, discovery requests made
    # by Envoy will be rate limited.
    rate_limit_settings: "RateLimitSettings" = betterproto.message_field(6)
    # Skip the node identifier in subsequent discovery requests for streaming
    # gRPC config types.
    set_node_on_first_message_only: bool = betterproto.bool_field(7)


@dataclass
class AggregatedConfigSource(betterproto.Message):
    """
    Aggregated Discovery Service (ADS) options. This is currently empty, but
    when set in :ref:`ConfigSource <envoy_api_msg_core.ConfigSource>` can be
    used to specify that ADS is to be used.
    """

    pass


@dataclass
class SelfConfigSource(betterproto.Message):
    """
    [#not-implemented-hide:] Self-referencing config source options. This is
    currently empty, but when set in :ref:`ConfigSource
    <envoy_api_msg_core.ConfigSource>` can be used to specify that other data
    can be obtained from the same server.
    """

    # API version for xDS transport protocol. This describes the xDS gRPC/REST
    # endpoint and version of [Delta]DiscoveryRequest/Response used on the wire.
    transport_api_version: "ApiVersion" = betterproto.enum_field(1)


@dataclass
class RateLimitSettings(betterproto.Message):
    """
    Rate Limit settings to be applied for discovery requests made by Envoy.
    """

    # Maximum number of tokens to be used for rate limiting discovery request
    # calls. If not set, a default value of 100 will be used.
    max_tokens: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # Rate at which tokens will be filled per second. If not set, a default fill
    # rate of 10 tokens per second will be used.
    fill_rate: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )


@dataclass
class ConfigSource(betterproto.Message):
    """
    Configuration for :ref:`listeners <config_listeners>`, :ref:`clusters
    <config_cluster_manager>`, :ref:`routes
    <envoy_api_msg_RouteConfiguration>`, :ref:`endpoints
    <arch_overview_service_discovery>` etc. may either be sourced from the
    filesystem or from an xDS API source. Filesystem configs are watched with
    inotify for updates. [#next-free-field: 7]
    """

    # Path on the filesystem to source and watch for configuration updates. When
    # sourcing configuration for :ref:`secret <envoy_api_msg_auth.Secret>`, the
    # certificate and key files are also watched for updates. .. note::  The path
    # to the source must exist at config load time. .. note::   Envoy will only
    # watch the file path for *moves.* This is because in general only moves
    # are atomic. The same method of swapping files as is demonstrated in the
    # :ref:`runtime documentation <config_runtime_symbolic_link_swap>` can be
    # used here also.
    path: str = betterproto.string_field(1, group="config_source_specifier")
    # API configuration source.
    api_config_source: "ApiConfigSource" = betterproto.message_field(
        2, group="config_source_specifier"
    )
    # When set, ADS will be used to fetch resources. The ADS API configuration
    # source in the bootstrap configuration is used.
    ads: "AggregatedConfigSource" = betterproto.message_field(
        3, group="config_source_specifier"
    )
    # [#not-implemented-hide:] When set, the client will access the resources
    # from the same server it got the ConfigSource from, although not necessarily
    # from the same stream. This is similar to the
    # :ref:`ads<envoy_api_field.ConfigSource.ads>` field, except that the client
    # may use a different stream to the same server. As a result, this field can
    # be used for things like LRS that cannot be sent on an ADS stream. It can
    # also be used to link from (e.g.) LDS to RDS on the same server without
    # requiring the management server to know its name or required credentials.
    # [#next-major-version: In xDS v3, consider replacing the ads field with this
    # one, since this field can implicitly mean to use the same stream in the
    # case where the ConfigSource is provided via ADS and the specified data can
    # also be obtained via ADS.]
    self: "SelfConfigSource" = betterproto.message_field(
        5, group="config_source_specifier"
    )
    # When this timeout is specified, Envoy will wait no longer than the
    # specified time for first config response on this xDS subscription during
    # the :ref:`initialization process <arch_overview_initialization>`. After
    # reaching the timeout, Envoy will move to the next initialization phase,
    # even if the first config is not delivered yet. The timer is activated when
    # the xDS API subscription starts, and is disarmed on first config update or
    # on error. 0 means no timeout - Envoy will wait indefinitely for the first
    # xDS config (unless another timeout applies). The default is 15s.
    initial_fetch_timeout: timedelta = betterproto.message_field(4)
    # API version for xDS resources. This implies the type URLs that the client
    # will request for resources and the resource type that the client will in
    # turn expect to be delivered.
    resource_api_version: "ApiVersion" = betterproto.enum_field(6)


@dataclass
class EventServiceConfig(betterproto.Message):
    """
    [#not-implemented-hide:] Configuration of the event reporting service
    endpoint.
    """

    # Specifies the gRPC service that hosts the event reporting service.
    grpc_service: "GrpcService" = betterproto.message_field(
        1, group="config_source_specifier"
    )


@dataclass
class HealthCheck(betterproto.Message):
    """[#next-free-field: 23]"""

    # The time to wait for a health check response. If the timeout is reached the
    # health check attempt will be considered a failure.
    timeout: timedelta = betterproto.message_field(1)
    # The interval between health checks.
    interval: timedelta = betterproto.message_field(2)
    # An optional jitter amount in milliseconds. If specified, Envoy will start
    # health checking after for a random time in ms between 0 and initial_jitter.
    # This only applies to the first health check.
    initial_jitter: timedelta = betterproto.message_field(20)
    # An optional jitter amount in milliseconds. If specified, during every
    # interval Envoy will add interval_jitter to the wait time.
    interval_jitter: timedelta = betterproto.message_field(3)
    # An optional jitter amount as a percentage of interval_ms. If specified,
    # during every interval Envoy will add interval_ms * interval_jitter_percent
    # / 100 to the wait time. If interval_jitter_ms and interval_jitter_percent
    # are both set, both of them will be used to increase the wait time.
    interval_jitter_percent: int = betterproto.uint32_field(18)
    # The number of unhealthy health checks required before a host is marked
    # unhealthy. Note that for *http* health checking if a host responds with 503
    # this threshold is ignored and the host is considered unhealthy immediately.
    unhealthy_threshold: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # The number of healthy health checks required before a host is marked
    # healthy. Note that during startup, only a single successful health check is
    # required to mark a host healthy.
    healthy_threshold: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    # [#not-implemented-hide:] Non-serving port for health checking.
    alt_port: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    # Reuse health check connection between health checks. Default is true.
    reuse_connection: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL
    )
    # HTTP health check.
    http_health_check: "HealthCheckHttpHealthCheck" = betterproto.message_field(
        8, group="health_checker"
    )
    # TCP health check.
    tcp_health_check: "HealthCheckTcpHealthCheck" = betterproto.message_field(
        9, group="health_checker"
    )
    # gRPC health check.
    grpc_health_check: "HealthCheckGrpcHealthCheck" = betterproto.message_field(
        11, group="health_checker"
    )
    # Custom health check.
    custom_health_check: "HealthCheckCustomHealthCheck" = betterproto.message_field(
        13, group="health_checker"
    )
    # The "no traffic interval" is a special health check interval that is used
    # when a cluster has never had traffic routed to it. This lower interval
    # allows cluster information to be kept up to date, without sending a
    # potentially large amount of active health checking traffic for no reason.
    # Once a cluster has been used for traffic routing, Envoy will shift back to
    # using the standard health check interval that is defined. Note that this
    # interval takes precedence over any other. The default value for "no traffic
    # interval" is 60 seconds.
    no_traffic_interval: timedelta = betterproto.message_field(12)
    # The "unhealthy interval" is a health check interval that is used for hosts
    # that are marked as unhealthy. As soon as the host is marked as healthy,
    # Envoy will shift back to using the standard health check interval that is
    # defined. The default value for "unhealthy interval" is the same as
    # "interval".
    unhealthy_interval: timedelta = betterproto.message_field(14)
    # The "unhealthy edge interval" is a special health check interval that is
    # used for the first health check right after a host is marked as unhealthy.
    # For subsequent health checks Envoy will shift back to using either
    # "unhealthy interval" if present or the standard health check interval that
    # is defined. The default value for "unhealthy edge interval" is the same as
    # "unhealthy interval".
    unhealthy_edge_interval: timedelta = betterproto.message_field(15)
    # The "healthy edge interval" is a special health check interval that is used
    # for the first health check right after a host is marked as healthy. For
    # subsequent health checks Envoy will shift back to using the standard health
    # check interval that is defined. The default value for "healthy edge
    # interval" is the same as the default interval.
    healthy_edge_interval: timedelta = betterproto.message_field(16)
    # Specifies the path to the :ref:`health check event log
    # <arch_overview_health_check_logging>`. If empty, no event log will be
    # written.
    event_log_path: str = betterproto.string_field(17)
    # [#not-implemented-hide:] The gRPC service for the health check event
    # service. If empty, health check events won't be sent to a remote endpoint.
    event_service: "EventServiceConfig" = betterproto.message_field(22)
    # If set to true, health check failure events will always be logged. If set
    # to false, only the initial health check failure event will be logged. The
    # default value is false.
    always_log_health_check_failures: bool = betterproto.bool_field(19)
    # This allows overriding the cluster TLS settings, just for health check
    # connections.
    tls_options: "HealthCheckTlsOptions" = betterproto.message_field(21)


@dataclass
class HealthCheckPayload(betterproto.Message):
    """Describes the encoding of the payload bytes in the payload."""

    # Hex encoded payload. E.g., "000000FF".
    text: str = betterproto.string_field(1, group="payload")
    # [#not-implemented-hide:] Binary payload.
    binary: bytes = betterproto.bytes_field(2, group="payload")


@dataclass
class HealthCheckHttpHealthCheck(betterproto.Message):
    """[#next-free-field: 12]"""

    # The value of the host header in the HTTP health check request. If left
    # empty (default value), the name of the cluster this health check is
    # associated with will be used. The host header can be customized for a
    # specific endpoint by setting the :ref:`hostname
    # <envoy_api_field_endpoint.Endpoint.HealthCheckConfig.hostname>` field.
    host: str = betterproto.string_field(1)
    # Specifies the HTTP path that will be requested during health checking. For
    # example */healthcheck*.
    path: str = betterproto.string_field(2)
    # [#not-implemented-hide:] HTTP specific payload.
    send: "HealthCheckPayload" = betterproto.message_field(3)
    # [#not-implemented-hide:] HTTP specific response.
    receive: "HealthCheckPayload" = betterproto.message_field(4)
    # An optional service name parameter which is used to validate the identity
    # of the health checked cluster. See the :ref:`architecture overview
    # <arch_overview_health_checking_identity>` for more information. ..
    # attention::   This field has been deprecated in favor of
    # `service_name_matcher` for better flexibility   over matching with service-
    # cluster name.
    service_name: str = betterproto.string_field(5)
    # Specifies a list of HTTP headers that should be added to each request that
    # is sent to the health checked cluster. For more information, including
    # details on header value syntax, see the documentation on :ref:`custom
    # request headers <config_http_conn_man_headers_custom_request_headers>`.
    request_headers_to_add: List["HeaderValueOption"] = betterproto.message_field(6)
    # Specifies a list of HTTP headers that should be removed from each request
    # that is sent to the health checked cluster.
    request_headers_to_remove: List[str] = betterproto.string_field(8)
    # If set, health checks will be made using http/2. Deprecated, use
    # :ref:`codec_client_type
    # <envoy_api_field_core.HealthCheck.HttpHealthCheck.codec_client_type>`
    # instead.
    use_http2: bool = betterproto.bool_field(7)
    # Specifies a list of HTTP response statuses considered healthy. If provided,
    # replaces default 200-only policy - 200 must be included explicitly as
    # needed. Ranges follow half-open semantics of :ref:`Int64Range
    # <envoy_api_msg_type.Int64Range>`. The start and end of each range are
    # required. Only statuses in the range [100, 600) are allowed.
    expected_statuses: List[___type__.Int64Range] = betterproto.message_field(9)
    # Use specified application protocol for health checks.
    codec_client_type: ___type__.CodecClientType = betterproto.enum_field(10)
    # An optional service name parameter which is used to validate the identity
    # of the health checked cluster using a :ref:`StringMatcher
    # <envoy_api_msg_type.matcher.StringMatcher>`. See the :ref:`architecture
    # overview <arch_overview_health_checking_identity>` for more information.
    service_name_matcher: ___type_matcher__.StringMatcher = betterproto.message_field(
        11
    )


@dataclass
class HealthCheckTcpHealthCheck(betterproto.Message):
    # Empty payloads imply a connect-only health check.
    send: "HealthCheckPayload" = betterproto.message_field(1)
    # When checking the response, “fuzzy” matching is performed such that each
    # binary block must be found, and in the order specified, but not necessarily
    # contiguous.
    receive: List["HealthCheckPayload"] = betterproto.message_field(2)


@dataclass
class HealthCheckRedisHealthCheck(betterproto.Message):
    # If set, optionally perform ``EXISTS <key>`` instead of ``PING``. A return
    # value from Redis of 0 (does not exist) is considered a passing healthcheck.
    # A return value other than 0 is considered a failure. This allows the user
    # to mark a Redis instance for maintenance by setting the specified key to
    # any value and waiting for traffic to drain.
    key: str = betterproto.string_field(1)


@dataclass
class HealthCheckGrpcHealthCheck(betterproto.Message):
    """
    `grpc.health.v1.Health <https://github.com/grpc/grpc/blob/master/src/proto/
    grpc/health/v1/health.proto>`_-based healthcheck. See `gRPC doc
    <https://github.com/grpc/grpc/blob/master/doc/health-checking.md>`_ for
    details.
    """

    # An optional service name parameter which will be sent to gRPC service in
    # `grpc.health.v1.HealthCheckRequest <https://github.com/grpc/grpc/blob/maste
    # r/src/proto/grpc/health/v1/health.proto#L20>`_. message. See `gRPC health-
    # checking overview <https://github.com/grpc/grpc/blob/master/doc/health-
    # checking.md>`_ for more information.
    service_name: str = betterproto.string_field(1)
    # The value of the :authority header in the gRPC health check request. If
    # left empty (default value), the name of the cluster this health check is
    # associated with will be used. The authority header can be customized for a
    # specific endpoint by setting the :ref:`hostname
    # <envoy_api_field_endpoint.Endpoint.HealthCheckConfig.hostname>` field.
    authority: str = betterproto.string_field(2)


@dataclass
class HealthCheckCustomHealthCheck(betterproto.Message):
    """Custom health check."""

    # The registered name of the custom health checker.
    name: str = betterproto.string_field(1)
    config: betterproto_lib_google_protobuf.Struct = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: betterproto_lib_google_protobuf.Any = betterproto.message_field(
        3, group="config_type"
    )


@dataclass
class HealthCheckTlsOptions(betterproto.Message):
    """
    Health checks occur over the transport socket specified for the cluster.
    This implies that if a cluster is using a TLS-enabled transport socket, the
    health check will also occur over TLS. This allows overriding the cluster
    TLS settings, just for health check connections.
    """

    # Specifies the ALPN protocols for health check connections. This is useful
    # if the corresponding upstream is using ALPN-based :ref:`FilterChainMatch
    # <envoy_api_msg_listener.FilterChainMatch>` along with different protocols
    # for health checks versus data connections. If empty, no ALPN protocols will
    # be set on health check connections.
    alpn_protocols: List[str] = betterproto.string_field(1)


@dataclass
class TcpProtocolOptions(betterproto.Message):
    """[#not-implemented-hide:]"""

    pass


@dataclass
class UpstreamHttpProtocolOptions(betterproto.Message):
    # Set transport socket `SNI
    # <https://en.wikipedia.org/wiki/Server_Name_Indication>`_ for new upstream
    # connections based on the downstream HTTP host/authority header, as seen by
    # the :ref:`router filter <config_http_filters_router>`.
    auto_sni: bool = betterproto.bool_field(1)
    # Automatic validate upstream presented certificate for new upstream
    # connections based on the downstream HTTP host/authority header, as seen by
    # the :ref:`router filter <config_http_filters_router>`. This field is
    # intended to set with `auto_sni` field.
    auto_san_validation: bool = betterproto.bool_field(2)


@dataclass
class HttpProtocolOptions(betterproto.Message):
    """[#next-free-field: 6]"""

    # The idle timeout for connections. The idle timeout is defined as the period
    # in which there are no active requests. When the idle timeout is reached the
    # connection will be closed. If the connection is an HTTP/2 downstream
    # connection a drain sequence will occur prior to closing the connection, see
    # :ref:`drain_timeout <envoy_api_field_config.filter.network.http_connection_
    # manager.v2.HttpConnectionManager.drain_timeout>`. Note that request based
    # timeouts mean that HTTP/2 PINGs will not keep the connection alive. If not
    # specified, this defaults to 1 hour. To disable idle timeouts explicitly set
    # this to 0. .. warning::   Disabling this timeout has a highly likelihood of
    # yielding connection leaks due to lost TCP   FIN packets, etc.
    idle_timeout: timedelta = betterproto.message_field(1)
    # The maximum duration of a connection. The duration is defined as a period
    # since a connection was established. If not set, there is no max duration.
    # When max_connection_duration is reached the connection will be closed.
    # Drain sequence will occur prior to closing the connection if if's
    # applicable. See :ref:`drain_timeout <envoy_api_field_config.filter.network.
    # http_connection_manager.v2.HttpConnectionManager.drain_timeout>`. Note: not
    # implemented for upstream connections.
    max_connection_duration: timedelta = betterproto.message_field(3)
    # The maximum number of headers. If unconfigured, the default maximum number
    # of request headers allowed is 100. Requests that exceed this limit will
    # receive a 431 response for HTTP/1.x and cause a stream reset for HTTP/2.
    max_headers_count: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # Total duration to keep alive an HTTP request/response stream. If the time
    # limit is reached the stream will be reset independent of any other
    # timeouts. If not specified, this value is not set.
    max_stream_duration: timedelta = betterproto.message_field(4)
    # Action to take when a client request with a header name containing
    # underscore characters is received. If this setting is not specified, the
    # value defaults to ALLOW. Note: upstream responses are not affected by this
    # setting.
    headers_with_underscores_action: "HttpProtocolOptionsHeadersWithUnderscoresAction" = betterproto.enum_field(
        5
    )


@dataclass
class Http1ProtocolOptions(betterproto.Message):
    """[#next-free-field: 6]"""

    # Handle HTTP requests with absolute URLs in the requests. These requests are
    # generally sent by clients to forward/explicit proxies. This allows clients
    # to configure envoy as their HTTP proxy. In Unix, for example, this is
    # typically done by setting the *http_proxy* environment variable.
    allow_absolute_url: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    # Handle incoming HTTP/1.0 and HTTP 0.9 requests. This is off by default, and
    # not fully standards compliant. There is support for pre-HTTP/1.1 style
    # connect logic, dechunking, and handling lack of client host iff
    # *default_host_for_http_10* is configured.
    accept_http_10: bool = betterproto.bool_field(2)
    # A default host for HTTP/1.0 requests. This is highly suggested if
    # *accept_http_10* is true as Envoy does not otherwise support HTTP/1.0
    # without a Host header. This is a no-op if *accept_http_10* is not true.
    default_host_for_http_10: str = betterproto.string_field(3)
    # Describes how the keys for response headers should be formatted. By
    # default, all header keys are lower cased.
    header_key_format: "Http1ProtocolOptionsHeaderKeyFormat" = betterproto.message_field(
        4
    )
    # Enables trailers for HTTP/1. By default the HTTP/1 codec drops proxied
    # trailers. .. attention::   Note that this only happens when Envoy is chunk
    # encoding which occurs when:   - The request is HTTP/1.1.   - Is neither a
    # HEAD only request nor a HTTP Upgrade.   - Not a response to a HEAD request.
    # - The content length header is not present.
    enable_trailers: bool = betterproto.bool_field(5)


@dataclass
class Http1ProtocolOptionsHeaderKeyFormat(betterproto.Message):
    # Formats the header by proper casing words: the first character and any
    # character following a special character will be capitalized if it's an
    # alpha character. For example, "content-type" becomes "Content-Type", and
    # "foo$b#$are" becomes "Foo$B#$Are". Note that while this results in most
    # headers following conventional casing, certain headers are not covered. For
    # example, the "TE" header will be formatted as "Te".
    proper_case_words: "Http1ProtocolOptionsHeaderKeyFormatProperCaseWords" = betterproto.message_field(
        1, group="header_format"
    )


@dataclass
class Http1ProtocolOptionsHeaderKeyFormatProperCaseWords(betterproto.Message):
    pass


@dataclass
class Http2ProtocolOptions(betterproto.Message):
    """[#next-free-field: 14]"""

    # `Maximum table size
    # <https://httpwg.org/specs/rfc7541.html#rfc.section.4.2>`_ (in octets) that
    # the encoder is permitted to use for the dynamic HPACK table. Valid values
    # range from 0 to 4294967295 (2^32 - 1) and defaults to 4096. 0 effectively
    # disables header compression.
    hpack_table_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # `Maximum concurrent streams
    # <https://httpwg.org/specs/rfc7540.html#rfc.section.5.1.2>`_ allowed for
    # peer on one HTTP/2 connection. Valid values range from 1 to 2147483647
    # (2^31 - 1) and defaults to 2147483647. For upstream connections, this also
    # limits how many streams Envoy will initiate concurrently on a single
    # connection. If the limit is reached, Envoy may queue requests or establish
    # additional connections (as allowed per circuit breaker limits).
    max_concurrent_streams: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    # `Initial stream-level flow-control window
    # <https://httpwg.org/specs/rfc7540.html#rfc.section.6.9.2>`_ size. Valid
    # values range from 65535 (2^16 - 1, HTTP/2 default) to 2147483647 (2^31 - 1,
    # HTTP/2 maximum) and defaults to 268435456 (256 * 1024 * 1024). NOTE: 65535
    # is the initial window size from HTTP/2 spec. We only support increasing the
    # default window size now, so it's also the minimum. This field also acts as
    # a soft limit on the number of bytes Envoy will buffer per-stream in the
    # HTTP/2 codec buffers. Once the buffer reaches this pointer, watermark
    # callbacks will fire to stop the flow of data to the codec buffers.
    initial_stream_window_size: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    # Similar to *initial_stream_window_size*, but for connection-level flow-
    # control window. Currently, this has the same minimum/maximum/default as
    # *initial_stream_window_size*.
    initial_connection_window_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    # Allows proxying Websocket and other upgrades over H2 connect.
    allow_connect: bool = betterproto.bool_field(5)
    # [#not-implemented-hide:] Hiding until envoy has full metadata support.
    # Still under implementation. DO NOT USE. Allows metadata. See [metadata docs
    # ](https://github.com/envoyproxy/envoy/blob/master/source/docs/h2_metadata.m
    # d) for more information.
    allow_metadata: bool = betterproto.bool_field(6)
    # Limit the number of pending outbound downstream frames of all types (frames
    # that are waiting to be written into the socket). Exceeding this limit
    # triggers flood mitigation and connection is terminated. The
    # ``http2.outbound_flood`` stat tracks the number of terminated connections
    # due to flood mitigation. The default limit is 10000. [#comment:TODO:
    # implement same limits for upstream outbound frames as well.]
    max_outbound_frames: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    # Limit the number of pending outbound downstream frames of types PING,
    # SETTINGS and RST_STREAM, preventing high memory utilization when receiving
    # continuous stream of these frames. Exceeding this limit triggers flood
    # mitigation and connection is terminated. The
    # ``http2.outbound_control_flood`` stat tracks the number of terminated
    # connections due to flood mitigation. The default limit is 1000.
    # [#comment:TODO: implement same limits for upstream outbound frames as
    # well.]
    max_outbound_control_frames: Optional[int] = betterproto.message_field(
        8, wraps=betterproto.TYPE_UINT32
    )
    # Limit the number of consecutive inbound frames of types HEADERS,
    # CONTINUATION and DATA with an empty payload and no end stream flag. Those
    # frames have no legitimate use and are abusive, but might be a result of a
    # broken HTTP/2 implementation. The `http2.inbound_empty_frames_flood`` stat
    # tracks the number of connections terminated due to flood mitigation.
    # Setting this to 0 will terminate connection upon receiving first frame with
    # an empty payload and no end stream flag. The default limit is 1.
    # [#comment:TODO: implement same limits for upstream inbound frames as well.]
    max_consecutive_inbound_frames_with_empty_payload: Optional[
        int
    ] = betterproto.message_field(9, wraps=betterproto.TYPE_UINT32)
    # Limit the number of inbound PRIORITY frames allowed per each opened stream.
    # If the number of PRIORITY frames received over the lifetime of connection
    # exceeds the value calculated using this formula::
    # max_inbound_priority_frames_per_stream * (1 + inbound_streams) the
    # connection is terminated. The ``http2.inbound_priority_frames_flood`` stat
    # tracks the number of connections terminated due to flood mitigation. The
    # default limit is 100. [#comment:TODO: implement same limits for upstream
    # inbound frames as well.]
    max_inbound_priority_frames_per_stream: Optional[int] = betterproto.message_field(
        10, wraps=betterproto.TYPE_UINT32
    )
    # Limit the number of inbound WINDOW_UPDATE frames allowed per DATA frame
    # sent. If the number of WINDOW_UPDATE frames received over the lifetime of
    # connection exceeds the value calculated using this formula::     1 + 2 *
    # (inbound_streams +
    # max_inbound_window_update_frames_per_data_frame_sent *
    # outbound_data_frames) the connection is terminated. The
    # ``http2.inbound_priority_frames_flood`` stat tracks the number of
    # connections terminated due to flood mitigation. The default limit is 10.
    # Setting this to 1 should be enough to support HTTP/2 implementations with
    # basic flow control, but more complex implementations that try to estimate
    # available bandwidth require at least 2. [#comment:TODO: implement same
    # limits for upstream inbound frames as well.]
    max_inbound_window_update_frames_per_data_frame_sent: Optional[
        int
    ] = betterproto.message_field(11, wraps=betterproto.TYPE_UINT32)
    # Allows invalid HTTP messaging and headers. When this option is disabled
    # (default), then the whole HTTP/2 connection is terminated upon receiving
    # invalid HEADERS frame. However, when this option is enabled, only the
    # offending stream is terminated. See `RFC7540, sec. 8.1
    # <https://tools.ietf.org/html/rfc7540#section-8.1>`_ for details.
    stream_error_on_invalid_http_messaging: bool = betterproto.bool_field(12)
    # [#not-implemented-hide:] Specifies SETTINGS frame parameters to be sent to
    # the peer, with two exceptions: 1. SETTINGS_ENABLE_PUSH (0x2) is not
    # configurable as HTTP/2 server push is not supported by Envoy. 2.
    # SETTINGS_ENABLE_CONNECT_PROTOCOL (0x8) is only configurable through the
    # named field 'allow_connect'. Note that custom parameters specified through
    # this field can not also be set in the corresponding named parameters: ..
    # code-block:: text   ID    Field Name   ----------------   0x1
    # hpack_table_size   0x3   max_concurrent_streams   0x4
    # initial_stream_window_size Collisions will trigger config validation
    # failure on load/update. Likewise, inconsistencies between custom parameters
    # with the same identifier will trigger a failure. See `IANA HTTP/2 Settings
    # <https://www.iana.org/assignments/http2-parameters/http2-parameters.xhtml#s
    # ettings>`_ for standardized identifiers.
    custom_settings_parameters: List[
        "Http2ProtocolOptionsSettingsParameter"
    ] = betterproto.message_field(13)


@dataclass
class Http2ProtocolOptionsSettingsParameter(betterproto.Message):
    """
    Defines a parameter to be sent in the SETTINGS frame. See `RFC7540, sec.
    6.5.1 <https://tools.ietf.org/html/rfc7540#section-6.5.1>`_ for details.
    """

    # The 16 bit parameter identifier.
    identifier: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    # The 32 bit parameter value.
    value: Optional[int] = betterproto.message_field(2, wraps=betterproto.TYPE_UINT32)


@dataclass
class GrpcProtocolOptions(betterproto.Message):
    """[#not-implemented-hide:]"""

    http2_protocol_options: "Http2ProtocolOptions" = betterproto.message_field(1)
