"""Constants used in Klang."""
import math


PI: float = math.pi
"""Half the circle constant."""

TAU: float = 2. * math.pi
"""Circle constant."""

INF: float = float('inf')
"""To infinity and beyond."""

DODE: int = 12
"""Greek twelve."""

REF_OCTAVE: int = 5
"""Main octave number (MIDI notes 60-71)."""

SEMITONES_PER_OCTAVE: int = 12
"""Number of semitones in an octave."""

MONO: int = 1
"""Mono."""

STEREO: int = 2
"""Stereo."""

ONE_D: int = 1
"""It is one dimensional. What is there more to say."""

TWO_D: int = 2
"""Two dimensional."""

CENT_PER_OCTAVE: int = 1200
"""Cents per octave."""

SCALAR: int = 1
"""Scalar array shape."""
