# -*- coding: utf-8 -*-

"""
firstlanguageapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from firstlanguageapi.api_helper import APIHelper
from firstlanguageapi.controllers.enterprise_only_controller import EnterpriseOnlyController
from firstlanguageapi.models.api_question_request import ApiQuestionRequest


class EnterpriseOnlyControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(EnterpriseOnlyControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = EnterpriseOnlyController(cls.config, cls.auth_managers, cls.response_catcher)

    # # QA : Defintion and it's usage
    #A Question Answering System retrieves the answer relevant to the question given by the user. A question answering system can be used for building a text based chatbots, search engines etc. Our question answering system  is mutilingual and supports 100 + languages. Please use ISO 639-2 2 digit language code  to get results. For example, use 'en' for English, 'ta' for Tamil, 'hi' for Hindi, 'fr' for French etc.
    #
    #For ISO code reference, please check the link https://www.loc.gov/standards/iso639-2/php/code_list.php
    def test_get_qa_enterprise(self):
        # Parameters for the API call
        body = APIHelper.json_deserialize('{"input":{"question":"Who is father of Arya Stark?","lang":"en"}}', ApiQuestionRequest.from_dictionary)

        # Perform the API call through the SDK function
        result = self.controller.get_qa_enterprise(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"answer":"உப்பு, புளி, மிளகாய்"}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

