# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_k_fold_validation.ipynb (unless otherwise specified).

__all__ = ['make_folds', 'score_averages', 'k_fold_validation', 'KFoldPipeline']

# Cell

# export
import sys
from unittest.mock import Mock
from os import path
import tempfile
from random import random
import numpy as np
import pandas as pd
import sklearn
import logging
from sklearn.model_selection import KFold

from .pipeline_classifier import Pipeline
import tensorflow as tf

# Cell
def make_folds(X,n_splits=4):
    kf = KFold(n_splits=n_splits)
    kf.get_n_splits(X)
    for train_index, test_index in kf.split(X):
        yield X.iloc[train_index], X.iloc[test_index]

# Cell
def score_averages(**k_fold_evaluations):
    fold1 = next(iter(k_fold_evaluations.values()))
    split_names = fold1.keys()
    score_names = next(iter(fold1.values())).keys()
    K = len(k_fold_evaluations)
    return {
        split: {
            score_name: sum(
                k_fold_evaluations[k][split][score_name]
                for k in k_fold_evaluations.keys()
            ) / K
            for score_name in score_names
        }
        for split in split_names
    }

# Cell
def k_fold_validation(n_splits, **kwargs):
    ''' Implements the `pipeline` method for each fold.
        The averaged score is stored in `avg_evaluation`
        actions: A dictionary of functions over the pipeline for each fold
    '''
    evaluations = {}
    pipeline = Pipeline(**kwargs)
    best_score = {'score': -1.0,'dir_name':...}
    k = 1

    pipeline = Pipeline(**kwargs)
    for train, test in make_folds(pipeline.data, n_splits=n_splits):
        pipeline.dfs = {'train': train, 'test': test}
        pipeline.pipeline()

        evaluations[str(k)] = pipeline.evaluation
        best_score = update_best_score_index(best_score, pipeline)
        log_status(
            k, pipeline.evaluation,
            'current best score: ' + str(best_score['score'])
        )
        k += 1

    return evaluations, best_results

# Cell


class KFoldPipeline(Pipeline):
    '''K fold validation over the model built in `Pipeline` class
    '''
    def __init__(self, dataset_file, n_splits=4):
        self.n_splits = n_splits
        self.k_fold_evaluations = {}
        Pipeline.__init__(self, src_file=dataset_file)

    def k_fold_validation(self):
        ''' Implements the `pipeline` method for each fold.
            The averaged score is stored in `avg_evaluation`
        '''
        for k, split in enumerate(
            k_fold_validation(self.data, n_splits=self.n_splits)
        ):
            self.dfs = {'train': split[0], 'test': split[1]}
            self.pipeline()
            self.k_fold_evaluations[str(k + 1)] = self.evaluation

            logging.info(f'fold {k+1} has finished...')
            logging.info(
                '\n'.join(
                    [
                        'The %s score for the training set in fold %s is %s' %
                        (key, k + 1, self.evaluation['train'][key])
                        for key in ('accuracy', 'f1_score')
                    ]
                )
            )

        self.avg_evaluation = score_averages(**self.k_fold_evaluations)