# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ibis',
 'ibis.backends',
 'ibis.backends.base',
 'ibis.backends.base.sql',
 'ibis.backends.base.sql.alchemy',
 'ibis.backends.base.sql.compiler',
 'ibis.backends.base.sql.registry',
 'ibis.backends.bigquery',
 'ibis.backends.bigquery.tests',
 'ibis.backends.bigquery.tests.system',
 'ibis.backends.bigquery.tests.system.udf',
 'ibis.backends.bigquery.tests.unit',
 'ibis.backends.bigquery.tests.unit.udf',
 'ibis.backends.bigquery.udf',
 'ibis.backends.clickhouse',
 'ibis.backends.clickhouse.compiler',
 'ibis.backends.clickhouse.tests',
 'ibis.backends.dask',
 'ibis.backends.dask.execution',
 'ibis.backends.dask.tests',
 'ibis.backends.dask.tests.execution',
 'ibis.backends.datafusion',
 'ibis.backends.datafusion.tests',
 'ibis.backends.duckdb',
 'ibis.backends.duckdb.tests',
 'ibis.backends.impala',
 'ibis.backends.impala.tests',
 'ibis.backends.mssql',
 'ibis.backends.mssql.tests',
 'ibis.backends.mysql',
 'ibis.backends.mysql.tests',
 'ibis.backends.pandas',
 'ibis.backends.pandas.execution',
 'ibis.backends.pandas.tests',
 'ibis.backends.pandas.tests.execution',
 'ibis.backends.polars',
 'ibis.backends.polars.tests',
 'ibis.backends.postgres',
 'ibis.backends.postgres.tests',
 'ibis.backends.pyarrow',
 'ibis.backends.pyspark',
 'ibis.backends.pyspark.tests',
 'ibis.backends.snowflake',
 'ibis.backends.snowflake.tests',
 'ibis.backends.sqlite',
 'ibis.backends.sqlite.tests',
 'ibis.backends.tests',
 'ibis.backends.trino',
 'ibis.backends.trino.tests',
 'ibis.common',
 'ibis.common.tests',
 'ibis.expr',
 'ibis.expr.datatypes',
 'ibis.expr.operations',
 'ibis.expr.types',
 'ibis.tests',
 'ibis.tests.benchmarks',
 'ibis.tests.expr',
 'ibis.tests.sql',
 'ibis.tests.sql.snapshots.test_compiler.test_column_distinct',
 'ibis.tests.sql.snapshots.test_compiler.test_column_expr_default_name',
 'ibis.tests.sql.snapshots.test_compiler.test_column_expr_retains_name',
 'ibis.tests.sql.snapshots.test_compiler.test_count_distinct',
 'ibis.tests.sql.snapshots.test_compiler.test_difference_project_column',
 'ibis.tests.sql.snapshots.test_compiler.test_having_from_filter',
 'ibis.tests.sql.snapshots.test_compiler.test_intersect_project_column',
 'ibis.tests.sql.snapshots.test_compiler.test_multiple_count_distinct',
 'ibis.tests.sql.snapshots.test_compiler.test_subquery_where_location',
 'ibis.tests.sql.snapshots.test_compiler.test_table_difference',
 'ibis.tests.sql.snapshots.test_compiler.test_table_distinct',
 'ibis.tests.sql.snapshots.test_compiler.test_table_drop_with_filter',
 'ibis.tests.sql.snapshots.test_compiler.test_table_intersect',
 'ibis.tests.sql.snapshots.test_compiler.test_union',
 'ibis.tests.sql.snapshots.test_compiler.test_union_project_column',
 'ibis.tests.sql.snapshots.test_select_sql.test_aggregate_count_joined',
 'ibis.tests.sql.snapshots.test_select_sql.test_anti_join',
 'ibis.tests.sql.snapshots.test_select_sql.test_bool_bool',
 'ibis.tests.sql.snapshots.test_select_sql.test_case_in_projection',
 'ibis.tests.sql.snapshots.test_select_sql.test_endswith',
 'ibis.tests.sql.snapshots.test_select_sql.test_fuse_projections',
 'ibis.tests.sql.snapshots.test_select_sql.test_join_between_joins',
 'ibis.tests.sql.snapshots.test_select_sql.test_join_just_materialized',
 'ibis.tests.sql.snapshots.test_select_sql.test_limit_with_self_join',
 'ibis.tests.sql.snapshots.test_select_sql.test_multiple_joins',
 'ibis.tests.sql.snapshots.test_select_sql.test_multiple_limits',
 'ibis.tests.sql.snapshots.test_select_sql.test_nameless_table',
 'ibis.tests.sql.snapshots.test_select_sql.test_order_by_on_limit_yield_subquery',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.agg_explicit_column',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.agg_string_columns',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.aggregate_table_count_metric',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.filter_then_limit',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.limit_simple',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.limit_then_filter',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.limit_with_offset',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.mixed_columns_ascending',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.self_reference_simple',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.single_column',
 'ibis.tests.sql.snapshots.test_select_sql.test_select_sql.test_physical_table_reference_translate',
 'ibis.tests.sql.snapshots.test_select_sql.test_semi_join',
 'ibis.tests.sql.snapshots.test_select_sql.test_simple_joins',
 'ibis.tests.sql.snapshots.test_select_sql.test_startswith',
 'ibis.tests.sql.snapshots.test_select_sql.test_subquery_in_union',
 'ibis.tests.sql.snapshots.test_select_sql.test_where_analyze_scalar_op',
 'ibis.tests.sql.snapshots.test_select_sql.test_where_no_pushdown_possible',
 'ibis.tests.sql.snapshots.test_select_sql.test_where_with_between',
 'ibis.tests.sql.snapshots.test_select_sql.test_where_with_join',
 'ibis.tests.sql.snapshots.test_sqlalchemy.test_lower_projection_sort_key',
 'ibis.tests.sql.snapshots.test_sqlalchemy.test_where_simple_comparisons',
 'ibis.udf']

package_data = \
{'': ['*'],
 'ibis.backends.bigquery.tests.system.udf': ['snapshots/test_udf_execute/test_udf_with_struct/*'],
 'ibis.backends.bigquery.tests.unit': ['snapshots/test_compiler/test_approx/filter-approx_median/*',
                                       'snapshots/test_compiler/test_approx/filter-approx_nunique/*',
                                       'snapshots/test_compiler/test_approx/no_filter-approx_median/*',
                                       'snapshots/test_compiler/test_approx/no_filter-approx_nunique/*',
                                       'snapshots/test_compiler/test_binary/*',
                                       'snapshots/test_compiler/test_bit/filter-bit_and/*',
                                       'snapshots/test_compiler/test_bit/filter-bit_or/*',
                                       'snapshots/test_compiler/test_bit/filter-bit_xor/*',
                                       'snapshots/test_compiler/test_bit/no_filter-bit_and/*',
                                       'snapshots/test_compiler/test_bit/no_filter-bit_or/*',
                                       'snapshots/test_compiler/test_bit/no_filter-bit_xor/*',
                                       'snapshots/test_compiler/test_bool_reducers/mean/*',
                                       'snapshots/test_compiler/test_bool_reducers/sum/*',
                                       'snapshots/test_compiler/test_bool_reducers_where_conj/*',
                                       'snapshots/test_compiler/test_bool_reducers_where_simple/*',
                                       'snapshots/test_compiler/test_bucket/*',
                                       'snapshots/test_compiler/test_compile_toplevel/*',
                                       'snapshots/test_compiler/test_cov/pop/*',
                                       'snapshots/test_compiler/test_cov/sample/*',
                                       'snapshots/test_compiler/test_day_of_week/date/*',
                                       'snapshots/test_compiler/test_day_of_week/datetime/*',
                                       'snapshots/test_compiler/test_day_of_week/string_date/*',
                                       'snapshots/test_compiler/test_day_of_week/string_timestamp/*',
                                       'snapshots/test_compiler/test_day_of_week/timestamp/*',
                                       'snapshots/test_compiler/test_day_of_week/timestamp_date/*',
                                       'snapshots/test_compiler/test_divide_by_zero/floordiv/*',
                                       'snapshots/test_compiler/test_divide_by_zero/truediv/*',
                                       'snapshots/test_compiler/test_extract_temporal_from_timestamp/date/*',
                                       'snapshots/test_compiler/test_extract_temporal_from_timestamp/time/*',
                                       'snapshots/test_compiler/test_geospatial_azimuth/*',
                                       'snapshots/test_compiler/test_geospatial_binary/contains/*',
                                       'snapshots/test_compiler/test_geospatial_binary/covered_by/*',
                                       'snapshots/test_compiler/test_geospatial_binary/covers/*',
                                       'snapshots/test_compiler/test_geospatial_binary/d_within/*',
                                       'snapshots/test_compiler/test_geospatial_binary/difference/*',
                                       'snapshots/test_compiler/test_geospatial_binary/disjoint/*',
                                       'snapshots/test_compiler/test_geospatial_binary/distance/*',
                                       'snapshots/test_compiler/test_geospatial_binary/geo_equals/*',
                                       'snapshots/test_compiler/test_geospatial_binary/intersection/*',
                                       'snapshots/test_compiler/test_geospatial_binary/intersects/*',
                                       'snapshots/test_compiler/test_geospatial_binary/max_distance/*',
                                       'snapshots/test_compiler/test_geospatial_binary/touches/*',
                                       'snapshots/test_compiler/test_geospatial_binary/union/*',
                                       'snapshots/test_compiler/test_geospatial_binary/within/*',
                                       'snapshots/test_compiler/test_geospatial_minmax/x_max/*',
                                       'snapshots/test_compiler/test_geospatial_minmax/x_min/*',
                                       'snapshots/test_compiler/test_geospatial_minmax/y_max/*',
                                       'snapshots/test_compiler/test_geospatial_minmax/y_min/*',
                                       'snapshots/test_compiler/test_geospatial_point/*',
                                       'snapshots/test_compiler/test_geospatial_simplify/*',
                                       'snapshots/test_compiler/test_geospatial_unary/aread/*',
                                       'snapshots/test_compiler/test_geospatial_unary/as_binary/*',
                                       'snapshots/test_compiler/test_geospatial_unary/as_text/*',
                                       'snapshots/test_compiler/test_geospatial_unary/buffer/*',
                                       'snapshots/test_compiler/test_geospatial_unary/centroid/*',
                                       'snapshots/test_compiler/test_geospatial_unary/end_point/*',
                                       'snapshots/test_compiler/test_geospatial_unary/geometry_type/*',
                                       'snapshots/test_compiler/test_geospatial_unary/length/*',
                                       'snapshots/test_compiler/test_geospatial_unary/npoints/*',
                                       'snapshots/test_compiler/test_geospatial_unary/perimeter/*',
                                       'snapshots/test_compiler/test_geospatial_unary/point_n/*',
                                       'snapshots/test_compiler/test_geospatial_unary/start_point/*',
                                       'snapshots/test_compiler/test_geospatial_unary_union/*',
                                       'snapshots/test_compiler/test_geospatial_xy/x/*',
                                       'snapshots/test_compiler/test_geospatial_xy/y/*',
                                       'snapshots/test_compiler/test_hash/binary/*',
                                       'snapshots/test_compiler/test_hash/string/*',
                                       'snapshots/test_compiler/test_hashbytes/md5-test-binary/*',
                                       'snapshots/test_compiler/test_hashbytes/md5-test-string/*',
                                       'snapshots/test_compiler/test_hashbytes/sha1-test-binary/*',
                                       'snapshots/test_compiler/test_hashbytes/sha1-test-string/*',
                                       'snapshots/test_compiler/test_hashbytes/sha256-test-binary/*',
                                       'snapshots/test_compiler/test_hashbytes/sha256-test-string/*',
                                       'snapshots/test_compiler/test_hashbytes/sha512-test-binary/*',
                                       'snapshots/test_compiler/test_hashbytes/sha512-test-string/*',
                                       'snapshots/test_compiler/test_identical_to/*',
                                       'snapshots/test_compiler/test_integer_to_timestamp/ms/*',
                                       'snapshots/test_compiler/test_integer_to_timestamp/ns/*',
                                       'snapshots/test_compiler/test_integer_to_timestamp/s/*',
                                       'snapshots/test_compiler/test_integer_to_timestamp/us/*',
                                       'snapshots/test_compiler/test_literal_timestamp_or_time/datetime/*',
                                       'snapshots/test_compiler/test_literal_timestamp_or_time/string_time/*',
                                       'snapshots/test_compiler/test_literal_timestamp_or_time/string_timestamp/*',
                                       'snapshots/test_compiler/test_literal_timestamp_or_time/time/*',
                                       'snapshots/test_compiler/test_literal_timestamp_or_time/timestamp/*',
                                       'snapshots/test_compiler/test_literal_year/date/*',
                                       'snapshots/test_compiler/test_literal_year/datetime/*',
                                       'snapshots/test_compiler/test_literal_year/string_date/*',
                                       'snapshots/test_compiler/test_literal_year/string_timestamp/*',
                                       'snapshots/test_compiler/test_literal_year/timestamp/*',
                                       'snapshots/test_compiler/test_literal_year/timestamp_date/*',
                                       'snapshots/test_compiler/test_now/*',
                                       'snapshots/test_compiler/test_projection_fusion_only_peeks_at_immediate_parent/*',
                                       'snapshots/test_compiler/test_range_window_function/prec_foll/*',
                                       'snapshots/test_compiler/test_range_window_function/prec_prec/*',
                                       'snapshots/test_compiler/test_set_operation/difference/*',
                                       'snapshots/test_compiler/test_set_operation/intersect/*',
                                       'snapshots/test_compiler/test_set_operation/union_all/*',
                                       'snapshots/test_compiler/test_set_operation/union_distinct/*',
                                       'snapshots/test_compiler/test_substring/*',
                                       'snapshots/test_compiler/test_temporal_truncate/day-date/*',
                                       'snapshots/test_compiler/test_temporal_truncate/day-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/hour-time/*',
                                       'snapshots/test_compiler/test_temporal_truncate/hour-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/micros-time/*',
                                       'snapshots/test_compiler/test_temporal_truncate/micros-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/millis-time/*',
                                       'snapshots/test_compiler/test_temporal_truncate/millis-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/minute-time/*',
                                       'snapshots/test_compiler/test_temporal_truncate/minute-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/month-date/*',
                                       'snapshots/test_compiler/test_temporal_truncate/month-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/quarter-date/*',
                                       'snapshots/test_compiler/test_temporal_truncate/quarter-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/second-time/*',
                                       'snapshots/test_compiler/test_temporal_truncate/second-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/week-date/*',
                                       'snapshots/test_compiler/test_temporal_truncate/week-timestamp/*',
                                       'snapshots/test_compiler/test_temporal_truncate/year-date/*',
                                       'snapshots/test_compiler/test_temporal_truncate/year-timestamp/*',
                                       'snapshots/test_compiler/test_to_timestamp_no_timezone/*',
                                       'snapshots/test_compiler/test_to_timestamp_timezone/*',
                                       'snapshots/test_compiler/test_trailing_range_window/days/*',
                                       'snapshots/test_compiler/test_trailing_range_window/five/*',
                                       'snapshots/test_compiler/test_trailing_range_window/hours/*',
                                       'snapshots/test_compiler/test_trailing_range_window/micros/*',
                                       'snapshots/test_compiler/test_trailing_range_window/minutes/*',
                                       'snapshots/test_compiler/test_trailing_range_window/nanos/*',
                                       'snapshots/test_compiler/test_trailing_range_window/seconds/*',
                                       'snapshots/test_compiler/test_trailing_range_window/two_days/*',
                                       'snapshots/test_compiler/test_trailing_range_window/week/*',
                                       'snapshots/test_compiler/test_union/False/*',
                                       'snapshots/test_compiler/test_union/True/*',
                                       'snapshots/test_compiler/test_union_cte/False-False/*',
                                       'snapshots/test_compiler/test_union_cte/False-True/*',
                                       'snapshots/test_compiler/test_union_cte/True-False/*',
                                       'snapshots/test_compiler/test_union_cte/True-True/*',
                                       'snapshots/test_compiler/test_window_function/current_foll/*',
                                       'snapshots/test_compiler/test_window_function/prec_current/*',
                                       'snapshots/test_compiler/test_window_function/prec_prec/*',
                                       'snapshots/test_compiler/test_window_unbounded/following/*',
                                       'snapshots/test_compiler/test_window_unbounded/preceding/*'],
 'ibis.backends.bigquery.tests.unit.udf': ['snapshots/test_core/test_assign/*',
                                           'snapshots/test_core/test_binary_operators/add/*',
                                           'snapshots/test_core/test_binary_operators/div/*',
                                           'snapshots/test_core/test_binary_operators/mul/*',
                                           'snapshots/test_core/test_binary_operators/sub/*',
                                           'snapshots/test_core/test_class/*',
                                           'snapshots/test_core/test_class_with_properties/*',
                                           'snapshots/test_core/test_continue/*',
                                           'snapshots/test_core/test_delete/*',
                                           'snapshots/test_core/test_dict/*',
                                           'snapshots/test_core/test_floordiv/*',
                                           'snapshots/test_core/test_function_def/*',
                                           'snapshots/test_core/test_lambda_with_splat/*',
                                           'snapshots/test_core/test_len_rewrite/*',
                                           'snapshots/test_core/test_list_comp/*',
                                           'snapshots/test_core/test_logical_not/*',
                                           'snapshots/test_core/test_missing_vararg/*',
                                           'snapshots/test_core/test_pow/*',
                                           'snapshots/test_core/test_scope_with_while/*',
                                           'snapshots/test_core/test_set_to_object/*',
                                           'snapshots/test_core/test_setitem/*',
                                           'snapshots/test_core/test_splat/*',
                                           'snapshots/test_core/test_str/*',
                                           'snapshots/test_core/test_true_false_none/*',
                                           'snapshots/test_core/test_tuple/*',
                                           'snapshots/test_core/test_unary_minus/*',
                                           'snapshots/test_core/test_unary_plus/*',
                                           'snapshots/test_core/test_varargs/*',
                                           'snapshots/test_core/test_variable_declaration/*',
                                           'snapshots/test_core/test_yield/*',
                                           'snapshots/test_core/test_yield_from/*'],
 'ibis.backends.clickhouse.tests': ['snapshots/test_aggregations/test_reduction_where/count/*',
                                    'snapshots/test_aggregations/test_reduction_where/max/*',
                                    'snapshots/test_aggregations/test_reduction_where/mean/*',
                                    'snapshots/test_aggregations/test_reduction_where/min/*',
                                    'snapshots/test_aggregations/test_reduction_where/std/*',
                                    'snapshots/test_aggregations/test_reduction_where/sum/*',
                                    'snapshots/test_aggregations/test_reduction_where/var/*',
                                    'snapshots/test_aggregations/test_std_var_pop/std/*',
                                    'snapshots/test_aggregations/test_std_var_pop/var/*',
                                    'snapshots/test_functions/test_cast_double_col/float/*',
                                    'snapshots/test_functions/test_cast_double_col/float32/*',
                                    'snapshots/test_functions/test_cast_double_col/float64/*',
                                    'snapshots/test_functions/test_cast_double_col/int16/*',
                                    'snapshots/test_functions/test_cast_double_col/int8/*',
                                    'snapshots/test_functions/test_cast_string_col/date/*',
                                    'snapshots/test_functions/test_cast_string_col/int16/*',
                                    'snapshots/test_functions/test_cast_string_col/int8/*',
                                    'snapshots/test_functions/test_cast_string_col/mapstring_int64/*',
                                    'snapshots/test_functions/test_cast_string_col/string/*',
                                    'snapshots/test_functions/test_cast_string_col/structa_string_b_int64/*',
                                    'snapshots/test_functions/test_cast_string_col/timestamp/*',
                                    'snapshots/test_functions/test_column_regexp_extract/*',
                                    'snapshots/test_functions/test_column_regexp_replace/*',
                                    'snapshots/test_functions/test_greatest_least/*',
                                    'snapshots/test_functions/test_group_concat/comma_none/*',
                                    'snapshots/test_functions/test_group_concat/comma_zero/*',
                                    'snapshots/test_functions/test_group_concat/minus_none/*',
                                    'snapshots/test_functions/test_noop_cast/bigint_col/*',
                                    'snapshots/test_functions/test_noop_cast/bool_col/*',
                                    'snapshots/test_functions/test_noop_cast/date_string_col/*',
                                    'snapshots/test_functions/test_noop_cast/double_col/*',
                                    'snapshots/test_functions/test_noop_cast/float_col/*',
                                    'snapshots/test_functions/test_noop_cast/id/*',
                                    'snapshots/test_functions/test_noop_cast/index/*',
                                    'snapshots/test_functions/test_noop_cast/int_col/*',
                                    'snapshots/test_functions/test_noop_cast/month/*',
                                    'snapshots/test_functions/test_noop_cast/smallint_col/*',
                                    'snapshots/test_functions/test_noop_cast/string_col/*',
                                    'snapshots/test_functions/test_noop_cast/timestamp_col/*',
                                    'snapshots/test_functions/test_noop_cast/tinyint_col/*',
                                    'snapshots/test_functions/test_noop_cast/year/*',
                                    'snapshots/test_functions/test_string_column_find/*',
                                    'snapshots/test_functions/test_string_column_find_in_set/*',
                                    'snapshots/test_functions/test_string_column_like/*',
                                    'snapshots/test_functions/test_string_column_substring/*',
                                    'snapshots/test_functions/test_timestamp_cast/*',
                                    'snapshots/test_functions/test_timestamp_from_integer/*',
                                    'snapshots/test_functions/test_timestamp_truncate/d/*',
                                    'snapshots/test_functions/test_timestamp_truncate/h/*',
                                    'snapshots/test_functions/test_timestamp_truncate/m/*',
                                    'snapshots/test_functions/test_timestamp_truncate/minute/*',
                                    'snapshots/test_functions/test_timestamp_truncate/w/*',
                                    'snapshots/test_functions/test_timestamp_truncate/y/*',
                                    'snapshots/test_functions/test_translate_math_functions/abs/*',
                                    'snapshots/test_functions/test_translate_math_functions/ceil/*',
                                    'snapshots/test_functions/test_translate_math_functions/exp/*',
                                    'snapshots/test_functions/test_translate_math_functions/log/*',
                                    'snapshots/test_functions/test_translate_math_functions/log10/*',
                                    'snapshots/test_functions/test_translate_math_functions/log2/*',
                                    'snapshots/test_functions/test_translate_math_functions/round/*',
                                    'snapshots/test_functions/test_translate_math_functions/round_0/*',
                                    'snapshots/test_functions/test_translate_math_functions/round_2/*',
                                    'snapshots/test_functions/test_translate_math_functions/sign/*',
                                    'snapshots/test_functions/test_translate_math_functions/sqrt/*',
                                    'snapshots/test_literals/test_string_literals/nested_quote/*',
                                    'snapshots/test_literals/test_string_literals/nested_token/*',
                                    'snapshots/test_literals/test_string_literals/simple/*',
                                    'snapshots/test_select/test_complex_array_expr_projection/*',
                                    'snapshots/test_select/test_isin_notin_in_select/*',
                                    'snapshots/test_select/test_isnull_case_expr_rewrite_failure/*',
                                    'snapshots/test_select/test_join_self_reference/*',
                                    'snapshots/test_select/test_named_from_filter_groupby/*',
                                    'snapshots/test_select/test_physical_table_reference_translate/*',
                                    'snapshots/test_select/test_scalar_exprs_no_table_refs/add/*',
                                    'snapshots/test_select/test_scalar_exprs_no_table_refs/now/*',
                                    'snapshots/test_select/test_self_reference_simple/*',
                                    'snapshots/test_select/test_simple_joins/playerID-awardID-any_inner_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-awardID-any_left_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-awardID-inner_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-awardID-left_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-playerID-any_inner_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-playerID-any_left_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-playerID-inner_join/*',
                                    'snapshots/test_select/test_simple_joins/playerID-playerID-left_join/*',
                                    'snapshots/test_select/test_simple_scalar_aggregates/*',
                                    'snapshots/test_select/test_table_column_unbox/*',
                                    'snapshots/test_select/test_timestamp_extract_field/*',
                                    'snapshots/test_select/test_where_simple_comparisons/*',
                                    'snapshots/test_select/test_where_use_if/*',
                                    'snapshots/test_select/test_where_with_between/*',
                                    'snapshots/test_select/test_where_with_timestamp/*'],
 'ibis.backends.impala.tests': ['snapshots/test_analytic_functions/test_analytic_exprs/first/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lag_arg/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lag_default/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lag_explicit_default/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/last/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lead_arg/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lead_default/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/lead_explicit_default/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/ntile/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/percent_rank/*',
                                'snapshots/test_analytic_functions/test_analytic_exprs/row_number/*',
                                'snapshots/test_bucket_histogram/test_bucket_assign_labels/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/close_extreme_false/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/close_extreme_false_closed_right/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/close_extreme_false_include_under_include_over/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/closed_right/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/closed_right_close_extreme_false_include_under/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/closed_right_include_over_include_under/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/default/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/include_over_include_under0/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/include_over_include_under1/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/include_over_include_under2/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/include_under/*',
                                'snapshots/test_bucket_histogram/test_bucket_to_case/include_under_include_over/*',
                                'snapshots/test_case_exprs/test_decimal_fillna_cast_arg/fillna_l_extendedprice/*',
                                'snapshots/test_case_exprs/test_decimal_fillna_cast_arg/fillna_l_extendedprice_double/*',
                                'snapshots/test_case_exprs/test_decimal_fillna_cast_arg/fillna_l_quantity/*',
                                'snapshots/test_case_exprs/test_identical_to/*',
                                'snapshots/test_case_exprs/test_identical_to_special_case/*',
                                'snapshots/test_case_exprs/test_isnull_1_0/*',
                                'snapshots/test_case_exprs/test_nullif_ifnull/nullif_boolean/*',
                                'snapshots/test_case_exprs/test_nullif_ifnull/nullif_input/*',
                                'snapshots/test_case_exprs/test_nullif_ifnull/nullif_negate_boolean/*',
                                'snapshots/test_case_exprs/test_search_case/*',
                                'snapshots/test_case_exprs/test_simple_case/*',
                                'snapshots/test_case_exprs/test_where_use_if/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/coalesce_columns/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/coalesce_scalar/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/greatest_columns/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/greatest_scalar/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/least_columns/*',
                                'snapshots/test_coalesce_greater_least/test_varargs_functions/least_scalar/*',
                                'snapshots/test_ddl_compilation/test_add_partition/*',
                                'snapshots/test_ddl_compilation/test_add_partition_string_key/*',
                                'snapshots/test_ddl_compilation/test_add_partition_with_props/*',
                                'snapshots/test_ddl_compilation/test_alter_partition_properties/*',
                                'snapshots/test_ddl_compilation/test_alter_table_properties/*',
                                'snapshots/test_ddl_compilation/test_avro_other_formats/*',
                                'snapshots/test_ddl_compilation/test_cache_table_pool_name/*',
                                'snapshots/test_ddl_compilation/test_create_external_table_as/*',
                                'snapshots/test_ddl_compilation/test_create_external_table_avro/*',
                                'snapshots/test_ddl_compilation/test_create_table_delimited/*',
                                'snapshots/test_ddl_compilation/test_create_table_like_parquet/*',
                                'snapshots/test_ddl_compilation/test_create_table_parquet/*',
                                'snapshots/test_ddl_compilation/test_create_table_parquet_like_other/*',
                                'snapshots/test_ddl_compilation/test_create_table_parquet_with_schema/*',
                                'snapshots/test_ddl_compilation/test_create_table_with_location_compile/*',
                                'snapshots/test_ddl_compilation/test_drop_partition/*',
                                'snapshots/test_ddl_compilation/test_drop_table_compile/*',
                                'snapshots/test_ddl_compilation/test_load_data_partitioned/*',
                                'snapshots/test_ddl_compilation/test_load_data_unpartitioned/*',
                                'snapshots/test_ddl_compilation/test_no_overwrite/*',
                                'snapshots/test_ddl_compilation/test_select_basics/*',
                                'snapshots/test_exprs/test_filter_with_analytic/*',
                                'snapshots/test_exprs/test_named_from_filter_group_by/*',
                                'snapshots/test_exprs/test_nunique_where/*',
                                'snapshots/test_exprs/test_where_with_timestamp/*',
                                'snapshots/test_in_not_in/test_field_in_literals/isin/*',
                                'snapshots/test_in_not_in/test_field_in_literals/notin/*',
                                'snapshots/test_in_not_in/test_isin_notin_in_select/isin/*',
                                'snapshots/test_in_not_in/test_isin_notin_in_select/notin/*',
                                'snapshots/test_in_not_in/test_literal_in_fields/isin/*',
                                'snapshots/test_in_not_in/test_literal_in_fields/notin/*',
                                'snapshots/test_sql/test_group_by_with_window_preserves_range/*',
                                'snapshots/test_sql/test_is_parens/isnull/*',
                                'snapshots/test_sql/test_is_parens/notnull/*',
                                'snapshots/test_sql/test_is_parens_identical_to/*',
                                'snapshots/test_sql/test_join_aliasing/*',
                                'snapshots/test_sql/test_join_key_name/*',
                                'snapshots/test_sql/test_join_key_name2/*',
                                'snapshots/test_sql/test_join_no_predicates_for_impala/cross_join/*',
                                'snapshots/test_sql/test_join_no_predicates_for_impala/inner_join/*',
                                'snapshots/test_sql/test_join_no_predicates_for_impala/left_join/*',
                                'snapshots/test_sql/test_join_no_predicates_for_impala/outer_join/*',
                                'snapshots/test_sql/test_join_with_nested_or_condition/*',
                                'snapshots/test_sql/test_join_with_nested_xor_condition/*',
                                'snapshots/test_sql/test_limit_cte_extract/*',
                                'snapshots/test_sql/test_logically_negate_complex_boolean_expr/*',
                                'snapshots/test_sql/test_multiple_filters/*',
                                'snapshots/test_sql/test_multiple_filters2/*',
                                'snapshots/test_sql/test_nested_join_base/*',
                                'snapshots/test_sql/test_nested_join_multiple_ctes/*',
                                'snapshots/test_sql/test_nested_joins_single_cte/*',
                                'snapshots/test_sql/test_relabel_projection/*',
                                'snapshots/test_string_builtins/test_find/*',
                                'snapshots/test_string_builtins/test_string_builtins/ascii_str/*',
                                'snapshots/test_string_builtins/test_string_builtins/capitalize/*',
                                'snapshots/test_string_builtins/test_string_builtins/extract_host/*',
                                'snapshots/test_string_builtins/test_string_builtins/find/*',
                                'snapshots/test_string_builtins/test_string_builtins/find_in_set_multiple/*',
                                'snapshots/test_string_builtins/test_string_builtins/find_in_set_single/*',
                                'snapshots/test_string_builtins/test_string_builtins/find_with_offset/*',
                                'snapshots/test_string_builtins/test_string_builtins/length/*',
                                'snapshots/test_string_builtins/test_string_builtins/like/*',
                                'snapshots/test_string_builtins/test_string_builtins/like_multiple/*',
                                'snapshots/test_string_builtins/test_string_builtins/lower/*',
                                'snapshots/test_string_builtins/test_string_builtins/lpad_char/*',
                                'snapshots/test_string_builtins/test_string_builtins/lpad_default/*',
                                'snapshots/test_string_builtins/test_string_builtins/lstrip/*',
                                'snapshots/test_string_builtins/test_string_builtins/re_extract/*',
                                'snapshots/test_string_builtins/test_string_builtins/re_replace/*',
                                'snapshots/test_string_builtins/test_string_builtins/re_search/*',
                                'snapshots/test_string_builtins/test_string_builtins/repeat/*',
                                'snapshots/test_string_builtins/test_string_builtins/reverse/*',
                                'snapshots/test_string_builtins/test_string_builtins/rlike/*',
                                'snapshots/test_string_builtins/test_string_builtins/rpad_char/*',
                                'snapshots/test_string_builtins/test_string_builtins/rpad_default/*',
                                'snapshots/test_string_builtins/test_string_builtins/rstrip/*',
                                'snapshots/test_string_builtins/test_string_builtins/strip/*',
                                'snapshots/test_string_builtins/test_string_builtins/strright/*',
                                'snapshots/test_string_builtins/test_string_builtins/substr_0_3/*',
                                'snapshots/test_string_builtins/test_string_builtins/substr_2/*',
                                'snapshots/test_string_builtins/test_string_builtins/translate/*',
                                'snapshots/test_string_builtins/test_string_builtins/upper/*',
                                'snapshots/test_string_builtins/test_string_join/*',
                                'snapshots/test_udf/test_create_uda/False/*',
                                'snapshots/test_udf/test_create_uda/True/*',
                                'snapshots/test_udf/test_create_udf/*',
                                'snapshots/test_udf/test_create_udf_type_conversions/*',
                                'snapshots/test_udf/test_delete_udf_aggregate/*',
                                'snapshots/test_udf/test_delete_udf_db/*',
                                'snapshots/test_udf/test_delete_udf_if_exists/*',
                                'snapshots/test_udf/test_delete_udf_simple/*',
                                'snapshots/test_udf/test_list_udafs/*',
                                'snapshots/test_udf/test_list_udafs_like/*',
                                'snapshots/test_udf/test_list_udf/*',
                                'snapshots/test_udf/test_list_udfs_like/*',
                                'snapshots/test_udf/test_sql_generation/*',
                                'snapshots/test_udf/test_sql_generation_from_infoclass/*',
                                'snapshots/test_unary_builtins/test_hash/*',
                                'snapshots/test_unary_builtins/test_numeric/log_with_base/*',
                                'snapshots/test_unary_builtins/test_numeric/round_expr/*',
                                'snapshots/test_unary_builtins/test_numeric/round_no_args/*',
                                'snapshots/test_unary_builtins/test_numeric/round_two/*',
                                'snapshots/test_unary_builtins/test_numeric/round_zero/*',
                                'snapshots/test_unary_builtins/test_numeric/sign_double/*',
                                'snapshots/test_unary_builtins/test_numeric/sign_float/*',
                                'snapshots/test_unary_builtins/test_numeric/sign_tinyint/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-abs/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-approx_median/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-approx_nunique/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-ceil/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-exp/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-floor/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-ln/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-log/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-log10/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-log2/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-nullifzero/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-sqrt/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/double_col-zeroifnull/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-abs/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-approx_median/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-approx_nunique/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-ceil/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-exp/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-floor/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-ln/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-log/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-log10/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-log2/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-nullifzero/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-sqrt/*',
                                'snapshots/test_unary_builtins/test_numeric_unary_builtins/int_col-zeroifnull/*',
                                'snapshots/test_unary_builtins/test_reduction_where/avg/*',
                                'snapshots/test_unary_builtins/test_reduction_where/count/*',
                                'snapshots/test_unary_builtins/test_reduction_where/max/*',
                                'snapshots/test_unary_builtins/test_reduction_where/min/*',
                                'snapshots/test_unary_builtins/test_reduction_where/stddev_pop/*',
                                'snapshots/test_unary_builtins/test_reduction_where/stddev_samp/*',
                                'snapshots/test_unary_builtins/test_reduction_where/sum/*',
                                'snapshots/test_unary_builtins/test_reduction_where/var_pop/*',
                                'snapshots/test_unary_builtins/test_reduction_where/var_samp/*',
                                'snapshots/test_value_exprs/test_any_all/all/*',
                                'snapshots/test_value_exprs/test_any_all/any/*',
                                'snapshots/test_value_exprs/test_any_all/not_all/*',
                                'snapshots/test_value_exprs/test_any_all/not_any/*',
                                'snapshots/test_value_exprs/test_between/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/add/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/and/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/div/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/eq/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/ge/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/gt/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/le/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/lt/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/mul/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/ne/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/or/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/pow/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/sub/*',
                                'snapshots/test_value_exprs/test_binary_infix_operators/xor/*',
                                'snapshots/test_value_exprs/test_binary_infix_parenthesization/function_call/*',
                                'snapshots/test_value_exprs/test_binary_infix_parenthesization/negation/*',
                                'snapshots/test_value_exprs/test_binary_infix_parenthesization/parens_left/*',
                                'snapshots/test_value_exprs/test_casts/a-int16/*',
                                'snapshots/test_value_exprs/test_casts/a-int32/*',
                                'snapshots/test_value_exprs/test_casts/a-int64/*',
                                'snapshots/test_value_exprs/test_casts/a-string/*',
                                'snapshots/test_value_exprs/test_casts/d-int8/*',
                                'snapshots/test_value_exprs/test_casts/g-double/*',
                                'snapshots/test_value_exprs/test_casts/g-timestamp/*',
                                'snapshots/test_value_exprs/test_column_ref_table_aliases/*',
                                'snapshots/test_value_exprs/test_correlated_predicate_subquery/*',
                                'snapshots/test_value_exprs/test_decimal_builtins/precision/*',
                                'snapshots/test_value_exprs/test_decimal_builtins/scale/*',
                                'snapshots/test_value_exprs/test_decimal_casts/column/*',
                                'snapshots/test_value_exprs/test_decimal_casts/literal/*',
                                'snapshots/test_value_exprs/test_isnull_notnull/compound_isnull/*',
                                'snapshots/test_value_exprs/test_isnull_notnull/isnull/*',
                                'snapshots/test_value_exprs/test_isnull_notnull/notnull/*',
                                'snapshots/test_value_exprs/test_literals/embedded_double_quote/*',
                                'snapshots/test_value_exprs/test_literals/embedded_single_quote/*',
                                'snapshots/test_value_exprs/test_literals/false/*',
                                'snapshots/test_value_exprs/test_literals/float/*',
                                'snapshots/test_value_exprs/test_literals/int/*',
                                'snapshots/test_value_exprs/test_literals/simple/*',
                                'snapshots/test_value_exprs/test_literals/true/*',
                                'snapshots/test_value_exprs/test_misc_conditionals/*',
                                'snapshots/test_value_exprs/test_named_expressions/cast/*',
                                'snapshots/test_value_exprs/test_named_expressions/compound_expr/*',
                                'snapshots/test_value_exprs/test_named_expressions/spaces/*',
                                'snapshots/test_value_exprs/test_negate/a/*',
                                'snapshots/test_value_exprs/test_negate/f/*',
                                'snapshots/test_value_exprs/test_negate/h/*',
                                'snapshots/test_value_exprs/test_sql_extract/*',
                                'snapshots/test_value_exprs/test_timestamp_day_of_week/full_name/*',
                                'snapshots/test_value_exprs/test_timestamp_day_of_week/index/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/days/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/hours/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/minutes/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/months/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/seconds/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/weeks/*',
                                'snapshots/test_value_exprs/test_timestamp_deltas/years/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/day/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/hour/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/millisecond/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/minute/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/month/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/second/*',
                                'snapshots/test_value_exprs/test_timestamp_extract_field/year/*',
                                'snapshots/test_value_exprs/test_timestamp_from_integer/default/*',
                                'snapshots/test_value_exprs/test_timestamp_from_integer/ms/*',
                                'snapshots/test_value_exprs/test_timestamp_from_integer/us/*',
                                'snapshots/test_value_exprs/test_timestamp_literals/pd_timestamp/*',
                                'snapshots/test_value_exprs/test_timestamp_literals/pydatetime/*',
                                'snapshots/test_value_exprs/test_timestamp_literals/timestamp_function/*',
                                'snapshots/test_value_exprs/test_timestamp_now/*',
                                'snapshots/test_window/test_add_default_order_by/*',
                                'snapshots/test_window/test_aggregate_in_projection/*',
                                'snapshots/test_window/test_cumulative_functions/max/*',
                                'snapshots/test_window/test_cumulative_functions/mean/*',
                                'snapshots/test_window/test_cumulative_functions/min/*',
                                'snapshots/test_window/test_cumulative_functions/sum/*',
                                'snapshots/test_window/test_multiple_windows/*',
                                'snapshots/test_window/test_nested_analytic_function/*',
                                'snapshots/test_window/test_order_by_desc/*',
                                'snapshots/test_window/test_propagate_nested_windows/*',
                                'snapshots/test_window/test_rank_functions/*',
                                'snapshots/test_window/test_row_number_does_not_require_order_by/*',
                                'snapshots/test_window/test_row_number_properly_composes_with_arithmetic/*',
                                'snapshots/test_window/test_window_frame_specs/cumulative/*',
                                'snapshots/test_window/test_window_frame_specs/foll_0/*',
                                'snapshots/test_window/test_window_frame_specs/foll_10_5/*',
                                'snapshots/test_window/test_window_frame_specs/foll_2/*',
                                'snapshots/test_window/test_window_frame_specs/foll_2_prec_0/*',
                                'snapshots/test_window/test_window_frame_specs/foll_5_10/*',
                                'snapshots/test_window/test_window_frame_specs/prec_0/*',
                                'snapshots/test_window/test_window_frame_specs/prec_5/*',
                                'snapshots/test_window/test_window_frame_specs/prec_5_foll_0/*',
                                'snapshots/test_window/test_window_frame_specs/prec_5_foll_2/*',
                                'snapshots/test_window/test_window_frame_specs/trailing_10/*'],
 'ibis.backends.postgres.tests': ['snapshots/test_client/test_compile_toplevel/*'],
 'ibis.backends.sqlite.tests': ['snapshots/test_client/test_compile_toplevel/*'],
 'ibis.tests.sql': ['snapshots/test_compiler/test_agg_and_non_agg_filter/*',
                    'snapshots/test_compiler/test_agg_filter/*',
                    'snapshots/test_compiler/test_agg_filter_with_alias/*',
                    'snapshots/test_compiler/test_having_size/*',
                    'snapshots/test_compiler/test_pushdown_with_or/*',
                    'snapshots/test_compiler/test_simple_agg_filter/*',
                    'snapshots/test_select_sql/test_aggregate_having/*',
                    'snapshots/test_select_sql/test_aggregate_projection_alias_bug/*',
                    'snapshots/test_select_sql/test_aggregate_projection_subquery/*',
                    'snapshots/test_select_sql/test_bug_duplicated_where/*',
                    'snapshots/test_select_sql/test_bug_project_multiple_times/*',
                    'snapshots/test_select_sql/test_double_nested_subquery_no_aliases/*',
                    'snapshots/test_select_sql/test_filter_inside_exists/*',
                    'snapshots/test_select_sql/test_filter_predicates/*',
                    'snapshots/test_select_sql/test_filter_self_join_analysis_bug/*',
                    'snapshots/test_select_sql/test_filter_subquery_derived_reduction/*',
                    'snapshots/test_select_sql/test_identifier_quoting/*',
                    'snapshots/test_select_sql/test_join_filtered_tables_no_pushdown/*',
                    'snapshots/test_select_sql/test_join_projection_subquery_bug/*',
                    'snapshots/test_select_sql/test_join_with_limited_table/*',
                    'snapshots/test_select_sql/test_limit_cte_extract/*',
                    'snapshots/test_select_sql/test_loj_subquery_filter_handling/*',
                    'snapshots/test_select_sql/test_projection_filter_fuse/*',
                    'snapshots/test_select_sql/test_scalar_subquery_different_table/*',
                    'snapshots/test_select_sql/test_self_join_subquery_distinct_equal/*',
                    'snapshots/test_select_sql/test_sort_then_group_by_propagates_keys/*',
                    'snapshots/test_select_sql/test_subquery_factor_correlated_subquery/*',
                    'snapshots/test_select_sql/test_subquery_in_filter_predicate/*',
                    'snapshots/test_select_sql/test_subquery_used_for_self_join/*',
                    'snapshots/test_select_sql/test_topk_analysis_bug/*',
                    'snapshots/test_select_sql/test_topk_operation/*',
                    'snapshots/test_select_sql/test_topk_predicate_pushdown_bug/*',
                    'snapshots/test_select_sql/test_topk_to_aggregate/*',
                    'snapshots/test_select_sql/test_tpch_self_join_failure/*',
                    'snapshots/test_sqlalchemy/test_cte_factor_distinct_but_equal/*',
                    'snapshots/test_sqlalchemy/test_exists/*',
                    'snapshots/test_sqlalchemy/test_no_cart_join/*',
                    'snapshots/test_sqlalchemy/test_not_exists/*',
                    'snapshots/test_sqlalchemy/test_order_by_expr/*',
                    'snapshots/test_sqlalchemy/test_self_reference_in_not_exists/*',
                    'snapshots/test_sqlalchemy/test_self_reference_join/*',
                    'snapshots/test_sqlalchemy/test_subquery_aliased/*',
                    'snapshots/test_sqlalchemy/test_where_correlated_subquery/*',
                    'snapshots/test_sqlalchemy/test_where_uncorrelated_subquery/*']}

install_requires = \
['atpublic>=2.3,<4',
 'multipledispatch>=0.6,<1',
 'numpy>=1,<2',
 'pandas>=1.2.5,<2',
 'parsy>=1.3.0,<3',
 'python-dateutil>=2.8.2,<3',
 'pytz>=2022.7',
 'rich>=12.4.4,<14',
 'sqlglot>=10.4.3,<11',
 'toolz>=0.11,<1',
 'typing-extensions>=4.3.0,<5']

extras_require = \
{'bigquery': ['db-dtypes>=0.3,<2',
              'google-cloud-bigquery>=3,<4',
              'google-cloud-bigquery-storage>=2,<3',
              'pydata-google-auth>=1.4.0,<2.0.0'],
 'clickhouse': ['clickhouse-cityhash>=1.0.2,<2',
                'clickhouse-driver[numpy]>=0.1,<1',
                'lz4>=3.1.10,<5'],
 'dask': ['dask[array,dataframe]>=2022.9.1',
          'pyarrow>=2,<11',
          'regex>=2021.7.6'],
 'datafusion': ['datafusion>=0.6,<0.8'],
 'decompiler': ['black>=22.1.0,<23'],
 'duckdb': ['duckdb>=0.3.3,<1',
            'duckdb-engine>=0.1.8,<1',
            'pyarrow>=2,<11',
            'sqlalchemy>=1.4,<2'],
 'geospatial': ['GeoAlchemy2>=0.6.3,<1',
                'geopandas>=0.6,<1',
                'shapely>=1.6,!=1.8.*,<3'],
 'impala': ['fsspec>=2022.1.0',
            'impyla>=0.17,<1',
            'requests>=2,<3',
            'sqlalchemy>=1.4,<2'],
 'mssql': ['pymssql>=2.2.5,<3', 'sqlalchemy>=1.4,<2'],
 'mysql': ['pymysql>=1,<2', 'sqlalchemy>=1.4,<2'],
 'pandas': ['regex>=2021.7.6'],
 'polars': ['polars>=0.14.18,<1', 'pyarrow>=2,<11'],
 'postgres': ['psycopg2>=2.8.4,<3', 'sqlalchemy>=1.4,<2'],
 'pyspark': ['pyarrow>=2,<11', 'pyspark>=3,<4'],
 'snowflake': ['snowflake-connector-python[pandas]>=2.7.10,<3',
               'snowflake-sqlalchemy[pandas]>=1.4.1,<2'],
 'sqlite': ['regex>=2021.7.6', 'sqlalchemy>=1.4,<2'],
 'trino': ['sqlalchemy>=1.4,<2', 'trino[sqlalchemy]>=0.319,<1'],
 'visualization': ['graphviz>=0.16,<1']}

entry_points = \
{'ibis.backends': ['bigquery = ibis.backends.bigquery',
                   'clickhouse = ibis.backends.clickhouse',
                   'dask = ibis.backends.dask',
                   'datafusion = ibis.backends.datafusion',
                   'duckdb = ibis.backends.duckdb',
                   'impala = ibis.backends.impala',
                   'mssql = ibis.backends.mssql',
                   'mysql = ibis.backends.mysql',
                   'pandas = ibis.backends.pandas',
                   'polars = ibis.backends.polars',
                   'postgres = ibis.backends.postgres',
                   'pyspark = ibis.backends.pyspark',
                   'snowflake = ibis.backends.snowflake',
                   'spark = ibis.backends.pyspark',
                   'sqlite = ibis.backends.sqlite',
                   'trino = ibis.backends.trino']}

setup_kwargs = {
    'name': 'ibis-framework',
    'version': '4.0.0',
    'description': 'Productivity-centric Python Big Data Framework',
    'long_description': '# Ibis\n\n[![Documentation Status](https://img.shields.io/badge/docs-docs.ibis--project.org-blue.svg)](http://ibis-project.org)\n[![Anaconda-Server Badge](https://anaconda.org/conda-forge/ibis-framework/badges/version.svg)](https://anaconda.org/conda-forge/ibis-framework)\n[![PyPI](https://img.shields.io/pypi/v/ibis-framework.svg)](https://pypi.org/project/ibis-framework)\n[![Build status](https://github.com/ibis-project/ibis/actions/workflows/ibis-main.yml/badge.svg)](https://github.com/ibis-project/ibis/actions/workflows/ibis-main.yml?query=branch%3Amaster)\n[![Build status](https://github.com/ibis-project/ibis/actions/workflows/ibis-backends.yml/badge.svg)](https://github.com/ibis-project/ibis/actions/workflows/ibis-backends.yml?query=branch%3Amaster)\n[![Codecov branch](https://img.shields.io/codecov/c/github/ibis-project/ibis/master.svg)](https://codecov.io/gh/ibis-project/ibis)\n\n## What is Ibis?\n\nIbis is a Python library that provides a lightweight, universal interface for data wrangling. It helps Python users explore and transform data of any size, stored anywhere.\n\nIbis has three primary components:\n\n1. **A dataframe API for Python**.\n   This means that Python users can write Ibis code to manipulate tabular data.\n2. **Interfaces to 10+ query engines.**\n   This means that wherever data is stored, data scientists can use Ibis as their API of choice to communicate with any of those query engines.\n3. **Deferred execution**.\n   Ibis uses deferred execution, meaning that execution of code is pushed to the query engine.\n   This means users can execute at the speed of their backend, not their local computer.\n\n## Why Use Ibis?\n\nIbis aims to be a future-proof solution to interacting with data using Python and can accomplish this goal through its main features:\n\n- **Familiar API**: Ibis’s API design borrows from popular APIs like pandas and dplyr that most users already know and like to use.\n- **Consistent syntax**: Ibis aims to be universal Python API for tabular data, big or small.\n- **Deferred execution**: Ibis pushes code execution to the query engine and only moves required data into memory when it has to.\n  This leads to more faster, more efficient analytics workflows\n- **Interactive mode**: Ibis also provides an interactive mode, in which users can quickly diagnose problems, do exploratory data analysis, and mock up workflows locally.\n- **10+ supported backends**: Ibis supports multiple query engines and DataFrame APIs.\n  Use one interface to transform with your data wherever it lives: from DataFrames in pandas to parquet files through DuckDB to tables in BigQuery.\n- **Minimize rewrites**: Depending on backend capabilities, teams can often keep most of their Ibis code the same whether a team changes anything on the backend, like increasing or decreasing computing power, changing the number or size of their databases, or switching backend engines.\n\n## Common Use Cases\n\n- **Speed up prototype to production.**\n  Scale code written and tested locally to the cloud of distributed systems with minimum rewrites.\n- **Boost performance of existing Python or pandas code.**\n  For example a general rule of thumb for pandas is "Have 5 to 10 times as much RAM as the size of your dataset".\n  When a dataset exceeds this rule, using in-memory frameworks, like pandas, can be slow.\n  Instead, using Ibis will significantly speed up your workflows because of its deferred execution.\n  Ibis also empowers you to switch to a faster database engine, without changing much of your code.\n- **Get rid of long, error-prone, fstrings.**\n  Ibis provides one syntax for multiple query engines and dataframe APIs that lets you avoid learning new flavors of SQL or other framework-specific code.\n  Learn the syntax once and use that syntax anywhere.\n\n## Backends\n\nIbis acts as a universal frontend to the following systems:\n\n- [Apache Impala](https://ibis-project.org/docs/latest/backends/Impala/)\n- [ClickHouse](https://ibis-project.org/docs/latest/backends/ClickHouse/)\n- [Dask](https://ibis-project.org/docs/latest/backends/Dask/)\n- [DuckDB](https://ibis-project.org/docs/latest/backends/DuckDB/)\n- [Google BigQuery](https://ibis-project.org/docs/dev/backends/BigQuery/)\n- [HeavyAI](https://github.com/heavyai/ibis-heavyai)\n- [MySQL](https://ibis-project.org/docs/latest/backends/MySQL/)\n- [Microsoft SQL Server](https://ibis-project.org/dev/latest/backends/MSSQL/)\n- [Pandas](https://ibis-project.org/docs/latest/backends/Pandas/)\n- [Polars](https://ibis-project.org/docs/dev/backends/Polars/)\n- [PostgreSQL](https://ibis-project.org/docs/latest/backends/PostgreSQL/)\n- [PySpark](https://ibis-project.org/docs/latest/backends/PySpark/)\n- [Snowflake](https://ibis-project.org/docs/dev/backends/Snowflake) (experimental)\n- [SQLite](https://ibis-project.org/docs/latest/backends/SQLite/)\n- [Trino](https://ibis-project.org/docs/dev/backends/Trino/) (experimental)\n\nThe list of supported backends is continuously growing. Anyone can get involved\nin adding new ones! Learn more about contributing to ibis in our contributing\ndocs at https://github.com/ibis-project/ibis/blob/master/docs/CONTRIBUTING.md\n\n## Installation\n\nInstall Ibis from PyPI with:\n\n```\npip install ibis-framework\n```\n\nOr from conda-forge with:\n\n```\nconda install ibis-framework -c conda-forge\n```\n\n(It’s a common mistake to `pip install ibis`. If you try to use Ibis and get errors early on try uninstalling `ibis` and installing `ibis-framework`)\n\nFor specific backends, include the backend name in brackets for PyPI:\n\n```\npip install ibis-framework[duckdb]\n```\n\nOr use `ibis-$BACKEND` where `$BACKEND` the specific backend you want to use:\n\n```\nconda install ibis-postgres -c conda-forge\n```\n\n## Getting Started with Ibis\n\nYou can find a number of helpful tutorials on the Ibis website\n[here](https://ibis-project.org/docs/latest/tutorial/01-Introduction-to-Ibis/)\nincluding:\n\n- [Introduction to Ibis](https://ibis-project.org/docs/latest/tutorial/01-Introduction-to-Ibis/)\n- [Aggregating and Joining Data](https://ibis-project.org/docs/latest/tutorial/02-Aggregates-Joins/)\n- [Creating and Inserting Data](https://ibis-project.org/docs/latest/tutorial/05-IO-Create-Insert-External-Data/)\n\nYou can also get started analyzing any dataset, anywhere with just a few lines of Ibis code.\nHere’s an example of how to use Ibis with an SQLite database.\n\nDownload the SQLite database from the ibis-tutorial-data GCS (Google Cloud Storage) bucket, then connect to it using ibis.\n\n```bash\n# make a directory called geo_dir and add the geography database to that folder\nmkdir -p geo_dir\ncurl -LsS -o geo_dir/geography.db \'https://storage.googleapis.com/ibis-tutorial-data/geography.db\'\n```\n\nConnect to the the database and show the available tables\n\n```python\n>>> import ibis\n>>> ibis.options.interactive = True\n>>> connection = ibis.sqlite.connect(\'geo_dir/geography.db\')\n>>> connection.list_tables()\n[\'countries\', \'gdp\', \'independence\']\n```\n\nChoose the `countries` table and preview its first few rows\n\n```python\n>>> countries = connection.table(\'countries\')\ncountries.head()\n```\n\n|     | iso_alpha2 | iso_alpha3 | iso_numeric | fips | name                 | capital          | area_km2 | population | continent |\n| :-- | :--------- | :--------- | :---------- | :--- | :------------------- | :--------------- | :------- | :--------- | :-------- |\n| 0   | AD         | AND        | 20          | AN   | Andorra              | Andorra la Vella | 468      | 84000      | EU        |\n| 1   | AE         | ARE        | 784         | AE   | United Arab Emirates | Abu Dhabi        | 82880    | 4975593    | AS        |\n| 2   | AF         | AFG        | 4           | AF   | Afghanistan          | Kabul            | 647500   | 29121286   | AS        |\n| 3   | AG         | ATG        | 28          | AC   | Antigua and Barbuda  | St. Johns        | 443      | 86754      | NA        |\n| 4   | AI         | AIA        | 660         | AV   | Anguilla             | The Valley       | 102      | 13254      | NA        |\n\n```python\n# Select the name, continent and population columns and filter them to only return countries from Asia\n\nasian_countries = countries[\'name\', \'continent\', \'population\'].filter(countries[\'continent\'] == \'AS\')\nasian_countries.limit(6)\n```\n\n|     | name                 | continent | population |\n| :-- | :------------------- | :-------- | :--------- |\n| 0   | United Arab Emirates | AS        | 4975593    |\n| 1   | Afghanistan          | AS        | 29121286   |\n| 2   | Armenia              | AS        | 2968000    |\n| 3   | Azerbaijan           | AS        | 8303512    |\n| 4   | Bangladesh           | AS        | 156118464  |\n| 5   | Bahrain              | AS        | 738004     |\n\n## Community and Contributing\n\nIbis is an open source project and welcomes contributions from anyone in the community.\nRead more about how you can contribute [here](https://github.com/ibis-project/ibis/blob/master/docs/CONTRIBUTING.md).\nWe care about keeping our community welcoming for all to participate and have a [code of conduct](https://github.com/ibis-project/ibis/blob/master/docs/CODE_OF_CONDUCT.md) to ensure this.\nThe Ibis project is open sourced under the [Apache License](https://github.com/ibis-project/ibis/blob/master/LICENSE.txt).\n\nJoin our community here:\n\n- Twitter: https://twitter.com/IbisData\n- Gitter: https://gitter.im/ibis-dev/Lobby\n- StackOverflow: https://stackoverflow.com/questions/tagged/ibis\n\nFor more information visit our official website [here](https://ibis-project.org/docs/latest/).\n',
    'author': 'Ibis Contributors',
    'author_email': 'None',
    'maintainer': 'Ibis Contributors',
    'maintainer_email': 'None',
    'url': 'https://ibis-project.org',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
