# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['flyswot']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8,<10',
 'huggingface-hub>=0.2.1,<0.6.0',
 'numpy>=1.20,<2.0',
 'rich>=10.1,<13.0',
 'toolz>=0.11.1,<0.12.0',
 'transformers[torch]>=4.16.2,<5.0.0',
 'typer>=0.3.2,<0.5.0',
 'typing_extensions>=3.10,<5.0',
 'validators>=0.18.2,<0.19.0']

entry_points = \
{'console_scripts': ['flyswot = flyswot.cli:main']}

setup_kwargs = {
    'name': 'flyswot',
    'version': '0.3.3',
    'description': 'flyswot',
    'long_description': '# flyswot\n\n[![PyPI](https://img.shields.io/pypi/v/flyswot.svg)][pypi_]\n[![Status](https://img.shields.io/pypi/status/hugit.svg)][status]\n[![Python Version](https://img.shields.io/pypi/pyversions/hugit)][python version]\n[![License](https://img.shields.io/pypi/l/hugit)][license]\n\n[![Read the documentation at https://hugit.readthedocs.io/](https://img.shields.io/readthedocs/hugit/latest.svg?label=Read%20the%20Docs)][read the docs]\n[![Tests](https://github.com/davanstrien/flyswot/actions/workflows/tests.yml/badge.svg)](https://github.com/davanstrien/flyswot/actions/workflows/tests.yml)\n[![Codecov](https://codecov.io/gh/davanstrien/hugit/branch/main/graph/badge.svg)][codecov]\n\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][pre-commit]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/flyswot/\n[status]: https://pypi.org/project/flyswot/\n[python version]: https://pypi.org/project/flyswot\n[license]: https://opensource.org/licenses/MIT\n[read the docs]: https://flyswot.readthedocs.io/\n[tests]: https://github.com/davanstrien/flyswot/actions?workflow=Tests\n[codecov]: https://app.codecov.io/gh/davanstrien/flyswot\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n\n![flyswot logo](https://raw.githubusercontent.com/davanstrien/flyswot/main/docs/_static/fly.png?token=ACEUI5KJ2HPO4ZGNTBX6OE3ARMXII)\n\n## Disclaimer\n\n`flyswot` is a work in progress and is currently only intended to be used for testing by [HMD](https://www.bl.uk/projects/heritage-made-digital)\n\nThis code and documentation is a work in progress.\n\n## Features\n\n`flyswot` is a Command Line Tool for detecting \'fake\' flysheets.\n\n- unix style search patterns for matching images to predict against\n- produces a csv output containing the paths to the input images, the predicted label and the models confidence for that prediction.\n- produces a summary \'report\' providing a high level summary of the predictions made by `flyswot`\n- automatically downloads latest available [flyswot model](https://huggingface.co/davanstrien/flyswot)\n\n[![asciicast](https://asciinema.org/a/449685.svg)](https://asciinema.org/a/449685)\n\n## Requirements\n\n- Python 3.7 or greater\n\n## Installation\n\nYou can install _flyswot_ via [pip] from [PyPI]:\n\n```console\n$ pip install flyswot\n```\n\nThis will install the latest release version of _flyswot_\n\n## Detailed Installation Guide\n\nThis section gives a more detailed instructions for installing _flyswot_. This guidance is aimed particularly at [HMD] users of _flyswot_. This set of instructions covers the steps required to install _flyswot_.\n\n### Note on the examples\n\nYou will see examples for input in the guidance below which looks like:\n\n```console\n$ pip\n```\n\nThe `$` symbol here is often used as a convention to show that this is input to a terminal/command line. When you input this into your own terminal you should only input the part after the `$` symbol. For example, in the above case you would type `pip`.\n\n### Install Python\n\n_flyswot_ uses the [Python] programming language. You will therefore need to have Python installed on your computer to run _flyswot_.\n\nFor HMD users of `flyswot` it is suggested to use the [Anaconda] distribution of Python. If you are on a managed PC/laptop you should request this to be installed via the Technology team.\n\n### Create and activate a Conda Environment\n\nA virtual environment allows us to isolate the requirements of different python packages. This can be useful since different python packages might have different requirements. Using a virtual environment allows us to install these in a way where you are less likely to have conflicts between these packages.\n\nThere are various different ways of creating virtual environments within Python. Anaconda comes with a system for creating virtual environment\'s. Creating Conda environments within Conda can be done in various ways, if you are new to Python and Anaconda it is suggested to use [Anaconda Navigator].\n\nYou can find more detailed instructions for creating a new virtual environments in the [Anaconda documentation]. Briefly you should:\n\n- Open Anaconda Navigator\n- Navigate to the _Environments_ tab\n- Create a new Python environment and give it a descriptive name i.e. _flyswot_. You should ensure that the Python version is version 3.7 or above.\n\nOnce you have created this new environment you can "activate it" by clicking on the arrow next to the name of the environment. You should select the "open terminal". This should open a new terminal window. On the left you should see the name of your environment in brackets:\n\n```console\n(flyswot) $\n```\n\n### Install flyswot in your Conda Environment\n\nNow you have created and activated your conda environment you can install flyswot. Before doing this you can check that [pip] is available inside your environment:\n\n```console\n$ pip\n```\n\nThis should return the help pages for [pip]. We can now use [pip] to install _flyswot_ from [PyPI].\nTo do this run:\n\n```console\n$ pip install flyswot\n```\n\nYou should now see the installation process begin. During this you will see some information printed to the terminal abou what packages are being installed.\n\n### Check flyswot is installed\n\nWe can quickly confirm that _flyswot_ has been installed by printing out the help information. We can do this by typing:\n\n```console\n$ flyswot --help\n```\n\nThis should print some help information to the screen. If you get this it means you have successfully installed _flyswot_ 💪.\n\n### Update flyswot\n\nIf you need to upgrade your version of flyswot you should activate your Conda Environment and then run\n\n```console\n$ pip install flyswot --upgrade\n```\n\n## Usage\n\nYou can see help for `flyswot` using `flyswot --help`\n\n<!-- [[[cog\nimport cog\nfrom flyswot.cli import app\nfrom typer.testing import CliRunner\nrunner = CliRunner()\nresult = runner.invoke(app, ["--help"])\nhelp = result.output.replace("Usage: root", "Usage: flyswot")\ncog.out(\n    "```\\n{}\\n```".format(help)\n)\n]]] -->\n\n```\nUsage: flyswot [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --install-completion [bash|zsh|fish|powershell|pwsh]\n                                  Install completion for the specified shell.\n  --show-completion [bash|zsh|fish|powershell|pwsh]\n                                  Show completion for the specified shell, to\n                                  copy it or customize the installation.\n  --help                          Show this message and exit.\n\nCommands:\n  model    flyswot commands for interacting with models\n  predict  flyswot commands for making predictions\n\n```\n\n<!-- [[[end]]] -->\n\n### Making predictions\n\nYou can get help for the prediction functionality for `flyswot` as follows:\n\n<!-- [[[cog\nimport cog\nfrom flyswot.cli import app\nfrom typer.testing import CliRunner\nrunner = CliRunner()\nresult = runner.invoke(app,  ["predict", "directory", "--help"])\nhelp = result.output.replace("Usage: root", "Usage: flyswot")\ncog.out(\n    "```\\n{}\\n```".format(help)\n)\n]]] -->\n\n```\nUsage: flyswot predict directory [OPTIONS] DIRECTORY CSV_SAVE_DIR\n\n  Predicts against all images stored under DIRECTORY which match PATTERN in the\n  filename.\n\n  By default searches for filenames containing \'fs\'.\n\n  Creates a CSV report saved to `csv_save_dir`\n\nArguments:\n  DIRECTORY     Directory to start searching for images from  [required]\n  CSV_SAVE_DIR  Directory used to store the csv report  [required]\n\nOptions:\n  --model-id TEXT       The model flyswot should use for making predictions\n                        [default: flyswot/convnext-tiny-224_flyswot]\n  --model-path TEXT\n  --pattern TEXT        Pattern used to filter image filenames  [default: fs]\n  --bs INTEGER          Batch Size  [default: 16]\n  --image-formats TEXT  Image format for flyswot to use for predictions,\n                        defaults to `*.tif`  [default: .tif]\n  --help                Show this message and exit.\n\n```\n\n<!-- [[[end]]] -->\n\nTo run predictions against a directory of images:\n\n```console\n$ flyswot predict directory manuscripts_folder .\n```\n\n- _flyswot_ will search inside the manuscripts_folder looking for image files.\n- By default it will look for files that contain {code}`FS` in the filename since these are files which have been labelled as being "end flysheets" or "front flysheets"\n- Once it has found all the files labelled as `flysheet` it will then run a computer vision model against these images to see if they are labelled correctly i.e. if it is indeed a flysheet or something else.\n- flyswot will save a csv report containing the paths to the image, the directory the image is stored in, the label, and the confidence for that prediction.\n\n## Detailed Usage Guide\n\nThis section provides additional guidance on the usage of _flyswot_. This is primarily aimed at [HMD] users of _flyswot_.\n\n### How flyswot searches for images\n\n_flyswot_ is currently intended to identify images which have an incorrect label associated with them. In particular it is currently intended to identify "fake" flysheets. These images have `fs` as part of their filename so this is used by _flyswot_ to identify images which should be checked using the computer vision model. This can be channged if you also want to match other filename patterns.\n\nSince these images of concern will often be inside a directory structure _flyswot_ will look in sub-folders from the input folder for images which contain `fs` in the name. For example in the following folder structure:\n\n```console\nCollection/\n├─ item1/\n│  ├─ add_ms_9403_fbspi.tif\n│  ├─ add_ms_9403_fse001r.tif\n│  ├─ add_ms_9403_fse001v.tif\n├─ item2/\n│  ├─ sloane_ms_116_fblefr.tif\n│  ├─ sloane_ms_116_fbspi.tif\n│  ├─ sloane_ms_116_fse004r.tif\n```\n\nAll of the files which have `fs` in the filname will be check but files which don\'t contains `fs` such as `add_ms_9403_fbspi.tif` will be ignored since these aren\'t labelled as flysheets.\n\n### Running flyswot against a directory of images\n\nTo run _flyswot_ against a directory of images you need to give it the path to that directory/folder.\nThere are different ways you could do this. The following is suggested for people who are not very familiar (yet 😜) with terminal interfaces.\n\nIdentify the folder you want to _flyswot_ to check for "fake" flysheets. If you are using _flyswot_ for the first time it may make sense to choose a folder which doesn\'t contain a huge number of collection items so you don\'t have to wait to long for _flyswot_ to finish running. Once you have found a directory you want to predict against copy the path. This path should be the full path to the item.\n\nFor example something that looks like:\n\n```console\n\\\\ad\\collections\\hmd\\excitingcollection\\excitingsubcollection\\\n```\n\nThis will be the folder from which _flyswot_ starts looking.\n\nWhen you activated your conda environment in a terminal, you were likely \'inside\' your user directory. Since we need to specify a place for _flyswot_ to store the CSV report, we\'ll move to a better place to store that output; your `Desktop` folder. To do we can navigate using the command:\n\n```console\n$ chdir desktop\n```\n\nif you are using Mac, Linux or have GitBash installed you should instead run:\n\n```console\n$ cd Desktop\n```\n\nThis will take you to your Desktop. We\'ll now run _flyswot_. As with many other command line tools, _flyswot_ has commands and sub-commands. We are interested in the `predict` command. This includes two sub-commands: `predict-image` and `directory`. We will mostly want to predict directories. To do this we use the following approach\n\n```console\n$ flyswot predict directory input_directory output_directory\n```\n\nThe input directory is the folder containing our images and the output directory is where we want to save our CSV report. Using the folder we previously identified this would look like:\n\n```console\n$ flyswot predict directory "\\\\ad\\collections\\hmd\\excitingcollection\\excitingsubcollection\\" .\n```\n\nWe can use `.` to indicate we want the CSV report to be saved to the current directory (in this case the Deskop directory). Also notice that there are quotation marks `""` around the path. This is used to make sure that any spaces in the path are escaped.\n\nOnce you run this command you should see some progress reported by _flyswot_, including a progress bar that shows how many of the images _flyswot_ has predicted against.\n\nWhen _flyswot_ has finshed you will have a CSV \'report\' which contains the path to the image, the predicted label and the confidence for that prediction.\n\n## License\n\nDistributed under the terms of the [MIT license],\n_flyswot_ is free and open source software.\n\n## Issues\n\nIf you encounter any problems,\nplease [file an issue] along with a detailed description.\n\n## Credits\n\nThis project was generated from [@cjolowicz]\'s [Hypermodern Python Cookiecutter] template.\n\n[@cjolowicz]: https://github.com/cjolowicz\n[cookiecutter]: https://github.com/audreyr/cookiecutter\n[mit license]: https://opensource.org/licenses/MIT\n[pypi]: https://pypi.org/\n[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n[file an issue]: https://github.com/davanstrien/flyswot/issues\n[pip]: https://pip.pypa.io/\n\n<!-- github-only -->\n\n[contributor guide]: https://github.com/davanstrien/flyswot/blob/main/CONTRIBUTING.md\n',
    'author': 'Daniel van Strien',
    'author_email': 'daniel.van-strien@bl.uk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/davanstrien/flyswot',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
