# foxtail-trainer-api
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import foxtail_trainer_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import foxtail_trainer_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import foxtail_trainer_api
from foxtail_trainer_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = foxtail_trainer_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with foxtail_trainer_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = foxtail_trainer_api.JobApi(api_client)
    create_job_command = foxtail_trainer_api.CreateJobCommand() # CreateJobCommand | Job to store (optional)

    try:
        # Create and store job entity.   Post an empty Job or Job with models
        api_response = api_instance.api_job_create_job_post(create_job_command=create_job_command)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling JobApi->api_job_create_job_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*JobApi* | [**api_job_create_job_post**](docs/JobApi.md#api_job_create_job_post) | **POST** /api/Job/CreateJob | Create and store job entity.   Post an empty Job or Job with models
*JobApi* | [**api_job_get_job_id_get**](docs/JobApi.md#api_job_get_job_id_get) | **GET** /api/Job/GetJob/{id} | Get job
*JobApi* | [**api_job_run_job_id_post**](docs/JobApi.md#api_job_run_job_id_post) | **POST** /api/Job/RunJob/{id} | 
*MLModelApi* | [**api_job_job_id_ml_model_add_post**](docs/MLModelApi.md#api_job_job_id_ml_model_add_post) | **POST** /api/Job/{jobId}/MLModel/Add | Add ML models to the job
*MLModelApi* | [**api_job_job_id_ml_model_delete_all_delete**](docs/MLModelApi.md#api_job_job_id_ml_model_delete_all_delete) | **DELETE** /api/Job/{jobId}/MLModel/DeleteAll | Delete ML models from job
*MLModelApi* | [**api_job_job_id_ml_model_get_all_get**](docs/MLModelApi.md#api_job_job_id_ml_model_get_all_get) | **GET** /api/Job/{jobId}/MLModel/GetAll | Get list of model guids for job
*MLModelApi* | [**api_job_job_id_ml_model_get_id_get**](docs/MLModelApi.md#api_job_job_id_ml_model_get_id_get) | **GET** /api/Job/{jobId}/MLModel/Get/{id} | 
*MLModelApi* | [**api_job_job_id_ml_model_update_status_id_put**](docs/MLModelApi.md#api_job_job_id_ml_model_update_status_id_put) | **PUT** /api/Job/{jobId}/MLModel/UpdateStatus/{id} | 
*ReportApi* | [**api_job_job_id_report_get_job_metric_get**](docs/ReportApi.md#api_job_job_id_report_get_job_metric_get) | **GET** /api/Job/{jobId}/Report/GetJobMetric | 
*ReportApi* | [**api_job_job_id_report_get_ml_models_metric_get**](docs/ReportApi.md#api_job_job_id_report_get_ml_models_metric_get) | **GET** /api/Job/{jobId}/Report/GetMLModelsMetric | 
*ReportApi* | [**api_job_job_id_report_get_ml_models_status_counts_get**](docs/ReportApi.md#api_job_job_id_report_get_ml_models_status_counts_get) | **GET** /api/Job/{jobId}/Report/GetMLModelsStatusCounts | 
*ReportApi* | [**api_job_job_id_report_get_ml_models_status_get**](docs/ReportApi.md#api_job_job_id_report_get_ml_models_status_get) | **GET** /api/Job/{jobId}/Report/GetMLModelsStatus | Get status for every model. Report contains model id and current status.
*ReportApi* | [**api_job_job_id_report_get_ml_models_url_get**](docs/ReportApi.md#api_job_job_id_report_get_ml_models_url_get) | **GET** /api/Job/{jobId}/Report/GetMLModelsUrl | 
*ReportApi* | [**api_job_job_id_report_get_training_time_get**](docs/ReportApi.md#api_job_job_id_report_get_training_time_get) | **GET** /api/Job/{jobId}/Report/GetTrainingTime | 
*TrainingConfigApi* | [**api_job_job_id_training_config_get_id_get**](docs/TrainingConfigApi.md#api_job_job_id_training_config_get_id_get) | **GET** /api/Job/{jobId}/TrainingConfig/Get/{id} | 
*TrainingResultApi* | [**api_job_job_id_ml_model_ml_model_id_training_result_create_post**](docs/TrainingResultApi.md#api_job_job_id_ml_model_ml_model_id_training_result_create_post) | **POST** /api/Job/{jobId}/MLModel/{mlModelId}/TrainingResult/Create | 
*TrainingResultApi* | [**api_job_job_id_ml_model_ml_model_id_training_result_get_id_get**](docs/TrainingResultApi.md#api_job_job_id_ml_model_ml_model_id_training_result_get_id_get) | **GET** /api/Job/{jobId}/MLModel/{mlModelId}/TrainingResult/Get/{id} | 


## Documentation For Models

 - [AggregatedMetricReportDto](docs/AggregatedMetricReportDto.md)
 - [CreateDataSetsSizesDto](docs/CreateDataSetsSizesDto.md)
 - [CreateJobCommand](docs/CreateJobCommand.md)
 - [CreateMLModelDto](docs/CreateMLModelDto.md)
 - [CreateMLModelsCommand](docs/CreateMLModelsCommand.md)
 - [CreateMetricDto](docs/CreateMetricDto.md)
 - [CreateTrainingConfigDto](docs/CreateTrainingConfigDto.md)
 - [CreateTrainingHistoryDto](docs/CreateTrainingHistoryDto.md)
 - [CreateTrainingResultCommand](docs/CreateTrainingResultCommand.md)
 - [CreateTrainingResultDto](docs/CreateTrainingResultDto.md)
 - [CreatedJobDto](docs/CreatedJobDto.md)
 - [CreatedMLModelsDto](docs/CreatedMLModelsDto.md)
 - [DataSetsSizesDto](docs/DataSetsSizesDto.md)
 - [DeletedMLModelsDto](docs/DeletedMLModelsDto.md)
 - [JobDto](docs/JobDto.md)
 - [JobMetricReportDto](docs/JobMetricReportDto.md)
 - [MLModelDto](docs/MLModelDto.md)
 - [MLModelMetricReportDto](docs/MLModelMetricReportDto.md)
 - [MLModelsGuidsListDto](docs/MLModelsGuidsListDto.md)
 - [MLModelsMetricListReportDto](docs/MLModelsMetricListReportDto.md)
 - [MLModelsStatusCountReportDto](docs/MLModelsStatusCountReportDto.md)
 - [MLModelsStatusCountsListReportDto](docs/MLModelsStatusCountsListReportDto.md)
 - [MLModelsStatusListReportDto](docs/MLModelsStatusListReportDto.md)
 - [MLModelsStatusReportDto](docs/MLModelsStatusReportDto.md)
 - [MLModelsUrlListReportDto](docs/MLModelsUrlListReportDto.md)
 - [MLModelsUrlReportDto](docs/MLModelsUrlReportDto.md)
 - [MetricDto](docs/MetricDto.md)
 - [MetricReportDto](docs/MetricReportDto.md)
 - [MetricType](docs/MetricType.md)
 - [ModelStatus](docs/ModelStatus.md)
 - [ModelType](docs/ModelType.md)
 - [ProblemType](docs/ProblemType.md)
 - [RunJobCommand](docs/RunJobCommand.md)
 - [RunedJobDto](docs/RunedJobDto.md)
 - [TrainingConfigDto](docs/TrainingConfigDto.md)
 - [TrainingHistoryDto](docs/TrainingHistoryDto.md)
 - [TrainingResultDto](docs/TrainingResultDto.md)
 - [TrainingTimeReportDto](docs/TrainingTimeReportDto.md)
 - [UpdateMLModelsStatusCommand](docs/UpdateMLModelsStatusCommand.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




