PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themselves. As a rule the men have carefully saved their money, limiting permitted purchases for themselves to send it home to those dependent on them.”

Intemperance and Imprisonment Causes of Poverty.—Just at the time when a board of inebriety has been appointed in New York, the New York Association for Improving the Condition of the Poor, one of the largest and oldest relief societies of this country, announces the results of a statistical study, commented upon thus in the New York World:

“Only two families in every hundred of the 1,573 which have been in the care of the Association for Improving the Condition of the Poor this summer were brought to poverty through intemperance. The percentage goes against preconceived notions and is indeed surprisingly small. It should disturb that prosperous complacency which sees in poverty only or mainly the penalty of wanton misdeed. The association’s report for 1909 showed that intemperance, imprisonment, desertion, ‘shiftlessness and inefficiency,’ all told, accounted for not 12 per cent of those brought to want.

“The figures for that year showed that 65 per cent of the poverty was due to two causes—sickness and unemployment. This summer the two causes account for 68 per cent of the poverty noted, and 43 per cent, or nearly half, was due to sickness alone. Here are causes of misery which society can abate or largely remove and the economic evils of which it can provide against through some form of insurance.”

Prison Labor in District of Columbia.—The establishment of an industrial plant in connection with the new district workhouse and reformatory is being considered by the commissioners.

The plan under consideration is to have school furniture, garbage cans and a variety of articles which the district annually is forced to buy manufactured at the plant.

With the object of determining the feasibility of the scheme, Commissioner Judson recently visited the Hampton Industrial Agricultural Institute, at Hampton, Va., where he observed the manufacturing methods that are employed as a part of the course taught in the school.

It is the opinion of Commissioner Judson that the establishment of an industrial plant by the District, the labor to be supplied by the reformatory prisoners, will prove both practicable and economical.

In the event of the plan materializing, the District, it is said, may sell the articles manufactured at the plant to the different departments of the local government, but may not dispose of them to outside buyers. It was stated today that the commissioners will soon endeavor to secure a new reformatory site.

A “Hobo Army.”—During the first day of September a much-heralded army of the unemployed “descended” on Washington. Thousands had been announced by James Eads How, who for years has been with evident sincerity trying to organize the vagrants of this country into a union. Mr. How’s army numbered at the most several hundred in Washington. The deliberations of the conference furnished space writers of summer newspaper stories with material. But, as the Elizabeth (New Jersey) Journal says: “So far as any impression on the national congress is concerned, the self-styled hoboes might as well have met in Atlantic City.”

Yet there is a real significance in the repeated efforts of James Eads How to organize his hobo brotherhoods in St. Louis, Chicago, New York and elsewhere. His organization efforts seem futile, but his almost fanatical persistency has attracted more newspaper attention to the fact of an ever-present vagrant army that will not work than has any other public event in this field, unless it be the campaign in New York in 1911 for a farm colony for habitual tramps and vagrants. How is pushing the vagrancy problem into the foreground, but perhaps not in the way he imagines.

The Nemesis of Finger Prints.—An editorial in the New York Times of September 5th states that the evidence of guilty finger prints has hitherto been little used in criminal trials. No one has been convicted upon such evidence unsupported by other proof, although in a case of burglary a few months ago the corroborative testimony was supplied by the felon’s confession, made after he had compared the telltale whorls photographed upon the window pane of his victim’s house with his confirmatory digits. A grand jury has this week for the first time returned an indictment upon recorded prints on file at the central office of detectives which are reported to be identical with the faint impressions upon a dusty case found in a loft that had been looted by their stealthy maker. If he is convicted, Captain Faurot of the Police Department’s Bureau of Identification will have won a notable triumph.

Men have been convicted of crimes upon the disputed testimony of handwriting experts. There has always remained some doubt that the chirography of others might be so like their variable hands as to be mistaken for it. There was the chance, too, that some malicious foe had carefully forged the damnatory documents. But the convolutions upon the tactile surfaces of hands and fingers cannot be forged, there is not one chance in a hundred millions that they will resemble the finger prints of another, and their identification with the guilty one is capable of mathematical proof. It would seem that no evidence could be more exact. As its nature becomes known to those who make up our juries, convictions upon such evidence will be common.

Criminal Law and Criminology.—The American Association of Criminal Law and Criminology held its third annual meeting in Boston early in September. Governor Foss of Massachusetts in opening the conferences expressed himself as opposed to the long sentence and in favor of the indeterminate sentence and congenial labor for prisoners.

“The medical world would rise up as a body to condemn any method of medical treatment which left the patient more liable to a recurrence of the disease than he was to its first attack. And yet everywhere men are being sent out of prison with the prison pallor on them, penniless, weakened in body by unwholesome conditions and broken in spirit by the withdrawal of all hope, ambition and self-confidence.

“You are aware that in some places criminals are sent to jail with no guard, going freely on their honor; and that even when they reach the jail they find no prison wall, no armed guard waiting to shoot them down, but only a chance to test their own manhood again; a chance to live in a wholesome place, with sun and air, fair treatment and every incentive to regain their own self-respect.

“I realize that these measures are the extreme and radically opposite to the customary prison methods; and it may be necessary to proceed cautiously in following them. But they have proved effective, and they promise the only hope of betterment that I know of. We can begin to work toward them by gradually abolishing our city prisons, with their dark, cheerless interiors, and building our future houses of correction out in the country, where the sun and wind can get in and where all the men who do not forfeit such right can work in the open fields. There’s nothing dangerously radical in that!”

Professor Kirchwey, of the Columbia university faculty, spoke of the new sense of oneness in society as it is related to the problem of crime. “We can no longer think of society as arrayed against a group of its so-called enemies,” he said. “The criminal is a part of society. The motive power that must drive our reforms is not mere humanitarianism nor sentimentality, but a passion for society as a whole—a realization that society falls short of its oneness, its wholeness, so long as one of its little ones shrivels in the fire.”

He spoke of the institute’s work as a three-fold work: first, to reform criminal judicial procedure; second, to administer remedial measures; and, third, to study conditions, hereditary and environmental, with a view to determining the causes of crime. The third is the most important, he thought, because it is aiming to prevent crime. “It is,” he said, “a field of sanitation, of preventive medicine, of anticipating and preventing the social cancer of crime.

“The state has not been ashamed to avow itself the guardian of the delinquent child. May the time come when it sees there is no distinction of age in all its erring children. Why limit the guardianship of the state to the delinquent or dependent child? It’s impossible to draw the line between the delinquent child and the child not delinquent. They are all entitled to the care and guardianship of society of which they are a part. Society as a whole is responsible for all its members.”

The growing amount of crime among women was discussed. One-seventh of the number of women committed to prison are old offenders. The growing activity of women in industry was declared by President MacChesney to be responsible for a surprising increase in crime.

“In Massachusetts crime among women is much more an economic than a moral problem,” said Miss Mary Boyle O’Reilly. “The overwhelming majority of women in industry are low wage earners, often victims of seasonal trades with their alternate periods of over-work and semi-starvation.

“These young and unsettled workers, many of them homeless and suffering from malnutrition, are ignorant of business customs. Working at machines and trades that are soon learned, they are entirely at the mercy of their employers.

“In our Massachusetts prisons the population falls as prosperity increases in the great centers of industry, but immediately there is a shut-down in the mills of the State we are then forced to note a pitiable increase in the number of women who fall into evil ways.”

The sensation of the annual meeting (from the newspaper standpoint) was the scoring of conditions at the Deer Island (Boston) House of Correction by President MacChesney.

“The buildings are so far behind the times that they must have been built before my State was established. The sanitary conditions are very bad. There is no attempt at classification or segregation. Youths of tender years convicted of minor offenses are thrown among adult prisoners who have been guilty of serious offenses. Prisoners of all types are thrown together and this should not be so.”

Referring to the women’s prison, Mr. MacChesney said, “I saw one case there that is most deplorable. It is that of a little girl but 17 years of age. She was sent to the institution after being convicted on a charge of vagrancy. She is there thrown among pickpockets and others who have committed serious crimes. Two of your own judges, who were with me, agreed that she should not have been sent there and that girls of that age should be segregated from older and hardened women.”

The men’s dormitories at the institution were also the object of severe criticism. The men’s cells, constructed before the civil war, with no sanitary arrangements at all, were termed barbaric, and, as one member said, “ought to be dynamited.”

While many Massachusetts newspapers expressed satisfaction that the conference had raised the Deer Island issue again, the self-satisfaction or complacency or resentfulness of some of the editorials showed that not all of the “cocksureness” of Puritan times regarding the high character of home habits and institutions has departed from the Bay State.

Jail Poetry.—Upton Sinclair recently “did” eighteen hours imprisonment in the New Castle (Del.) workhouse for violating a Sunday blue law. Seven hours of the time were spent on the stone-pile. The inside cells and the “doubling up” practices led to the following verse:


THE MENAGERIE.
Oh, come ye lords and ladies of the realm,
Come from your couches soft, your perfumed halls,
Come watch with me throughout the weary hours.
Here are there sounds to fill your jaded nerves,
Such as the cave men, you forefathers, heard
Crouching in forests of primeval night.
Here tier on tier in steel-barred cages pent,
The breasts ye breed and hunt throughout the world.
Hark to that snore, some beast that slumbers deep,
Hark to that roar, some beast that dreams of blood,
Hark to that moan, some beast that wakes and weeps,
And there in sudden stillness mark the sound
Some beast that rasps his vermin hide.
Oh, come, ye lords and ladies of the realm,
Come keep the watch with me, the show is yours.
Behold the source of all our joy and pride,
These beasts ye harness fast and set to draw
The chariots of your pageantry and pomp.
It is this blood ye shed to make your feasts,
It is their treadmill that moves all your world.
Come sit and think how it will be with you
When God shall send his flaming angel down
And break these bars, so hath he done of yore.
So doeth he to lords and ladies grand,
Who feed upon the blood of other men
And loose these beasts to raven in your streets.
American Prison Association.—The American prison association will hold its annual meeting at Omaha, Nebraska, from October 14-19, 1911. Among the subjects to be discussed are: the resolutions of the 1910 international prison congress in their application to the United States; prison construction; mental deficiency and moral delinquents; prison recreation; the prison physician; the prevention of crime and insanity; psychology of the criminal; physical defects as a factor in the making of criminals; the jails of Florida; farm work for misdemeanants; statistics of crime; tuberculosis in prisons; governing boards; payment to prisoners and their families; some facts concerning prisoners’ dependents.

The following standing committees will report: prison discipline; prevention and probation; jails, lock-ups and police stations; reformatory work and parole; discharged prisoners.

Among the speakers will be Professor Charles R. Henderson, Judge C. A. DeCourcey, James A. Leonard, Joseph F. Scott, A. H. Leslie, Frank Moore, J. K. Cutting, Henry W. K. Scott, Charles M. Miller, Franklin H. Briggs, Dr. Theodore Cook, Jr., Dr. Daniel Phelan, Dr. William Healy, Dr. William Martin Richards, George W. Wickersham, W. H. Eichorn, A. W. Gilchrist, L. A. Halbert, Frank L. Randall, Mrs. Imogen B. Oakley, Eugene Smith, Rev. Thomas W. Houston, Guy H. Humphreys, William H. DeLacy, William H. Venn, Miss Eva Booth, Joseph P. Byers.

Surely a splendid program. Every one interested in prison reform should attend the Omaha meeting.

Baltimore, Md., July 31, 1911.
Editor, The Review,

Sir—Referring to the article in The Review for July, regarding “Parole in Maryland,” the reporter of the Baltimore American, from which paper this was taken, drew a great deal upon his imagination and as a result did not make correct statements.

Probation has been in service in Maryland for several years, but its use has grown very rapidly during the past two years under the new system instituted by the supreme bench. The mention made of $600 having been collected year before last by the Association and the probability of $5,000 being collected this year referred entirely to non-support cases. The practice of the courts has formerly been to order the husbands to pay their wives direct, but as the system worked very badly this is being gradually changed to a great extent by the courts ordering that the alimony be paid through this Association; a great improvement has been noted under the new arrangement.

The earnings of our probationers last year amounted to about $40,000. This was ascertained by carefully kept records from reports made monthly by the probationers. One can easily see the importance of this work to the city and state if viewed only from an economic point of view.

PRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Reform.—Albert H. Hall, who has the gift of “speakin’ out in meetin’” to some purpose, outlined at the recent annual conference of the American Institute of Criminal Law and Criminology what Minnesota has recently done, and recommended a law which has been enacted this year in his own state. He stated the provisions of that law, giving the reasons for each. All sentences, except for treason or murder in any of the degrees, shall be indeterminate: they shall be without limit of time. A board of parole is established, with the prison warden as a member ex-officio, to observe the prisoners, study them minutely, inquire into their history and watch their tendencies and their motives, and learn all about them. With this knowledge about them, the board establishes a record of marks, giving credit for merits and charge for derelictions, and on the basis of such register the board may release the prisoner on parole when it deems it expedient. The prisoners are to be provided with the rules and regulations, enabling them to score themselves, if they like, and giving them the right of a hearing before the board if they think the official score does not give them full credit.

In order that all shall be treated absolutely alike, petitions from outside persons for the release of any prisoner will not be received or acted upon. The initiative is to rest with the board, and it may modify its conditions of parole during the period the prisoner remains under its observation. The prison warden is made a member of the board because of his intimate knowledge of the prisoners.

Another feature of the proposition is that the prisoner loses his citizenship when he is sentenced, and its restoration rests with the governor, to whom the board of parole is to certify when it grants an absolute release, stating the reasons for the release.

Addressing himself to the merits of the general proposition, Mr. Hall declared that the deterrent of crime is not the punishment, but the fear of conviction. What any person respects more than anything else is his honor, and he shrinks from being branded as a criminal. The system proposed puts him on his own honor and gives him hope and ambition.

Changes at Atlanta.—Widespread newspaper attention has been given to proposed changes at the Federal prison at Atlanta. Hereafter the emphasis will be placed upon reformation instead of on punishment. The convicts will no longer be regarded as dangerous and unmanageable animals, to be subjected only to hard labor, coarse diet and various degrees of punishment, but they will be treated as men: men facing a future filled with the opportunity of reformation, and the influences of prison life will be directed towards the development of their manhood and the creation of new hope in their bosoms.

In the prosecution of this new plan a prison library will be inaugurated, a school established, concerts given by a band to be formed among the inmates and games permitted in the leisure hours. Good behaviour will be rewarded by increased opportunities for instruction and amusement; bad conduct will be punished by curtailment of privilege.

A Governor to Stump for Prison Reform.—The Boston Advertiser reports that Gov. Foss having pardoned 51 convicts, and broken the record, will make prison reform an issue on the stump. He says:

“I have pronounced ideas on the subject. I have received many letters commenting favorably on the reforms that I suggested in my address before the American Bar Association. Massachusetts is standing still on the treatment of its prisoners.

“There are hundreds of so-called criminals in the prisons who may be cured just as people in hospitals are cured of disease.

“Only a very small number of the men in prison are habitual criminals. I don’t wish my ideas to be misinterpreted. Some of my political opponents are attempting to picture me as opening the doors of the prisons. As a matter of fact, I have very decided ideas on the protection of the public from the habitual criminal.

“There are many men in the prisons, however, who commit crime when under the influence of liquor. They become brutes when under the influence of liquor, but when sober and temperate are perfectly normal, first-class citizens who may become a credit to their various communities.”

Transferring Prisoners.—A recent Auburn (N. Y.) newspaper item states that forty-four prisoners were that day transferred to Comstock prison, a journey of about 200 miles. “At 9.30 the prisoners were manacled by twos, with handcuffs on their wrists, and short lengths of chain between their feet, making the act of walking as difficult as a three-legged race. They were marched by twos to the outside prison gate, and lined up while the guards placed themselves in position. At the word, the gate swung back, and the line of gray suits filed out, with a guard in blue at the side of every ten or twelve men. Marching to the New York Central station across the street, each man carrying a small bundle containing a few private belongings, they waited for the train which was half an hour late. A crowd of morbidly curious quickly rushed to the spot.

“When the train finally pulled in, the prisoners were marched up the steps of a special car and down the aisles in regular order. Some difficulty was experienced in getting the men, impeded as they were, up the car steps, and they all smiled at the bystanders as if they were enjoying the little trip in the open air. The guards took up their positions inside the car, the doors were locked, and the train pulled out, leaving the crowd to comment upon the late spectacle.”

Germany’s methods could teach us much by comparison. Transfer of prisoners is specially frequent because in Prussia practically all persons are under a central authority, the department of justice, which transfers prisoners according as fluctuations of population in the prisons occur. By arrangement with the railroads—which in Prussia are under governmental control and operation—specially constructed railway prison cars are attached to early morning or late evening trains, the cars being so constructed as not to afford public display of the prisoners. From the interior of the prison the prisoners are conveyed in vans to the railway stations. So important and frequent are these transfers that a small corps of prison department officials are assigned solely to this special work. This is a “made in Germany” humane plan that deserves our contemplation.

A Michigan Prison Farm.—The Detroit (Mich.) News prints the following editorial, entitled “Prison Farm Redemption”:

The state at large has not heard more encouraging news of progress in any of its institutions than Warden Simpson sets forth in his report on the management and operation of the prison farm at Jackson. The farm is not a big one—only 30 acres in extent—and it admits of little more than experimenting. But the warden and his charges have done some important work on it in the summer now ending. They have grown cabbages, peas, beets, parsnips, carrots, onions, radishes, lettuce, cucumbers, sweet corn and tomatoes enough of the staples to supply the prison for a whole year, and enough of the seasonal produce to give the prisoners fresh vegetables during the summer. One of the new silos will be filled with the ensilage from the green corn. The shelves in the fruit cellars hold 5,000 quarts of canned strawberries, while the memory of seven “feeds” of fresh berries and cream, not to mention shortcake, still lingers with the prisoners. Fifty bushels of huckleberries have been picked from the prison farm marsh. When the tomatoes and apples are ripe, 5,000 gallons of them will be put up for the winter table. In four months 133 hogs have been fattened and slaughtered, yielding 22,077 pounds of fresh pork. All this has been done at a monetary profit to the state. For the bigger profit reference is made to the warden’s own words:

“The inmate working upon the farm, in addition to his useful service, is forming for himself habits of industry, growing fond of his work, perhaps to the extent of following this vocation at the time of his parole and release, thus taking him away from questionable haunts and evil associates known to him of former years in his city home. In my opinion there is no work, trade or calling to which men striving for a livelihood may fall heir, so conducive to the development of health, happiness, honesty and independence, combined with all the attributes of a good citizen, as practical and successful farming.”

The Montpelier (Vt.) Jail.—The Review mentioned briefly the remarkable success of Sheriff Tracy of Montpelier, Vermont, in allowing his prisoners to go out to work for farmers and other employers. In the Atlantic Monthly for August Morrison I. Swift tells interestingly of the results lately:

“The state of Vermont contains a prison where the inmates are treated upon a novel plan. They are trusted and treated like other human beings; they come and go almost as freely as the members of the jailer’s own family; so far as possible, whatever suggests punishment or disgrace is banished, and they are made to feel that their imprisonment is designed to improve them as men and to restore them to social life not only with full self-respect but with the cordial respect of the community.

“This great innovation in prison practice was made possible by a state law authorizing all sheriffs to set their prisoners at work either inside or outside the jails. In Montpelier, where this prison stands, the inveterate prejudice against prisoners has been swept away.

“As late as two or three years ago, when the men did not return promptly to the jail at the time appointed the sheriff would become nervous and go out to walk the streets looking for them. That is all past now, not only because of the unsuspected traits of human nature that experience has unfolded but because of the marvellous practical success of the system. During the four years, out of 800 prisoners treated upon the new plan only two attempted to escape, both of whom were recaptured and sentenced to long terms in the house of correction for betraying the trust reposed in them. With such a record as this the sheriff no longer feels perturbed if his entire corps of prisoners is scattered in every direction during the day, and he is perfectly assured that at night they will reappear at the jail.

“During the whole period their labor earned above $6,000, of which a total exceeding $2,600 was kept by themPRISON LABOR LEGISLATION OF 1911
By E. Stagg Whitin

General Secretary, National Committee on Prison Labor

The state’s property right in the prisoner’s labor exists by virtue of the 13th Amendment of the Constitution of the United States which provides that slavery or involuntary servitude may be a punishment for crime, after due process of law. This property right the state may lease or retain for its own use, the manner being set forth in state constitutions and acts of legislatures. To make this of material value the prisoner’s labor must be productive. The distribution of the product of the prisoner’s labor inevitably presents the problem of competition. The confounding of the evil of penal servitude with the methods of production and the methods of distribution which have grown out of it has produced a confusion in the thought underlying prison labor regulation by legislative enactment.

The usual penological analysis of prison labor into lease, contract, piece-price, public account and state-use systems is impossible to use in an economic analysis of the labor conditions involved. Economically two systems of convict production and two systems of distribution of convict-made goods exist; production is either by the state or under individual enterprise: distribution is either limited to the preferred state use market or through the general competitive market. In the light of such classification the convict labor legislation of the current year shows definite tendencies toward the state’s assumption of its responsibility for its own use of the prisoner on state lands, in state mines and as operatives in state factories; while in distribution the competition of the open market, with its disastrous effect upon prices, tends to give place to the use of labor and commodities by the state itself in its manifold activities. Improvements like these in the production and distribution of the products mitigate evils, but in no vital way effect the economic injustice always inherent under a slave system. The payment of wage to the convict as a right growing out of his production of valuable commodities is the phase of this legislation which tends to destroy the slavery condition. Such legislation has made its appearance, together with the first suggestion of the right of choice allowed to the convict in regard to his occupation. These statutes still waver in an uncertain manner between the conception of the wage as a privilege, common to England and Germany, and the wage as a right as it exists in France. The development of the idea of the right of wage, fused as it is with the movement towards the governmental work and workshops, cannot fail to stand out in significance when viewed from the standpoint of the labor movement.

The expression of these tendencies found in the legislation of 1911 comes to view in divers states and a confusion of statutes in which every shade of development is present. While no state legislated to give new powers of leasing or contracting for the labor of prisoners and one only, Idaho, extended the field of its present leases, twenty-one made some provision for the state’s assumption and operation of industries: eight, California, Idaho, Indiana, Missouri, New Jersey, North Dakota, Ohio, and Wyoming, provided in some manner for the state’s consumption of the manufactured articles; and six, California, Indiana, Missouri, New Jersey, Ohio, and Wyoming, established laws for the regulation of prices and standardization of commodities. The prisoner received compensation for labor in six states, Florida, Kansas, Michigan, Nevada, Rhode Island, and Wyoming; his dependent family was given assistance in five, Colorado, Maine, Massachusetts, Missouri and New Jersey; while Nevada gave him the right to choose between working on the roads or working indoors. The New York farm and industrial colony for tramps and vagrants is of significance. Florida met the peonage issue by a provision for working off fines during imprisonment. The antagonism of organized labor to the distribution of the products of the convict’s labor on the open market resulted in the passage in Montana, Oregon and California of laws requiring branding of convict made goods. The New Jersey and Wyoming laws, which are especially complete, are summarized below.

In a word, the economic progress in prison labor shown in the legislation of 1911 is toward more efficient production by the elimination of the profits of the leasee, more economical distribution by the substitution of a preferred market where the profits of the middleman are eliminated in place of the unfair competition with the products of free labor in the open markets, and finally the curtailment of the slave system by the provisions for wages and choice of occupation for the man in penal servitude.

New Jersey.—The sale on the open market of the products of convict labor of any state penal institution is prohibited after the expiration of existing contracts. A preferred market is established consisting of all manufacturable articles consumed by the state and sub-divisions thereof. A prison labor commission is created to so regulate the penal industries that the greatest amount consumable by this preferred market will be produced. They are to publish a list of all possible articles of manufacture and grant releases when articles cannot be supplied. Penal officers are required to keep all physically capable convicts employed, not to exceed nine hours a day except Sunday and holidays, on productive work or in receiving industrial and scholastic instruction.

Yearly budgets are to be sent on October 1st to the commission by all purchasing officials in the state. The penal institutions are to report fully regarding all convict labor and its productive power together with the cost of production. A uniform system of accounting is to be established, together with a standardization of commodities to be manufactured, on which is to be affixed a fair price. Agricultural pursuits are to be given preference and the products sold as above, except that the surplus products may be sold at advertised auction to the general public once in six months unless they are of destructible character and require more immediate sale. Counties and municipalities are to conform to the state plan but may employ the prisoners for their own use. Charitable institutions are allowed to manufacture for their own use. Prisoners’ families dependent on charity are relieved by the commissioner of charities at the rate of fifty cents for every day the prisoner works, but this relief fund is limited to 5 per cent. of the value of all goods produced. The services of charitable societies are to be used for making investigations of families. The estimates of added appropriations needed to carry this into effect are to be included in annual estimates. The commission reports to the governor.

Wyoming.—The state board of charities and reform and the warden constitute a state commission on prison labor, to regulate according to its best judgment the employment of the state convicts so that they may acquire a knowledge of a trade at which they can earn a livelihood upon release. The labor of the convicts is to be upon products for the state and sub-divisions of the state, and public officials cannot purchase in the open market, unless upon release by the commission. The price is fixed at the market price, and the type of articles may be standardized. Prisoners, in the discretion of the commission, are to receive a graded compensation, in no case more than 10 per cent. of earnings of the institution. Surplus earnings may go to a prisoner’s family, but may never be used in buying food or clothing beyond that of common usage in his class; the balance, paid on release, is subject to draft.

A REAL JAIL
[From the Boston, (Mass.,) Globe, August 6, 1911]
The new jail and house of correction for Plymouth county is the finest of its kind in the state. To Sheriff Henry S. Porter credit is due for the jail. Had it not been for his untiring efforts to get the county commissioners to buy and build in this locality the county would not have had such a place.

Soon after the county purchased the property work was commenced on laying out for the new building. Excavating began in 1907. The work was done by the “trusty” prisoners, in charge of officers and engineers. The building is fireproof. The material is concrete and iron, most of the work being done by the prisoners themselves. All the floors in the institution are of terrazzo, made and finished by the “trusties” after a few instructions. Such a building put out to contract would have cost Plymouth a fortune, more than $200,000, but as it is the cost will not be far from $100,000.

The jail is on the top of a hill. It commands a view of the surrounding country. It has a frontage of 250 feet, and is 48 feet deep, with an ell 86×46.

In January, 1902, when Sheriff Henry S. Porter took the position of high sheriff of Plymouth county, there were 53 inmates in the jail. During the following five years prisoners increased to nearly 100. At the present time the number varies from 120 to 130. After he had been in office a short time he began to consider improvements for the men. They were all cane-seating chairs for townspeople, an industry which netted the county but $400 a year and they paid an instructor $1200. The sheriff found that a good man who had some experience could earn only about five cents a day and others two and a half cents and that the industry was not a paying one. It was then that he first devised the plan of working his men in the open. He hired half an acre of land in Samoset street and placed four or five of the “trusty” prisoners, in charge of officers, tilling the ground. That year he raised 50 bushels of potatoes, and the men who did the work were in much better condition than those employed inside. The sheriff was vigorously opposed by the county commissioners, who ordered him to stop the work, but after he had shown what could be done the commissioners decided to let him continue. A tract of land of three acres was bought in 1904, and that year the sheriff raised 519 bushels of potatoes, 265 bushels of turnips, 610 pounds of ham, 325 pounds of rib and at the end of the season had four hogs left. The products sold for $1084.25. The expenses were $390. They were for dressing, seed and tools.

The next year the sheriff made more money, and provided fresh vegetables and potatoes during the winter for the men in the institution. In 1907 he prevailed upon the county commissioners to purchase what was known as the Chandler farm, at Obery, about a mile from the center of Plymouth on which was a dwelling house and barn. Its acreage was 135, field and woods. The farm was much run down and was covered with bushes and weeds. The sheriff started in immediately to build it up, and a large number of the “trusty” men were put out there, with officers in charge, and cleared away the bushes and broke up the land. Part of the men worked on the new jail, while the others were employed in the garden.

In 1910 about 15 acres were broken up into tillage land. In that year was grown 75 tons of hay, 175 bushels of potatoes, 850 bushels of turnips, 650 bushels of corn, many vegetables, five tons of cabbages, 100 hogs, scores of sheep and numerous hens. At the beginning of 1911 there were five cows, two yokes of oxen, seven horses and a large number of hogs and poultry at the place.

The construction of the new jail was begun late in 1908, and since then an average of 48 to 50 men have been employed at it daily. A good deal has been said about the care and expense of prisoners in all institutions, but Sheriff Porter believes that his scheme is one of the best that can be done for prisoners, as the work benefits the men and they are not likely to come back. Last year the sheriff had to send to the state farm for men to assist in the general work. Out of 100 who have been here and worked on the farm, 85 have made good. The sheriff believes that good treatment and outdoor work has good and lasting effects. One man who did work at the jail for nearly a year after his term expired was employed by the contractor, and worked every day thereafter until the building was completed. Several others who worked on the construction of the building have been working at the concrete business out in the free world ever since.

“Men who work on the farm have to have different food from those inside,” says the sheriff. “We give them a hearty breakfast, dinner and supper and no fault is found with the bill of fare.”

During the period of outdoor work only four men have tried to escape. They were brought back. Not a man has been treated roughly and no man has been required to do more than a fair day’s work. The sheriff says that when he first took charge the dungeon was used 65 times a year. Last year it was only used three or four times, which seems to show that the prisoners are contented.

THE EVILS OF “DOUBLING UP.”
On his return from a two-months’ trip to Europe, where he visited some two-score prisons and correctional institutions, O. F. Lewis, general secretary of the Prison Association of New York, has raised the issue in New York City of the “doubling-up” of prisoners in cells. In an open letter, published in interview form in several city papers, Mr. Lewis says:

“I have just returned from a two months’ visit to about forty prisons in Belgium, Holland, Germany, England, and Scotland. In not a single cell of the thousands which I saw did I see two inmates imprisoned. One might say that the first principle of all in administering correctional institutions in Europe and in Great Britain is that prisoners shall never be ‘doubled up.’

“As for the situation in New York city on the night of September 10, at the Jefferson Market district prison, in four cells two men were sleeping, though only one cot was in each cell. In two instances the men were sleeping, one at the head and one at the foot of the cot; in two other instances, one of the men was sleeping on the floor. The ‘doubling up’ was occasioned by a lack of cell space for the male prisoners. On the ground floor there is for male prisoners a pen with bare boards, not separated off into bunks, where men sleep or try to sleep overnight.

“In the night court for men on East Fifty-seventh street the prison connected with the court was so crowded at 11.30 on that night that in several cells five and six men were confined, so closely as to forbid any of the men lying down unless on the floor. In one large room sixteen peddlers, fined $2, were awaiting midnight to pay $1 then remaining of their fine. The night keeper at the district prison stated that the prison is frequently grievously overcrowded, that ‘doubling up’ of three or four persons is common, and that on such nights as last night it is necessary to pack prisoners into the various cells and await the close of court, when the distribution can take place with some alleviation, but with a continuance of the ‘doubling up’ system.

“At the Criminal Courts building there are so-called prison pens in which persons not yet convicted are held often for hours pending their appearance in some one of the parts of the Court of General Sessions. Particularly on Fridays one of these pens, smaller than the cattle car of a freight train is packed with from fifty to seventy-five persons, mainly young men. No more improper or wretched preparation for a court trial could, it seems to me, be imagined than this pen. Fortunately our foreign visitors to the International Prison Congress last fall were not shown this pen. Grand juries and the Prison Association have since the first of the year frequently called the attention of the borough president to this condition, yet it remains unchanged. ‘Doubling up’ is of frequent occurrence in the Tombs. English law expressly provides that such ‘doubling up’ shall never take place.

“We cast around for explanations of crime waves, increasing tendency to criminality, and a growing disregard by young men in New York City of the principles of law and order. I fail to see how any young man going through the experience now daily undergone by hundreds of our young men can emerge from New York City’s prisons without a vindictive attitude of mind toward the city which maltreats him thus.

“The remedy is more money—more money for more cells and more prisons. For some years a new workhouse has been contemplated. It is as necessary to have an up-to-date workhouse as an up-to-date police force. If we are to have a night court for men, to save the innocent from overnight imprisonment, we must have a night prison which will not condemn the guilty to intolerable conditions of imprisonment. If we expect to reform our young criminals, we must provide a cell for each prisoner. And if the city is really concerned with the reduction of crime, its Board of Estimate and Apportionment must clearly recognize that it costs money to reduce crime, and that one of its first principles of useful imprisonment is separate confinement.”

DOMESTIC RELATIONS COURT OF NEW YORK
By Kellogg Durland

[Reprinted from Boston Transcript]
The domestic relations court which was established in New York city exactly one year ago has already taken its place as a permanent institution of the city. The tremendous work of this court arouses wonder that the idea had not been adopted years ago and that it is not more widely emulated in other cities throughout the country. Chicago and Washington are the only two other cities where similar courts exist, and even in these cities the jurisdiction of the courts is not quite the same as in New York. There are two domestic relations courts in New York city, one located in East Fifty-seventh street in the same building with a magistrate’s court and a municipal civil court, and serving the needs of the residents of the two boroughs, Manhattan and the Bronx; the other is in Brooklyn, administering to that section of the greater city.

The domestic relations court is essentially a poor man’s court. In its prime office, indeed, it partakes of the nature of a conciliatory court, similar to the conciliatory courts of France, through which all domestic difficulties pass before any divorce or other serious case involving domestic infelicity, abandonment or non-support can enter the courts proper. Like the judges of the conciliatory courts in France, the judges of the domestic relations court in New York are chosen for their tact, patience, knowledge of mankind and sympathy with the frailties of men and women. Every case that comes into the domestic relations court these judges first try to adjust without legal procedure.

In the next instance the domestic relations court is a woman’s court. In almost every case that has appeared here the complainant has been a woman. It is not more than once in several months that a man appears as a complainant in this court. This is, of course, largely owing to the fact that man is not usually dependent upon his wife for support, and even if deserted by his wife a man is not likely to be exposed to hardship and suffering as is the case with a woman. Furthermore, this court has no power to grant divorces. It merely adjusts differences, punishes abandoning husbands, and advises separation when separation seems the only wise course, and determines the amount of money that the man must contribute towards the support of his wife, children or other relatives. The law under which the domestic relations court was established provides that to this court “shall be taken or transferred for arraignment, examination or trial, or to which shall be summoned all persons described as disorderly, all persons compelled by law to support poor relatives, and all persons charged with abandonment or non-support of wives of poor relatives under any provision of law, conferring upon magistrates summary jurisdiction or the authority to hold for trial in another court.” The law further provides that “the commissioner of public charities shall establish and maintain an office of the superintendent of outdoor poor in or convenient to the building in which is situated the domestic relations court.” This latter provision is to insure the supervision over delinquent husbands and also to provide against any miscarriage of support money. In other words, it is a sort of clearing house and controlling office after the case has passed through the domestic relations court.

The functions of the domestic relations court in New York, therefore, are clearly defined and extremely limited. In Chicago the domestic relations court has a much more ample scope, for it has jurisdiction in any of the following violations of state laws: Abduction of children under twelve years of age, abandonment of wife or child, bastardy, improper public exhibition or employment of children under fourteen years of age, contributing to dependency or delinquency of children, violation of all laws relating to child labor, violation of all laws relating to compulsory education and truancy, climbing upon cars by minors, permitting minors to gamble in saloons, permitting minors to enter dance halls where intoxicating liquor is sold, sale or gift of deadly weapons to minors, having or procuring intoxicating liquors for minors, sale of tobacco to minors. And also the Chicago court has jurisdiction over violations of the following city ordinances: sale of cigarettes to minors, sale of cigarettes within 600 feet from schoolhouse, gathering of cigar refuse by minors, sale of tobacco to minors under sixteen years of age, sale of intoxicating liquors to minors, purchasing of intoxicating liquors by minors, obtaining intoxicating liquors by minors by false pretences, sale of materials saturated with liquor to minors under sixteen years of age, giving samples of intoxicating liquors in bottles or otherwise to minors, gambling by minors in saloons, jumping up on moving cars by minors under eighteen years of age, employment of minors under sixteen years of age in pawnshops, receiving pledges from minors by pawn brokers, sale of deadly weapons to minors. Thus it is apparent that the Chicago domestic relations court is almost a combined children’s court. If the jurisdiction of the New York court were anything like as large, the calendar would be constantly glutted, and cases would have to wait as long as cases on the Supreme Court calendar must needs wait now. As it is, the domestic relations court handles all of its cases promptly, although it is perhaps the busiest court of the city, owing to the fact that the docket is cleaned up every day.

The two judges who sit in the Manhattan court are Magistrates Harris and Cornell. Each magistrate sits fifteen days alternately, then five days in one of the regular criminal magistrate’s courts, and then ten days holiday. Under Judge Harris and Judge Cornell the domestic relations court experiment has been tried out and proved successful. Under these two magistrates there has been established a progressive procedure in regard to husbands who refuse to live with and support their wives and families. When a woman appears in this court the judge listens to her story and if he feels that there is ground for action or need of legal interference, he will issue a summons which is really a legal form of request to the husband to appear in court on a certain day. The wife is then told to come back on the same day. If the husband appears in response to this summons, all well and good.

On the other hand, if he fails to take cognizance of the summons, a warrant is issued for his arrest, and he is brought to court willy nilly. When the moment for trial comes, the woman is put on the witness stand and after being duly sworn, proceeds to tell her story, without let or hindrance. If the corporation counsel happens to be present he represents the woman, and the defendant is entitled to counsel, although most of them are willing to tell their side of the story and abide by the decision of the judge. In the absence of the corporation counsel the presiding magistrate questions the woman, not in a hostile way at all, but with the idea of drawing from her all the facts which shall enable him to attain a wise decision. When she has finished the defendant takes the stand in the usual way and the judge questions him with a similar desire to elucidate the trouble. If the case is flagrant it is within the power of the court to sentence the man to the workhouse for a period of not more than six months. Many women urge that their neglectful husbands be sent away, but it is in this connection that the law is perhaps not all that it should be. If sending a man to prison provided his wife and children with bread and butter and rent it might frequently be a good thing for society in general and the family in particular to have the man locked up. Unfortunately, a man sent to Blackwell’s Island for six months is obliged to do work for the state, but this precludes all possibility of his contributing to the support of his family during the period of his incarceration. Furthermore, the law will not allow the prosecution a second time of a man who has just served a term of imprisonment for non-support or abandonment within one year of the first prosecution, so that if a woman asks the court to lock up her husband and the court complies, that woman voluntarily surrenders all legal right to take further action against him or collect money from him for a whole year. There is an agitation just now to have the state pay a prisoner for the work he does during his term of imprisonment and have the money forwarded to his family. This surely is a wise and reasonable provision.

If the court stipulates that a man making nine or ten dollars a week must contribute three dollars and a half or four dollars a week to the support of his family, that man is either placed on probation to one of the two regular probation officers attached to the domestic relations court, or he is placed under the supervision of the department of charities, alimony division. Money to be paid through the department of charities is regulated in this way. The defendant is instructed to bring or send the stated amount to the office of this department, at the foot of East Twenty-sixth street, a certain day in the week, and then the wife or whoever is to receive the money must call in person the following day and, upon accepting the amount, is required to give a receipt which is duly sent to the remitter. These receipts often figure in court at a later date as evidence of the amount of money which has actually been paid by the payee. It frequently happens that a man will contribute faithfully for several weeks and then payments will cease. In some instances this secession of payment is for a legitimate reason—the man may be sick, or may have lost his position, whereupon he is given an opportunity to explain in the court the reason for his delinquency. When the wife appears in court and tells the magistrate that her husband has become delinquent, the clerk of the court sends out a printed form which reads as follows:

Dear Sir—I have been informed by your wife, So-and-So, that you have failed to comply with the direction of the court to pay her——so much——per week. I desire to inform you that unless the direction of the court is complied with at once, a warrant will be issued for your arrest and you may be compelled to furnish a bond to insure the payment of the said money for the support of your family.

Respectfully,
If the man appears in court in response to this notice, all well and good, otherwise he is arrested by an officer and brought before the judge to explain his failure to comply with the direction of the court.

The work of the domestic relations court is constantly increasing as the functions of the court are being more widely heard of throughout the city, especially among the foreign population. The largest number of cases that come before this court are classified under the nationality of Russia. There is an injustice in this classification, however, inasmuch as the “Russians” are 99 per cent. Russian or Polish Jews. Very many of the cases brought by the Jewish women are extremely difficult to handle owing to the fact that the desertion has oftentimes taken place in Europe. A man living in the ghetto of Warsaw or Bialystok or Wilna will decide to come to America to seek his fortune. Not having money enough to bring his wife and family, he starts out alone leaving behind him the assurances that he will return for them, or will send them money to bring them over. As a rule two or three letters at least are sent back to the old country, containing money orders for little sums of money, then the letters will cease. Sometimes the wife waits for four or five or six years before in despair she sets out in quest of her husband. Sometimes she finds him married to some American woman or some woman he has met over here, and then she goes to court with her trouble. The law here is confronted with the situation obviously impossible to handle with equal justice to all parties concerned without working hardship somewhere. The wife from the Old World with her children certainly has first claim upon the man, but at the same time the wife whom he has married here has perhaps married him in good faith, knowing nothing about the other family, and so have her children been born.

The Italians are the second largest nationality in the classification of the domestic relations court cases. The Italians are very apt to be disorderly persons. They are hot tempered, quick to strike and a great many times an Italian wife appeals to the domestic relations court because her husband has been cruel to her and struck her, and this court is obliged to send her to the magistrates court in order that her husband may be treated as a disorderly person. In justice to the Italians of Northern Italy, it should be stated that it is very rare to find an Italian in the domestic relations court who originally came from any province in Italy north of Rome. The great mass of Italians who get into this court are Neapolitans, Calabrians and Sicilians. The third group are from Central Europe, Hungarians, peoples from the Balkan states, Galicia and other provinces of Austria. The French rarely are obliged to appeal to the domestic relations court. The French are naturally a home-loving people, and anything like a domestic break is rare among them. Only two or three times since this court was established have French couples been obliged to appear there. A great many people classify themselves as Americans when as a matter of fact they are foreign born, so that the figures in regard to the number of Americans in this court are misleading. Negroes, however, turn up here in great numbers. Colored men often have no sense of responsibility whatever and they are constantly forsaking their wives and families or going off with somebody else’s wife. The excuses offered by colored men who are haled into this court are often very amusing.

For the most part, however, this is not an amusing court. The long line of people who press before Judge Cornell and Judge Harris day after day, is for the most part a sordid, hideous line, and the tales the complainants tell fill one with contempt and sourness toward humanity. The domestic relations court offers an even seamier picture of life in this city than the magistrates courts. While it is true that occasionally a family of the better class makes appeal to this court, for the most part the clients are illiterate and very poor. A very large per cent. of the cases that are brought here are people who, if abandoned, would become public charges. That is why the state interests itself to the extent of providing a counsel for complainants, in order to protect itself from the burden of caring for helpless women and little children, whom some individual has simply deserted. There are people who pretend to find amusement in the rehearsal of the marital woes of the poor. To be sure, occasionally a case turns up with its funny side, but to me the recitals are heartbreaking and dreary.

In the state of New York the failure of a man to support his wife, if there are no children, the crime ranks as a misdemeanor, and six months in the workhouse is the maximum penalty which can be imposed upon him. The domestic relations court, in specializing on this phase of law, will undoubtedly lead to certain reforms and amendments to the existing law tending ultimately to develop a system of domestic relations jurisprudence. It is a great boon, as it stands today, to suffering poor women. Any woman without a dollar in the world can walk into the domestic relations court, tell her troubles to the clerk of the court, and then if her case is a worthy one, she is within a few minutes placed on the witness stand, where she can repeat the recital to the judge. The whole proceeding of bringing her husband to the bar of justice and getting the court to forcing him to provide for her is speedy and absolutely without cost. A woman under our present system of life ought to have a court of this kind in which she may take refuge, because the world at large is, at the present time, so unfair to women. A woman can serve a man for years, bear him a large family of children, and suddenly be deserted and left with the burden of support for herself and family on her. If her husband is faithless, all she can do is to appear before the supreme court and apply for a divorce, but in this domestic relations court the judge will make her husband contribute to her support and to the support of his children.

Drink is frequently at the bottom of domestic troubles, but not nearly so often as most people would think. Drink, especially whiskey, frequently makes a man irritable and quarrelsome, which leads to family rows and frequently to disorderly conduct. The greatest number of cases that come into this court are against shiftless, worthless, idle men who seem to belong naturally to the submerged tenth. One day this week I sat with Judge Cornell for an entire session of the court and the run of cases which appeared that day gave ample indication of the tone of the court. One case was of a colored girl who has been married less than a year, who had brought her big black husband into the court to explain why he had abandoned her. The explanation was frankly given. He was so accustomed to living with white women, he said that he could not bring himself to live any longer with the wife of his own color. He was bonded to pay his wife $1 a week. Another woman, neat, pretty and intelligent, a California girl, not yet twenty, had had her husband arrested because he insisted that she go on the streets and make money, not only for herself but for him, as a public prostitute. An Irish woman complained that her husband who made good wages drank it all up. He countered by stating, under oath, that his wife was an habitual drunkard, which made no impression whatsoever on the court, because the woman was particularly prepossessing and without a single incriminating mark upon her. There were the usual number of Jewish women whose husbands had simply gone off saying they would have nothing more to do with them. And one or two Italian women, with small babies in their arms, whose husbands had got angry with them and put them out of the house or struck them.

It is a miserable, pitiable phase of life that one sees in the domestic relations court, but that the court is so overworked, so constantly busy, is justification enough for its establishment and indication that any large community requires some such institution to placate and bring together men and women, husbands and wives, whom oftentimes trifling difficulties are about to separate, and to make it impossible for husbands to desert their wives with impunity. That there should be only three such courts in this country is a striking commentary on the life we lead when it has been proved and demonstrated so extraordinarily by the domestic relations court in New York city that the need is so great. A visit to the domestic relations court will not insure a pleasant afternoon or an amusing hour, but it will prove an enlightening experience.

IN THE PRISONERS’ AID FIELD
PRISONERS’ AID
WORK IN CALIFORNIA

The San Francisco Post reports that:

“A statement of the work of the California prison commission during the past year shows that a remarkable number of men and women, who have been released from prison, have been given employment by this organization through the good work that is being accomplished at Golden Rule Hall. At this place those who have been discharged from prison are provided for until suitable employment is found for them.

“During the past year 465 have been placed in positions, an average of nine a week. Of these 26 were over 60 years of age, and four over 80. Fourteen consumptives were placed either in positions of light employment or in homes or hospitals. More than 200 were sent direct from prison to employment; others, who were either invalids, cripples, or aged, were temporarily boarded at Golden Rule Hall. Another good office of the commission is to look after the wives and children of prisoners.

“All of this work has entailed a great deal of expense. The building and equipment of Golden Rule Hall, to take the place of the building that was destroyed by fire, has put the organization into debt. An appeal is being made to the public to lessen this difficulty, and to help along an institution that is doing much toward preventing a repetition of crimes by ex-convicts.”

As to the renovation of San Quentin prison, the Post says:

“Within a few months the new 800-room concrete and steel cellhouse now in course of construction at San Quentin prison will be completed.

“The building is a prison within a prison, and is a class A structure, 600 feet in length and 60 feet in height. The cells are built in the center of the structure and run its full length. There are four tiers with 200 cells on a tier. Four hundred of these cells are separated by steel bars and are so arranged that twenty-five may be bolted at the same time. Eight hundred prisoners may be locked up three minutes after they reach the inside of the prison.

“The walls and the cells of the new prison are built of reinforced concrete and in every foot of concrete steel bars are laid, running parallel and perpendicular, making it impossible for a prisoner to cut through at any point of his cell.

“All the steel and iron work was turned out by the prisoners. Every part of the new building was manufactured and erected by prison labor. The roof of the structure is of copper and slate and has been pronounced by experts to be of the finest workmanship. The inside is finished with plaster and so clever is the workmanship that it resembles enamel work.

“Work is now being done on a wall sixty feet high and six feet thick by the prisoners. This will surround the cellhouse. Upon completion an electric light plant and heating apparatus will be installed.

“Warden Hoyle plans when the new cellhouse is ready for occupancy to put his new grading system into execution. The new prison will house all the first termers and they will not mingle with second and third term convicts. Each grade will have a separate yard and under the first grade the prisoners will wear a uniform.

“The second termers will be together and wear a different kind of a uniform. The third grade will consist of life termers and hardened criminals. These will wear stripes.

“The first-grade prison will be known as the reformatory, and at any time a prisoner’s deportment is bad he will be sent into the second-grade prison.”

SUPPORTING A
GOOD WARDEN

The Prisoners’ Aid Society of Baltimore has recently taken up the cudgels for the retention in office of Charles A. Hook, warden of the Baltimore city jail. A letter to the mayor of Baltimore details some of the improvements effected by Warden Hook.

“The citizens of Baltimore have every reason to be proud of this their one definite penal institution. It has reached an excellence of administration and a physical condition that place it easily among the foremost institutions of similar nature throughout the country. The improvements have been very marked, and from simply a correctional and detentional institution it has been transformed into a place of real helpfulness and reformation.

“This state of efficiency is the direct result of the wise, practical and broad-spirited administration of its warden, Mr. Charles A. Hook. Warden Hook is a student of criminology. He has taken advantage of every opportunity to meet the wardens of other institutions and gathered from these conferences that which would be helpful to his own administration.

“It is becoming more and more evident that the administration of a penal institution should be as scientifically based as the administration of a medical infirmary, and no greater boon can be conferred for the welfare of the municipality than the removal of this office from political influence.

“To state concretely some of the very many improvements of this institution I would name the following:

“The addition of 328 new concrete cells for men and women, with all modern improvements for hygiene and sanitation.

“New hospital and operating room in the main building.

“A library for the prisoners.

“New hot water system for bathing purposes.

“New beds made especially in the institution for the purpose of extreme cleanliness.

“New sterilizing plant for infected clothing.

“New baths and clothes rooms for prisoners.

“New four-story workshop, of brick and cement.

“New jail workshop, where articles used by the prisoners are made.

“The substitution of machinery for the hands of the prisoners in the bakeshop.

“In the moral features of the institution:

“No official is now allowed to strike a prisoner except in self-defense.

“All cases of infringement of rules are settled by the warden himself.

“Dark cells and shower baths for punishment abolished.

“All prisoners have the ear of the warden and he gives every Sunday morning to visitation and the consideration of personal requests and grievances.

“Prisoners working in the shops with sentences of three months or over are allowed one-fourth of their earnings, one-half payable during confinement and the remainder on release.

“Through the personal interest of the warden and his assistants a large share of the amount earned by the prisoners during confinement is paid to their families.

“The definite result of these marked improvements in the physical condition and the moral and spiritual administration is very apparent in the number of inmates who are brought to realize the possibilities of a better life through reformation, and by this specific work the population of the jail is smaller than it has been in past years.

“Every co-operation and sympathy have been granted the work of the Prisoners’ Aid Association by Warden Hook and his assistants, and through this co-operation a splendidly large number of men and women are being returned to society law-abiding and self-respecting.”

EVENTS IN BRIEF
[Under this heading will appear each month numerous paragraphs of general interest, relating to the prison field and the treatment of the delinquent.]

Congress of Juvenile Court Judges.—Eight hundred invitations are being sent out by Judge Muir Weissinger and his advisory board of the Juvenile Court, for the third annual conference of juvenile court judges of the central states to be held in Louisville November 14, 15 and 16. The invitations go to judges in Kentucky, Tennessee, Indiana, Ohio, Illinois, Michigan, Missouri, Kansas, Oklahoma and Colorado. Special invitations are issued to officials of institutions in Kentucky interested in juvenile corrections and the juvenile judges in other states are asked to bring with them such probation officers and other officials as may wish to attend the conference.

Reformatory versus Prison.—That the proper classification of prisoners is of basic importance in any effort to reform and rehabilitate them, and that courts are often parties to the creation of almost insuperable difficulties in this regard is shown in a recent article in the Rahway (New Jersey) Herald:

D. George Wight, commissioner of charities and correction of New Jersey finds that there is no uniform rule under which the common pleas judges of the state deal out sentences. There are a number of first offenders in the state prison who should have been sent to the reformatory, and there are numerous cases where prisoners should have been sent to the state prison instead of the reformatory. Dr. Wight also shows that there are a number of hardened criminals confined in the reformatory.

The out-of-place presence of these detained persons interferes with the work in the prison and in the reformatory. Mr. Osborne, warden of the state prison, concludes that reformation is an almost impossible achievement in the state prison, and Dr. Moore, superintendent of the state reformatory, is of the opinion that the presence of hardened criminals in the reformatory prevents the carrying on of efficient reformatory work in his institution.

Under the existing laws it is provided that the male first offenders between the ages of 16 and 30 years shall be sent to the reformatory. Notwithstanding the provisions, Dr. Wight’s statistics show that from June, 1909, to June, 1911, there were committed to the state prison 240 prisoners of the first offender class, and less than 25 years of age. Dr. Wight shows that this total is twenty-five per cent. of the commitments during the two years which the statistics cover. There have been 231 commitments to the Rahway reformatory in the past year, and of this number at least fifty-five per cent. are second offenders, and some of the men are serving their third and fourth terms in prison. The report of Dr. Moore shows that of the commitments in the past year sixty-nine are second offenders, thirty-three are third offenders, eighteen are fourth offenders, five are fifth offenders and six are sixth offenders, leaving 104 first offenders committed during the year, with a total of 234.

The investigation shows that the sentences imposed by the trial judges have not been based upon the seriousness of the crime, but upon the individual preferences of the court.

A Prison Program for New York.—Commissioner Frank E. Wade, of Buffalo, has embodied the results of a recent careful inspection of the county penitentiaries of New York (New York, Albany, Onondaga, Monroe and Erie) in well digested reports to the commission, and in addition recommends a policy of action for the state which deserves quoting. For years the inefficient county management of most of the penitentiaries has been notorious.

“Control of the penitentiaries under existing conditions is essentially a state function. The prospects, however, of state ownership are not promising for some time to come. The initial cost will be so great that, in the present condition of state finances, the proposition for the purchase of these institutions is not likely to meet with favor; furthermore, there are some related problems which should be settled before state ownership of penitentiaries. I refer to a state farm for vagrants, a reformatory for male misdemeanants between the ages of 16 and 21 and the development of industries in the penitentiaries.

“The state is already committed to the farm colony plan and its successful operation will decrease the number in the penitentiaries of the most hopeless class of inmates as far as penitentiary treatment is concerned.

“A state reformatory for misdemeanants, where boys between the ages of 16 and 21 can be committed on an indeterminate sentence and receive instruction in trades and letters, is the most necessary and urgent prison reform under public discussion. These boys can now be committed only to penitentiaries and jails, except in the city of New York, and the penitentiary and jail associations and treatment confirm them in criminal habits.

“The introduction and extension of industries in the penitentiaries is of vital importance. The present idleness of the prisoners in all the penitentiaries (except New York and Onondaga county penitentiaries, where the product can be increased fifty per cent) is tending to destroy their future usefulness and turn them into loafers. It is the duty of the state commission of prisons to present the evils of this idleness to the public and to endeavor to have the county authorities furnish employment for all the prisoners, as required by law.

“The enactment of a law permitting the superintendent of prisons to market the product of the penitentiaries will be of great assistance. Staple industries could then be established and industries supplementary to those in the state prisons could be installed in the penitentiaries.

“The proposition of paying prisoners or their families a portion of the earnings is involved in the development of the industries in the penitentiaries. At present the idleness and the heavy cost of maintenance will not permit such payments, but if the earnings of prisoners were materially increased a substantial percentage might be given.”

Mr. Hall on Prison Ref