"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @stability stable
 */
class GatewayRoute extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteProps(props);
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualGateway.mesh.env.account),
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
                priority: routeSpecConfig.priority,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing GatewayRoute given an ARN.
     *
     * @stability stable
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(gatewayRouteArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * Import an existing GatewayRoute given attributes.
     *
     * @stability stable
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteAttributes(attrs);
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRoute", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,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