# mypy-boto3-elb

[![PyPI - mypy-boto3-elb](https://img.shields.io/pypi/v/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticLoadBalancing 1.13.22](https://boto3.amazonaws.com/v1/documentation/api/1.13.22/reference/services/elb.html#ElasticLoadBalancing) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-elb](#mypy-boto3-elb)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ElasticLoadBalancing` service.

```bash
python -m pip install boto3-stubs[elb]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import elb
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_elb as elb

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("elb")
client: elb.ElasticLoadBalancingClient = boto3.client("elb")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: elb.ElasticLoadBalancingClient = session.client("elb")


# Waiters need type annotation on creation
any_instance_in_service_waiter: elb.AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
instance_deregistered_waiter: elb.InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
instance_in_service_waiter: elb.InstanceInServiceWaiter = client.get_waiter("instance_in_service")

# Paginators need type annotation on creation
describe_account_limits_paginator: elb.DescribeAccountLimitsPaginator = client.get_paginator("describe_account_limits")
describe_load_balancers_paginator: elb.DescribeLoadBalancersPaginator = client.get_paginator("describe_load_balancers")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.