# AUTOGENERATED! DO NOT EDIT! File to edit: 08_cognitive.ipynb (unless otherwise specified).

__all__ = ['relative_power', 'normalize_df', 'interm_shannon', 'interm_reny', 'interm_tsallis', 'shannon_entropy',
           'renyi_entropy', 'tsallis_entropy', 'running_mean_uniform_filter1d', 'running_mean_convolve',
           'running_mean_cumsum', 'cognitive_scores']

# Cell
import matplotlib
import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
import scipy.ndimage.filters as ndif
import time
import mne
import yasa

from cognify import muse,spectra



# Cell
def relative_power(raw,ch = 'TP9'):
    times,strided = yasa.sliding_window(raw.get_data(),sf=raw.info['sfreq'],window=4,step=0.125)
    bands = [ (4, 8, 'Theta'), (7.5, 13, 'Alpha'),  (13, 30, 'Beta'), (30, 40, 'Gamma')]
    powers = []
    for win in range(len(times)):
        bp_rel = yasa.bandpower(strided[win],sf=raw.info['sfreq'],ch_names=raw.info['ch_names'],relative = True,bands=bands)
        save = bp_rel.drop(['TotalAbsPow','FreqRes','Relative'],axis=1).T.unstack().to_frame().T[ch]
        powers.append(save)
    pd_powers = pd.concat(powers)
    return times,pd_powers



# Cell

def normalize_df(data):
    return (data-data.min())/(data.max()-data.min())

def interm_shannon(rel_p):
    return rel_p*np.log2(rel_p)

def interm_reny(rel_p):
    return np.power(rel_p,2)

def interm_tsallis(rel_p):
    return rel_p-np.power(rel_p,2)

def shannon_entropy(bands):
    return -1*(np.sum([pd.apply(np.vectorize(interm_shannon)).to_numpy() for pd in bands],axis=0))

def renyi_entropy(bands,alpha=3):
    return (np.log2(np.sum([pd.apply(np.vectorize(interm_reny)).to_numpy() for pd in bands],axis=0)))/(1-alpha)

def tsallis_entropy(bands,alpha=3):
    return np.sum([pd.apply(np.vectorize(interm_tsallis)).to_numpy() for pd in bands],axis=0)/(alpha-1)


# Cell

def running_mean_uniform_filter1d(x, N):
    return ndif.uniform_filter1d(x, N, mode='constant', origin=-(N//2))[:-(N-1)]
def running_mean_convolve(x, N):
    return np.convolve(x, np.ones(N) / float(N), 'valid')
def running_mean_cumsum(x, N):
    cumsum = np.cumsum(np.insert(x, 0, 0))
    return (cumsum[N:] - cumsum[:-N]) / float(N)


# Cell
def cognitive_scores(metricId,ch = 'TP9'):
    raw,events_eeg,df_eeg = muse.eeg_to_mne(metricId)
    times,pd_powers = relative_power(raw,ch = ch)

    Relax_bands = [pd_powers['Theta'],pd_powers['Alpha']]
    Focus_bands = [pd_powers['Beta'],pd_powers['Gamma']]
    timestamps = (np.datetime64(df_eeg.index[0])+(1000*times).astype('timedelta64[ms]') - np.datetime64('1970-01-01T00:00:00Z')) / np.timedelta64(1, 's')

    df_cognitive = pd.DataFrame(data={'timestamp': timestamps,
                                   'naive_relax':pd_powers['Alpha'].to_numpy(),
                                   'naive_focus':pd_powers['Gamma'].to_numpy(),
                                   'renyi_relax':normalize_df(renyi_entropy(Relax_bands)),
                                   'renyi_focus':normalize_df(renyi_entropy(Focus_bands)),
                                   'shannon_relax':normalize_df(shannon_entropy(Relax_bands)),
                                   'shannon_focus':normalize_df(shannon_entropy(Focus_bands)),
                                   'tsallis_relax':normalize_df(tsallis_entropy(Relax_bands)),
                                   'tsallis_focus':normalize_df(tsallis_entropy(Focus_bands))
    })

    return df_cognitive
