# coding: utf-8
# /*##########################################################################
#
# Copyright (c) 2016-2017 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/

__authors__ = ["H. Payno", "V.Valls"]
__license__ = "MIT"
__date__ = "06/11/2019"

import numpy


def create_dataset(shape, noise=False):
    """

    :param tuple shape:
    :return: energy, spectra
    """

    germa_energy, germa_spectrum = _germanium_spectrum()
    assert shape[0] <= len(germa_energy)
    spectra = numpy.zeros(shape=shape)
    noise_arr = numpy.zeros(len(germa_spectrum))
    for i in range(shape[1]):
        for j in range(shape[2]):
            if noise:
                noise_arr = numpy.random.normal(0.0, 0.05, len(germa_spectrum))
            spectra[:, i, j] = (germa_spectrum + noise_arr)[: shape[0]]

    return germa_energy[: shape[0]], spectra


def _germanium_spectrum():
    energy = numpy.array(
        [
            1.080000000000000000e04,
            1.080500000000000000e04,
            1.081000000000000000e04,
            1.081500000000000000e04,
            1.082000000000000000e04,
            1.082500000000000000e04,
            1.083000000000000000e04,
            1.083500000000000000e04,
            1.084000000000000000e04,
            1.084500000000000000e04,
            1.085000000000000000e04,
            1.085500000000000000e04,
            1.086000000000000000e04,
            1.086500000000000000e04,
            1.087000000000000000e04,
            1.087500000000000000e04,
            1.088000000000000000e04,
            1.088500000000000000e04,
            1.089000000000000000e04,
            1.089500000000000000e04,
            1.090000000000000000e04,
            1.090500000000000000e04,
            1.091000000000000000e04,
            1.091500000000000000e04,
            1.092000000000000000e04,
            1.092500000000000000e04,
            1.093000000000000000e04,
            1.093500000000000000e04,
            1.094000000000000000e04,
            1.094500000000000000e04,
            1.095000000000000000e04,
            1.095500000000000000e04,
            1.096000000000000000e04,
            1.096500000000000000e04,
            1.097000000000000000e04,
            1.097500000000000000e04,
            1.098000000000000000e04,
            1.098500000000000000e04,
            1.099000000000000000e04,
            1.099500000000000000e04,
            1.100000000000000000e04,
            1.100500000000000000e04,
            1.101000000000000000e04,
            1.101500000000000000e04,
            1.102000000000000000e04,
            1.102500000000000000e04,
            1.102989999999999964e04,
            1.103460000000000036e04,
            1.103920000000000073e04,
            1.104360000000000036e04,
            1.104779999999999927e04,
            1.105179999999999927e04,
            1.105560000000000036e04,
            1.105929999999999927e04,
            1.106279999999999927e04,
            1.106610000000000036e04,
            1.106920000000000073e04,
            1.107220000000000073e04,
            1.107500000000000000e04,
            1.107760000000000036e04,
            1.108000000000000000e04,
            1.108220000000000073e04,
            1.108429999999999927e04,
            1.108620000000000073e04,
            1.108789999999999964e04,
            1.108939999999999964e04,
            1.109079999999999927e04,
            1.109189999999999964e04,
            1.109289999999999964e04,
            1.109379999999999927e04,
            1.109439999999999964e04,
            1.109489999999999964e04,
            1.109520000000000073e04,
            1.109550000000000000e04,
            1.109579999999999927e04,
            1.109610000000000036e04,
            1.109639999999999964e04,
            1.109670000000000073e04,
            1.109700000000000000e04,
            1.109729999999999927e04,
            1.109760000000000036e04,
            1.109789999999999964e04,
            1.109820000000000073e04,
            1.109850000000000000e04,
            1.109879999999999927e04,
            1.109910000000000036e04,
            1.109939999999999964e04,
            1.109970000000000073e04,
            1.110000000000000000e04,
            1.110029999999999927e04,
            1.110060000000000036e04,
            1.110089999999999964e04,
            1.110120000000000073e04,
            1.110150000000000000e04,
            1.110179999999999927e04,
            1.110210000000000036e04,
            1.110239999999999964e04,
            1.110270000000000073e04,
            1.110300000000000000e04,
            1.110329999999999927e04,
            1.110360000000000036e04,
            1.110389999999999964e04,
            1.110420000000000073e04,
            1.110450000000000000e04,
            1.110479999999999927e04,
            1.110510000000000036e04,
            1.110539999999999964e04,
            1.110570000000000073e04,
            1.110600000000000000e04,
            1.110629999999999927e04,
            1.110660000000000036e04,
            1.110689999999999964e04,
            1.110720000000000073e04,
            1.110750000000000000e04,
            1.110779999999999927e04,
            1.110810000000000036e04,
            1.110839999999999964e04,
            1.110870000000000073e04,
            1.110900000000000000e04,
            1.110929999999999927e04,
            1.110960000000000036e04,
            1.110989999999999964e04,
            1.111020000000000073e04,
            1.111050000000000000e04,
            1.111079999999999927e04,
            1.111110000000000036e04,
            1.111139999999999964e04,
            1.111170000000000073e04,
            1.111200000000000000e04,
            1.111229999999999927e04,
            1.111260000000000036e04,
            1.111289999999999964e04,
            1.111320000000000073e04,
            1.111350000000000000e04,
            1.111379999999999927e04,
            1.111410000000000036e04,
            1.111439999999999964e04,
            1.111470000000000073e04,
            1.111500000000000000e04,
            1.111529999999999927e04,
            1.111560000000000036e04,
            1.111589999999999964e04,
            1.111620000000000073e04,
            1.111650000000000000e04,
            1.111679999999999927e04,
            1.111710000000000036e04,
            1.111739999999999964e04,
            1.111770000000000073e04,
            1.111800000000000000e04,
            1.111829999999999927e04,
            1.111860000000000036e04,
            1.111889999999999964e04,
            1.111920000000000073e04,
            1.111950000000000000e04,
            1.111979999999999927e04,
            1.112010000000000036e04,
            1.112039999999999964e04,
            1.112070000000000073e04,
            1.112100000000000000e04,
            1.112129999999999927e04,
            1.112160000000000036e04,
            1.112200000000000000e04,
            1.112229999999999927e04,
            1.112260000000000036e04,
            1.112300000000000000e04,
            1.112329999999999927e04,
            1.112360000000000036e04,
            1.112400000000000000e04,
            1.112429999999999927e04,
            1.112470000000000073e04,
            1.112500000000000000e04,
            1.112539999999999964e04,
            1.112570000000000073e04,
            1.112610000000000036e04,
            1.112650000000000000e04,
            1.112679999999999927e04,
            1.112720000000000073e04,
            1.112760000000000036e04,
            1.112800000000000000e04,
            1.112829999999999927e04,
            1.112870000000000073e04,
            1.112910000000000036e04,
            1.112950000000000000e04,
            1.112989999999999964e04,
            1.113029999999999927e04,
            1.113070000000000073e04,
            1.113110000000000036e04,
            1.113150000000000000e04,
            1.113189999999999964e04,
            1.113229999999999927e04,
            1.113270000000000073e04,
            1.113310000000000036e04,
            1.113350000000000000e04,
            1.113400000000000000e04,
            1.113439999999999964e04,
            1.113479999999999927e04,
            1.113520000000000073e04,
            1.113570000000000073e04,
            1.113610000000000036e04,
            1.113650000000000000e04,
            1.113700000000000000e04,
            1.113739999999999964e04,
            1.113789999999999964e04,
            1.113829999999999927e04,
            1.113879999999999927e04,
            1.113929999999999927e04,
            1.113970000000000073e04,
            1.114020000000000073e04,
            1.114070000000000073e04,
            1.114110000000000036e04,
            1.114160000000000036e04,
            1.114210000000000036e04,
            1.114260000000000036e04,
            1.114300000000000000e04,
            1.114350000000000000e04,
            1.114400000000000000e04,
            1.114450000000000000e04,
            1.114500000000000000e04,
            1.114550000000000000e04,
            1.114600000000000000e04,
            1.114650000000000000e04,
            1.114700000000000000e04,
            1.114750000000000000e04,
            1.114800000000000000e04,
            1.114850000000000000e04,
            1.114910000000000036e04,
            1.114960000000000036e04,
            1.115010000000000036e04,
            1.115060000000000036e04,
            1.115120000000000073e04,
            1.115170000000000073e04,
            1.115220000000000073e04,
            1.115279999999999927e04,
            1.115329999999999927e04,
            1.115389999999999964e04,
            1.115439999999999964e04,
            1.115500000000000000e04,
            1.115550000000000000e04,
            1.115610000000000036e04,
            1.115660000000000036e04,
            1.115720000000000073e04,
            1.115779999999999927e04,
            1.115839999999999964e04,
            1.115889999999999964e04,
            1.115950000000000000e04,
            1.116010000000000036e04,
            1.116070000000000073e04,
            1.116129999999999927e04,
            1.116179999999999927e04,
            1.116239999999999964e04,
            1.116300000000000000e04,
            1.116360000000000036e04,
            1.116420000000000073e04,
            1.116479999999999927e04,
            1.116539999999999964e04,
            1.116600000000000000e04,
            1.116670000000000073e04,
            1.116729999999999927e04,
            1.116789999999999964e04,
            1.116850000000000000e04,
            1.116920000000000073e04,
            1.116979999999999927e04,
            1.117039999999999964e04,
            1.117100000000000000e04,
            1.117170000000000073e04,
            1.117229999999999927e04,
            1.117300000000000000e04,
            1.117360000000000036e04,
            1.117429999999999927e04,
            1.117489999999999964e04,
            1.117560000000000036e04,
            1.117620000000000073e04,
            1.117689999999999964e04,
            1.117760000000000036e04,
            1.117820000000000073e04,
            1.117889999999999964e04,
            1.117960000000000036e04,
            1.118020000000000073e04,
            1.118089999999999964e04,
            1.118160000000000036e04,
            1.118229999999999927e04,
            1.118300000000000000e04,
            1.118370000000000073e04,
            1.118439999999999964e04,
            1.118510000000000036e04,
            1.118579999999999927e04,
            1.118650000000000000e04,
            1.118720000000000073e04,
            1.118789999999999964e04,
            1.118860000000000036e04,
            1.118929999999999927e04,
            1.119000000000000000e04,
            1.119079999999999927e04,
            1.119150000000000000e04,
            1.119220000000000073e04,
            1.119300000000000000e04,
            1.119370000000000073e04,
            1.119439999999999964e04,
            1.119520000000000073e04,
            1.119589999999999964e04,
            1.119670000000000073e04,
            1.119739999999999964e04,
            1.119820000000000073e04,
            1.119889999999999964e04,
            1.119970000000000073e04,
            1.120039999999999964e04,
            1.120120000000000073e04,
            1.120200000000000000e04,
            1.120270000000000073e04,
            1.120350000000000000e04,
            1.120429999999999927e04,
            1.120510000000000036e04,
            1.120589999999999964e04,
            1.120660000000000036e04,
            1.120739999999999964e04,
            1.120820000000000073e04,
            1.120900000000000000e04,
            1.120979999999999927e04,
            1.121060000000000036e04,
            1.121139999999999964e04,
            1.121220000000000073e04,
            1.121310000000000036e04,
            1.121389999999999964e04,
            1.121470000000000073e04,
            1.121550000000000000e04,
            1.121629999999999927e04,
            1.121710000000000036e04,
            1.121800000000000000e04,
            1.121879999999999927e04,
            1.121960000000000036e04,
            1.122050000000000000e04,
            1.122129999999999927e04,
            1.122220000000000073e04,
            1.122300000000000000e04,
            1.122389999999999964e04,
            1.122470000000000073e04,
            1.122560000000000036e04,
            1.122639999999999964e04,
            1.122729999999999927e04,
            1.122820000000000073e04,
            1.122900000000000000e04,
            1.122989999999999964e04,
            1.123079999999999927e04,
            1.123170000000000073e04,
            1.123250000000000000e04,
            1.123339999999999964e04,
            1.123429999999999927e04,
            1.123520000000000073e04,
            1.123610000000000036e04,
            1.123700000000000000e04,
            1.123789999999999964e04,
            1.123879999999999927e04,
            1.123970000000000073e04,
            1.124060000000000036e04,
            1.124150000000000000e04,
            1.124239999999999964e04,
            1.124339999999999964e04,
            1.124429999999999927e04,
            1.124520000000000073e04,
            1.124610000000000036e04,
            1.124700000000000000e04,
            1.124800000000000000e04,
            1.124889999999999964e04,
            1.124989999999999964e04,
            1.125079999999999927e04,
            1.125170000000000073e04,
            1.125270000000000073e04,
            1.125360000000000036e04,
            1.125460000000000036e04,
            1.125560000000000036e04,
            1.125650000000000000e04,
            1.125750000000000000e04,
            1.125839999999999964e04,
            1.125939999999999964e04,
            1.126039999999999964e04,
            1.126139999999999964e04,
            1.126229999999999927e04,
            1.126329999999999927e04,
            1.126429999999999927e04,
            1.126529999999999927e04,
            1.126629999999999927e04,
            1.126729999999999927e04,
            1.126829999999999927e04,
            1.126929999999999927e04,
            1.127029999999999927e04,
            1.127129999999999927e04,
            1.127229999999999927e04,
            1.127329999999999927e04,
            1.127429999999999927e04,
            1.127529999999999927e04,
            1.127639999999999964e04,
            1.127739999999999964e04,
            1.127839999999999964e04,
            1.127939999999999964e04,
            1.128050000000000000e04,
            1.128150000000000000e04,
            1.128250000000000000e04,
            1.128360000000000036e04,
            1.128460000000000036e04,
            1.128570000000000073e04,
            1.128670000000000073e04,
            1.128779999999999927e04,
            1.128879999999999927e04,
            1.128989999999999964e04,
            1.129100000000000000e04,
            1.129200000000000000e04,
            1.129310000000000036e04,
            1.129420000000000073e04,
            1.129529999999999927e04,
            1.129629999999999927e04,
            1.129739999999999964e04,
            1.129850000000000000e04,
            1.129960000000000036e04,
            1.130070000000000073e04,
            1.130179999999999927e04,
            1.130289999999999964e04,
            1.130400000000000000e04,
            1.130510000000000036e04,
            1.130620000000000073e04,
            1.130729999999999927e04,
            1.130839999999999964e04,
            1.130950000000000000e04,
            1.131060000000000036e04,
            1.131170000000000073e04,
            1.131289999999999964e04,
            1.131400000000000000e04,
            1.131510000000000036e04,
            1.131629999999999927e04,
            1.131739999999999964e04,
            1.131850000000000000e04,
            1.131970000000000073e04,
            1.132079999999999927e04,
            1.132200000000000000e04,
            1.132310000000000036e04,
            1.132429999999999927e04,
            1.132539999999999964e04,
            1.132660000000000036e04,
            1.132779999999999927e04,
            1.132889999999999964e04,
            1.133010000000000036e04,
            1.133129999999999927e04,
            1.133250000000000000e04,
            1.133360000000000036e04,
            1.133479999999999927e04,
            1.133600000000000000e04,
            1.133720000000000073e04,
            1.133839999999999964e04,
            1.133960000000000036e04,
            1.134079999999999927e04,
            1.134200000000000000e04,
            1.134320000000000073e04,
            1.134439999999999964e04,
            1.134560000000000036e04,
            1.134679999999999927e04,
            1.134800000000000000e04,
            1.134920000000000073e04,
            1.135050000000000000e04,
            1.135170000000000073e04,
            1.135289999999999964e04,
            1.135410000000000036e04,
            1.135539999999999964e04,
            1.135660000000000036e04,
            1.135789999999999964e04,
            1.135910000000000036e04,
            1.136029999999999927e04,
            1.136160000000000036e04,
            1.136289999999999964e04,
            1.136410000000000036e04,
            1.136539999999999964e04,
            1.136660000000000036e04,
            1.136789999999999964e04,
            1.136920000000000073e04,
            1.137039999999999964e04,
            1.137170000000000073e04,
            1.137300000000000000e04,
            1.137420000000000073e04,
            1.137550000000000000e04,
            1.137679999999999927e04,
            1.137810000000000036e04,
            1.137939999999999964e04,
            1.138070000000000073e04,
            1.138200000000000000e04,
            1.138329999999999927e04,
            1.138460000000000036e04,
            1.138589999999999964e04,
            1.138720000000000073e04,
            1.138850000000000000e04,
            1.138979999999999927e04,
            1.139120000000000073e04,
            1.139250000000000000e04,
            1.139379999999999927e04,
            1.139510000000000036e04,
            1.139650000000000000e04,
            1.139779999999999927e04,
            1.139910000000000036e04,
            1.140050000000000000e04,
            1.140179999999999927e04,
            1.140320000000000073e04,
            1.140450000000000000e04,
            1.140589999999999964e04,
            1.140720000000000073e04,
            1.140860000000000036e04,
            1.141000000000000000e04,
            1.141129999999999927e04,
            1.141270000000000073e04,
            1.141410000000000036e04,
            1.141539999999999964e04,
            1.141679999999999927e04,
            1.141820000000000073e04,
            1.141960000000000036e04,
            1.142100000000000000e04,
            1.142229999999999927e04,
            1.142370000000000073e04,
            1.142510000000000036e04,
            1.142650000000000000e04,
            1.142789999999999964e04,
            1.142929999999999927e04,
            1.143070000000000073e04,
            1.143210000000000036e04,
            1.143360000000000036e04,
            1.143500000000000000e04,
            1.143639999999999964e04,
            1.143779999999999927e04,
            1.143920000000000073e04,
            1.144070000000000073e04,
            1.144210000000000036e04,
            1.144350000000000000e04,
            1.144500000000000000e04,
            1.144639999999999964e04,
            1.144789999999999964e04,
            1.144929999999999927e04,
            1.145079999999999927e04,
            1.145220000000000073e04,
            1.145370000000000073e04,
            1.145510000000000036e04,
            1.145660000000000036e04,
            1.145810000000000036e04,
            1.145950000000000000e04,
            1.146100000000000000e04,
            1.146250000000000000e04,
            1.146389999999999964e04,
            1.146539999999999964e04,
            1.146689999999999964e04,
            1.146839999999999964e04,
            1.146989999999999964e04,
            1.147139999999999964e04,
            1.147289999999999964e04,
            1.147439999999999964e04,
            1.147589999999999964e04,
            1.147739999999999964e04,
            1.147889999999999964e04,
            1.148039999999999964e04,
            1.148189999999999964e04,
            1.148339999999999964e04,
            1.148489999999999964e04,
            1.148650000000000000e04,
            1.148800000000000000e04,
            1.148950000000000000e04,
            1.149100000000000000e04,
            1.149260000000000036e04,
            1.149410000000000036e04,
            1.149570000000000073e04,
            1.149720000000000073e04,
            1.149879999999999927e04,
            1.150029999999999927e04,
            1.150189999999999964e04,
            1.150339999999999964e04,
            1.150500000000000000e04,
            1.150650000000000000e04,
            1.150810000000000036e04,
            1.150970000000000073e04,
            1.151120000000000073e04,
            1.151279999999999927e04,
            1.151439999999999964e04,
            1.151600000000000000e04,
            1.151760000000000036e04,
            1.151920000000000073e04,
            1.152070000000000073e04,
            1.152229999999999927e04,
            1.152389999999999964e04,
            1.152550000000000000e04,
            1.152710000000000036e04,
            1.152870000000000073e04,
            1.153029999999999927e04,
            1.153189999999999964e04,
            1.153360000000000036e04,
            1.153520000000000073e04,
            1.153679999999999927e04,
            1.153839999999999964e04,
            1.154010000000000036e04,
            1.154170000000000073e04,
            1.154329999999999927e04,
            1.154489999999999964e04,
            1.154660000000000036e04,
            1.154820000000000073e04,
            1.154989999999999964e04,
            1.155150000000000000e04,
            1.155320000000000073e04,
            1.155479999999999927e04,
            1.155650000000000000e04,
            1.155810000000000036e04,
            1.155979999999999927e04,
            1.156150000000000000e04,
            1.156310000000000036e04,
            1.156479999999999927e04,
            1.156650000000000000e04,
            1.156820000000000073e04,
            1.156979999999999927e04,
            1.157150000000000000e04,
            1.157320000000000073e04,
            1.157489999999999964e04,
            1.157660000000000036e04,
            1.157829999999999927e04,
            1.158000000000000000e04,
            1.158170000000000073e04,
            1.158339999999999964e04,
            1.158510000000000036e04,
            1.158679999999999927e04,
            1.158850000000000000e04,
            1.159029999999999927e04,
            1.159200000000000000e04,
            1.159370000000000073e04,
            1.159539999999999964e04,
            1.159720000000000073e04,
            1.159889999999999964e04,
            1.160060000000000036e04,
            1.160239999999999964e04,
            1.160410000000000036e04,
            1.160579999999999927e04,
            1.160760000000000036e04,
            1.160929999999999927e04,
            1.161110000000000036e04,
            1.161289999999999964e04,
            1.161460000000000036e04,
            1.161639999999999964e04,
            1.161810000000000036e04,
            1.161989999999999964e04,
            1.162170000000000073e04,
            1.162350000000000000e04,
            1.162520000000000073e04,
            1.162700000000000000e04,
            1.162879999999999927e04,
            1.163060000000000036e04,
            1.163239999999999964e04,
            1.163420000000000073e04,
            1.163600000000000000e04,
            1.163779999999999927e04,
            1.163960000000000036e04,
            1.164139999999999964e04,
            1.164320000000000073e04,
            1.164500000000000000e04,
            1.164679999999999927e04,
            1.164860000000000036e04,
            1.165050000000000000e04,
            1.165229999999999927e04,
            1.165410000000000036e04,
            1.165589999999999964e04,
            1.165779999999999927e04,
            1.165960000000000036e04,
            1.166139999999999964e04,
            1.166329999999999927e04,
            1.166510000000000036e04,
            1.166700000000000000e04,
            1.166879999999999927e04,
            1.167070000000000073e04,
            1.167250000000000000e04,
            1.167439999999999964e04,
            1.167629999999999927e04,
            1.167810000000000036e04,
            1.168000000000000000e04,
            1.168189999999999964e04,
            1.168379999999999927e04,
            1.168560000000000036e04,
            1.168750000000000000e04,
            1.168939999999999964e04,
            1.169129999999999927e04,
            1.169320000000000073e04,
            1.169510000000000036e04,
            1.169700000000000000e04,
            1.169889999999999964e04,
            1.170079999999999927e04,
            1.170270000000000073e04,
            1.170460000000000036e04,
            1.170650000000000000e04,
            1.170839999999999964e04,
            1.171029999999999927e04,
            1.171229999999999927e04,
            1.171420000000000073e04,
            1.171610000000000036e04,
            1.171800000000000000e04,
            1.172000000000000000e04,
            1.172189999999999964e04,
            1.172379999999999927e04,
            1.172579999999999927e04,
            1.172770000000000073e04,
            1.172970000000000073e04,
            1.173160000000000036e04,
            1.173360000000000036e04,
            1.173550000000000000e04,
            1.173750000000000000e04,
            1.173950000000000000e04,
            1.174139999999999964e04,
            1.174339999999999964e04,
            1.174539999999999964e04,
            1.174739999999999964e04,
            1.174929999999999927e04,
            1.175129999999999927e04,
            1.175329999999999927e04,
            1.175529999999999927e04,
            1.175729999999999927e04,
            1.175929999999999927e04,
            1.176129999999999927e04,
            1.176329999999999927e04,
            1.176529999999999927e04,
            1.176729999999999927e04,
            1.176929999999999927e04,
            1.177129999999999927e04,
            1.177329999999999927e04,
            1.177529999999999927e04,
            1.177739999999999964e04,
            1.177939999999999964e04,
            1.178139999999999964e04,
            1.178339999999999964e04,
            1.178550000000000000e04,
            1.178750000000000000e04,
            1.178960000000000036e04,
            1.179160000000000036e04,
            1.179360000000000036e04,
            1.179570000000000073e04,
            1.179770000000000073e04,
            1.179979999999999927e04,
            1.180189999999999964e04,
            1.180389999999999964e04,
            1.180600000000000000e04,
            1.180800000000000000e04,
            1.181010000000000036e04,
            1.181220000000000073e04,
            1.181429999999999927e04,
            1.181639999999999964e04,
            1.181839999999999964e04,
            1.182050000000000000e04,
            1.182260000000000036e04,
            1.182470000000000073e04,
            1.182679999999999927e04,
            1.182889999999999964e04,
            1.183100000000000000e04,
            1.183310000000000036e04,
            1.183520000000000073e04,
            1.183729999999999927e04,
            1.183939999999999964e04,
            1.184150000000000000e04,
            1.184370000000000073e04,
            1.184579999999999927e04,
            1.184789999999999964e04,
            1.185000000000000000e04,
            1.185220000000000073e04,
            1.185429999999999927e04,
            1.185639999999999964e04,
            1.185860000000000036e04,
            1.186070000000000073e04,
            1.186289999999999964e04,
            1.186500000000000000e04,
            1.186720000000000073e04,
            1.186929999999999927e04,
            1.187150000000000000e04,
            1.187360000000000036e04,
            1.187579999999999927e04,
            1.187800000000000000e04,
            1.188010000000000036e04,
            1.188229999999999927e04,
            1.188450000000000000e04,
            1.188670000000000073e04,
            1.188889999999999964e04,
            1.189110000000000036e04,
            1.189320000000000073e04,
            1.189539999999999964e04,
            1.189760000000000036e04,
            1.189979999999999927e04,
            1.190200000000000000e04,
            1.190420000000000073e04,
            1.190639999999999964e04,
            1.190860000000000036e04,
            1.191089999999999964e04,
            1.191310000000000036e04,
            1.191529999999999927e04,
            1.191750000000000000e04,
            1.191970000000000073e04,
            1.192200000000000000e04,
            1.192420000000000073e04,
            1.192639999999999964e04,
            1.192870000000000073e04,
            1.193089999999999964e04,
            1.193320000000000073e04,
            1.193539999999999964e04,
            1.193770000000000073e04,
            1.193989999999999964e04,
            1.194220000000000073e04,
            1.194439999999999964e04,
            1.194670000000000073e04,
            1.194900000000000000e04,
            1.195120000000000073e04,
            1.195350000000000000e04,
            1.195579999999999927e04,
            1.195800000000000000e04,
            1.196029999999999927e04,
            1.196260000000000036e04,
            1.196489999999999964e04,
            1.196720000000000073e04,
            1.196950000000000000e04,
            1.197179999999999927e04,
            1.197410000000000036e04,
            1.197639999999999964e04,
            1.197870000000000073e04,
            1.198100000000000000e04,
            1.198329999999999927e04,
            1.198560000000000036e04,
            1.198789999999999964e04,
            1.199020000000000073e04,
            1.199260000000000036e04,
            1.199489999999999964e04,
            1.199720000000000073e04,
            1.199960000000000036e04,
            1.200189999999999964e04,
            1.200420000000000073e04,
            1.200660000000000036e04,
            1.200889999999999964e04,
            1.201129999999999927e04,
            1.201360000000000036e04,
            1.201600000000000000e04,
            1.201829999999999927e04,
            1.202070000000000073e04,
            1.202300000000000000e04,
            1.202539999999999964e04,
            1.202779999999999927e04,
            1.203010000000000036e04,
            1.203250000000000000e04,
            1.203489999999999964e04,
            1.203729999999999927e04,
            1.203970000000000073e04,
            1.204200000000000000e04,
            1.204439999999999964e04,
            1.204679999999999927e04,
            1.204920000000000073e04,
            1.205160000000000036e04,
            1.205400000000000000e04,
            1.205639999999999964e04,
            1.205879999999999927e04,
            1.206129999999999927e04,
            1.206370000000000073e04,
            1.206610000000000036e04,
            1.206850000000000000e04,
            1.207089999999999964e04,
            1.207329999999999927e04,
            1.207579999999999927e04,
            1.207820000000000073e04,
            1.208070000000000073e04,
            1.208310000000000036e04,
            1.208550000000000000e04,
            1.208800000000000000e04,
            1.209039999999999964e04,
            1.209289999999999964e04,
            1.209529999999999927e04,
            1.209779999999999927e04,
            1.210020000000000073e04,
            1.210270000000000073e04,
            1.210520000000000073e04,
            1.210760000000000036e04,
            1.211010000000000036e04,
            1.211260000000000036e04,
            1.211510000000000036e04,
            1.211750000000000000e04,
            1.212000000000000000e04,
            1.212250000000000000e04,
            1.212500000000000000e04,
            1.212750000000000000e04,
            1.213000000000000000e04,
            1.213250000000000000e04,
            1.213500000000000000e04,
            1.213750000000000000e04,
            1.214000000000000000e04,
            1.214250000000000000e04,
            1.214500000000000000e04,
            1.214760000000000036e04,
            1.215010000000000036e04,
            1.215260000000000036e04,
            1.215510000000000036e04,
            1.215770000000000073e04,
            1.216020000000000073e04,
            1.216270000000000073e04,
            1.216529999999999927e04,
            1.216779999999999927e04,
            1.217029999999999927e04,
            1.217289999999999964e04,
            1.217550000000000000e04,
            1.217800000000000000e04,
            1.218060000000000036e04,
            1.218310000000000036e04,
            1.218570000000000073e04,
            1.218820000000000073e04,
            1.219079999999999927e04,
            1.219339999999999964e04,
            1.219600000000000000e04,
            1.219850000000000000e04,
            1.220110000000000036e04,
            1.220370000000000073e04,
            1.220629999999999927e04,
            1.220889999999999964e04,
            1.221150000000000000e04,
            1.221410000000000036e04,
            1.221670000000000073e04,
            1.221929999999999927e04,
            1.222189999999999964e04,
            1.222450000000000000e04,
            1.222710000000000036e04,
            1.222970000000000073e04,
            1.223229999999999927e04,
            1.223500000000000000e04,
            1.223760000000000036e04,
            1.224020000000000073e04,
            1.224279999999999927e04,
            1.224550000000000000e04,
            1.224810000000000036e04,
            1.225070000000000073e04,
            1.225339999999999964e04,
            1.225600000000000000e04,
            1.225870000000000073e04,
            1.226129999999999927e04,
            1.226400000000000000e04,
            1.226660000000000036e04,
            1.226929999999999927e04,
            1.227200000000000000e04,
            1.227460000000000036e04,
            1.227729999999999927e04,
            1.228000000000000000e04,
            1.228270000000000073e04,
            1.228529999999999927e04,
            1.228800000000000000e04,
            1.229070000000000073e04,
            1.229339999999999964e04,
            1.229610000000000036e04,
            1.229879999999999927e04,
            1.230150000000000000e04,
            1.230420000000000073e04,
            1.230689999999999964e04,
            1.230960000000000036e04,
            1.231229999999999927e04,
            1.231500000000000000e04,
            1.231770000000000073e04,
            1.232039999999999964e04,
            1.232310000000000036e04,
            1.232589999999999964e04,
            1.232860000000000036e04,
            1.233129999999999927e04,
            1.233410000000000036e04,
            1.233679999999999927e04,
            1.233950000000000000e04,
            1.234229999999999927e04,
            1.234500000000000000e04,
            1.234779999999999927e04,
            1.235050000000000000e04,
            1.235329999999999927e04,
            1.235610000000000036e04,
            1.235879999999999927e04,
            1.236160000000000036e04,
            1.236429999999999927e04,
            1.236710000000000036e04,
            1.236989999999999964e04,
            1.237270000000000073e04,
            1.237539999999999964e04,
            1.237820000000000073e04,
            1.238100000000000000e04,
            1.238379999999999927e04,
            1.238660000000000036e04,
            1.238939999999999964e04,
            1.239220000000000073e04,
            1.239500000000000000e04,
            1.239779999999999927e04,
            1.240060000000000036e04,
            1.240339999999999964e04,
            1.240620000000000073e04,
            1.240900000000000000e04,
            1.241179999999999927e04,
            1.241470000000000073e04,
            1.241750000000000000e04,
            1.242029999999999927e04,
            1.242320000000000073e04,
            1.242600000000000000e04,
            1.242879999999999927e04,
            1.243170000000000073e04,
            1.243450000000000000e04,
            1.243729999999999927e04,
            1.244020000000000073e04,
            1.244300000000000000e04,
            1.244589999999999964e04,
            1.244879999999999927e04,
            1.245160000000000036e04,
            1.245450000000000000e04,
            1.245739999999999964e04,
            1.246020000000000073e04,
            1.246310000000000036e04,
            1.246600000000000000e04,
            1.246889999999999964e04,
            1.247170000000000073e04,
            1.247460000000000036e04,
            1.247750000000000000e04,
            1.248039999999999964e04,
            1.248329999999999927e04,
            1.248620000000000073e04,
            1.248910000000000036e04,
            1.249200000000000000e04,
            1.249489999999999964e04,
            1.249779999999999927e04,
            1.250070000000000073e04,
            1.250360000000000036e04,
            1.250660000000000036e04,
            1.250950000000000000e04,
            1.251239999999999964e04,
            1.251529999999999927e04,
            1.251829999999999927e04,
            1.252120000000000073e04,
            1.252410000000000036e04,
            1.252710000000000036e04,
            1.253000000000000000e04,
            1.253300000000000000e04,
            1.253589999999999964e04,
            1.253889999999999964e04,
            1.254179999999999927e04,
            1.254479999999999927e04,
            1.254770000000000073e04,
            1.255070000000000073e04,
            1.255370000000000073e04,
            1.255660000000000036e04,
            1.255960000000000036e04,
            1.256260000000000036e04,
            1.256560000000000036e04,
            1.256860000000000036e04,
            1.257150000000000000e04,
            1.257450000000000000e04,
            1.257750000000000000e04,
            1.258050000000000000e04,
            1.258350000000000000e04,
            1.258650000000000000e04,
            1.258950000000000000e04,
            1.259250000000000000e04,
            1.259550000000000000e04,
            1.259860000000000036e04,
            1.260160000000000036e04,
            1.260460000000000036e04,
            1.260760000000000036e04,
            1.261060000000000036e04,
            1.261370000000000073e04,
            1.261670000000000073e04,
            1.261970000000000073e04,
            1.262279999999999927e04,
            1.262579999999999927e04,
            1.262889999999999964e04,
            1.263189999999999964e04,
            1.263489999999999964e04,
            1.263800000000000000e04,
            1.264110000000000036e04,
            1.264410000000000036e04,
            1.264720000000000073e04,
            1.265029999999999927e04,
            1.265329999999999927e04,
            1.265639999999999964e04,
            1.265950000000000000e04,
            1.266260000000000036e04,
            1.266560000000000036e04,
            1.266870000000000073e04,
            1.267179999999999927e04,
            1.267489999999999964e04,
            1.267800000000000000e04,
            1.268110000000000036e04,
            1.268420000000000073e04,
            1.268729999999999927e04,
            1.269039999999999964e04,
            1.269350000000000000e04,
            1.269660000000000036e04,
            1.269970000000000073e04,
            1.270279999999999927e04,
            1.270589999999999964e04,
            1.270910000000000036e04,
            1.271220000000000073e04,
            1.271529999999999927e04,
            1.271850000000000000e04,
            1.272160000000000036e04,
            1.272470000000000073e04,
            1.272789999999999964e04,
            1.273100000000000000e04,
            1.273420000000000073e04,
            1.273729999999999927e04,
            1.274050000000000000e04,
            1.274360000000000036e04,
            1.274679999999999927e04,
            1.274989999999999964e04,
            1.275310000000000036e04,
            1.275629999999999927e04,
            1.275939999999999964e04,
            1.276260000000000036e04,
            1.276579999999999927e04,
            1.276900000000000000e04,
            1.277220000000000073e04,
            1.277539999999999964e04,
            1.277850000000000000e04,
            1.278170000000000073e04,
            1.278489999999999964e04,
            1.278810000000000036e04,
            1.279129999999999927e04,
            1.279450000000000000e04,
            1.279770000000000073e04,
            1.280100000000000000e04,
            1.280420000000000073e04,
            1.280739999999999964e04,
            1.281060000000000036e04,
            1.281379999999999927e04,
            1.281710000000000036e04,
            1.282029999999999927e04,
            1.282350000000000000e04,
            1.282679999999999927e04,
            1.283000000000000000e04,
            1.283320000000000073e04,
            1.283650000000000000e04,
            1.283970000000000073e04,
            1.284300000000000000e04,
            1.284620000000000073e04,
            1.284950000000000000e04,
            1.285270000000000073e04,
            1.285600000000000000e04,
            1.285929999999999927e04,
            1.286250000000000000e04,
            1.286579999999999927e04,
            1.286910000000000036e04,
            1.287239999999999964e04,
            1.287560000000000036e04,
            1.287889999999999964e04,
            1.288220000000000073e04,
            1.288550000000000000e04,
            1.288879999999999927e04,
            1.289210000000000036e04,
            1.289539999999999964e04,
            1.289870000000000073e04,
            1.290200000000000000e04,
            1.290529999999999927e04,
            1.290860000000000036e04,
            1.291189999999999964e04,
            1.291529999999999927e04,
            1.291860000000000036e04,
            1.292189999999999964e04,
            1.292520000000000073e04,
            1.292860000000000036e04,
            1.293189999999999964e04,
            1.293520000000000073e04,
            1.293860000000000036e04,
            1.294189999999999964e04,
            1.294520000000000073e04,
            1.294860000000000036e04,
            1.295200000000000000e04,
            1.295529999999999927e04,
            1.295870000000000073e04,
            1.296200000000000000e04,
            1.296539999999999964e04,
            1.296870000000000073e04,
            1.297210000000000036e04,
            1.297550000000000000e04,
            1.297889999999999964e04,
            1.298220000000000073e04,
            1.298560000000000036e04,
            1.298900000000000000e04,
            1.299239999999999964e04,
            1.299579999999999927e04,
            1.299920000000000073e04,
            1.300260000000000036e04,
            1.300600000000000000e04,
            1.300939999999999964e04,
            1.301279999999999927e04,
            1.301620000000000073e04,
            1.301960000000000036e04,
            1.302300000000000000e04,
            1.302639999999999964e04,
            1.302979999999999927e04,
            1.303329999999999927e04,
            1.303670000000000073e04,
            1.304010000000000036e04,
            1.304360000000000036e04,
            1.304700000000000000e04,
            1.305050000000000000e04,
            1.305389999999999964e04,
            1.305729999999999927e04,
            1.306079999999999927e04,
            1.306420000000000073e04,
            1.306770000000000073e04,
            1.307120000000000073e04,
            1.307460000000000036e04,
            1.307810000000000036e04,
            1.308150000000000000e04,
            1.308500000000000000e04,
            1.308850000000000000e04,
            1.309200000000000000e04,
            1.309539999999999964e04,
            1.309889999999999964e04,
            1.310239999999999964e04,
        ]
    )

    mu = numpy.array(
        [
            7.097449999999999593e-02,
            6.934389999999999998e-02,
            6.777700000000000391e-02,
            6.614009999999999334e-02,
            6.448399999999999965e-02,
            6.296179999999999832e-02,
            6.135659999999999725e-02,
            5.980250000000000149e-02,
            5.842039999999999733e-02,
            5.685350000000000126e-02,
            5.534390000000000143e-02,
            5.390450000000000103e-02,
            5.251589999999999731e-02,
            5.108279999999999765e-02,
            4.954770000000000008e-02,
            4.808919999999999861e-02,
            4.643950000000000161e-02,
            4.495539999999999953e-02,
            4.347129999999999744e-02,
            4.198729999999999823e-02,
            4.047769999999999840e-02,
            3.898719999999999963e-02,
            3.753499999999999892e-02,
            3.615920000000000245e-02,
            3.460509999999999975e-02,
            3.319110000000000116e-02,
            3.161780000000000146e-02,
            3.018469999999999834e-02,
            2.877069999999999975e-02,
            2.751589999999999939e-02,
            2.626109999999999903e-02,
            2.485350000000000059e-02,
            2.343939999999999912e-02,
            2.213369999999999921e-02,
            2.078980000000000064e-02,
            1.951589999999999922e-02,
            1.817200000000000065e-02,
            1.680890000000000162e-02,
            1.544580000000000085e-02,
            1.405730000000000000e-02,
            1.282800000000000086e-02,
            1.141400000000000053e-02,
            1.024199999999999937e-02,
            8.993620000000000780e-03,
            7.840710000000000734e-03,
            6.624159999999999597e-03,
            5.541410000000000086e-03,
            4.458580000000000182e-03,
            3.458590000000000102e-03,
            2.643260000000000141e-03,
            1.898090000000000064e-03,
            1.203789999999999938e-03,
            7.834400000000000478e-04,
            4.458579999999999857e-04,
            2.165509999999999939e-04,
            5.732680000000000143e-05,
            0.000000000000000000e00,
            2.229289999999999928e-04,
            6.624089999999999796e-04,
            1.394899999999999916e-03,
            2.426709999999999891e-03,
            3.815230000000000184e-03,
            5.433059999999999973e-03,
            7.738809999999999613e-03,
            1.005729999999999992e-02,
            1.323560000000000014e-02,
            1.659870000000000095e-02,
            2.031200000000000019e-02,
            2.428019999999999831e-02,
            2.827390000000000111e-02,
            3.203820000000000279e-02,
            3.506370000000000320e-02,
            3.723569999999999658e-02,
            3.969430000000000180e-02,
            4.227390000000000314e-02,
            4.512739999999999807e-02,
            4.815919999999999923e-02,
            5.166880000000000084e-02,
            5.536300000000000249e-02,
            5.940120000000000122e-02,
            6.398080000000000434e-02,
            6.925470000000000237e-02,
            7.496179999999999510e-02,
            8.145220000000000238e-02,
            8.871969999999999856e-02,
            9.701269999999999338e-02,
            1.070890000000000036e-01,
            1.183820000000000011e-01,
            1.318090000000000095e-01,
            1.474519999999999997e-01,
            1.669619999999999993e-01,
            1.898600000000000010e-01,
            2.173760000000000137e-01,
            2.527710000000000234e-01,
            3.005349999999999966e-01,
            3.604459999999999886e-01,
            4.400249999999999995e-01,
            5.458659999999999624e-01,
            6.839250000000000052e-01,
            8.625260000000000149e-01,
            1.048170000000000046e00,
            1.225489999999999968e00,
            1.366549999999999931e00,
            1.462620000000000031e00,
            1.519889999999999963e00,
            1.552240000000000064e00,
            1.580349999999999921e00,
            1.608519999999999950e00,
            1.630409999999999915e00,
            1.636500000000000066e00,
            1.623729999999999896e00,
            1.600410000000000110e00,
            1.574829999999999952e00,
            1.548750000000000071e00,
            1.518029999999999990e00,
            1.485500000000000043e00,
            1.452399999999999913e00,
            1.422449999999999992e00,
            1.396919999999999940e00,
            1.374829999999999997e00,
            1.357369999999999965e00,
            1.342119999999999980e00,
            1.329579999999999984e00,
            1.320259999999999989e00,
            1.314510000000000067e00,
            1.312119999999999953e00,
            1.311320000000000041e00,
            1.310060000000000002e00,
            1.307250000000000023e00,
            1.302680000000000060e00,
            1.297469999999999901e00,
            1.292100000000000026e00,
            1.286880000000000024e00,
            1.281250000000000000e00,
            1.274149999999999894e00,
            1.264259999999999939e00,
            1.251409999999999911e00,
            1.234499999999999931e00,
            1.213810000000000056e00,
            1.189559999999999951e00,
            1.162449999999999983e00,
            1.132290000000000019e00,
            1.103140000000000009e00,
            1.075120000000000076e00,
            1.049180000000000001e00,
            1.026580000000000048e00,
            1.008229999999999960e00,
            9.944460000000000521e-01,
            9.866409999999999902e-01,
            9.832589999999999941e-01,
            9.833039999999999559e-01,
            9.856770000000000254e-01,
            9.889839999999999742e-01,
            9.928799999999999848e-01,
            9.971950000000000536e-01,
            1.001440000000000108e00,
            1.005800000000000027e00,
            1.009740000000000082e00,
            1.012999999999999901e00,
            1.015530000000000044e00,
            1.016880000000000006e00,
            1.017249999999999988e00,
            1.016739999999999977e00,
            1.015470000000000095e00,
            1.014150000000000107e00,
            1.012939999999999952e00,
            1.012100000000000000e00,
            1.011759999999999993e00,
            1.011970000000000036e00,
            1.012729999999999908e00,
            1.013980000000000103e00,
            1.015330000000000066e00,
            1.016960000000000086e00,
            1.018629999999999924e00,
            1.020199999999999996e00,
            1.021619999999999973e00,
            1.023009999999999975e00,
            1.024299999999999988e00,
            1.025640000000000107e00,
            1.026690000000000103e00,
            1.027449999999999974e00,
            1.027670000000000083e00,
            1.027130000000000098e00,
            1.025479999999999947e00,
            1.022540000000000004e00,
            1.018469999999999986e00,
            1.012890000000000068e00,
            1.006269999999999998e00,
            9.990029999999999744e-01,
            9.921539999999999804e-01,
            9.857850000000000223e-01,
            9.809109999999999774e-01,
            9.772669999999999968e-01,
            9.757820000000000382e-01,
            9.759379999999999722e-01,
            9.774920000000000275e-01,
            9.799200000000000133e-01,
            9.829339999999999744e-01,
            9.860659999999999981e-01,
            9.890799999999999592e-01,
            9.917719999999999869e-01,
            9.940989999999999549e-01,
            9.958339999999999970e-01,
            9.971729999999999761e-01,
            9.982429999999999914e-01,
            9.990059999999999496e-01,
            9.996399999999999730e-01,
            1.000299999999999967e00,
            1.000709999999999988e00,
            1.000790000000000068e00,
            1.000869999999999926e00,
            1.000660000000000105e00,
            1.000369999999999981e00,
            1.000199999999999978e00,
            1.000019999999999909e00,
            9.998150000000000093e-01,
            9.993959999999999511e-01,
            9.991010000000000169e-01,
            9.987989999999999924e-01,
            9.984690000000000509e-01,
            9.986810000000000409e-01,
            9.994929999999999648e-01,
            1.000650000000000039e00,
            1.002210000000000045e00,
            1.004000000000000004e00,
            1.006289999999999907e00,
            1.008879999999999999e00,
            1.011940000000000062e00,
            1.015549999999999953e00,
            1.019060000000000077e00,
            1.022669999999999968e00,
            1.026070000000000038e00,
            1.028780000000000028e00,
            1.030419999999999892e00,
            1.030699999999999950e00,
            1.029530000000000056e00,
            1.026639999999999997e00,
            1.022550000000000070e00,
            1.017360000000000042e00,
            1.012270000000000003e00,
            1.007220000000000004e00,
            1.002879999999999994e00,
            9.994549999999999823e-01,
            9.968310000000000226e-01,
            9.946920000000000206e-01,
            9.928169999999999495e-01,
            9.910080000000000000e-01,
            9.893990000000000284e-01,
            9.877770000000000161e-01,
            9.859679999999999556e-01,
            9.842570000000000485e-01,
            9.826179999999999914e-01,
            9.811879999999999491e-01,
            9.802389999999999715e-01,
            9.797599999999999643e-01,
            9.798010000000000330e-01,
            9.805089999999999639e-01,
            9.816589999999999483e-01,
            9.834180000000000144e-01,
            9.859639999999999516e-01,
            9.892400000000000082e-01,
            9.929599999999999538e-01,
            9.973480000000000123e-01,
            1.002410000000000023e00,
            1.007530000000000037e00,
            1.012629999999999919e00,
            1.017840000000000078e00,
            1.022809999999999997e00,
            1.027320000000000011e00,
            1.031039999999999957e00,
            1.033730000000000038e00,
            1.035449999999999982e00,
            1.036280000000000090e00,
            1.036200000000000010e00,
            1.035090000000000066e00,
            1.033539999999999903e00,
            1.031420000000000003e00,
            1.029360000000000053e00,
            1.027400000000000091e00,
            1.025760000000000005e00,
            1.024359999999999937e00,
            1.023099999999999898e00,
            1.021709999999999896e00,
            1.020289999999999919e00,
            1.018880000000000008e00,
            1.017349999999999977e00,
            1.015849999999999920e00,
            1.014359999999999928e00,
            1.013069999999999915e00,
            1.011970000000000036e00,
            1.011069999999999913e00,
            1.009889999999999954e00,
            1.008450000000000069e00,
            1.006420000000000092e00,
            1.003649999999999931e00,
            1.000189999999999912e00,
            9.964480000000000004e-01,
            9.928329999999999655e-01,
            9.897569999999999979e-01,
            9.875420000000000309e-01,
            9.859499999999999931e-01,
            9.854450000000000154e-01,
            9.857120000000000326e-01,
            9.866409999999999902e-01,
            9.881590000000000096e-01,
            9.901079999999999881e-01,
            9.924239999999999728e-01,
            9.948069999999999968e-01,
            9.973410000000000331e-01,
            9.995730000000000448e-01,
            1.001160000000000050e00,
            1.001710000000000100e00,
            1.001030000000000086e00,
            9.986800000000000122e-01,
            9.946899999999999631e-01,
            9.891480000000000272e-01,
            9.826040000000000330e-01,
            9.753199999999999648e-01,
            9.681130000000000013e-01,
            9.612399999999999833e-01,
            9.552829999999999933e-01,
            9.502289999999999903e-01,
            9.464799999999999880e-01,
            9.438260000000000538e-01,
            9.421599999999999975e-01,
            9.411680000000000046e-01,
            9.407090000000000174e-01,
            9.404249999999999554e-01,
            9.396830000000000460e-01,
            9.400990000000000180e-01,
            9.410199999999999676e-01,
            9.406520000000000437e-01,
            9.408410000000000384e-01,
            9.419939999999999980e-01,
            9.438299999999999468e-01,
            9.463679999999999870e-01,
            9.496280000000000276e-01,
            9.532389999999999475e-01,
            9.569189999999999641e-01,
            9.609189999999999676e-01,
            9.651619999999999644e-01,
            9.697139999999999649e-01,
            9.744249999999999856e-01,
            9.793730000000000491e-01,
            9.841870000000000340e-01,
            9.891870000000000385e-01,
            9.940539999999999932e-01,
            9.988430000000000364e-01,
            1.002990000000000048e00,
            1.006450000000000067e00,
            1.008999999999999897e00,
            1.010389999999999899e00,
            1.010920000000000041e00,
            1.010820000000000052e00,
            1.010289999999999910e00,
            1.009570000000000078e00,
            1.009030000000000094e00,
            1.008289999999999909e00,
            1.007830000000000004e00,
            1.007679999999999909e00,
            1.007460000000000022e00,
            1.007220000000000004e00,
            1.006289999999999907e00,
            1.004480000000000040e00,
            1.002269999999999994e00,
            9.996749999999999803e-01,
            9.971320000000000183e-01,
            9.950109999999999788e-01,
            9.930529999999999635e-01,
            9.912309999999999732e-01,
            9.893570000000000420e-01,
            9.871480000000000254e-01,
            9.843520000000000048e-01,
            9.809149999999999814e-01,
            9.772290000000000143e-01,
            9.733800000000000230e-01,
            9.696709999999999496e-01,
            9.661009999999999875e-01,
            9.626169999999999449e-01,
            9.594479999999999675e-01,
            9.562500000000000444e-01,
            9.531460000000000488e-01,
            9.499729999999999563e-01,
            9.469319999999999959e-01,
            9.440840000000000343e-01,
            9.415360000000000396e-01,
            9.392620000000000413e-01,
            9.374160000000000270e-01,
            9.358290000000000219e-01,
            9.341979999999999729e-01,
            9.329380000000000450e-01,
            9.317990000000000439e-01,
            9.308459999999999512e-01,
            9.302150000000000141e-01,
            9.298459999999999503e-01,
            9.293160000000000309e-01,
            9.283979999999999455e-01,
            9.272550000000000514e-01,
            9.255879999999999663e-01,
            9.239079999999999515e-01,
            9.224520000000000497e-01,
            9.217039999999999678e-01,
            9.216180000000000483e-01,
            9.225900000000000212e-01,
            9.246579999999999799e-01,
            9.275809999999999889e-01,
            9.312089999999999534e-01,
            9.349830000000000085e-01,
            9.384869999999999601e-01,
            9.414879999999999916e-01,
            9.439659999999999718e-01,
            9.457619999999999916e-01,
            9.469419999999999504e-01,
            9.473009999999999486e-01,
            9.468760000000000510e-01,
            9.457889999999999908e-01,
            9.443679999999999852e-01,
            9.428549999999999986e-01,
            9.416200000000000125e-01,
            9.409509999999999819e-01,
            9.408349999999999769e-01,
            9.413589999999999458e-01,
            9.424339999999999939e-01,
            9.439269999999999605e-01,
            9.456409999999999538e-01,
            9.474040000000000239e-01,
            9.491709999999999869e-01,
            9.508790000000000298e-01,
            9.524920000000000053e-01,
            9.541269999999999474e-01,
            9.556759999999999700e-01,
            9.569919999999999538e-01,
            9.587430000000000119e-01,
            9.608039999999999914e-01,
            9.623699999999999477e-01,
            9.643450000000000077e-01,
            9.654509999999999481e-01,
            9.665089999999999515e-01,
            9.664179999999999993e-01,
            9.655599999999999739e-01,
            9.636639999999999651e-01,
            9.615040000000000253e-01,
            9.584350000000000369e-01,
            9.549389999999999823e-01,
            9.513909999999999867e-01,
            9.486320000000000308e-01,
            9.451509999999999634e-01,
            9.424320000000000475e-01,
            9.400309999999999500e-01,
            9.381629999999999692e-01,
            9.366520000000000401e-01,
            9.353359999999999452e-01,
            9.336659999999999959e-01,
            9.321249999999999813e-01,
            9.291369999999999907e-01,
            9.270169999999999799e-01,
            9.239889999999999493e-01,
            9.208100000000000174e-01,
            9.177159999999999762e-01,
            9.150409999999999933e-01,
            9.090989999999999904e-01,
            9.077269999999999506e-01,
            9.041059999999999652e-01,
            9.007730000000000459e-01,
            8.974940000000000140e-01,
            8.942160000000000108e-01,
            8.904919999999999503e-01,
            8.887669999999999737e-01,
            8.859799999999999898e-01,
            8.835180000000000256e-01,
            8.819120000000000292e-01,
            8.809580000000000188e-01,
            8.805009999999999781e-01,
            8.802849999999999842e-01,
            8.805800000000000294e-01,
            8.811949999999999505e-01,
            8.828730000000000189e-01,
            8.851879999999999749e-01,
            8.876340000000000341e-01,
            8.895880000000000454e-01,
            8.917770000000000419e-01,
            8.935499999999999554e-01,
            8.958500000000000352e-01,
            8.978570000000000162e-01,
            8.996009999999999840e-01,
            9.013600000000000501e-01,
            9.025609999999999467e-01,
            9.043940000000000312e-01,
            9.061409999999999743e-01,
            9.075280000000000014e-01,
            9.084719999999999462e-01,
            9.090939999999999577e-01,
            9.096530000000000449e-01,
            9.096680000000000321e-01,
            9.096379999999999466e-01,
            9.093900000000000317e-01,
            9.088340000000000307e-01,
            9.083539999999999948e-01,
            9.078100000000000058e-01,
            9.072879999999999834e-01,
            9.066269999999999607e-01,
            9.058040000000000536e-01,
            9.045849999999999724e-01,
            9.031420000000000003e-01,
            9.016950000000000243e-01,
            9.004550000000000054e-01,
            8.992769999999999930e-01,
            8.984680000000000444e-01,
            8.978720000000000034e-01,
            8.976539999999999520e-01,
            8.975090000000000012e-01,
            8.973430000000000017e-01,
            8.970550000000000468e-01,
            8.963440000000000296e-01,
            8.952499999999999902e-01,
            8.940280000000000449e-01,
            8.926199999999999690e-01,
            8.910249999999999559e-01,
            8.894290000000000251e-01,
            8.879780000000000451e-01,
            8.866680000000000117e-01,
            8.855309999999999571e-01,
            8.846009999999999707e-01,
            8.833630000000000093e-01,
            8.821630000000000305e-01,
            8.810109999999999886e-01,
            8.799839999999999884e-01,
            8.788219999999999921e-01,
            8.775570000000000315e-01,
            8.761160000000000059e-01,
            8.742079999999999851e-01,
            8.723109999999999475e-01,
            8.703049999999999953e-01,
            8.681200000000000028e-01,
            8.657580000000000275e-01,
            8.632520000000000193e-01,
            8.606460000000000221e-01,
            8.582229999999999581e-01,
            8.559240000000000181e-01,
            8.538219999999999699e-01,
            8.521739999999999871e-01,
            8.508120000000000127e-01,
            8.496150000000000091e-01,
            8.485030000000000072e-01,
            8.474070000000000213e-01,
            8.461680000000000312e-01,
            8.448590000000000266e-01,
            8.432549999999999768e-01,
            8.423289999999999944e-01,
            8.407829999999999471e-01,
            8.395829999999999682e-01,
            8.387649999999999828e-01,
            8.383930000000000549e-01,
            8.387620000000000076e-01,
            8.394819999999999505e-01,
            8.406749999999999501e-01,
            8.419550000000000090e-01,
            8.432899999999999840e-01,
            8.451589999999999936e-01,
            8.464019999999999877e-01,
            8.476679999999999771e-01,
            8.486949999999999772e-01,
            8.493680000000000119e-01,
            8.495340000000000114e-01,
            8.495920000000000138e-01,
            8.494439999999999769e-01,
            8.491929999999999756e-01,
            8.489480000000000359e-01,
            8.485449999999999937e-01,
            8.482840000000000380e-01,
            8.482450000000000268e-01,
            8.480790000000000273e-01,
            8.481429999999999803e-01,
            8.479900000000000215e-01,
            8.479299999999999615e-01,
            8.475789999999999713e-01,
            8.471999999999999531e-01,
            8.467909999999999604e-01,
            8.459360000000000213e-01,
            8.449079999999999924e-01,
            8.436989999999999768e-01,
            8.424610000000000154e-01,
            8.411889999999999645e-01,
            8.398529999999999607e-01,
            8.385550000000000503e-01,
            8.376820000000000377e-01,
            8.363479999999999803e-01,
            8.351499999999999480e-01,
            8.336449999999999694e-01,
            8.323319999999999608e-01,
            8.309670000000000112e-01,
            8.296240000000000281e-01,
            8.283430000000000515e-01,
            8.268750000000000266e-01,
            8.255209999999999493e-01,
            8.239309999999999690e-01,
            8.224949999999999761e-01,
            8.209729999999999528e-01,
            8.195740000000000247e-01,
            8.184690000000000021e-01,
            8.168900000000000050e-01,
            8.156710000000000349e-01,
            8.144259999999999833e-01,
            8.129330000000000167e-01,
            8.115440000000000431e-01,
            8.100829999999999975e-01,
            8.084999999999999964e-01,
            8.069119999999999626e-01,
            8.055520000000000458e-01,
            8.042820000000000524e-01,
            8.030080000000000551e-01,
            8.018180000000000307e-01,
            8.007360000000000033e-01,
            7.997539999999999649e-01,
            7.991470000000000518e-01,
            7.984480000000000466e-01,
            7.981380000000000141e-01,
            7.975999999999999757e-01,
            7.971949999999999870e-01,
            7.965590000000000170e-01,
            7.963289999999999536e-01,
            7.957800000000000429e-01,
            7.952339999999999964e-01,
            7.946579999999999755e-01,
            7.941209999999999658e-01,
            7.933390000000000164e-01,
            7.925119999999999942e-01,
            7.916950000000000376e-01,
            7.909530000000000172e-01,
            7.901500000000000190e-01,
            7.894940000000000291e-01,
            7.889890000000000514e-01,
            7.887150000000000549e-01,
            7.886389999999999789e-01,
            7.886239999999999917e-01,
            7.886189999999999589e-01,
            7.885499999999999732e-01,
            7.883829999999999449e-01,
            7.883520000000000527e-01,
            7.877830000000000110e-01,
            7.873630000000000351e-01,
            7.870780000000000554e-01,
            7.867150000000000531e-01,
            7.862639999999999629e-01,
            7.858739999999999615e-01,
            7.853620000000000045e-01,
            7.849270000000000413e-01,
            7.843909999999999494e-01,
            7.839920000000000222e-01,
            7.833780000000000188e-01,
            7.828199999999999603e-01,
            7.822339999999999849e-01,
            7.814510000000000067e-01,
            7.806800000000000406e-01,
            7.798749999999999849e-01,
            7.789479999999999738e-01,
            7.781430000000000291e-01,
            7.770829999999999682e-01,
            7.760430000000000383e-01,
            7.748549999999999605e-01,
            7.738150000000000306e-01,
            7.726189999999999447e-01,
            7.714750000000000218e-01,
            7.702649999999999775e-01,
            7.689730000000000176e-01,
            7.677199999999999580e-01,
            7.663969999999999949e-01,
            7.650400000000000533e-01,
            7.637549999999999617e-01,
            7.620780000000000332e-01,
            7.605969999999999676e-01,
            7.592640000000000500e-01,
            7.578110000000000124e-01,
            7.564999999999999503e-01,
            7.551259999999999639e-01,
            7.538839999999999986e-01,
            7.527970000000000494e-01,
            7.514699999999999713e-01,
            7.502999999999999670e-01,
            7.492370000000000418e-01,
            7.482079999999999842e-01,
            7.471029999999999616e-01,
            7.456080000000000485e-01,
            7.442379999999999551e-01,
            7.434309999999999530e-01,
            7.423689999999999456e-01,
            7.413830000000000142e-01,
            7.404159999999999631e-01,
            7.396669999999999634e-01,
            7.389860000000000317e-01,
            7.384319999999999773e-01,
            7.378949999999999676e-01,
            7.373490000000000322e-01,
            7.368989999999999707e-01,
            7.362349999999999728e-01,
            7.357099999999999751e-01,
            7.352429999999999799e-01,
            7.347219999999999862e-01,
            7.341910000000000380e-01,
            7.336150000000000171e-01,
            7.332459999999999534e-01,
            7.326160000000000450e-01,
            7.321429999999999882e-01,
            7.315009999999999568e-01,
            7.307869999999999644e-01,
            7.301959999999999562e-01,
            7.295300000000000118e-01,
            7.288409999999999611e-01,
            7.282530000000000392e-01,
            7.274639999999999995e-01,
            7.267169999999999463e-01,
            7.259160000000000057e-01,
            7.252840000000000398e-01,
            7.245089999999999586e-01,
            7.238200000000000189e-01,
            7.230509999999999993e-01,
            7.224220000000000086e-01,
            7.216740000000000377e-01,
            7.208860000000000268e-01,
            7.199670000000000236e-01,
            7.192730000000000512e-01,
            7.184660000000000490e-01,
            7.176270000000000149e-01,
            7.169649999999999634e-01,
            7.161669999999999980e-01,
            7.153779999999999584e-01,
            7.146029999999999882e-01,
            7.135970000000000368e-01,
            7.124800000000000022e-01,
            7.117729999999999890e-01,
            7.106040000000000134e-01,
            7.096369999999999623e-01,
            7.088459999999999761e-01,
            7.079619999999999802e-01,
            7.069959999999999578e-01,
            7.059910000000000352e-01,
            7.048539999999999806e-01,
            7.037569999999999659e-01,
            7.028029999999999555e-01,
            7.017229999999999857e-01,
            7.017959999999999754e-01,
            6.996630000000000349e-01,
            6.985970000000000235e-01,
            6.975109999999999921e-01,
            6.963890000000000358e-01,
            6.952570000000000139e-01,
            6.941619999999999457e-01,
            6.930429999999999646e-01,
            6.918809999999999683e-01,
            6.906379999999999741e-01,
            6.895149999999999890e-01,
            6.883460000000000134e-01,
            6.873719999999999830e-01,
            6.862850000000000339e-01,
            6.852639999999999842e-01,
            6.842249999999999721e-01,
            6.832200000000000495e-01,
            6.822019999999999751e-01,
            6.812669999999999559e-01,
            6.804339999999999833e-01,
            6.795240000000000169e-01,
            6.787419999999999565e-01,
            6.778819999999999846e-01,
            6.769410000000000149e-01,
            6.760410000000000030e-01,
            6.752869999999999706e-01,
            6.745179999999999509e-01,
            6.737880000000000535e-01,
            6.731639999999999846e-01,
            6.723989999999999689e-01,
            6.717990000000000350e-01,
            6.710150000000000281e-01,
            6.702690000000000037e-01,
            6.695879999999999610e-01,
            6.689319999999999711e-01,
            6.682420000000000027e-01,
            6.676729999999999610e-01,
            6.669239999999999613e-01,
            6.662829999999999586e-01,
            6.655029999999999557e-01,
            6.647969999999999713e-01,
            6.639749999999999819e-01,
            6.633489999999999664e-01,
            6.625579999999999803e-01,
            6.618100000000000094e-01,
            6.610869999999999802e-01,
            6.601960000000000051e-01,
            6.592829999999999524e-01,
            6.584179999999999477e-01,
            6.575739999999999919e-01,
            6.567760000000000264e-01,
            6.558599999999999985e-01,
            6.550529999999999964e-01,
            6.541879999999999917e-01,
            6.532989999999999631e-01,
            6.524680000000000479e-01,
            6.515889999999999738e-01,
            6.505600000000000271e-01,
            6.495419999999999527e-01,
            6.486790000000000056e-01,
            6.477220000000000200e-01,
            6.468260000000000121e-01,
            6.458500000000000352e-01,
            6.449300000000000033e-01,
            6.440150000000000041e-01,
            6.430059999999999665e-01,
            6.420000000000000151e-01,
            6.410599999999999632e-01,
            6.400660000000000238e-01,
            6.390799999999999814e-01,
            6.380230000000000068e-01,
            6.370230000000000059e-01,
            6.360679999999999668e-01,
            6.351919999999999789e-01,
            6.341299999999999715e-01,
            6.331480000000000441e-01,
            6.321799999999999642e-01,
            6.312729999999999730e-01,
            6.301390000000000047e-01,
            6.291909999999999448e-01,
            6.281609999999999694e-01,
            6.270919999999999828e-01,
            6.260409999999999586e-01,
            6.251320000000000210e-01,
            6.241729999999999778e-01,
            6.232689999999999619e-01,
            6.223290000000000211e-01,
            6.213560000000000194e-01,
            6.204180000000000250e-01,
            6.195420000000000371e-01,
            6.186660000000000492e-01,
            6.177920000000000078e-01,
            6.168479999999999519e-01,
            6.159930000000000128e-01,
            6.149050000000000349e-01,
            6.140529999999999600e-01,
            6.131769999999999721e-01,
            6.123830000000000107e-01,
            6.115650000000000253e-01,
            6.107690000000000063e-01,
            6.099430000000000129e-01,
            6.090870000000000450e-01,
            6.082940000000000014e-01,
            6.076810000000000267e-01,
            6.068879999999999830e-01,
            6.060569999999999569e-01,
            6.052659999999999707e-01,
            6.044479999999999853e-01,
            6.036780000000000479e-01,
            6.029480000000000395e-01,
            6.021440000000000126e-01,
            6.015779999999999461e-01,
            6.004819999999999602e-01,
            5.995780000000000554e-01,
            5.988459999999999894e-01,
            5.980339999999999545e-01,
            5.971520000000000161e-01,
            5.962720000000000242e-01,
            5.957500000000000018e-01,
            5.946289999999999631e-01,
            5.937040000000000095e-01,
            5.928600000000000536e-01,
            5.918689999999999785e-01,
            5.909590000000000121e-01,
            5.900819999999999954e-01,
            5.891129999999999978e-01,
            5.882239999999999691e-01,
            5.872079999999999522e-01,
            5.862659999999999538e-01,
            5.853850000000000442e-01,
            5.843530000000000113e-01,
            5.834310000000000329e-01,
            5.826390000000000180e-01,
            5.815730000000000066e-01,
            5.805639999999999690e-01,
            5.798079999999999901e-01,
            5.786109999999999864e-01,
            5.776499999999999968e-01,
            5.768879999999999564e-01,
            5.762850000000000472e-01,
            5.750410000000000244e-01,
            5.740380000000000482e-01,
            5.731439999999999868e-01,
            5.720830000000000082e-01,
            5.709739999999999815e-01,
            5.700399999999999912e-01,
            5.691399999999999793e-01,
            5.681619999999999449e-01,
            5.671450000000000102e-01,
            5.660969999999999613e-01,
            5.649359999999999937e-01,
            5.639950000000000241e-01,
            5.630579999999999474e-01,
            5.623050000000000548e-01,
            5.613430000000000364e-01,
            5.605390000000000095e-01,
            5.591099999999999959e-01,
            5.583660000000000290e-01,
            5.573780000000000401e-01,
            5.564689999999999914e-01,
            5.556100000000000483e-01,
            5.548070000000000501e-01,
            5.538260000000000405e-01,
            5.528669999999999973e-01,
            5.520220000000000127e-01,
            5.510930000000000550e-01,
            5.501850000000000351e-01,
            5.491909999999999847e-01,
            5.483249999999999513e-01,
            5.469939999999999802e-01,
            5.471460000000000212e-01,
            5.457009999999999916e-01,
            5.448469999999999702e-01,
            5.439040000000000541e-01,
            5.431340000000000057e-01,
            5.422420000000000018e-01,
            5.413759999999999684e-01,
            5.405410000000000492e-01,
            5.396429999999999838e-01,
            5.386940000000000062e-01,
            5.378279999999999728e-01,
            5.369869999999999921e-01,
            5.361660000000000315e-01,
            5.353440000000000420e-01,
            5.344330000000000469e-01,
            5.334900000000000198e-01,
            5.325539999999999718e-01,
            5.316429999999999767e-01,
            5.309749999999999748e-01,
            5.300639999999999796e-01,
            5.292550000000000310e-01,
            5.283499999999999863e-01,
            5.275100000000000344e-01,
            5.265349999999999753e-01,
            5.260700000000000376e-01,
            5.247709999999999875e-01,
            5.238150000000000306e-01,
            5.228660000000000529e-01,
            5.220249999999999613e-01,
            5.210700000000000331e-01,
            5.201909999999999590e-01,
            5.192740000000000133e-01,
            5.182989999999999542e-01,
            5.173250000000000348e-01,
            5.163440000000000252e-01,
            5.154330000000000300e-01,
            5.144389999999999796e-01,
            5.134269999999999667e-01,
            5.125539999999999541e-01,
            5.114589999999999970e-01,
            5.104899999999999993e-01,
            5.094649999999999457e-01,
            5.085920000000000440e-01,
            5.076239999999999641e-01,
            5.066939999999999777e-01,
            5.057580000000000409e-01,
            5.047709999999999697e-01,
            5.038409999999999833e-01,
            5.029240000000000377e-01,
            5.020000000000000018e-01,
            5.011590000000000211e-01,
            5.001339999999999675e-01,
            4.992480000000000251e-01,
            4.983179999999999832e-01,
            4.975289999999999990e-01,
            4.963819999999999899e-01,
            4.954390000000000183e-01,
            4.944459999999999966e-01,
            4.937199999999999922e-01,
            4.928600000000000203e-01,
            4.919490000000000252e-01,
            4.910760000000000125e-01,
            4.901269999999999794e-01,
            4.892170000000000130e-01,
            4.883379999999999943e-01,
            4.874839999999999729e-01,
            4.865289999999999893e-01,
            4.856690000000000174e-01,
            4.848600000000000132e-01,
            4.840249999999999830e-01,
            4.830130000000000257e-01,
            4.821400000000000130e-01,
            4.813180000000000236e-01,
            4.804010000000000224e-01,
            4.796429999999999860e-01,
            4.786369999999999791e-01,
            4.776110000000000078e-01,
            4.769240000000000146e-01,
            4.761210000000000164e-01,
            4.753379999999999828e-01,
            4.744840000000000169e-01,
            4.735599999999999810e-01,
            4.727009999999999823e-01,
            4.718149999999999844e-01,
            4.709430000000000005e-01,
            4.699740000000000029e-01,
            4.690509999999999957e-01,
            4.681529999999999858e-01,
            4.673059999999999992e-01,
            4.667259999999999742e-01,
            4.653499999999999859e-01,
            4.646370000000000222e-01,
            4.636560000000000126e-01,
            4.627390000000000114e-01,
            4.617260000000000253e-01,
            4.608149999999999746e-01,
            4.598729999999999762e-01,
            4.589940000000000131e-01,
            4.579869999999999775e-01,
            4.570830000000000171e-01,
            4.561399999999999899e-01,
            4.552479999999999860e-01,
            4.543440000000000256e-01,
            4.534009999999999985e-01,
            4.523570000000000091e-01,
            4.513440000000000230e-01,
            4.503759999999999986e-01,
            4.494779999999999887e-01,
            4.485669999999999935e-01,
            4.475160000000000249e-01,
            4.465729999999999977e-01,
            4.456689999999999818e-01,
            4.447389999999999954e-01,
            4.437900000000000178e-01,
            4.428219999999999934e-01,
            4.419620000000000215e-01,
            4.410000000000000031e-01,
            4.401269999999999905e-01,
            4.392550000000000066e-01,
            4.382550000000000057e-01,
            4.376110000000000277e-01,
            4.366309999999999913e-01,
            4.356880000000000197e-01,
            4.347389999999999866e-01,
            4.338980000000000059e-01,
            4.329549999999999788e-01,
            4.319870000000000099e-01,
            4.310450000000000115e-01,
            4.302099999999999813e-01,
            4.292360000000000064e-01,
            4.282869999999999733e-01,
            4.274390000000000134e-01,
            4.265669999999999740e-01,
            4.256809999999999761e-01,
            4.248339999999999894e-01,
            4.237960000000000060e-01,
            4.228979999999999961e-01,
            4.219430000000000125e-01,
            4.210829999999999851e-01,
            4.204649999999999777e-01,
            4.193439999999999945e-01,
            4.183439999999999936e-01,
            4.174590000000000245e-01,
            4.165409999999999946e-01,
            4.158410000000000162e-01,
            4.149039999999999950e-01,
            4.140639999999999876e-01,
            4.132799999999999807e-01,
            4.122669999999999946e-01,
            4.112930000000000197e-01,
            4.103629999999999778e-01,
            4.094389999999999974e-01,
            4.084590000000000165e-01,
            4.075860000000000039e-01,
            4.068660000000000054e-01,
            4.058660000000000045e-01,
            4.049490000000000034e-01,
            4.041080000000000227e-01,
            4.032100000000000128e-01,
            4.022290000000000032e-01,
            4.013249999999999873e-01,
            4.004329999999999834e-01,
            3.992229999999999945e-01,
            3.987959999999999838e-01,
            3.977450000000000152e-01,
            3.967390000000000083e-01,
            3.958530000000000104e-01,
            3.948659999999999948e-01,
            3.938789999999999791e-01,
            3.929679999999999840e-01,
            3.925290000000000168e-01,
            3.914779999999999927e-01,
            3.903820000000000068e-01,
            3.894779999999999909e-01,
            3.885859999999999870e-01,
            3.876180000000000181e-01,
            3.866749999999999909e-01,
            3.858090000000000130e-01,
            3.847450000000000037e-01,
            3.835990000000000233e-01,
            3.829239999999999866e-01,
            3.820060000000000122e-01,
            3.811339999999999728e-01,
            3.801970000000000072e-01,
            3.791970000000000063e-01,
            3.782610000000000139e-01,
            3.773179999999999867e-01,
            3.763310000000000266e-01,
            3.753819999999999935e-01,
            3.745600000000000041e-01,
            3.736180000000000057e-01,
            3.726430000000000020e-01,
            3.714970000000000216e-01,
            3.704779999999999740e-01,
            3.695800000000000196e-01,
            3.686429999999999985e-01,
            3.676940000000000208e-01,
            3.667710000000000137e-01,
            3.658279999999999865e-01,
            3.648980000000000001e-01,
            3.638919999999999932e-01,
            3.629299999999999748e-01,
            3.625030000000000197e-01,
            3.609939999999999816e-01,
            3.601719999999999922e-01,
            3.591400000000000148e-01,
            3.582170000000000076e-01,
            3.573120000000000185e-01,
            3.563629999999999853e-01,
            3.554140000000000077e-01,
            3.545409999999999950e-01,
            3.536429999999999851e-01,
            3.527129999999999987e-01,
            3.518089999999999828e-01,
            3.509169999999999789e-01,
            3.500130000000000186e-01,
            3.491210000000000147e-01,
            3.482169999999999987e-01,
            3.473060000000000036e-01,
            3.463689999999999825e-01,
            3.454200000000000048e-01,
            3.445730000000000182e-01,
            3.436750000000000083e-01,
            3.426620000000000221e-01,
            3.417769999999999975e-01,
            3.408979999999999788e-01,
            3.399619999999999864e-01,
            3.389739999999999975e-01,
            3.379429999999999934e-01,
            3.370759999999999867e-01,
            3.361529999999999796e-01,
            3.353570000000000162e-01,
            3.344520000000000270e-01,
            3.335029999999999939e-01,
            3.325159999999999783e-01,
            3.316109999999999891e-01,
            3.308340000000000169e-01,
            3.298409999999999953e-01,
            3.290060000000000207e-01,
            3.280699999999999728e-01,
            3.271720000000000184e-01,
            3.263249999999999762e-01,
            3.254270000000000218e-01,
            3.245600000000000152e-01,
            3.235290000000000110e-01,
            3.225410000000000221e-01,
            3.216620000000000035e-01,
            3.207389999999999963e-01,
            3.197900000000000187e-01,
            3.188599999999999768e-01,
            3.178030000000000022e-01,
            3.168019999999999725e-01,
            3.159299999999999886e-01,
            3.149810000000000110e-01,
            3.140189999999999926e-01,
            3.131019999999999914e-01,
            3.122800000000000020e-01,
            3.112869999999999804e-01,
            3.103380000000000027e-01,
            3.094970000000000221e-01,
            3.085289999999999977e-01,
            3.076880000000000170e-01,
            3.067389999999999839e-01,
            3.056309999999999860e-01,
            3.046240000000000059e-01,
            3.037639999999999785e-01,
            3.027710000000000123e-01,
            3.018469999999999764e-01,
            3.009229999999999960e-01,
            3.000829999999999886e-01,
            2.991340000000000110e-01,
            2.982360000000000011e-01,
            2.973500000000000032e-01,
            2.964709999999999845e-01,
            2.954899999999999749e-01,
            2.943760000000000265e-01,
            2.937770000000000103e-01,
            2.928220000000000267e-01,
            2.919300000000000228e-01,
            2.910249999999999782e-01,
            2.900130000000000208e-01,
            2.892100000000000226e-01,
            2.883890000000000065e-01,
            2.873890000000000056e-01,
            2.865030000000000077e-01,
            2.855989999999999918e-01,
            2.846110000000000029e-01,
            2.835539999999999727e-01,
            2.825860000000000039e-01,
            2.816940000000000000e-01,
            2.807640000000000136e-01,
        ]
    )
    return energy, mu
