# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetLibraryPanelResult',
    'AwaitableGetLibraryPanelResult',
    'get_library_panel',
    'get_library_panel_output',
]

@pulumi.output_type
class GetLibraryPanelResult:
    """
    A collection of values returned by getLibraryPanel.
    """
    def __init__(__self__, created=None, dashboard_ids=None, description=None, folder_id=None, folder_name=None, folder_uid=None, id=None, model_json=None, name=None, org_id=None, panel_id=None, type=None, uid=None, updated=None, version=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if dashboard_ids and not isinstance(dashboard_ids, list):
            raise TypeError("Expected argument 'dashboard_ids' to be a list")
        pulumi.set(__self__, "dashboard_ids", dashboard_ids)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, int):
            raise TypeError("Expected argument 'folder_id' to be a int")
        pulumi.set(__self__, "folder_id", folder_id)
        if folder_name and not isinstance(folder_name, str):
            raise TypeError("Expected argument 'folder_name' to be a str")
        pulumi.set(__self__, "folder_name", folder_name)
        if folder_uid and not isinstance(folder_uid, str):
            raise TypeError("Expected argument 'folder_uid' to be a str")
        pulumi.set(__self__, "folder_uid", folder_uid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_json and not isinstance(model_json, str):
            raise TypeError("Expected argument 'model_json' to be a str")
        pulumi.set(__self__, "model_json", model_json)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, int):
            raise TypeError("Expected argument 'org_id' to be a int")
        pulumi.set(__self__, "org_id", org_id)
        if panel_id and not isinstance(panel_id, int):
            raise TypeError("Expected argument 'panel_id' to be a int")
        pulumi.set(__self__, "panel_id", panel_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        Timestamp when the library panel was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="dashboardIds")
    def dashboard_ids(self) -> Sequence[int]:
        """
        Numerical IDs of Grafana dashboards containing the library panel.
        """
        return pulumi.get(self, "dashboard_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the library panel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> int:
        """
        ID of the folder where the library panel is stored.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="folderName")
    def folder_name(self) -> str:
        """
        Name of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_name")

    @property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> str:
        """
        Unique ID (UID) of the folder containing the library panel.
        """
        return pulumi.get(self, "folder_uid")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> str:
        """
        The JSON model for the library panel.
        """
        return pulumi.get(self, "model_json")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the library panel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> int:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="panelId")
    def panel_id(self) -> int:
        """
        The numeric ID of the library panel computed by Grafana.
        """
        return pulumi.get(self, "panel_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the library panel (eg. text).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        The unique identifier (UID) of the library panel.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        Timestamp when the library panel was last modified.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        Version of the library panel.
        """
        return pulumi.get(self, "version")


class AwaitableGetLibraryPanelResult(GetLibraryPanelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLibraryPanelResult(
            created=self.created,
            dashboard_ids=self.dashboard_ids,
            description=self.description,
            folder_id=self.folder_id,
            folder_name=self.folder_name,
            folder_uid=self.folder_uid,
            id=self.id,
            model_json=self.model_json,
            name=self.name,
            org_id=self.org_id,
            panel_id=self.panel_id,
            type=self.type,
            uid=self.uid,
            updated=self.updated,
            version=self.version)


def get_library_panel(name: Optional[str] = None,
                      uid: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLibraryPanelResult:
    """
    Data source for retrieving a single library panel by name or uid.


    :param str name: Name of the library panel.
    :param str uid: The unique identifier (UID) of the library panel.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['uid'] = uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getLibraryPanel:getLibraryPanel', __args__, opts=opts, typ=GetLibraryPanelResult).value

    return AwaitableGetLibraryPanelResult(
        created=__ret__.created,
        dashboard_ids=__ret__.dashboard_ids,
        description=__ret__.description,
        folder_id=__ret__.folder_id,
        folder_name=__ret__.folder_name,
        folder_uid=__ret__.folder_uid,
        id=__ret__.id,
        model_json=__ret__.model_json,
        name=__ret__.name,
        org_id=__ret__.org_id,
        panel_id=__ret__.panel_id,
        type=__ret__.type,
        uid=__ret__.uid,
        updated=__ret__.updated,
        version=__ret__.version)


@_utilities.lift_output_func(get_library_panel)
def get_library_panel_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                             uid: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLibraryPanelResult]:
    """
    Data source for retrieving a single library panel by name or uid.


    :param str name: Name of the library panel.
    :param str uid: The unique identifier (UID) of the library panel.
    """
    ...
