# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from setuptools import setup, find_packages  # noqa: H301

NAME = "cythereal-magic"
VERSION = "1.20.0"
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = [
    "certifi>=2017.4.17",
    "python-dateutil>=2.1",
    "six>=1.10",
    "urllib3>=1.23"
]
    

setup(
    name=NAME,
    version=VERSION,
    description="Cythereal MAGIC API",
    author_email="support@cythereal.com",
    url="",
    keywords=["Swagger", "Cythereal MAGIC API"],
    install_requires=REQUIRES,
    packages=find_packages(),
    include_package_data=True,
    long_description="""\
     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: &#x60;ff9790d7902fea4c910b182f6e0b00221a40d616&#x60;   * Can be used for &#x60;file_hash&#x60; parameters. * Procedure RVA: &#x60;0x1000&#x60;   * Use with the above SHA1 for &#x60;proc_rva&#x60; parameters.   # API Conventions  Properties MUST be named using &#x60;snake_case&#x60;.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type &#x60;APIResponse&#x60; and contain the following fields:  * &#x60;api_version&#x60; |  The current api version * &#x60;success&#x60; | Boolean value indicating if the operation succeeded. * &#x60;code&#x60; | Status code. Typically corresponds to the HTTP status code.  * &#x60;message&#x60; | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a &#x60;SuccessResponse&#x60;, which extends &#x60;APIResponse&#x60; by adding:  * &#x60;data&#x60; | Properties containing the response object. * &#x60;success&#x60; | MUST equal True  When returning objects from a successful response, the &#x60;data&#x60; object SHOULD contain a property named after the requested object type. For example, the &#x60;/matches&#x60; endpoint should return a response object with &#x60;data.matches&#x60;. This property SHOULD  contain a list of the returned objects. For the &#x60;/matches&#x60; endpoint, the &#x60;data.matches&#x60; property contains a list of MagicMatch objects. See the &#x60;/matches&#x60; endpoint documentation for an example.  **Failed Operations** MUST return an &#x60;ErrorResponse&#x60;, which extends &#x60;APIResponse&#x60; by adding:  * &#x60;errors&#x60; | Array of error objects. An error object contains the following properties:     * &#x60;ErrorObject.reason&#x60; | Unique identifier for this error. Example: \&quot;FileNotFoundError\&quot;.     * &#x60;ErrorObject.message&#x60;| Human readable error message. * &#x60;success&#x60; | MUST equal False.   # noqa: E501
    """
)
