# 06 - Exporting An Overlay & IDA Pro Plugin

This tutorial explains how to use zelos to export instruction overlays and import them into IDA Pro using the zelos IDA plugin.

## Overview

The Overlay Plugin provides the ability to export runtime information from zelos, which can include:
  * Contents of all memory regions
  * Instruction-level comments & runtime values for all executed instructions
  * Function information for all executed functions

These overlays are intended to be used for integrating the results of zelos emulation into other tools. To demonstrate this using the zelos IDA plugin, described below, overlays can be imported into IDA Pro to improve static analysis by highlighting the runtime behavior of the emulated binary. The IDA plugin will recolor the IDA graph view to show the execution paths observed during zelos dynamic analysis, as well as annotate traced instructions with their corresponding runtime values. This is helpful for honing in on the most important areas of an executable during static analysis.

![Image](https://raw.githubusercontent.com/zeropointdynamics/zelos/master/docs/_static/plugin_active.png)

### Using the IDA Plugin

First, we are going to use zelos to emulate an executable and generate an overlay with comments. The executable that we are emulating is a basic "hello world", statically-compiled, ELF binary which can be found in the repo [here](https://github.com/zeropointdynamics/zelos/blob/master/tests/data/static_elf_helloworld).

```console
python -m zelos static_elf_helloworld --export_insts -vv --fasttrace
```

After generating an overlay (with comments), go ahead and open `static_elf_helloworld` in IDA Pro for disassembly. Wait for IDA to load the executable and the finish the initial autoanalysis. Once this completes, assuming you installed the zelos IDA plugin correctly, you should be able to see a View menu option that says "Load Zelos Overlay...". Click on this, and when prompted, navigate to and select the `static_elf_helloworld.zmu` overlay file that we generated above.

![Image](https://raw.githubusercontent.com/zeropointdynamics/zelos/master/docs/_static/plugin_select.png)

After a moment, you will notice that the IDA View has been updated. The yellow highlighting indicates an operation that has been emulated in zelos, and the updated comment string at each address describes the value of the emulated operands.

### Getting the IDA Plugin

After generating an overlay with instruction-level comments, it can be imported into IDA Pro using the zelos IDA plugin (which you can get [here](https://raw.githubusercontent.com/zeropointdynamics/zelos/master/src/zelos/ext/plugins/overlay/zelos_ida.py)).

#### Installing the IDA Plugin

The plugin source can be viewed and manually downloaded from [here](https://raw.githubusercontent.com/zeropointdynamics/zelos/master/src/zelos/ext/plugins/overlay/zelos_ida.py). To install, save this file into your IDA Pro install location's `plugins/` directory. On windows, this will typically be something like `C:\Program Files\IDA 7.0\plugins\`. On linux, this will typically be `<ida_install_dir>/plugins/`.

If you would instead prefer a script, if you are using windows, __modify the following powershell command for your IDA install location__:

```console
wget "https://raw.githubusercontent.com/zeropointdynamics/zelos/master/src/zelos/ext/plugins/overlay/zelos_ida.py" -outfile "C:\Program Files\IDA 7.0\plugins\zelos_ida.py"
```

If you are using linux, __modify the following bash command for your IDA install location__:

```console
wget https://raw.githubusercontent.com/zeropointdynamics/zelos/master/src/zelos/ext/plugins/overlay/zelos_ida.py -O <ida_install_dir>/plugins/zelos_ida.py
```

## Creating Instruction Overlays

Instruction overlays can be created using zelos from either the command line or in a script.

### Command Line Use

An instruction overlay can be generated by using the `--export_insts` flag on the command line in addition to the flag `-vv` to enable _verbose_ mode. The following command will emulate the executable `my_binary` normally, and upon completion will write an overlay to the file `my_binary.zmu`.

```console
$ zelos my_binary --export_insts -vv
```

For an additional speedup, the `--fasttrace` flag can be included in addition to `-vv`, which restricts verbose comment generation to only the first time an address is executed.

```console
$ zelos my_binary --export_insts -vv --fasttrace
```

### Script Use

An overlay can also be generated when using zelos as a library in scripts by interacting with the `overlay` plugin directly. The following shows an example of creating an overlay dynamically in a script.

```python
# Generating an overlay by invoking the overlay
# plugin directly.
from zelos import Zelos

z = Zelos(
    "/path/to/my_binary",
    verbosity=1, # include instruction-level comments
    fasttrace=True,
    export_insts=True,
)
z.start()

# After emulation finishes

# Open a new file for creating an overlay
with open("overlay.zmu", "w") as f:
    # Export an overlay
    z.plugins.overlay.export(f)
```
