from __future__ import annotations

from pathlib import Path

import numpy as np
from numpy.typing import NDArray

_PKG_NAME: str = Path(__file__).parent.stem

VERSION = "2024.739097.4"

__version__ = VERSION

DATA_DIR: Path = Path.home() / _PKG_NAME
"""
Defines a subdirectory named for this package in the user's home path.

If the subdirectory doesn't exist, it is created on package invocation.
"""
if not DATA_DIR.is_dir():
    DATA_DIR.mkdir(parents=False)

np.set_printoptions(precision=24, floatmode="fixed")

type ArrayBoolean = NDArray[np.bool_]
type ArrayFloat = NDArray[np.half | np.single | np.double]
type ArrayINT = NDArray[np.intp]

type ArrayDouble = NDArray[np.double]
type ArrayBIGINT = NDArray[np.int64]
