# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['random_data_gen', 'random_data_gen.features']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.22.1,<2.0.0', 'pandas>=1.4.0,<2.0.0']

setup_kwargs = {
    'name': 'random-data-gen',
    'version': '0.1.3',
    'description': 'Package to generate random transactional data',
    'long_description': '# RandomDataGen - Random Data Generator Package\n\n<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n[![Checked with mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n[![Downloads](https://pepy.tech/badge/random-data-gen)](https://pepy.tech/project/random-data-gen)\n\nThis is a package to generate random transactional data. You can use this package to study Pandas operations or clustering methods like RFM.\n\nWith this package you can create a table with transactional data containing:\n\n- consumer_id: ID identifying the customer that does the transaction;\n- transaction_created_at: Date of transaction;\n- transaction_payment_value: Monetary value of transaction.\n\nAll the fields are customizable.\n\n## How the data is generated\n\nThe *consumer_id* field is generated by a range function, returning a sequence of integers from 1 to *n_consumers*:\n\n``` python\nconsumer_ids = range(1, n_consumers + 1)\n```\n\nThe *transaction_created_at* field is generated by a Pandas function called date_range. You can view more about this functions in this [link](https://pandas.pydata.org/docs/reference/api/pandas.date_range.html):\n\n``` python\ncreated_at_list = list(pd.date_range(start=first_transaction_date, end=last_transaction_date, periods=n_rows)\n```\n\nThe *transaction_payment_value* is sample from a normal distribution with mean equals the mean_spend parameter and the stardand deviation  equals the std_spend parameter:\n\n``` python\nlist(np.random.normal(transaction_mean_value, transaction_std_value, n_rows))\n```\n\n## How to use\n\nYou can start the use of RandomDataGen with this example code:\n\n``` python\nfrom random_data_gen.data_generator import TransactionalDataGenerator\n\nTRGenerator = TransactionalDataGenerator(\n    n_rows=1000,\n    n_consumers=100,\n    transaction_mean_value=100,\n    transaction_std_value=10,\n    first_transaction_date="2020-01-01",\n    last_transaction_date="2021-01-01",\n)\n\ndf = TRGenerator()\n```\n\nIn this snippet we defined a dataframe with 1000 rows, 100 unique users, a mean spend in transactions of 100u.m., a standard deviation in transactional spend of 10u.m., the first transaction date (2020-01-01) and the last transaction date (2021-01-01).\n\nThe dataframe returned is in the form:\n\n```\n| consumer_id |     transaction_created_at    | transaction_payment_value |\n|:-----------:|:-----------------------------:|:-------------------------:|\n|     234     | 2020-01-01 00:00:00.000000000 |           120.10          |\n|      43     | 2020-01-01 08:47:34.054054054 |           87.10           |\n|     321     | 2021-10-23 10:27:12.092356134 |           12.98           |\n|     3123    | 2020-12-30 21:37:17.837837840 |           12.84           |\n```\n\nThe shape of this dataframe is defined by the parameter *n_rows*.\n\n## Contribute\n\nTo contribute you need to install [Poetry](https://python-poetry.org/).\n\nAfter installing, you need to clone this repo and run the following command:\n\n```\npoetry install -n\n```\n\nBefore sending the code to the repo, you need to run:\n\n```\nmake format\n```\n\nTo apply the project style to the new code.\n\nAnd after that, run:\n\n```\nmake check\n```\n\nThis command will check your code with flake8 and pytest.\n\n',
    'author': 'Felipe Sassi',
    'author_email': 'felipesassi@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/felipesassi/random-data-gen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
