# coding: utf-8

"""
    STACKL

    stackl  # noqa: E501

    The version of the OpenAPI document: 0.2.3dev
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from stackl_client.api_client import ApiClient
from stackl_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class InfrastructureBaseApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_infrastructure_base(self, infrastructure_base_type, infrastructure_base_name, **kwargs):  # noqa: E501
        """Delete Infrastructure Base  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_infrastructure_base(infrastructure_base_type, infrastructure_base_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param str infrastructure_base_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_infrastructure_base_with_http_info(infrastructure_base_type, infrastructure_base_name, **kwargs)  # noqa: E501

    def delete_infrastructure_base_with_http_info(self, infrastructure_base_type, infrastructure_base_name, **kwargs):  # noqa: E501
        """Delete Infrastructure Base  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_infrastructure_base_with_http_info(infrastructure_base_type, infrastructure_base_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param str infrastructure_base_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'infrastructure_base_type',
            'infrastructure_base_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_infrastructure_base" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'infrastructure_base_type' is set
        if self.api_client.client_side_validation and ('infrastructure_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_type` when calling `delete_infrastructure_base`")  # noqa: E501
        # verify the required parameter 'infrastructure_base_name' is set
        if self.api_client.client_side_validation and ('infrastructure_base_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_name` when calling `delete_infrastructure_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infrastructure_base_type' in local_var_params:
            path_params['infrastructure_base_type'] = local_var_params['infrastructure_base_type']  # noqa: E501
        if 'infrastructure_base_name' in local_var_params:
            path_params['infrastructure_base_name'] = local_var_params['infrastructure_base_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_infrastructure_base_by_type(self, infrastructure_base_type, **kwargs):  # noqa: E501
        """Get Infrastructure Base By Type  # noqa: E501

        Returns a specific infrastructure_base document with a type and name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infrastructure_base_by_type(infrastructure_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InfrastructureBaseDocument]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_infrastructure_base_by_type_with_http_info(infrastructure_base_type, **kwargs)  # noqa: E501

    def get_infrastructure_base_by_type_with_http_info(self, infrastructure_base_type, **kwargs):  # noqa: E501
        """Get Infrastructure Base By Type  # noqa: E501

        Returns a specific infrastructure_base document with a type and name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infrastructure_base_by_type_with_http_info(infrastructure_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InfrastructureBaseDocument], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'infrastructure_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_infrastructure_base_by_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'infrastructure_base_type' is set
        if self.api_client.client_side_validation and ('infrastructure_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_type` when calling `get_infrastructure_base_by_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infrastructure_base_type' in local_var_params:
            path_params['infrastructure_base_type'] = local_var_params['infrastructure_base_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/infrastructure_base/{infrastructure_base_type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InfrastructureBaseDocument]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_infrastructure_base_by_type_and_name(self, infrastructure_base_type, infrastructure_base_name, **kwargs):  # noqa: E501
        """Get Infrastructure Base By Type And Name  # noqa: E501

        Returns a specific infrastructure_base document with a type and name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infrastructure_base_by_type_and_name(infrastructure_base_type, infrastructure_base_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param str infrastructure_base_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InfrastructureBaseDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_infrastructure_base_by_type_and_name_with_http_info(infrastructure_base_type, infrastructure_base_name, **kwargs)  # noqa: E501

    def get_infrastructure_base_by_type_and_name_with_http_info(self, infrastructure_base_type, infrastructure_base_name, **kwargs):  # noqa: E501
        """Get Infrastructure Base By Type And Name  # noqa: E501

        Returns a specific infrastructure_base document with a type and name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infrastructure_base_by_type_and_name_with_http_info(infrastructure_base_type, infrastructure_base_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str infrastructure_base_type: (required)
        :param str infrastructure_base_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InfrastructureBaseDocument, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'infrastructure_base_type',
            'infrastructure_base_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_infrastructure_base_by_type_and_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'infrastructure_base_type' is set
        if self.api_client.client_side_validation and ('infrastructure_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_type` when calling `get_infrastructure_base_by_type_and_name`")  # noqa: E501
        # verify the required parameter 'infrastructure_base_name' is set
        if self.api_client.client_side_validation and ('infrastructure_base_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_name` when calling `get_infrastructure_base_by_type_and_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infrastructure_base_type' in local_var_params:
            path_params['infrastructure_base_type'] = local_var_params['infrastructure_base_type']  # noqa: E501
        if 'infrastructure_base_name' in local_var_params:
            path_params['infrastructure_base_name'] = local_var_params['infrastructure_base_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/infrastructure_base/{infrastructure_base_type}/{infrastructure_base_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfrastructureBaseDocument',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_infrastructure_base(self, infrastructure_base_document, **kwargs):  # noqa: E501
        """Post Infrastructure Base  # noqa: E501

        Create the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_infrastructure_base(infrastructure_base_document, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InfrastructureBaseDocument infrastructure_base_document: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InfrastructureBaseDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_infrastructure_base_with_http_info(infrastructure_base_document, **kwargs)  # noqa: E501

    def post_infrastructure_base_with_http_info(self, infrastructure_base_document, **kwargs):  # noqa: E501
        """Post Infrastructure Base  # noqa: E501

        Create the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_infrastructure_base_with_http_info(infrastructure_base_document, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InfrastructureBaseDocument infrastructure_base_document: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InfrastructureBaseDocument, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'infrastructure_base_document'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_infrastructure_base" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'infrastructure_base_document' is set
        if self.api_client.client_side_validation and ('infrastructure_base_document' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_document'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_document` when calling `post_infrastructure_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'infrastructure_base_document' in local_var_params:
            body_params = local_var_params['infrastructure_base_document']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/infrastructure_base', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfrastructureBaseDocument',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_infrastructure_base(self, infrastructure_base_document, **kwargs):  # noqa: E501
        """Put Infrastructure Base  # noqa: E501

        UPDATES the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_infrastructure_base(infrastructure_base_document, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InfrastructureBaseDocument infrastructure_base_document: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InfrastructureBaseDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_infrastructure_base_with_http_info(infrastructure_base_document, **kwargs)  # noqa: E501

    def put_infrastructure_base_with_http_info(self, infrastructure_base_document, **kwargs):  # noqa: E501
        """Put Infrastructure Base  # noqa: E501

        UPDATES the infrastructure_base document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_infrastructure_base_with_http_info(infrastructure_base_document, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InfrastructureBaseDocument infrastructure_base_document: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InfrastructureBaseDocument, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'infrastructure_base_document'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_infrastructure_base" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'infrastructure_base_document' is set
        if self.api_client.client_side_validation and ('infrastructure_base_document' not in local_var_params or  # noqa: E501
                                                        local_var_params['infrastructure_base_document'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `infrastructure_base_document` when calling `put_infrastructure_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'infrastructure_base_document' in local_var_params:
            body_params = local_var_params['infrastructure_base_document']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/infrastructure_base', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfrastructureBaseDocument',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
