"use strict";
// Use pipeline as CloudWAtch event target
Object.defineProperty(exports, "__esModule", { value: true });
const codebuild = require("@aws-cdk/aws-codebuild");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-pipeline-event-target');
const pipeline = new codepipeline.Pipeline(stack, 'MyPipeline');
const repository = new codecommit.Repository(stack, 'CodeCommitRepo', {
    repositoryName: 'foo',
});
const project = new codebuild.PipelineProject(stack, 'BuildProject', {
    grantReportGroupPermissions: false,
});
const sourceOutput = new codepipeline.Artifact('Source');
const sourceAction = new cpactions.CodeCommitSourceAction({
    actionName: 'CodeCommitSource',
    output: sourceOutput,
    repository,
    trigger: cpactions.CodeCommitTrigger.POLL,
});
const sourceStage = pipeline.addStage({
    stageName: 'Source',
    actions: [sourceAction],
});
pipeline.addStage({
    stageName: 'Build',
    actions: [
        new cpactions.CodeBuildAction({
            actionName: 'CodeBuildAction',
            input: sourceOutput,
            project,
            outputs: [new codepipeline.Artifact()],
        }),
    ],
});
const topic = new sns.Topic(stack, 'MyTopic');
const eventPipeline = events.EventField.fromPath('$.detail.pipeline');
const eventState = events.EventField.fromPath('$.detail.state');
pipeline.onStateChange('OnPipelineStateChange', {
    target: new targets.SnsTopic(topic, {
        message: events.RuleTargetInput.fromText(`Pipeline ${eventPipeline} changed state to ${eventState}`),
    }),
});
sourceStage.onStateChange('OnSourceStateChange', new targets.SnsTopic(topic));
sourceAction.onStateChange('OnActionStateChange', new targets.SnsTopic(topic)).addEventPattern({
    detail: { state: ['STARTED'] },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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