"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            },
        });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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