# moai-project-config-manager

## Overview

The `moai-project-config-manager` skill provides comprehensive configuration management for MoAI projects, handling all `.moai/config.json` CRUD operations with robust validation, error handling, and intelligent merge strategies.

## Key Features

- **Complete CRUD Operations**: Create, Read, Update, Delete configuration sections
- **Validation Engine**: Pre-save validation for all configuration changes
- **Merge Strategy**: Preserve unmodified sections while updating selected ones
- **Error Recovery**: Handle missing files, invalid JSON, permission issues
- **Batch Updates**: Handle multiple setting changes in single operation
- **Backup & Restore**: Automatic backup before major changes
- **Interactive Workflows**: User-friendly setting modification with TUI surveys

## Quick Start

```python
# Interactive configuration management
Skill("moai-project-config-manager")

# Programmatic update
Skill("moai-project-config-manager", action="update", changes={
    "language": {
        "conversation_language": "en",
        "conversation_language_name": "English"
    }
})

# Validate configuration
Skill("moai-project-config-manager", action="validate")
```

## Configuration Sections Managed

1. **Language Settings**: Conversation language and agent prompt language
2. **User Settings**: User nickname and preferences
3. **GitHub Settings**: Auto-delete branches and SPEC git workflow
4. **Report Generation**: Enable/Minimal/Disable with token optimization
5. **Project Domains**: Multi-select domain configuration

## Files

- `SKILL.md` - Main skill documentation and workflow guide
- `reference.md` - Complete API reference and schema documentation
- `examples.md` - Comprehensive usage examples and integration patterns
- `validate.py` - Skill structure validation script

## Integration

This skill integrates seamlessly with Alfred commands:
- `/alfred:0-project` - Project initialization and setting updates
- `/alfred:1-plan` - Configuration-aware planning
- `/alfred:2-run` - Configuration-guided execution
- `/alfred:3-sync` - Configuration synchronization

## Validation

Run the included validation script to verify skill structure:

```bash
python3 validate.py
```

## Size and Complexity

- **Total Documentation**: ~62KB (vs 600+ lines of original command)
- **Structured Approach**: Modular, reusable, maintainable
- **Comprehensive Coverage**: All configuration management workflows
- **Error Handling**: Robust error recovery and validation
- **Performance**: Optimized for fast operations and minimal resource usage

## Benefits

1. **Reduced Complexity**: Extracted 600+ line command into focused skill
2. **Reusability**: Can be used across different Alfred commands
3. **Maintainability**: Clear separation of concerns and documentation
4. **Reliability**: Comprehensive validation and error handling
5. **User Experience**: Interactive workflows with clear feedback

---

**Generated by**: skill-factory agent  
**Created**: 2025-11-05  
**Version**: 1.0.0  
**Status**: Production Ready
