_robot_images = {
  "gray" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAA1NTVZWVn//wCAgICsrKzAwMD////XBGfUxJj////UxJPXZEgLBoIBC/EAAICp+MAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBC/Gp+MAAAIDUhLLUhr4BC/EAADkS6CTY57ILBoIBC/ELBoKp+MAAABgAAALaFogAABUS6HzXOZWp+NALBoK1WqAS6GAS6QG2L+RFNyALBoIAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADBLUQAAAES6SDUhzQRBWIABAEAAADBLUTLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADBLUR/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBC/EAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAALBoIAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAABePXMrAAAACHRSTlP/////////AN6DvVkAAACXSURBVHjaxZLhCoQwDIOzbl7f/41vSdsx0RP8dWNg+YhtUoU7LmeySVuzsc5xfAzEzTYqnnicjjDuMF7iH70f8L3BU5yRcRhz03Mgw1+X4rEThLb3kMseWr7ddTXTKLWixUfERGpTXxNQHeLCF96bCNONra6dTrx8WzUE/SWmXM9ZhfhPGGlQVSxQOJaFyKVPmer6IVf1BbCqCS9jk1GTAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAzMzNbW1v/AACAgICkpKTAwMD////XBGfUxJj////UxJPXZEgQCQABCJgAAICpsbAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCJipsbAAAIDUhLLUhr4BCJgAADkS6CTY57IQCQABCJgQCQCpsbAAABgAAALaFogAABUS6HzXOZWpscAQCQC1WqAS6GAS6QG2L+RFNyAQCQAAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC7q7gAAAES6SDUhzQMCQgABAEAAAC7q7jLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQXAywAAAEWIhgWIjgABAAWYDgAAADUtik94ZEMCQgS6fAAAAAWYDg94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gMCQgABAEAAAC7q7h/uXwAAAEAAAAAAAAAAAAAAACKACEABADV8+N/uWh/mfgAAAAAAAQAAaYAAAIABAAAABMWIjgBEtkAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAUj8qSAGByAGKwj8rAAc0YS6sA97BsWYDgAAAAWIbgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQXAywAAAEAAAAWYDgWIbgXAwES6pTUwr8S6sQ90ZMXAyw95ZgWYDjUiKYAAAAAAAIAAMgAABMWIcAS6uzUhzQMCQgAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n98AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAQCQAAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAAAQ6+rlAAAACHRSTlP/////////AN6DvVkAAAB9SURBVHjardBBDsAgCATABaX8/8dFjBWVHpqUk5kAAlBVbMFGTYm4jhC5mBWlLOqOzlHNN2bIw9Z7ZiNlTpmRZ4cv37h8Yk23zG7ifFwQfsEWVtB2hDfWwLVzlY2tOOV+qiQbJ9PcJfAy3sP+HKn/cv/rZIrTbSx5kzG0xQ39dAqxz8DMUwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAA3NzdbW1v/AAD//wCAgICjo6PAwMD///8S8uhyd1MAAAABELAAADYAAAAAAFAAABkAAAGFBoMAAAkAADYAAAAAAFAAABkAAAAAAAAAABQAABcAAAkAAAQAAAQAAAQAAATxogDxoeQBELAAADkAAAMAABMAABMBDy0AAAAAACYFESAAAAAAACaqAAD///8V5iAV5hgS9XC1WqAS85wBEAG2L+RFNyAAABMAABMBDy1PyjgS9CC1WqC1VShP0RYAAABPyji1WqAS9CC1RBxP7jMAAAIBELAAADkAAAMAABMAABMV5iAS9BhBx0G1DExCx4VCx43LD8i1DGxFM5sS9BhFM7JFM7oS9LRFM8QS9BgS9JjLD8jLD8i1WqAS9DBCWLYABAEAAADA+CAAAAES9FzUhzQRBWIABAEAAADA+CDLD8i6q80AAAAS9JgS9HTUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS9SwAAAAWX8g94ZwAAAAAAAAABAAAABMS9RAS9TjXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADA+CB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCrEAAAAAAAAAAAAAAAAAAAAAAAAAAAAS8HSAFjwAAAUAAAXcCFSAGByAGKzcCGAArugS9fw97BsWX8gAAAAWIUgAAAQAAAAS9mQ95ZgAAADXIloAAAAS9bzUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES9dDUwr8S9gA90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS9ijUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS9mQ95ZgS9pDUi9n94AAS9pDUiFoS9lDUiCoAAA895ZgS+WgAABQAAAEAAAAAAAAAABAAAAAAAFAAAAEAAAAAAAAS9kTxbGQS+TjXBGfUiDD////UiCoAAAAAAAAJXRdjAAAACXRSTlP//////////wBTT3gSAAAAnklEQVR42sWSSxLEIAhEW0TD/U88fKMp3Q+L2HlFoMFABEcoE7RGY4v5EBzT6D2ZifkE1pfkLhzjhpvjo4jFt2NiueFoeccUvXp23vA5jnrc+Zwx/LkU8Z18s4dmN4c0eFHWMlTT8KLvmFjcjuqAAvGAbNhQfOLY3IQT5nQi5ZuqIMZEYUv3U1Uk/wkjDboyg7HvvB7kXHZnmV0/5Kt+x38Kzw6IUBEAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAzMzNbW1v/AACAgICkpKTAwMD///8AAAAS8uhyd1MAAAABD3UAADYAAAAAAFAAABkAAAGFBJ4AAAkAADYAAAAAAFAAABkAAAAAAAAAABQAABcAAAkAAAQAAAQAAAQAAATxogDxoeQBD3UAADkAAAMAABMAABMBDusAAAAAACYFDpQAAAAAACaqAAD///8V5iAV5hgS9XC1WqAS85wBDwG2L+RFNyAAABMAABMBDutPyjgS9CC1WqC1VShP0RYAAABPyji1WqAS9CC1RBxP7jMAAAIBD3UAADkAAAMAABMAABMV5iAS9BhBx0G1DExCx4VCx43LD8i1DGxFM5sS9BhFM7JFM7oS9LRFM8QS9BgS9JjLD8jLD8i1WqAS9DBCWLYABAEAAAC6Z1AAAAES9FzUhzRTBRAABAEAAAC6Z1DLD8i6q80AAAAS9JgS9HTUtqPUhPzUhaQDBRoAAAEWIagWIcgABAAWX8gAAADUtik94ZFTBRAS9SwAAAAWX8g94ZwAAAAAAAAABAAAABMS9RAS9TjXBGfUiDD////UiCrUuJsAAADLD8hTBRAABAEAAAC6Z1B+cqwAAAEAAAAAAAAAAAAAAACKACEABADV8+N+cph+8XAAAAAAAAQAAaYAAAIABAAAABMWIcgBCJ4AAAAAAAAAAAAAAAAAAAAAAAAAAAAS8HSAFjwAAAUAAAVI2FSAGByAGKxI2GAAb1oS9fw97BsWX8gAAAAWIUgAAAQAAAAS9mQ95ZgAAADXIloAAAAS9bzUtqPUhPzUhaQDBRoAAAEAAAAWX8gWIUgDBQES9dDUwr8S9gA90ZMDBRo95ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS9ijUhzRTBRAAAA8AAAAAAAA95Zi6q80AAAAS9mQ95ZgS9pDUi9n90AAS9pDUiFoS9lDUiCoAAA895ZgS+WgAABQAAAEAAAAAAAAAABAAAAAAAFAAAAEAAAAAAAAS9kTxbGQS+TjXBGfUiDD////UiCoAAAAAAADKTwNHAAAACHRSTlP/////////AN6DvVkAAAB6SURBVHjardCLCsAgCAXQO7P8/z+eyVxWEgzmKNghfEEES5CoqV5E7FFbIzKOao5SjJknj0yoGbt2fnKfOCQJHEt+43Lkdcp8J8bbBmEb7Jemh35cq/07axJjzhjIuJ+dsb/2iZaSc3fO3qO88T+PmpF5TB+YMp4bvwEGcAqR53QgIgAAAABJRU5ErkJggg==",  ],
  "blue" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAACMbHUdAQm5qbZX//wCZmsausdr////XBGfUxJj////UxJPXZEgdBeQBCsMAAICpXoAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCsOpXoAAAIDUhLLUhr4BCsMAADkS6CTY57IdBeQBCsMdBeSpXoAAABgAAALaFogAABUS6HzXOZWpXpAdBeS1WqAS6GAS6QG2L+RFNyAdBeQAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC9VJgAAAES6SDUhzQRBWIABAEAAAC9VJjLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC9VJh/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCsMAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAdBeQAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAACMAACNcr9aKAAAACHRSTlP/////////AN6DvVkAAACXSURBVHjaxZLhCoQwDIOzbl7f/41vSdsx0RP8dWNg+YhtUoU7LmeySVuzvs5xfAzEzTYqnrifjjDuMF7iH70f8L3BU5yecRhz03Mgw1+X4rEThHaMkMseWr49dDXTKLWixXvERGpTXxNQHeLCF96bCNONra6DTrx8WzUE/SWmXM9ZhfhPGGlQVSxQOJaFyKVPmer6IVf1BTTtCE84csDNAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAACgWGERGSHJtbpn/AACVlr+ys9/////XBGfUxJj////UxJPXZEgNBggBC/EAAICpyvgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBC/GpyvgAAIDUhLLUhr4BC/EAADkS6CTY57INBggBC/ENBgipyvgAABgAAALaFogAABUS6HzXOZWpywgNBgi1WqAS6GAS6QG2L+RFNyANBggAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC9jkAAAAES6SDUhzQRBWIABAEAAAC9jkDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC9jkB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBC/EAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAANBggAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAACgAACiJue8kAAAACHRSTlP/////////AN6DvVkAAAB9SURBVHjardBBDsAgCATABaX8/8dFjBWVHpqUk5kAAlBVbMFGTYm4jBC5mBW1LuqOzlHNN2bIw9Z7ZiNlTpmRZ4cv37h+Yk23zG7ifFwQfsEWVtB2hDfWwKVzkY2tOOV+qiQbJ9PcJfAy3sP+HKn/cv/rZIrTbSx5kzG0xQ3CdAn6/PCEzQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAACMcHkhERnJqbZX/AAD//wCQkb2usdr////UxJj////UxJPXZEgqBVgBCaoAAICprGAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCaqprGAAAIDUhLLUhr4BCaoAADkS6CTY57IqBVgBCaoqBViprGAAABgAAALaFogAABUS6HzXOZWprHAqBVi1WqAS6GAS6QG2L+RFNyAqBVgAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC810AAAAES6SDUhzQRBWIABAEAAAC810DLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC810B/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCaoAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAqBVgAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAACMAACNBU5ZGAAAACXRSTlP//////////wBTT3gSAAAAnklEQVR42sWSSxLEIAhEW1DD/U88fKMp3Q+L2HlFoMFABEcoE7RGvMV8CI6Je09mYj6B9SW5C8e44eb4KGLx7ZhYbjha3jFFr56dN3yOox53PmcMfy5FfCffbNbs5pB4LDq0DNU0Y9F3TCxuR3VAgXhANmwoPnFsbsLJGOlEyjdVQfBEYUv3U1Uk/wkjDboyg7HvvB7kXHZnmV0/5Kt+SqMJOP/C1HgAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAACUCBC46PWlpapP/AACIibX///8S6MjXBGfUxJj////UxJPXZEgdBYYBC8IAAICpkXAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBC8KpkXAAAIDUhLLUhr4BC8IAADkS6CTY57IdBYYBC8IdBYapkXAAABgAAALaFogAABUS6HzXOZWpkYAdBYa1WqAS6GAS6QG2L+RFNyAdBYYAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC6kHwAAAES6SDUhzQRBWIABAEAAAC6kHzLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC6kHx/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBC8IAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAdBYYAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAACUAACXp3SOvAAAAB3RSTlP///////8AGksDRgAAAHlJREFUeNqt0IsKwCAIBdCrlf//yUs3l5UEgzkKdghfEMESJN1UidijtEZ0c1Bz1GrMPHlkQsnYVfnJfeKQJHAs+Y3rkdcp850YbxuEbVCvnh7941Ls37knMeaMgYz17Iz9tU+0lJy7c/Ye5Y3/edSMzGP6wJTy1PgF6dUHud5WP/kAAAAASUVORK5CYII=",  ],
  "green" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAFgAVQhU7ZztkjmT//wCQvpCl06X////XBGfUxJj////UxJPXZEgQBgABDFwAAICpmGgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBDFypmGgAAIDUhLLUhr4BDFwAADkS6CTY57IQBgABDFwQBgCpmGgAABgAAALaFogAABUS6HzXOZWpmHgQBgC1WqAS6GAS6QG2L+RFNyAQBgAAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC+wvQAAAES6SDUhzQRBWIABAEAAAC+wvTLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC+wvR/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBDFwAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAQBgAAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAFgAAFgDgzxyHAAAACHRSTlP/////////AN6DvVkAAACXSURBVHjaxZLhCoQwDIOzbl7f/41vSdsx0RP8dWNg+YhtUoU7LmeySVuzvs5xfAzEzTYqnrifjjDuMF7iH70f8L3BU5yecRhz03Mgw1+X4rEThHaMkMseWr49dDXTKLWixXvERGpTXxNQHeLCF96bCNONra6DTrx8WzUE/SWmXM9ZhfhPGGlQVSxQOJaFyKVPmer6IVf1BTTtCE84csDNAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAHgARPhE/bD9mkGb/AACLuYup1an////XBGfUxJj////UxJPXZEgkBYIBDMoAAICpoVgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBDMqpoVgAAIDUhLLUhr4BDMoAADkS6CTY57IkBYIBDMokBYKpoVgAABgAAALaFogAABUS6HzXOZWpoWgkBYK1WqAS6GAS6QG2L+RFNyAkBYIAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC+TAQAAAES6SDUhzQRBWIABAEAAAC+TATLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC+TAR/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBDMoAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAkBYIAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAHgAAHgDUCIb6AAAACHRSTlP/////////AN6DvVkAAAB9SURBVHjardBBDsAgCATABaX8/8dFjBWVHpqUk5kAAlBVbMFGTYm4jBC5mBW1LuqOzlHNN2bIw9Z7ZiNlTpmRZ4cv37h+Yk23zG7ifFwQfsEWVtB2hDfWwKVzkY2tOOV+qiQbJ9PcJfAy3sP+HKn/cv/rZIrTbSx5kzG0xQ3CdAn6/PCEzQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAFgAXQxc8azxkjmT/AAD//wCJs4ml06X////UxJj////UxJPXZEgNBgwBCuIAAICpnOAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCuKpnOAAAIDUhLLUhr4BCuIAADkS6CTY57INBgwBCuINBgypnOAAABgAAALaFogAABUS6HzXOZWpnPANBgy1WqAS6GAS6QG2L+RFNyANBgwAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC+y1gAAAES6SDUhzQRBWIABAEAAAC+y1jLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC+y1h/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCuIAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAANBgwAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAFgAAFgB+RvKCAAAACXRSTlP//////////wBTT3gSAAAAnklEQVR42sWSSxLEIAhEW1DD/U88fKMp3Q+L2HlFoMFABEcoE7RGvMV8CI6Je09mYj6B9SW5C8e44eb4KGLx7ZhYbjha3jFFr56dN3yOox53PmcMfy5FfCffbNbs5pB4LDq0DNU0Y9F3TCxuR3VAgXhANmwoPnFsbsLJGOlEyjdVQfBEYUv3U1Uk/wkjDboyg7HvvB7kXHZnmV0/5Kt+SqMJOP/C1HgAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAGgAAKAA0YTRhjWF/rX//AAD///8S6MjXBGfUxJj////UxJPXZEgMBhIBCrEAAICpvvAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCrGpvvAAAIDUhLLUhr4BCrEAADkS6CTY57IMBhIBCrEMBhKpvvAAABgAAALaFogAABUS6HzXOZWpvwAMBhK1WqAS6GAS6QG2L+RFNyAMBhIAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC9lTQAAAES6SDUhzQRBWIABAEAAAC9lTTLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC9lTR/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCrEAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAMBhIAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAGgAAGgCKN+QpAAAAB3RSTlP///////8AGksDRgAAAHlJREFUeNqt0IsKwCAIBdCrlf//yTM3l5UEgzkKdghfEMESJGpdidij1Ep0c1BztGbMPHlkQsnYtfOT+8QhSeBY8hu3I69T5jsx3jYI22C/ND3041Ls31mTGHPGQMb97Iz9tU+0lJy7c/Ye5Y3/edSMzGP6wJTy1PgF2VMHsLrJY5kAAAAASUVORK5CYII=",  ],
  "light_blue" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAACggIHhsWOjVfqaH/AACQ7uK////I///////////UxJPXZEghBfoBCpwAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCpw8CTgAAIDUhLLUhr4BCpwAADkS6CTY57IhBfoBCpwhBfo8CTgAABgAAALaFogAABUS6HzXOZU8CUghBfq1WqAS6GAS6QG2L+RFNyAhBfoAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADACtAAAAES6SDUhzQRBWIABAEAAADACtDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADACtB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCpwAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAhBfoAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAAAgZlkZAAAACnRSTlP///////////8AsswszwAAAJ1JREFUeNrFklkOhDAMQ820KeT+F546m+iw/E5VQfUwjhOAKi5rsklb66PWvh8fELd+osYDj2UZxh3Gj7Pjhif1g/cLvg+4FmVFZaOLngXZ/HUo6jOBa0VcbvGwxdti22qynfCVuozBfuaj0IY+KyAdfEMLn00MM00vV2ESzdw9DcF8gSm3+zy5+E8YEdBOPkDDPix4X/YpQ50/ZJ2+ESANEMn5E+sAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAIHh0WOjVfqaH/AACQ7uK////I///////UxJj////UxJPXZEgtBWYBC8IAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBC8I8CTgAAIDUhLLUhr4BC8IAADkS6CTY57ItBWYBC8ItBWY8CTgAABgAAALaFogAABUS6HzXOZU8CUgtBWa1WqAS6GAS6QG2L+RFNyAtBWYAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC/mJAAAAES6SDUhzQRBWIABAEAAAC/mJDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC/mJB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBC8IAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAtBWYAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAADuz5NzAAAACXRSTlP//////////wBTT3gSAAAAd0lEQVR42q3QSQ7AIAgAQApK+f+LiyVaRDyYlJOZIBuICMRQaopItQfzrQ6lTGpu7FU9MME1WGuPbIIDJsizXcsdlyOWdMvNTbYXbNE+6DLwFhbHZFw5sH5OWfvl2bAyfrs4nsYb/D576r9svVZGP11gzov0oTUeiGEMnes12xEAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAACwkIHh0WOjVfqaH/AACQ7uK////I///////////UxJPXZEguBdYBCMsAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCMs8CTgAAIDUhLLUhr4BCMsAADkS6CTY57IuBdYBCMsuBdY8CTgAABgAAALaFogAABUS6HzXOZU8CUguBda1WqAS6GAS6QG2L+RFNyAuBdYAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADAEpAAAAES6SDUhzQRBWIABAEAAADAEpDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADAEpB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCMsAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAuBdYAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAAD5iCX+AAAACnRSTlP///////////8AsswszwAAAKBJREFUeNrFkkkWwyAMQ5UCdnz/C9cjkOF1Wy+C8p8DkglE8ChlgtYabcXnB4H7GMlM8BlYX5K7cIw3fDim+yZWrRNdzzQzb1h+41G14/4SRz3umDnCP4ciPpNrN2n34bDTWFRTcqs0Y9EZE4vbUiegQDwgGzYUnzg2N31Oz51I+e61IYhR2Np9VRXNf8JIg67MYMw7LxOZy+4su+uHnOoL3NgM+NZhtQcAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAAACAgFGRU2hXtn49L/AACh//+u///////UxJj////UxJPXZEg0BcABCpoAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCpo8CTgAAIDUhLLUhr4BCpoAADkS6CTY57I0BcABCpo0BcA8CTgAABgAAALaFogAABUS6HzXOZU8CUg0BcC1WqAS6GAS6QG2L+RFNyA0BcAAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADB5WwAAAES6SDUhzQRBWIABAEAAADB5WzLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADB5Wx/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCpoAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAA0BcAAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAADgUEUUAAAACXRSTlP//////////wBTT3gSAAAAfElEQVR42q3QSQ7AIAgFUKgT9z9xkRZFISZNysLFi/kMQARbIbGxXillrdoaorBVcShFOOfFLSPUiFU7v9knNiGGbctvXI68bxnfRNhdEOSC/eF44IWeABrMIcI1Yl404H4Xz+B/60Zby3U6ZZ2RRv3Ps6dlGdFxingd/AaZSgv6pVvhUAAAAABJRU5ErkJggg==",  ],
  "purple" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEURAAJLHjtwQ1+Xa4f//wDFl7XYrMr////XBGfUxJj////UxJPXZEgpBZQBCMsAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCMs8CTgAAIDUhLLUhr4BCMsAADkS6CTY57IpBZQBCMspBZQ8CTgAABgAAALaFogAABUS6HzXOZU8CUgpBZS1WqAS6GAS6QG2L+RFNyApBZQAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADAWqAAAAES6SDUhzQRBWIABAEAAADAWqDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADAWqB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCMsAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAApBZQAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoRAAIRAAJWkx99AAAACHRSTlP/////////AN6DvVkAAACXSURBVHjaxZLhCoQwDIOzbl7f/41vSdsx0RP8dWNg+YhtUoU7LmeySVuzvs5xfAzEzTYqnrifjjDuMF7iH70f8L3BU5yecRhz03Mgw1+X4rEThHaMkMseWr49dDXTKLWixXvERGpTXxNQHeLCF96bCNONra6DTrx8WzUE/SWmXM9ZhfhPGGlQVSxQOJaFyKVPmer6IVf1BTTtCE84csDNAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEURAAJIGjlxRWL/AACXa4e8j6vYrMr////XBGfUxJj////UxJPXZEgKBnwBCaoAAICp79AAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCaqp79AAAIDUhLLUhr4BCaoAADkS6CTY57IKBnwBCaoKBnyp79AAABgAAALaFogAABUS6HzXOZWp7+AKBny1WqAS6GAS6QG2L+RFNyAKBnwAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADBiwAAAAES6SDUhzQRBWIABAEAAADBiwDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADBiwB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCaoAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAKBnwAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoRAAIRAAIpItfNAAAACHRSTlP/////////AN6DvVkAAAB9SURBVHjardBBDsAgCATABaX8/8dFjBWVHpqUk5kAAlBVbMFGTYm4jhC5mBWlLOqOzlHNN2bIw9Z7ZiNlTpmRZ4cv37h8Yk23zG7ifFwQfsEWVtB2hDfWwLVzlY2tOOV+qiQbJ9PcJfAy3sP+HKn/cv/rZIrTbSx5kzG0xQ39dAqxz8DMUwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEURAAJNIDxxRWL/AACXa4f//wC7jqrYrMr////UxJj////UxJPXZEgYBZYBCpwAAICp61gAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCpyp61gAAIDUhLLUhr4BCpwAADkS6CTY57IYBZYBCpwYBZap61gAABgAAALaFogAABUS6HzXOZWp62gYBZa1WqAS6GAS6QG2L+RFNyAYBZYAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADBiuwAAAES6SDUhzQRBWIABAEAAADBiuzLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADBiux/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCpwAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAYBZYAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoRAAIRAAKVOkYIAAAACXRSTlP//////////wBTT3gSAAAAnklEQVR42sWSSxLEIAhEW0TD/U88fKMp3Q+L2HlFoMFABEcoE7RGvMV8CI6Je09mYj6B9SW5C8e44eb4KGLx7ZhYbjha3jFFr56dN3yOox53PmcMfy5FfCffbNbs5pB4LDq0DNU0Y9F3TCxuR3VAgXhANmwoPnFsbsLJGOlEyjdVQfBEYUv3U1Uk/wkjDboyg7HvvB7kXHZnmV0/5Kt+a7kJ+cUredMAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEURAAJIGjlxRWL/AACXa4e8j6vYrMr////XBGfUxJj////UxJPXZEgfBbgBCpwAAIA8CTgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCpw8CTgAAIDUhLLUhr4BCpwAADkS6CTY57IfBbgBCpwfBbg8CTgAABgAAALaFogAABUS6HzXOZU8CUgfBbi1WqAS6GAS6QG2L+RFNyAfBbgAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADB5pAAAAES6SDUhzQRBWIABAEAAADB5pDLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADB5pB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCpwAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAfBbgAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoRAAIRAAK3In3PAAAACHRSTlP/////////AN6DvVkAAAB4SURBVHjardBBDsAgCARAiij//3FBi6JS00NJ9DAhKwjMsBaLiV6IZJVLURf22jylykSTe0bIEYPrfrIr55hdiGOKQz5wOvK65eFPXn5QL4kH3bMGcGekxhQxQMR6doa92zZanpynM7YZudf/PN70TGN7xxjxPPgN+sEKkg2MzBYAAAAASUVORK5CYII=",  ],
  "yellow" : [ "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAA1NTVZWVmAAACAgEDd3QD//wD//7n//9/////////UxJPXZEg/BcABC54AAICpXoAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBC56pXoAAAIDUhLLUhr4BC54AADkS6CTY57I/BcABC54/BcCpXoAAABgAAALaFogAABUS6HzXOZWpXpA/BcC1WqAS6GAS6QG2L+RFNyA/BcAAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADACOAAAAES6SDUhzQRBWIABAEAAADACODLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADACOB/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBC54AAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAA/BcAAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAADUVPSFAAAACnRSTlP///////////8AsswszwAAAJ1JREFUeNrFklkOhDAMQ82kLeT+F546m+iw/E5VQfUwjhOAKi5rsklb66PWvh8fELd+osYDj2UZxh3Gj7Pjhif1g/cLvg+4FmVFZaOLngXZ/HUo6jOBa0VcbvGwxdti22qynfCVuozBfuaj0IY+KyAdfEMLn00MM00vV2ESzdw9DcF8gSm3+zy5+E8YEdBOPkDDPix4X/YpQ50/ZJ2+M+wNHGvcgAEAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAABbW1v/AACAgEDd3QD//wD//7n//9/////UxJj////UxJPXZEgdBeYBCgMAAICpsYAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCgOpsYAAAIDUhLLUhr4BCgMAADkS6CTY57IdBeYBCgMdBeapsYAAABgAAALaFogAABUS6HzXOZWpsZAdBea1WqAS6GAS6QG2L+RFNyAdBeYAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAADAAAwAAAES6SDUhzQRBWIABAEAAADAAAzLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAADAAAx/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCgMAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAdBeYAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAAAd4/SfAAAACXRSTlP//////////wBTT3gSAAAAd0lEQVR42q3QSQ7AIAgAQCpI+f+LiyVaRDyYlJOZIBuICMRQaopItQfzrQ6lTGpu7FU9MME1WGuPbIIDJsizXcsdlyOWdMvNTbYXbNE+6DLwFhbHZFw5sH5OWfvl2bAyfrs4nsYb/D576r9svVZGP11gzov0oTUevOkMweuql6MAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAAA3NzdbW1sAAP//AACAgEDd3QD//wD//7n//9/////UxJPXZEgiBdgBCpwAAICprGAAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCpyprGAAAIDUhLLUhr4BCpwAADkS6CTY57IiBdgBCpwiBdiprGAAABgAAALaFogAABUS6HzXOZWprHAiBdi1WqAS6GAS6QG2L+RFNyAiBdgAAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC+7vgAAAES6SDUhzQRBWIABAEAAAC+7vjLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC+7vh/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCpwAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAiBdgAAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAACaAEpEAAAAC3RSTlP/////////////AEpPAfIAAAChSURBVHjaxZJJFoQgDETLZgjm/gfujILK621nAeV/MVQCYMYrhDFaa7TEOD9w3GsNpmKcjuUjuAnD2OHDMD2LaLROdD9Tzeww/8Y1Y8V90454XPEY3vx7KGwzuWeTZB8GO5VJi5Rp2U2Z9GoTk+uWJyCBL+AFK/JfDKsbd1JKOOH03bMgaCCxptsuypP/hBEGTalBn3dcJqIvvbPIzgd5qS8HLg6mYkMgDQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAeCAMAAAAfOR5kAAAACXBIWXMAAA7EAAAOxAGVKw4bAAADAFBMVEUAAABbW1v/AACAgEDd3QD//wD//7n//9/////UxJj////UxJPXZEgUBf4BCocAAICpyvgAACQAAAGhoaIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5+jxWDYBCoepyvgAAIDUhLLUhr4BCocAADkS6CTY57IUBf4BCocUBf6pyvgAABgAAALaFogAABUS6HzXOZWpywgUBf61WqAS6GAS6QG2L+RFNyAUBf4AAIAAAAFPyjgS6OS1WqC1VShP0RYAAABPyji1WqAS6OS1RBxP7jPXNnrY5zIAAAAAAAEAAAAAAADUi9kS6NxBx0G1DExCx4VCx43LD8i1DGxFM5sS6NxFM7JFM7oS6XhFM8QS6NwS6VzLD8jLD8i1WqAS6PRCWLYABAEAAAC+UswAAAES6SDUhzQRBWIABAEAAAC+UszLD8i6q80AAAAS6VwS6TjUtqPUhPzUhaQlBV4AAAEWIagWIcgABAAWX8gAAADUtik94ZERBWIS6fAAAAAWX8g94ZwAAAAAAAAABAAAABMAAAAS6fzXBGfUiDD////UiCrUuJsAAADLD8gRBWIABAEAAAC+Usx/zwQAAAEAAAAAAAAAAAAAAACKACEABADV8+N/zvB/a8gAAAAAAAQAAaYAAAIABAAAABMWIcgBCocAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5TiAFjwAAAUAAAXcAqSAGByAGKzcArAArugS6sA97BsWX8gAAAAWIUgAAAQAAAAS6yg95ZgAAAAS6ojUhzQS6oDUtqPUhPzUhaQlBV4AAAEAAAAWX8gWIUglBQES6pTUwr8S6sQ90ZMlBV495ZgWX8jUiKYAAAAAAAIAAMgAABMWIVAS6uzUhzQRBWIAAA8AAAAAAAA95Zi6q80AAAAS6yg95ZgS61TUi9n94AAS61TUiFoS6xTUiCoAAA895ZgS7iwAABQAAAEAAAAAAAAAABAAAAAUBf4AAAEAAAAAAAAS6wjxbGQS7fzXBGfUiDD////UiCoAAAAAAACiBv84AAAACXRSTlP//////////wBTT3gSAAAAfElEQVR42q3QSQ7AIAgFULAO3P/ERVoUhZg0KQsXL+YzABFshcTGeuVctGpriMJWxSEl4VIWt4xQI1bt/Gaf2IQYti2/cTryvmV8E2F3QZAL9ofjgRd6AmgwhwjXiHnRgPtdPIP/rRttLdfplHVGGvU/z56WZUTHOeJ18BvzgwzNnf4n3QAAAABJRU5ErkJggg==",  ], }
