"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceTarget = exports.InstanceIdTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * (experimental) An EC2 instance that is the target for load balancing.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 *
 * @experimental
 */
class InstanceIdTarget {
    /**
     * (experimental) Create a new Instance target.
     *
     * @param instanceId Instance ID of the instance to register to.
     * @param port Override the default port for the target group.
     * @experimental
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * (experimental) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @experimental
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * (experimental) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @experimental
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
_a = JSII_RTTI_SYMBOL_1;
InstanceIdTarget[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.InstanceIdTarget", version: "1.90.1" };
/**
 * @experimental
 */
class InstanceTarget extends InstanceIdTarget {
    /**
     * (experimental) Create a new Instance target.
     *
     * @param instance Instance to register to.
     * @param port Override the default port for the target group.
     * @experimental
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
_b = JSII_RTTI_SYMBOL_1;
InstanceTarget[_b] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.InstanceTarget", version: "1.90.1" };
//# sourceMappingURL=data:application/json;base64,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