"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderBase = void 0;
const core_1 = require("@aws-cdk/core");
const attr_names_1 = require("../../private/attr-names");
/**
 * Options to integrate with the various social identity providers.
 *
 * @internal
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    /**
     * @stability stable
     */
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
exports.UserPoolIdentityProviderBase = UserPoolIdentityProviderBase;
//# sourceMappingURL=data:application/json;base64,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