import { Construct } from 'constructs';
import { UserPoolIdentityProviderProps } from './base';
import { UserPoolIdentityProviderBase } from './private/user-pool-idp-base';
/**
 * Properties to initialize UserPoolAmazonIdentityProvider.
 *
 * @stability stable
 */
export interface UserPoolIdentityProviderAmazonProps extends UserPoolIdentityProviderProps {
    /**
     * The client id recognized by 'Login with Amazon' APIs.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @stability stable
     */
    readonly clientId: string;
    /**
     * The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * The types of user profile data to obtain for the Amazon profile.
     *
     * @default [ profile ]
     * @see https://developer.amazon.com/docs/login-with-amazon/customer-profile.html
     * @stability stable
     */
    readonly scopes?: string[];
}
/**
 * Represents a identity provider that integrates with 'Login with Amazon'.
 *
 * @stability stable
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderAmazon extends UserPoolIdentityProviderBase {
    /**
     * The primary identifier of this identity provider.
     *
     * @stability stable
     */
    readonly providerName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderAmazonProps);
}
