/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { ILabShell, ILayoutRestorer } from '@jupyterlab/application';
import { IDocumentManager } from '@jupyterlab/docmanager';
import { Token } from "@lumino/coreutils";
import { ReactWidget, IThemeManager } from '@jupyterlab/apputils';
import { INotebookTracker } from '@jupyterlab/notebook';
import { OptumiLeftPanel } from './components/LeftPanel';
import { Global } from './Global';
import { OptumiMetadataTracker } from './models/OptumiMetadataTracker';
export const IOptumi = new Token("optumi:IOptumi");
const id = "optumi";
// ***NOTE*** If you change this version number, make sure you also change it in the package.json file
export const version = "2.2.0";
export default {
    activate,
    id,
    requires: [ILabShell, ILayoutRestorer, INotebookTracker, IThemeManager, IDocumentManager],
    provides: IOptumi,
    autoStart: true
};
async function activate(lab, labShell, restorer, tracker, manager, docManager) {
    let widget;
    console.log('JupyterLab extension jupyterlab-optumi version ' + version + ' is activated!');
    async function loadPanel() {
        // add widget
        if (!widget.isAttached) {
            labShell.add(widget, "left", { rank: 1000 });
        }
    }
    // Creates the left side bar widget once the app has fully started
    lab.started.then(() => {
        document.documentElement.style.setProperty('--jp-sidebar-min-width', '300px');
        Global.lab = lab;
        Global.labShell = labShell;
        Global.themeManager = manager;
        Global.tracker = tracker;
        Global.metadata = new OptumiMetadataTracker(Global.tracker);
        Global.docManager = docManager;
        Global.updateMachines();
        docManager.services.contents.getDownloadUrl("Agreement.html").then((url) => Global.agreementURL = url);
        widget = ReactWidget.create(React.createElement(OptumiLeftPanel, null));
        widget.id = 'optumi/Optumi';
        widget.title.iconClass = 'jp-o-logo jp-SideBar-tabIcon';
        widget.title.caption = 'Optumi';
        restorer.add(widget, widget.id);
    });
    // Initialize once the application shell has been restored
    lab.restored.then(() => {
        loadPanel();
    });
    return { widget };
}
