/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
export default class LogScaleUtils {
    constructor(min, max, step, logBase, ignoreLabel) {
        // Externally we will represent with the same number of decimals as in 'step'
        this.scale = (x) => this.round(x ** this.logBase, this.countDecimals(this.step));
        // Internally we will represent with 5 decimal places. This can be increased if necessary	
        this.unscale = (x) => this.round(x ** (1 / this.logBase), 5);
        this.min = min;
        this.max = max;
        this.step = step;
        this.logBase = logBase;
        this.marks = this.generateMarks(ignoreLabel);
    }
    getMarks() {
        return this.marks;
    }
    getScale() {
        return this.scale;
    }
    getUnscale() {
        return this.unscale;
    }
    countDecimals(value) {
        if (Math.floor(value) === value)
            return 0;
        return value.toString().split(".")[1].length || 0;
    }
    isWhole(value) {
        const ret = value % 1 == 0;
        return ret;
    }
    round(value, precision) {
        var multiplier = Math.pow(10, precision || 0);
        return Math.round(value * multiplier) / multiplier;
    }
    generateMarks(ignoreLabel) {
        const marks = [];
        const roundDigits = this.countDecimals(this.step);
        var i = this.min;
        while (i <= this.max) {
            if (this.isWhole(i) && !ignoreLabel) {
                marks.push({
                    value: this.round(i ** (1 / this.logBase), 5),
                    label: "$" + i.toFixed(0),
                });
            }
            else {
                marks.push({
                    value: this.round(i ** (1 / this.logBase), 5),
                });
            }
            i += this.step;
            i = this.round(i, roundDigits);
        }
        return marks;
    }
}
