/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import OverlayTrigger from 'react-bootstrap/OverlayTrigger';
import Popover from 'react-bootstrap/Popover';
import * as React from 'react';
import { Global } from '../Global';
import { withStyles } from '@material-ui/core';
const REMOVE_EXTRA_INFO_CAUSE_ISSUE = false;
// Include the bootstrap styles once
if (!REMOVE_EXTRA_INFO_CAUSE_ISSUE)
    document.body.innerHTML += `<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous" />`;
export function ExtraInfo(props) {
    const _a = Object.assign({
        // Defaults
        reminder: '',
        overview: '',
        documentation: '',
    }, props), { 
    // Props
    children, reminder, overview, documentation, onMouseOver, onMouseOut } = _a, other = __rest(_a, ["children", "reminder", "overview", "documentation", "onMouseOver", "onMouseOut"]);
    // To make this feel more familiar
    React.useEffect(() => { componentDidMount(); return componentWillUnmount; }, []);
    const [, reRender] = React.useReducer(x => x + 1, 0);
    const forceUpdate = () => reRender();
    const componentDidMount = () => {
        Global.onInQuestionModeChange.connect(forceUpdate);
    };
    const componentWillUnmount = () => {
        Global.onInQuestionModeChange.disconnect(forceUpdate);
    };
    const handleMouseOver = (triggerHandler, ...args) => {
        if (reminder !== undefined || (Global.inQuestionMode && overview !== undefined))
            triggerHandler.onFocus(args);
        if (onMouseOver)
            return onMouseOver(args);
    };
    const handleMouseOut = (triggerHandler, ...args) => {
        if (reminder !== undefined || (Global.inQuestionMode && overview !== undefined))
            triggerHandler.onBlur(args);
        if (onMouseOut)
            return onMouseOut(args);
    };
    const StyledPopover = withStyles({
        '@global': {
            '#styled-popover *': {
                color: `var(--jp-ui-font-color1)`,
            },
            '#styled-popover:not(:last-of-type) *': {
                display: 'none',
            },
            '#styled-popover': {
                zIndex: `1300`,
            },
            '#styled-popover .popover-header': {
                backgroundColor: `var(--jp-layout-color2)`,
                fontWeight: Global.inQuestionMode && 'bold',
                fontSize: !Global.inQuestionMode && '14px',
                padding: !Global.inQuestionMode && '3px 6px',
            },
            '#styled-popover .popover-body': {
                backgroundColor: `var(--jp-layout-color1)`,
            },
            '#styled-popover .arrow::after': {
                borderRightColor: Global.inQuestionMode && `var(--jp-layout-color1)`,
                borderTopColor: !Global.inQuestionMode && `var(--jp-layout-color2)`,
            },
        }
    })(Popover);
    return REMOVE_EXTRA_INFO_CAUSE_ISSUE ? children : ( // Render
    React.createElement(OverlayTrigger, { delay: { show: Global.inQuestionMode ? 10 : 500, hide: 10 }, trigger: ['hover', 'click', 'focus'], placement: Global.inQuestionMode ? 'right' : 'top', overlay: Global.inQuestionMode ? (React.createElement(StyledPopover, { id: 'styled-popover' },
            reminder && (React.createElement(Popover.Title, { as: 'h3' }, reminder)),
            overview && (React.createElement(Popover.Content, null, overview)))) : (React.createElement(StyledPopover, { id: 'styled-popover' }, reminder && (React.createElement(Popover.Title, { as: 'h3' }, reminder)))) }, (_a) => {
        var { ref } = _a, triggerHandler = __rest(_a, ["ref"]);
        // If you can't see triggerHandler.onBlur(args), expose it in OverlayInjectedProps in node_modules/react-bootstrap/esm/OverlayTrigger.d.ts
        triggerHandler.onFocus; // If does not exist, instructions on line above
        triggerHandler.onBlur; // If does not exist, instructions on line above
        return React.cloneElement(children, Object.assign({
            ref: ref,
            onMouseOver: (...args) => handleMouseOver(triggerHandler, args),
            onMouseOut: (...args) => handleMouseOut(triggerHandler, args),
        }, Object.assign({}, other)));
    }));
}
