/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Dialog, DialogContent, IconButton, Tab, Tabs, withStyles } from '@material-ui/core';
import * as React from 'react';
import { Global } from '../../Global';
import { Machine, NoMachine } from './Machine';
import PopupIcon from '@material-ui/icons/MoreVert';
import MuiDialogTitle from '@material-ui/core/DialogTitle';
import { ShadowedDivider } from '../../core';
import CloseIcon from '@material-ui/icons/Close';
import { MachineCapability } from './MachineCapabilities';
import FormatUtils from '../../utils/FormatUtils';
const StyledDialog = withStyles({
    paper: {
        width: '80%',
        height: '80%',
        overflowY: 'visible',
        backgroundColor: 'var(--jp-layout-color1)',
        maxWidth: 'inherit',
    },
})(Dialog);
// TODO:Beck The popup needs to be abstracted out, there is too much going on to reproduce it in more than one file
export class PopupMachineComponent extends React.Component {
    constructor(props) {
        super(props);
        this.handleClickOpen = () => {
            if (this.props.onOpen)
                this.props.onOpen();
            this.setState({ open: true });
        };
        this.handleClose = () => {
            this.setState({ open: false });
            if (this.props.onClose)
                this.props.onClose();
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('PopupMachineRender (' + new Date().getSeconds() + ')');
            const machine = this.props.machine;
            return (React.createElement(React.Fragment, null,
                React.createElement(IconButton, { disabled: machine instanceof NoMachine, onClick: this.handleClickOpen, style: {
                        display: 'inline-block',
                        width: '36px',
                        height: '36px',
                        padding: '3px',
                    } },
                    React.createElement(PopupIcon, { style: {
                            width: '30px',
                            height: '30px',
                            padding: '3px',
                        } })),
                React.createElement(StyledDialog, { open: this.state.open, onClose: this.handleClose, scroll: 'paper' },
                    React.createElement(MuiDialogTitle, { disableTypography: true, style: {
                            display: 'inline-flex',
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px',
                            borderRadius: '4px',
                        } },
                        React.createElement("div", { style: {
                                display: 'inline-flex',
                                minWidth: '150px',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                paddingRight: '12px',
                            } },
                            React.createElement("div", { style: { margin: 'auto' } }, "Machine")),
                        React.createElement("div", { style: {
                                width: '100%',
                                display: 'inline-flex',
                                fontSize: '16px',
                                fontWeight: 'bold',
                                padding: '10px',
                            } }),
                        React.createElement(IconButton, { onClick: this.handleClose, style: {
                                display: 'inline-block',
                                width: '36px',
                                height: '36px',
                                padding: '3px',
                            } },
                            React.createElement(CloseIcon, { style: {
                                    width: '30px',
                                    height: '30px',
                                    padding: '3px',
                                } }))),
                    React.createElement(ShadowedDivider, null),
                    React.createElement("div", { style: { display: 'flex', height: 'calc(100% - 48px - 2px' } },
                        React.createElement("div", { style: { width: '150px' } },
                            React.createElement(DialogContent, { style: { padding: '0px' } },
                                React.createElement("div", { style: { padding: '6px' } },
                                    React.createElement(Tabs, { value: this.state.selectedPanel, onChange: (event, newValue) => this.setState({ selectedPanel: newValue }), orientation: 'vertical', variant: 'fullWidth', indicatorColor: 'primary', textColor: 'primary', style: { minHeight: '24px' } },
                                        React.createElement(Tab, { label: 'CAPABILITY', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        React.createElement(Tab, { label: 'STATUS', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }),
                                        React.createElement(Tab, { label: 'COST', style: {
                                                padding: '0px',
                                                minWidth: 'auto',
                                                minHeight: '36px',
                                            } }))))),
                        React.createElement(ShadowedDivider, { orientation: 'vertical' }),
                        React.createElement("div", { style: { display: 'flex', flexFlow: 'column', overflow: 'hidden', width: 'calc(100% - 150px)', height: '100%' } },
                            React.createElement(DialogContent, { style: { padding: '0px', flexGrow: 1, overflowY: 'auto' } }, this.state.selectedPanel == 0 /* CAPABILITY */ ? (React.createElement(MachineCapability, { machine: machine })) : this.state.selectedPanel == 1 /* STATUS */ ? (React.createElement("div", { style: { margin: '6px' } }, Machine.getStateMessage(this.props.machine.state) == '' ? 'Machine currently has no status' : 'Machine is currently ' + Machine.getStateMessage(this.props.machine.state).toLowerCase())) : this.state.selectedPanel == 2 /* COST */ && (React.createElement("div", { style: { margin: '6px' } },
                                "Machine costs ",
                                FormatUtils.styleRateUnitValue()(machine.rate)))))))));
        };
        this.state = {
            open: false,
            selectedPanel: 0 /* CAPABILITY */,
        };
    }
}
