/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Divider } from '@material-ui/core';
import * as React from 'react';
import { Header, Label } from '../../core';
import { Global } from '../../Global';
import FormatUtils from '../../utils/FormatUtils';
export class MachineCapability extends React.Component {
    constructor(props) {
        super(props);
        this._isMounted = false;
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('MachineCapabilitiesRender (' + new Date().getSeconds() + ')');
            const machine = this.props.machine;
            return (React.createElement(React.Fragment, null,
                machine.graphicsNumCards > 0 && (React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { margin: '6px' } },
                        React.createElement(Header, { title: 'GPU', align: 'left' }),
                        machine.graphicsCardType !== 'None' && React.createElement(Label, { align: 'left', getValue: () => machine.graphicsCardType, label: 'Type' }),
                        machine.graphicsNumCards > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.graphicsNumCards, label: 'Count' }),
                        Global.user.userExpertise >= 2 && machine.graphicsCores > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.graphicsCores, label: 'Cores' }),
                        Global.user.userExpertise >= 2 && machine.graphicsScore > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.graphicsScore, label: 'Score' }),
                        Global.user.userExpertise >= 2 && machine.graphicsFrequency > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.graphicsFrequency, label: 'Frequency', styledUnitValue: FormatUtils.styleFrequencyUnitValue() })),
                    React.createElement(Divider, { variant: 'middle' }))),
                machine.computeCores > 0 && (React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { margin: '6px' } },
                        React.createElement(Header, { title: 'CPU', align: 'left' }),
                        machine.computeCores > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.computeCores, label: 'Cores' }),
                        Global.user.userExpertise >= 2 && machine.computeScore > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.computeScore, label: 'Score' }),
                        Global.user.userExpertise >= 2 && machine.computeFrequency > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.computeFrequency, label: 'Frequency', styledUnitValue: FormatUtils.styleFrequencyUnitValue() })),
                    React.createElement(Divider, { variant: 'middle' }))),
                machine.memorySize > 0 && (React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { margin: '6px' } },
                        React.createElement(Header, { title: 'RAM', align: 'left' }),
                        machine.memorySize > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.memorySize, label: 'Size', styledUnitValue: FormatUtils.styleCapacityUnitValue() })),
                    React.createElement(Divider, { variant: 'middle' }))),
                machine.storageSize > 0 && (React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { margin: '6px' } },
                        React.createElement(Header, { title: 'DSK', align: 'left' }),
                        machine.storageSize > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.storageSize, label: 'Size', styledUnitValue: FormatUtils.styleCapacityUnitValue() }),
                        Global.user.userExpertise >= 2 && machine.storageIops > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.storageIops, label: 'IOPS' }),
                        Global.user.userExpertise >= 2 && machine.storageThroughput > 0 && React.createElement(Label, { align: 'left', getValue: () => machine.storageThroughput, label: 'Throughput', styledUnitValue: FormatUtils.styleThroughputUnitValue() })),
                    React.createElement(Divider, { variant: 'middle' })))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.componentDidMount = () => {
            this._isMounted = true;
        };
        this.componentWillUnmount = () => {
            this._isMounted = false;
        };
        this.state = {};
    }
}
