/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { IdentityMachineComponent } from './IdentityMachineComponent';
import { MachineComponent } from './MachineComponent';
import { PopupMachineComponent } from './PopupMachineComponent';
import { RecommendedMachineComponent } from './RecommendedMachineComponent';
export class Machine {
    constructor() {
        this.computeCores = 0;
        this.computeFrequency = 0;
        this.computeRating = 0;
        this.computeScore = 0;
        this.graphicsCardType = 'None';
        this.graphicsCores = 0;
        this.graphicsFrequency = 0;
        this.graphicsMemory = 0;
        this.graphicsNumCards = 0;
        this.graphicsRating = 0;
        this.graphicsScore = 0;
        this.memoryRating = 0;
        this.memorySize = 0;
        this.storageRating = 0;
        this.storageSize = 0;
        this.storageIops = 0;
        this.storageThroughput = 0;
    }
    getComponent() {
        return React.createElement(MachineComponent, { key: this.uuid, machine: this });
    }
    getRecommendedComponent(order) {
        return React.createElement(RecommendedMachineComponent, { key: this.uuid + order, machine: this, order: order });
    }
    getIdentityComponent() {
        return React.createElement(IdentityMachineComponent, { key: this.uuid, machine: this });
    }
    getPopupComponent() {
        return React.createElement(PopupMachineComponent, { key: this.uuid, machine: this });
    }
    static getStateMessage(state) {
        switch (state) {
            case 'requisition requested':
            case 'requisition in progress':
                return 'Acquiring...';
            case 'requisition completed':
            case 'setup completed':
                return 'Ready';
            case 'teardown requested':
            case 'sequestration requested':
            case 'sequestration in progress':
            case 'sequestration completed':
                return 'Releasing...';
            case 'unused':
            default:
                return '';
        }
    }
}
export class NoMachine extends Machine {
}
