import * as React from 'react';
import { IdentityMachineComponent } from './IdentityMachineComponent';
import { MachineComponent } from './MachineComponent';
import { PopupMachineComponent } from './PopupMachineComponent';
import { RecommendedMachineComponent } from './RecommendedMachineComponent';
export declare class Machine {
    computeCores: number;
    computeFrequency: number;
    computeRating: number;
    computeScore: number;
    graphicsCardType: string;
    graphicsCores: number;
    graphicsFrequency: number;
    graphicsMemory: number;
    graphicsNumCards: number;
    graphicsRating: number;
    graphicsScore: number;
    memoryRating: number;
    memorySize: number;
    storageRating: number;
    storageSize: number;
    storageIops: number;
    storageThroughput: number;
    uuid: string;
    name: string;
    rate: number;
    state: string;
    getComponent(): React.CElement<any, MachineComponent>;
    getRecommendedComponent(order: number): React.CElement<any, RecommendedMachineComponent>;
    getIdentityComponent(): React.CElement<any, IdentityMachineComponent>;
    getPopupComponent(): React.CElement<any, PopupMachineComponent>;
    static getStateMessage(state: string): string;
}
export declare class NoMachine extends Machine {
}
