/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { App } from './App';
import { AppTracker } from './AppTracker';
import { ServerConnection } from '@jupyterlab/services';
import { Signal } from '@lumino/signaling';
import { Machines } from './Machines';
import { Machine } from './machine/Machine';
import { Page } from '../components/deploy/RequirementsBar';
export class User {
    constructor(unsignedAgreement, name, intent, userBudget, maxBudget, budgetCap, userRate, maxRate, rateCap, userAggregateRate, maxAggregateRate, aggregateRateCap, userHoldoverTime, maxHoldoverTime, holdoverTimeCap, userRecommendations, maxRecommendations, recommendationsCap, maxJobs, jobsCap, maxMachines, machinesCap, userExpertise, proactiveUploadsEnabled, compressFilesEnabled, lastPage, stopJobPreventEnabled, deleteJobPreventEnabled, noRequirementsPreventEnabled, noFileUploadsPreventEnabled, startSessionPreventEnabled, appTracker, machines) {
        this._deploySubMenuChanged = new Signal(this);
        this._selectedSettingsSubMenuChanged = new Signal(this);
        this._deploySubMenu = Page.RESOURCES;
        this._unsignedAgreement = unsignedAgreement === undefined ? true : unsignedAgreement;
        this._name = name;
        this._intent = intent;
        this._userBudget = userBudget;
        this._maxBudget = maxBudget;
        this._budgetCap = budgetCap;
        this._userRate = userRate;
        this._maxRate = maxRate;
        this._rateCap = rateCap;
        this._userAggregateRate = userAggregateRate;
        this._maxAggregateRate = maxAggregateRate;
        this._aggregateRateCap = aggregateRateCap;
        this._userHoldoverTime = userHoldoverTime;
        this._maxHoldoverTime = maxHoldoverTime;
        this._holdoverTimeCap = holdoverTimeCap;
        this._userRecommendations = userRecommendations;
        this._maxRecommendations = maxRecommendations;
        this._recommendationsCap = recommendationsCap;
        this._maxJobs = maxJobs;
        this._jobsCap = jobsCap;
        this._maxMachines = maxMachines;
        this._machinesCap = machinesCap;
        this._userExpertise = userExpertise;
        this._proactiveUploadsEnabled = proactiveUploadsEnabled;
        this._compressFilesEnabled = compressFilesEnabled;
        this._lastPage = lastPage;
        this._stopJobPreventEnabled = stopJobPreventEnabled;
        this._deleteJobPreventEnabled = deleteJobPreventEnabled;
        this._noRequirementsPreventEnabled = noRequirementsPreventEnabled;
        this._noFileUploadsPreventEnabled = noFileUploadsPreventEnabled;
        this._startSessionPreventEnabled = startSessionPreventEnabled;
        this._appTracker = appTracker;
        this._machines = machines;
    }
    // Helper function to avoid duplicate code when logging in
    static handleLogin(responseData) {
        var machines = [];
        for (var i = 0; i < responseData.machines.length; i++) {
            machines.push(Object.setPrototypeOf(responseData.machines[i], Machine.prototype));
        }
        const newUser = new User(responseData.newAgreement, responseData.name, responseData.intent, responseData.userBudget, responseData.maxBudget, responseData.budgetCap, responseData.userRate, responseData.maxRate, responseData.rateCap, responseData.userAggregateRate, responseData.maxAggregateRate, responseData.aggregateRateCap, responseData.userHoldoverTime, responseData.maxHoldoverTime, responseData.holdoverTimeCap, responseData.userRecommendations, responseData.maxRecommendations, responseData.recommendationsCap, responseData.maxJobs, responseData.jobsCap, responseData.maxMachines, responseData.machinesCap, responseData.userExpertise, responseData.proactiveUploadsEnabled, responseData.compressFilesEnabled, responseData.lastPage, responseData.stopJobPreventEnabled, responseData.deleteJobPreventEnabled, responseData.noRequirementsPreventEnabled, responseData.noFileUploadsPreventEnabled, responseData.startSessionPreventEnabled, new AppTracker(), new Machines(machines, responseData.maxRate));
        if (!newUser.unsignedAgreement)
            newUser.synchronize(responseData);
        return newUser;
    }
    get deploySubMenuChanged() {
        return this._deploySubMenuChanged;
    }
    get selectedSettingsSubMenuChanged() {
        return this._selectedSettingsSubMenuChanged;
    }
    get unsignedAgreement() {
        return this._unsignedAgreement;
    }
    set unsignedAgreement(unsignedAgreement) {
        if (unsignedAgreement === this._unsignedAgreement) {
            return;
        }
        this._unsignedAgreement = unsignedAgreement;
    }
    get name() {
        return this._name;
    }
    set name(name) {
        if (name === this._name) {
            return;
        }
        this._name = name;
    }
    get deploySubMenu() {
        return this._deploySubMenu;
    }
    set deploySubMenu(deploySubMenu) {
        if (deploySubMenu === this._deploySubMenu) {
            return;
        }
        this._deploySubMenu = deploySubMenu;
        this._deploySubMenuChanged.emit(this);
    }
    get intent() {
        return this._intent;
    }
    set intent(intent) {
        if (intent === this._intent) {
            return;
        }
        this._intent = intent;
        this.setUserInformation("intent", intent.toString());
    }
    get userBudget() {
        return this._userBudget;
    }
    set userBudget(userBudget) {
        if (userBudget === this._userBudget) {
            return;
        }
        this._userBudget = userBudget;
        this.setUserInformation("userBudget", userBudget.toString());
    }
    get maxBudget() {
        return this._maxBudget;
    }
    set maxBudget(maxBudget) {
        if (maxBudget === this._maxBudget) {
            return;
        }
        this._maxBudget = maxBudget;
        this.setUserInformation("maxBudget", maxBudget.toString());
    }
    get budgetCap() {
        return this._budgetCap;
    }
    get userRate() {
        return this._userRate;
    }
    set userRate(userRate) {
        if (userRate === this._userRate) {
            return;
        }
        this._userRate = userRate;
        this.setUserInformation("userRate", userRate.toString());
    }
    get maxRate() {
        return this._maxRate;
    }
    set maxRate(maxRate) {
        if (maxRate === this._maxRate) {
            return;
        }
        this._maxRate = maxRate;
        this.setUserInformation("maxRate", maxRate.toString());
    }
    get rateCap() {
        return this._rateCap;
    }
    get userAggregateRate() {
        return this._userAggregateRate;
    }
    set userAggregateRate(userAggregateRate) {
        if (userAggregateRate === this._userAggregateRate) {
            return;
        }
        this._userAggregateRate = userAggregateRate;
        this.setUserInformation("userAggregateRate", userAggregateRate.toString());
    }
    get maxAggregateRate() {
        return this._maxAggregateRate;
    }
    set maxAggregateRate(maxAggregateRate) {
        if (maxAggregateRate === this._maxAggregateRate) {
            return;
        }
        this._maxAggregateRate = maxAggregateRate;
        this.setUserInformation("maxAggregateRate", maxAggregateRate.toString());
    }
    get aggregateRateCap() {
        return this._aggregateRateCap;
    }
    get userHoldoverTime() {
        return this._userHoldoverTime;
    }
    set userHoldoverTime(userHoldoverTime) {
        if (userHoldoverTime === this._userHoldoverTime) {
            return;
        }
        this._userHoldoverTime = userHoldoverTime;
        this.setUserInformation("userHoldoverTime", userHoldoverTime.toString());
    }
    get maxHoldoverTime() {
        return this._maxHoldoverTime;
    }
    set maxHoldoverTime(maxHoldoverTime) {
        if (maxHoldoverTime === this._maxHoldoverTime) {
            return;
        }
        this._maxHoldoverTime = maxHoldoverTime;
        this.setUserInformation("maxHoldoverTime", maxHoldoverTime.toString());
    }
    get holdoverTimeCap() {
        return this._holdoverTimeCap;
    }
    get userRecommendations() {
        return this._userRecommendations;
    }
    set userRecommendations(userRecommendations) {
        if (userRecommendations === this._userRecommendations) {
            return;
        }
        this._userRecommendations = userRecommendations;
        this.setUserInformation("userRecommendations", userRecommendations.toString());
    }
    get maxRecommendations() {
        return this._maxRecommendations;
    }
    set maxRecommendations(maxRecommendations) {
        if (maxRecommendations === this._maxRecommendations) {
            return;
        }
        this._maxRecommendations = maxRecommendations;
        this.setUserInformation("maxRecommendations", maxRecommendations.toString());
    }
    get recommendationsCap() {
        return this._recommendationsCap;
    }
    get maxJobs() {
        return this._maxJobs;
    }
    set maxJobs(maxJobs) {
        if (maxJobs === this._maxJobs) {
            return;
        }
        this._maxJobs = maxJobs;
        this.setUserInformation("maxJobs", maxJobs.toString());
    }
    get jobsCap() {
        return this._jobsCap;
    }
    get maxMachines() {
        return this._maxMachines;
    }
    set maxMachines(maxMachines) {
        if (maxMachines === this._maxMachines) {
            return;
        }
        this._maxMachines = maxMachines;
        this.setUserInformation("maxMachines", maxMachines.toString());
    }
    get machinesCap() {
        return this._machinesCap;
    }
    get userExpertise() {
        return this._userExpertise;
    }
    set userExpertise(userExpertise) {
        if (userExpertise === this._userExpertise) {
            return;
        }
        this._userExpertise = userExpertise;
        this.setUserInformation("userExpertise", userExpertise.toString());
    }
    get proactiveUploadsEnabled() {
        return this._proactiveUploadsEnabled;
    }
    set proactiveUploadsEnabled(proactiveUploadsEnabled) {
        if (proactiveUploadsEnabled === this._proactiveUploadsEnabled) {
            return;
        }
        this._proactiveUploadsEnabled = proactiveUploadsEnabled;
        this.setUserInformation("proactiveUploadsEnabled", proactiveUploadsEnabled.toString());
    }
    get compressFilesEnabled() {
        return this._compressFilesEnabled;
    }
    set compressFilesEnabled(compressFilesEnabled) {
        if (compressFilesEnabled === this._compressFilesEnabled) {
            return;
        }
        this._compressFilesEnabled = compressFilesEnabled;
        this.setUserInformation("compressFilesEnabled", compressFilesEnabled.toString());
    }
    get lastPage() {
        return this._lastPage;
    }
    set lastPage(lastPage) {
        if (lastPage === this.lastPage) {
            return;
        }
        this._lastPage = lastPage;
        this.setUserInformation("lastPage", lastPage.toString());
    }
    get stopJobPreventEnabled() {
        return this._stopJobPreventEnabled;
    }
    set stopJobPreventEnabled(stopJobPreventEnabled) {
        if (stopJobPreventEnabled === this._stopJobPreventEnabled) {
            return;
        }
        this._stopJobPreventEnabled = stopJobPreventEnabled;
        this.setUserInformation("stopJobPreventEnabled", stopJobPreventEnabled.toString());
    }
    get deleteJobPreventEnabled() {
        return this._deleteJobPreventEnabled;
    }
    set deleteJobPreventEnabled(deleteJobPreventEnabled) {
        if (deleteJobPreventEnabled === this._deleteJobPreventEnabled) {
            return;
        }
        this._deleteJobPreventEnabled = deleteJobPreventEnabled;
        this.setUserInformation("deleteJobPreventEnabled", deleteJobPreventEnabled.toString());
    }
    get noRequirementsPreventEnabled() {
        return this._noRequirementsPreventEnabled;
    }
    set noRequirementsPreventEnabled(noRequirementsPreventEnabled) {
        if (noRequirementsPreventEnabled === this._noRequirementsPreventEnabled) {
            return;
        }
        this._noRequirementsPreventEnabled = noRequirementsPreventEnabled;
        this.setUserInformation("noRequirementsPreventEnabled", noRequirementsPreventEnabled.toString());
    }
    get noFileUploadsPreventEnabled() {
        return this._noFileUploadsPreventEnabled;
    }
    set noFileUploadsPreventEnabled(noFileUploadsPreventEnabled) {
        if (noFileUploadsPreventEnabled === this._noFileUploadsPreventEnabled) {
            return;
        }
        this._noFileUploadsPreventEnabled = noFileUploadsPreventEnabled;
        this.setUserInformation("noFileUploadsPreventEnabled", noFileUploadsPreventEnabled.toString());
    }
    get startSessionPreventEnabled() {
        return this._startSessionPreventEnabled;
    }
    set startSessionPreventEnabled(startSessionPreventEnabled) {
        if (startSessionPreventEnabled === this._startSessionPreventEnabled) {
            return;
        }
        this._startSessionPreventEnabled = startSessionPreventEnabled;
        this.setUserInformation("startSessionPreventEnabled", startSessionPreventEnabled.toString());
    }
    get appTracker() {
        return this._appTracker;
    }
    set machines(machines) {
        if (machines === this._machines) {
            return;
        }
        this._machines = machines;
    }
    get machines() {
        return this._machines;
    }
    synchronize(responseData) {
        // Add apps from user information if they don't already exist
        if (responseData.jobs) {
            NEW_APPS: for (let newApp of responseData.jobs) {
                // Ignore this app if we already have an object for it
                for (let app of this.appTracker.finishedSessions) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.finishedJobs) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.activeSessions) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                for (let app of this.appTracker.activeJobs) {
                    if (app.uuid == newApp.uuid)
                        continue NEW_APPS;
                }
                this.appTracker.addApp(App.reconstruct(newApp));
            }
        }
    }
    setUserInformation(param, value) {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/set-user-information";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'param': param,
                'value': value,
            })
        };
        ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                throw new ServerConnection.ResponseError(response);
            }
        });
    }
    changePassword(loginName, oldPassword, newPassword) {
        const settings = ServerConnection.makeSettings();
        const url = settings.baseUrl + "optumi/change-password";
        const init = {
            method: 'POST',
            body: JSON.stringify({
                'loginName': loginName,
                'oldPassword': oldPassword,
                'newPassword': newPassword,
            })
        };
        return ServerConnection.makeRequest(url, init, settings).then((response) => {
            if (response.status !== 200 && response.status !== 201) {
                throw new ServerConnection.ResponseError(response);
            }
        });
    }
}
