import { ISignal } from '@lumino/signaling';
import { Update } from './Update';
import { OutputFile } from './OutputFile';
import { Machine } from './machine/Machine';
export declare enum Status {
    Initializing = 0,
    Running = 1,
    Completed = 2
}
export declare class Module {
    private _changed;
    get changed(): ISignal<this, Module>;
    private _sessionReady;
    get sessionReady(): boolean;
    private addOutput;
    private readonly _uuid;
    private readonly _workloadUUID;
    private _sessionToken;
    private _sessionPort;
    private _machine;
    private _output;
    private _files;
    private _updates;
    private _polling;
    constructor(uuid: string, workloadUUID: string, addOutput: (line: string, modifier: string) => void, machine?: Machine, sessionToken?: string, output?: Update[], updates?: string[], files?: OutputFile[]);
    get uuid(): string;
    get sessionToken(): string;
    get sessionPort(): string;
    get machine(): Machine;
    get output(): Update[];
    get files(): OutputFile[];
    get modStatus(): Status;
    get error(): boolean;
    private receiveUpdate;
    pushModuleInput: (line: string) => void;
    startPolling(interactive?: boolean): void;
    stopPolling(interactive?: boolean): void;
}
