/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Signal } from '@lumino/signaling';
import { GraphicsCard } from './GraphicsCard';
export class Machines {
    constructor(machines, maxCost) {
        this._changed = new Signal(this);
        // Max compute values
        this.absoluteComputeMaxCores = 0;
        this.absoluteComputeMaxScore = 0;
        this.absoluteComputeMaxFrequency = 0;
        // Max graphics values
        this.absoluteGraphicsMaxScore = 0;
        this.absoluteGraphicsMaxCores = 0;
        this.absoluteGraphicsMaxMemory = 0;
        this.absoluteGraphicsMaxFrequency = 0;
        this.absoluteGraphicsMaxCards = [];
        // Max memory values
        this.absoluteMemoryMaxSize = 0;
        // Max storage values
        this.absoluteStorageMaxSize = 0;
        this.absoluteStorageMaxIops = 0;
        this.absoluteStorageMaxThroughput = 0;
        // Min compute values
        this.absoluteComputeMinCores = 0;
        this.absoluteComputeMinScore = 0;
        this.absoluteComputeMinFrequency = 0;
        // Min graphics values
        this.absoluteGraphicsMinScore = 0;
        this.absoluteGraphicsMinCores = 0;
        this.absoluteGraphicsMinMemory = 0;
        this.absoluteGraphicsMinFrequency = 0;
        // public absoluteGraphicsMinCards: GraphicsCard[] = [];
        // Min memory values
        this.absoluteMemoryMinSize = 0;
        // Min storage values
        this.absoluteStorageMinSize = 0;
        this.absoluteStorageMinIops = 0;
        this.absoluteStorageMinThroughput = 0;
        // The cheapest machine available, so we can adjust the resource cap slider
        this.cheapestMachine = null;
        // The most expensive machine available, incase we want to adjust the max resource cap in the future
        this.mostExpensiveMachine = null;
        // A list of all graphics cards
        this.graphicsCards = [];
        this.inventory = machines;
        this.setAbsoluteMaxResources(maxCost);
        // Global.onUserChange.connect(() => this.setAbsoluteMaxResources());
    }
    get changed() {
        return this._changed;
    }
    //  It is useful for us to know what the cost of the cheapest machine is
    getCheapestMachineCost() {
        if (this.cheapestMachine != null) {
            return this.cheapestMachine.rate;
        }
        return 0;
    }
    getMostExpensiveMachineCost() {
        if (this.mostExpensiveMachine != null) {
            return this.mostExpensiveMachine.rate;
        }
        return 0;
    }
    setAbsoluteMaxResources(maxCost) {
        for (let machine of this.inventory) {
            if (machine.rate > maxCost)
                continue;
            if (machine.graphicsNumCards != 0) {
                // Try to get card from list we have info about
                var graphicsCard = this.absoluteGraphicsMaxCards.filter(x => x.name == machine.graphicsCardType).pop();
                if (graphicsCard) {
                    // If we already have info about the card, add the new info about the card to the old info
                    graphicsCard.addConfig(machine.graphicsNumCards);
                }
                else {
                    // If this is a new card, add it to the list along with its info
                    this.absoluteGraphicsMaxCards.push(new GraphicsCard(machine.graphicsCardType, [machine.graphicsNumCards]));
                }
            }
            var computeCores = machine.computeCores;
            if (computeCores > this.absoluteComputeMaxCores)
                this.absoluteComputeMaxCores = computeCores;
            if (computeCores < this.absoluteComputeMinCores)
                this.absoluteComputeMinCores = computeCores;
            var computeScore = machine.computeScore;
            if (computeScore > this.absoluteComputeMaxScore)
                this.absoluteComputeMaxScore = computeScore;
            if (computeScore < this.absoluteComputeMinScore)
                this.absoluteComputeMinScore = computeScore;
            var computeFrequency = machine.computeFrequency;
            if (computeFrequency > this.absoluteComputeMaxFrequency)
                this.absoluteComputeMaxFrequency = computeFrequency;
            if (computeFrequency < this.absoluteComputeMinFrequency)
                this.absoluteComputeMinFrequency = computeFrequency;
            var graphicsScore = machine.graphicsScore;
            if (graphicsScore > this.absoluteGraphicsMaxScore)
                this.absoluteGraphicsMaxScore = graphicsScore;
            if (graphicsScore < this.absoluteGraphicsMinScore)
                this.absoluteGraphicsMinScore = graphicsScore;
            var graphicsCores = machine.graphicsCores;
            if (graphicsCores > this.absoluteGraphicsMaxCores)
                this.absoluteGraphicsMaxCores = graphicsCores;
            if (graphicsCores < this.absoluteGraphicsMinCores)
                this.absoluteGraphicsMinCores = graphicsCores;
            var graphicsMemory = machine.graphicsMemory;
            if (graphicsMemory > this.absoluteGraphicsMaxMemory)
                this.absoluteGraphicsMaxMemory = graphicsMemory;
            if (graphicsMemory < this.absoluteGraphicsMinMemory)
                this.absoluteGraphicsMinMemory = graphicsMemory;
            var graphicsFrequency = machine.graphicsFrequency;
            if (graphicsFrequency > this.absoluteGraphicsMaxFrequency)
                this.absoluteGraphicsMaxFrequency = graphicsFrequency;
            if (graphicsFrequency < this.absoluteGraphicsMinFrequency)
                this.absoluteGraphicsMinFrequency = graphicsFrequency;
            var memorySize = machine.memorySize;
            if (memorySize > this.absoluteMemoryMaxSize)
                this.absoluteMemoryMaxSize = memorySize;
            if (memorySize < this.absoluteMemoryMinSize)
                this.absoluteMemoryMinSize = memorySize;
            var storageSize = machine.storageSize;
            if (storageSize > this.absoluteStorageMaxSize)
                this.absoluteStorageMaxSize = storageSize;
            if (storageSize < this.absoluteStorageMinSize)
                this.absoluteStorageMinSize = storageSize;
            var storageIops = machine.storageIops;
            if (storageIops > this.absoluteStorageMaxIops)
                this.absoluteStorageMaxIops = storageIops;
            if (storageIops < this.absoluteStorageMinIops)
                this.absoluteStorageMinIops = storageIops;
            var storageThroughput = machine.storageThroughput;
            if (storageThroughput > this.absoluteStorageMaxThroughput)
                this.absoluteStorageMaxThroughput = storageThroughput;
            if (storageThroughput < this.absoluteStorageMinThroughput)
                this.absoluteStorageMinThroughput = storageThroughput;
            var rate = machine.rate;
            if (this.mostExpensiveMachine == null || rate > this.mostExpensiveMachine.rate)
                this.mostExpensiveMachine = machine;
            if (this.cheapestMachine == null || rate < this.cheapestMachine.rate)
                this.cheapestMachine = machine;
        }
    }
}
