import { ISignal } from '@lumino/signaling';
import { GraphicsCard } from './GraphicsCard';
import { Machine } from './machine/Machine';
export declare class Machines {
    inventory: Machine[];
    private _changed;
    get changed(): ISignal<this, Machines>;
    absoluteComputeMaxCores: number;
    absoluteComputeMaxScore: number;
    absoluteComputeMaxFrequency: number;
    absoluteGraphicsMaxScore: number;
    absoluteGraphicsMaxCores: number;
    absoluteGraphicsMaxMemory: number;
    absoluteGraphicsMaxFrequency: number;
    absoluteGraphicsMaxCards: GraphicsCard[];
    absoluteMemoryMaxSize: number;
    absoluteStorageMaxSize: number;
    absoluteStorageMaxIops: number;
    absoluteStorageMaxThroughput: number;
    absoluteComputeMinCores: number;
    absoluteComputeMinScore: number;
    absoluteComputeMinFrequency: number;
    absoluteGraphicsMinScore: number;
    absoluteGraphicsMinCores: number;
    absoluteGraphicsMinMemory: number;
    absoluteGraphicsMinFrequency: number;
    absoluteMemoryMinSize: number;
    absoluteStorageMinSize: number;
    absoluteStorageMinIops: number;
    absoluteStorageMinThroughput: number;
    cheapestMachine: Machine;
    mostExpensiveMachine: Machine;
    graphicsCards: GraphicsCard[];
    constructor(machines: Machine[], maxCost: number);
    getCheapestMachineCost(): number;
    getMostExpensiveMachineCost(): number;
    setAbsoluteMaxResources(maxCost: number): void;
}
