/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Status } from './Module';
import { Signal } from '@lumino/signaling';
export class AppTracker {
    constructor() {
        this._apps = [];
        this._appsChanged = new Signal(this);
    }
    get appsChanged() {
        return this._appsChanged;
    }
    get activeSessions() {
        return this._apps.filter((app) => app.getAppStatus() != Status.Completed && app.interactive);
    }
    get finishedSessions() {
        return this._apps.filter((app) => app.getAppStatus() == Status.Completed && app.interactive);
    }
    get activeJobs() {
        return this._apps.filter((app) => app.getAppStatus() != Status.Completed && !app.interactive);
    }
    get finishedJobs() {
        return this._apps.filter((app) => app.getAppStatus() == Status.Completed && !app.interactive);
    }
    addApp(app) {
        this._apps.unshift(app);
        this._appsChanged.emit(this._apps);
        app.changed.connect(() => this._appsChanged.emit(this._apps), this);
    }
    removeApp(uuid) {
        var app = this._apps.filter((app) => app.uuid == uuid)[0];
        for (let module of app.modules) {
            module.stopPolling(app.interactive);
        }
        app.stopPolling();
        this._apps = this._apps.filter((app) => app.uuid != uuid);
        app.changed.disconnect(() => this._appsChanged.emit(this._apps), this);
        this._appsChanged.emit(this._apps);
    }
    getDisplayNum() {
        return this._apps.filter((app) => app.getAppStatus() != Status.Completed).length;
    }
}
