/// <reference types="node" />
import * as React from 'react';
import { ProgressMessage } from './ProgressMessage';
import { Module, Status } from './Module';
import { ISignal } from '@lumino/signaling';
import { AppTracker } from './AppTracker';
import { Machine } from './machine/Machine';
import { Update } from './Update';
export declare enum Phase {
    Initializing = "initializing",
    Uploading = "uploading",
    Requisitioning = "requisitioning",
    Running = "running"
}
export declare class App {
    private _changed;
    get changed(): ISignal<this, App>;
    private _notebook;
    private _interactive;
    private formatForNotebook;
    private addOutput;
    private readonly _script;
    private _name;
    private _uuid;
    private _modules;
    private _initializing;
    private _uploading;
    private _requisitioning;
    private _running;
    private _timestamp;
    private _polling;
    constructor(name: string, notebook: any, script: string, uuid?: string, initializing?: Update[], uploading?: Update[], requisitioning?: Update[], running?: Update[], timestamp?: Date);
    static reconstruct(appMap: any): App;
    get script(): string;
    get notebook(): any;
    get name(): string;
    get uuid(): string;
    get modules(): Module[];
    get initializing(): ProgressMessage;
    get uploading(): ProgressMessage;
    get requisitioning(): ProgressMessage;
    get running(): ProgressMessage;
    get timestamp(): Date;
    get failed(): boolean;
    get interactive(): boolean;
    get sessionToken(): string;
    get sessionPort(): string;
    get machine(): Machine;
    addModule(mod: Module): void;
    previewNotebook(printRecommendations: boolean): Promise<Machine[]>;
    setupNotebook(appTracker: AppTracker): Promise<void>;
    private getLaunchStatus;
    private getCompressionProgress;
    private getUploadProgress;
    private launchNotebook;
    getAppStatus(): Status;
    getAppMessage(): string;
    getTimeElapsed(): string;
    getEndTime(): Date;
    getCost(): string;
    getShowLoading(): boolean;
    getPercentLoaded(): number;
    getLoadingTooltip(): string;
    getError(): boolean;
    private receiveUpdate;
    startPolling(): void;
    stopPolling(): void;
    getComponent(): React.CElement<IProps, AppComponent>;
    private formatTime;
    getIdentityComponent(): JSX.Element;
}
interface IProps {
    app: App;
}
interface IState {
    waiting: boolean;
    spinning: boolean;
    showDeleteJobPopup: boolean;
    showStopJobPopup: boolean;
}
declare class AppComponent extends React.Component<IProps, IState> {
    _isMounted: boolean;
    constructor(props: IProps);
    private getDeleteJobPreventValue;
    private saveDeleteJobPreventValue;
    private handleDeleteClicked;
    private getStopJobPreventValue;
    private saveStopJobPreventValue;
    private handleStopClicked;
    private getStatusColor;
    render: () => JSX.Element;
    shouldComponentUpdate: (nextProps: IProps, nextState: IState) => boolean;
    private checkAndSetState;
    componentDidMount: () => void;
    componentWillUnmount: () => void;
}
export {};
