/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import Ansi from 'ansi-to-react';
import * as React from 'react';
export default class OutputArea extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            let i = 0;
            return (React.createElement("div", { className: 'p-Widget lm-Widget jp-Cell-outputWrapper' },
                React.createElement("div", { className: 'p-Widget lm-Widget jp-OutputArea jp-Cell-outputArea' },
                    React.createElement("div", { className: 'p-Widget lm-Widget jp-OutputArea-child' },
                        React.createElement("div", { className: 'p-Widget lm-Widget jp-OutputPrompt jp-OutputArea-prompt' }),
                        React.createElement("div", { style: { display: 'block', width: '100%' } }, this.props.cell.outputs.map((output) => (React.createElement("div", { key: i++, "data-mime-type": output.name === 'stderr' || output.output_type === 'error' ? 'application/vnd.jupyter.stderr' : 'application/vnd.jupyter.stdout', className: 'p-Widget lm-Widget jp-RenderedText jp-OutputArea-output' }, output.output_type === 'stream' ? (React.createElement("pre", null, output.text.map((x) => x.replace(/\x08/g, '')))) : output.output_type === 'error' ? (output.traceback.map((line) => (React.createElement("pre", { key: line },
                            React.createElement(Ansi, null, line))))) : output.output_type === 'display_data' ? (React.createElement(React.Fragment, null)) : (React.createElement(React.Fragment, null))))))))));
        };
    }
}
