/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../../Global';
import CodeCell from './CodeCell';
import MarkdownCell from './MarkdownCell';
export default class Notebook extends React.Component {
    constructor() {
        super(...arguments);
        this.componentDidMount = () => {
            // Override the JupyterLab context menu open (disable it)
            this.oldOpen = Global.lab.contextMenu.open;
            Global.lab.contextMenu.open = () => false;
        };
        // Add context menu items back
        this.componentWillUnmount = () => {
            // Restore the old JupyterLab context menu open
            Global.lab.contextMenu.open = this.oldOpen;
        };
        this.render = () => {
            const notebook = this.props.notebook;
            let i = 0;
            return (React.createElement("div", { className: 'p-Widget lm-Widget jp-Notebook jp-NotebookPanel-notebook jp-mod-scrollPastEnd jp-mod-commandMode' }, notebook.cells.map(cell => cell.cell_type === 'code' ? (React.createElement(CodeCell, { key: i++, cell: cell, metadata: notebook.metadata })) : cell.cell_type === 'markdown' ? (React.createElement(MarkdownCell, { key: i++, cell: cell, metadata: notebook.metadata })) : (React.createElement(React.Fragment, null)))));
        };
    }
}
