/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { UnControlled as CodeMirror } from 'react-codemirror2';
export default class Editor extends React.Component {
    constructor() {
        super(...arguments);
        this.render = () => {
            return (React.createElement("div", { className: 'p-Widget lm-Widget jp-Editor jp-CodeMirrorEditor jp-InputArea-editor' },
                React.createElement(CodeMirror, { value: this.props.cell.source, options: {
                        readOnly: 'nocursor',
                        screenReaderLabel: 'jp-mod-readOnly',
                        theme: 'jupyter',
                        mode: this.props.metadata.language_info.name,
                    } })));
        };
    }
}
