/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import { Button, Checkbox, Dialog, DialogActions, DialogContent, DialogTitle, ListItemText, withStyles } from '@material-ui/core';
import * as React from 'react';
import { Header } from './Header';
import { ShadowedDivider } from './ShadowedDivider';
const StyledDialog = withStyles((theme) => ({
    root: {
        margin: '12px',
        padding: '0px',
    },
    paper: {
        backgroundColor: 'var(--jp-layout-color1)',
    },
}))(Dialog);
export default class WarningPopup extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            return (React.createElement(StyledDialog, { disableBackdropClick: true, disableEscapeKeyDown: true, open: this.props.open },
                this.props.headerText &&
                    React.createElement(DialogTitle, { disableTypography: true, style: {
                            backgroundColor: 'var(--jp-layout-color2)',
                            height: '48px',
                            padding: '6px 30px',
                        } },
                        React.createElement(Header, { title: this.props.headerText, style: { lineHeight: '24px' } })),
                React.createElement(ShadowedDivider, null),
                React.createElement("div", { style: { padding: '18px' } },
                    this.props.bodyText &&
                        React.createElement(DialogContent, { style: { padding: '6px 18px' } }, this.props.bodyText),
                    React.createElement(DialogActions, { style: { padding: '12px 6px 6px 6px' } },
                        this.props.preventText &&
                            React.createElement(React.Fragment, null,
                                React.createElement(Checkbox, { checked: this.state.prevent, onClick: () => this.setState({ prevent: !this.state.prevent }) }),
                                React.createElement(ListItemText, { primary: this.props.preventText, style: { marginLeft: '0px' } })),
                        this.props.cancel &&
                            React.createElement(Button, { variant: 'contained', onClick: () => {
                                    this.setState({ prevent: false });
                                    this.props.cancel.onCancel(this.state.prevent);
                                }, color: 'default' }, this.props.cancel.text),
                        React.createElement(this.ContinueButton, { variant: 'contained', onClick: () => this.props.continue.onContinue(this.state.prevent), style: { marginLeft: '18px' } }, this.props.continue.text)))));
        };
        this.state = {
            prevent: false,
        };
        this.ContinueButton = withStyles((theme) => {
            const paletteColor = (() => {
                switch (this.props.continue.color) {
                    case 'primary': return theme.palette.primary;
                    case 'secondary': return theme.palette.secondary;
                    case 'success': return theme.palette.success;
                    case 'error': return theme.palette.error;
                    case 'warning': return theme.palette.warning;
                    case 'info': return theme.palette.info;
                }
            })();
            return ({
                root: {
                    color: paletteColor.contrastText,
                    backgroundColor: paletteColor.main,
                    '&:hover': {
                        backgroundColor: paletteColor.dark,
                        // Reset on touch devices, it doesn't add specificity
                        '@media (hover: none)': {
                            backgroundColor: paletteColor.main,
                        },
                    },
                },
            });
        })(Button);
    }
}
