import * as React from 'react';
import { CSSProperties } from '@material-ui/core/styles/withStyles';
interface IProps {
    style?: CSSProperties;
    label: string;
    labelWidth?: string;
    getValue: () => number;
    saveValue: (value: number) => string | void;
    unitValues: {
        unit: string;
        value: number;
    }[];
    placeholder?: string;
    helperText?: string;
    minValue?: number;
    maxValue?: number;
    onFocus?: (event: React.FocusEvent<HTMLInputElement>) => void;
    onBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
}
interface IState {
    unit: string;
    value: number;
    errorMessage: string;
}
export declare class TextBoxDropdown extends React.Component<IProps, IState> {
    textField: React.RefObject<HTMLInputElement>;
    StyledSelect: any;
    constructor(props: IProps);
    private getStyledSelect;
    private normalize;
    private denormalize;
    private handleValueChange;
    private handleValueFocus;
    private handleValueBlur;
    private handleUnitChange;
    private handleUnitBlur;
    private saveChanges;
    render: () => JSX.Element;
    shouldComponentUpdate: (nextProps: IProps, nextState: IState) => boolean;
}
export {};
