/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import withStyles from '@material-ui/core/styles/withStyles';
import { Button, OutlinedInput, FormControl, InputLabel, InputAdornment, IconButton, FormHelperText } from '@material-ui/core';
import CloseIcon from '@material-ui/icons/Close';
import DoneIcon from '@material-ui/icons/Done';
import VisibilityIcon from '@material-ui/icons/Visibility';
import VisibilityOffIcon from '@material-ui/icons/VisibilityOff';
import LockIcon from '@material-ui/icons/Lock';
export class TextBox extends React.Component {
    constructor(props) {
        super(props);
        this.getStyledOutlinedInput = () => {
            return withStyles({
                input: {
                    fontSize: '12px',
                    padding: '3px 6px 3px 6px',
                },
                adornedEnd: {
                    paddingRight: '0px',
                },
            })(OutlinedInput);
        };
        this.getStyledInputLabel = () => {
            return withStyles({
                root: {
                    fontSize: '12px',
                    backgroundColor: 'var(--jp-layout-color1)',
                    padding: '1px 2px',
                },
                outlined: {
                    transform: 'translate(6px, 6px) scale(1)',
                    '&$shrink': {
                        transform: 'translate(9px, -6px) scale(0.8)',
                    }
                },
                formControl: {
                    transform: 'translate(6px, 6px) scale(1)',
                },
                shrink: {
                    transform: 'translate(9px, -6px) scale(0.8)',
                },
            })(InputLabel);
        };
        // This turns the textbox red if it is not a valid value determined by the unstyle function
        this.handleChange = async (event) => {
            const value = event.currentTarget.value;
            this.setState({ textValue: value });
            if (this.props.unstyleUnitValue == undefined) {
                if (typeof value === 'number') {
                    if (this.props.minValue !== undefined && value < this.props.minValue) {
                        this.setState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && value > this.props.maxValue) {
                        this.setState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.setState({ value: value, invalidTextMessage: '' });
                    }
                }
                else {
                    if (!this.props.editPressRequired)
                        this.setState({ value: value, invalidTextMessage: '' });
                }
            }
            else {
                var unstyledValue = this.props.unstyleUnitValue(value);
                if (!isNaN(unstyledValue)) {
                    if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                        this.setState({ invalidTextMessage: 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue) });
                    }
                    else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                        this.setState({ invalidTextMessage: 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue) });
                    }
                    else {
                        if (!this.props.editPressRequired)
                            this.setState({ value: unstyledValue, invalidTextMessage: '' });
                    }
                }
                else {
                    this.setState({ invalidTextMessage: 'Invalid format' });
                }
            }
        };
        this.startEdit = () => {
            this.setState({ editing: true });
            this.textField.current.disabled = false;
            this.textField.current.focus();
        };
        this.discardChanges = () => {
            this.setState({
                editing: false,
                textValue: this.props.styledUnitValue(this.state.value),
                invalidTextMessage: '',
            });
        };
        // If save clicked, or if unfocused if save not required. Saves value if it is a valid value determined by the unstyle function or lack thereof
        this.saveChanges = () => {
            var invalidTextMessage = '';
            var unstyledValue = this.state.textValue;
            if (this.props.unstyleUnitValue != undefined) {
                unstyledValue = this.props.unstyleUnitValue(this.state.textValue);
                if (isNaN(unstyledValue)) {
                    invalidTextMessage = 'Invalid format';
                }
                else if (this.props.minValue !== undefined && unstyledValue < this.props.minValue) {
                    invalidTextMessage = 'Minimum value is ' + this.props.styledUnitValue(this.props.minValue);
                }
                else if (this.props.maxValue !== undefined && unstyledValue > this.props.maxValue) {
                    invalidTextMessage = 'Maximum value is ' + this.props.styledUnitValue(this.props.maxValue);
                }
            }
            this.setState({ invalidTextMessage: invalidTextMessage });
            if (invalidTextMessage == '') {
                this.setState({ editing: false, value: unstyledValue, textValue: this.props.styledUnitValue(unstyledValue) });
                var saveReturn = this.props.saveValue(unstyledValue);
                this.setState({ invalidTextMessage: saveReturn == undefined ? '' : saveReturn });
            }
        };
        this.startHover = () => {
            this.setState({ hovered: true });
        };
        this.stopHover = () => {
            this.setState({ hovered: false });
        };
        this.renderPopupButton = (render) => {
            return this.props.editPopup !== undefined ? React.cloneElement(this.props.editPopup, {
                style: {
                    display: render ? 'flex' : 'none',
                },
                onOpen: () => {
                    this.setState({ editing: true });
                },
                onClose: () => {
                    this.setState({ hovered: false, editing: false });
                }
            }) : React.createElement(React.Fragment, null);
        };
        this.renderEditButton = (render) => {
            return (React.createElement(Button, { onClick: this.startEdit, style: {
                    display: render ? 'flex' : 'none',
                    width: '100%',
                    minWidth: '0px',
                    paddingTop: '6px',
                }, variant: "outlined" }, "EDIT"));
        };
        this.renderConfirmCancelButtons = (render) => {
            return (React.createElement(React.Fragment, null,
                React.createElement(Button, { onClick: this.discardChanges, variant: "outlined", color: "primary", style: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopRightRadius: '0px',
                        borderBottomRightRadius: '0px',
                        borderRight: '0px',
                    } },
                    React.createElement(CloseIcon, { style: { width: '20px', height: '20px' } })),
                React.createElement(Button, { onClick: this.saveChanges, variant: "outlined", color: "primary", style: {
                        display: render ? 'flex' : 'none',
                        width: '50%',
                        minWidth: '0px',
                        paddingTop: '6px',
                        borderTopLeftRadius: '0px',
                        borderBottomLeftRadius: '0px',
                    } },
                    React.createElement(DoneIcon, { style: { width: '20px', height: '20px' } }))));
        };
        this.renderLabelOverButton = (render) => {
            return (React.createElement(this.StyledInputLabel, { shrink: true, style: { display: render ? 'flex' : 'none', position: 'absolute' } }, this.props.label));
        };
        this.renderLabel = (render) => {
            return (React.createElement("span", { style: { display: render ? 'inline' : 'none', width: '100%', color: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? 'var(--jp-ui-font-color3)' : 'var(--jp-ui-font-color1)' } }, this.props.label));
        };
        this.handleFocus = (event) => {
            if (this.props.onFocus) {
                this.props.onFocus(event);
            }
        };
        this.handleBlur = (event) => {
            if (this.props.onBlur) {
                this.props.onBlur(event);
            }
            if (!(this.props.editPressRequired || this.props.editPopup !== undefined)) {
                this.saveChanges();
            }
        };
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('ResourceTextBoxRender (' + new Date().getSeconds() + ')');
            var showPopupButton = false, showEditButton = false, showConfirmCancelButtons = false, showLabel = false;
            // There should never be an if without an else. That could lead to nothing being rendered to the left of the textbox
            if (this.props.editPopup === undefined && !this.props.editPressRequired) {
                showLabel = true;
            }
            else if (!this.state.hovered && !this.state.editing) {
                showLabel = true;
            }
            else {
                if (this.props.editPopup !== undefined) {
                    showPopupButton = true;
                }
                else {
                    if (this.state.editing) {
                        showConfirmCancelButtons = true;
                    }
                    else {
                        showEditButton = true;
                    }
                }
            }
            return (React.createElement("div", { style: Object.assign({ display: 'inline-flex', width: '100%', padding: '6px 0px' }, this.props.style), onMouseOver: this.startHover, onMouseOut: this.stopHover },
                React.createElement("div", { style: {
                        display: 'flex',
                        position: 'relative',
                        minWidth: this.props.labelWidth || '68px',
                        maxWidth: this.props.labelWidth || '68px',
                        height: '24px',
                        margin: '0px 12px',
                        lineHeight: '24px',
                        textAlign: 'center',
                    } },
                    this.renderLabel(showLabel),
                    this.renderPopupButton(showPopupButton),
                    this.renderEditButton(showEditButton),
                    this.renderConfirmCancelButtons(showConfirmCancelButtons),
                    this.renderLabelOverButton(!showLabel)),
                React.createElement(FormControl, { title: this.state.invalidTextMessage, error: this.state.invalidTextMessage != '', variant: 'outlined', style: { width: '100%', margin: '2px 6px', height: this.props.helperText ? '32px' : '20px' } },
                    React.createElement(this.StyledOutlinedInput, { inputRef: this.textField, value: this.state.textValue, placeholder: this.props.placeholder, disabled: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ||
                            (this.props.editPressRequired && !this.state.editing) ||
                            this.props.editPopup !== undefined, onChange: this.handleChange, onKeyDown: (event) => { if (event.key == 'Enter' || event.key == 'Escape')
                            this.textField.current.blur(); }, onFocus: this.handleFocus, onBlur: this.handleBlur, type: this.props.password && this.state.hidePassword ? 'password' : 'text', endAdornment: !(this.props.disabledMessage == undefined || this.props.disabledMessage == '') ? (React.createElement(InputAdornment, { position: "end", title: this.props.disabledMessage, style: { height: '20px', margin: '0px 3px 0px 0px' } },
                            React.createElement(IconButton, { disabled: true, style: { padding: '3px 3px 3px 0px' } },
                                React.createElement(LockIcon, { style: { width: '14px', height: '14px' } })))) : this.props.password && (React.createElement(InputAdornment, { position: "end", title: this.state.hidePassword ? 'Show Password' : 'Hide Password', style: { height: '20px', margin: '0px 3px 0px 0px' } },
                            React.createElement(IconButton, { onClick: () => this.setState({ hidePassword: !this.state.hidePassword }), style: { padding: '3px 3px 3px 0px' } }, this.state.hidePassword ? (React.createElement(VisibilityOffIcon, { style: { width: '14px', height: '14px' } })) : (React.createElement(VisibilityIcon, { style: { width: '14px', height: '14px' } }))))) }),
                    this.props.helperText &&
                        React.createElement(FormHelperText, { style: { fontSize: '10px', lineHeight: '10px', margin: '4px 6px', whiteSpace: 'nowrap' } }, this.props.helperText))));
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledOutlinedInput = this.getStyledOutlinedInput();
        this.StyledInputLabel = this.getStyledInputLabel();
        this.textField = React.createRef();
        const value = this.props.getValue();
        this.state = {
            value: value,
            textValue: this.props.styledUnitValue(value),
            editing: false,
            hovered: false,
            invalidTextMessage: '',
            hidePassword: true,
        };
    }
}
TextBox.defaultProps = {
    styledUnitValue: (value) => { return value.toString(); },
};
