import * as React from 'react';
import { CSSProperties } from '@material-ui/core/styles/withStyles';
interface IProps<T> {
    style?: CSSProperties;
    label: string;
    labelWidth?: string;
    getValue: () => T;
    saveValue: (value: T) => string | void;
    editPressRequired?: boolean;
    editPopup?: JSX.Element;
    disabledMessage?: string;
    password?: boolean;
    placeholder?: string;
    styledUnitValue?: (value: T) => string;
    unstyleUnitValue?: (value: string) => T;
    minValue?: T;
    maxValue?: T;
    helperText?: string;
    onFocus?: (event: React.FocusEvent<HTMLInputElement>) => void;
    onBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
}
interface IState<T> {
    value: T;
    textValue: string;
    editing: boolean;
    invalidTextMessage: string;
    hovered: boolean;
    hidePassword: boolean;
}
export declare class TextBox<T> extends React.Component<IProps<T>, IState<T>> {
    StyledOutlinedInput: any;
    StyledInputLabel: any;
    textField: React.RefObject<HTMLInputElement>;
    static defaultProps: Partial<IProps<any>>;
    constructor(props: IProps<T>);
    private getStyledOutlinedInput;
    private getStyledInputLabel;
    private handleChange;
    private startEdit;
    private discardChanges;
    private saveChanges;
    private startHover;
    private stopHover;
    private renderPopupButton;
    private renderEditButton;
    private renderConfirmCancelButtons;
    private renderLabelOverButton;
    private renderLabel;
    private handleFocus;
    private handleBlur;
    render: () => JSX.Element;
    shouldComponentUpdate: (nextProps: IProps<any>, nextState: IState<any>) => boolean;
}
export {};
