/*
**  Copyright (C) Optumi Inc - All rights reserved.
**
**  You may only use this code under license with Optumi Inc and any distribution or modification is strictly prohibited.
**  To receive a copy of the licensing terms please write to contact@optumi.com or visit us at http://www.optumi.com.
**/
import * as React from 'react';
import { Global } from '../Global';
import { withStyles, Switch as OtherSwitch } from '@material-ui/core';
export const getStyledSwitch = () => {
    return withStyles({
        root: {
            width: '42px',
            height: '24px',
            padding: '0px',
        },
        thumb: {
            width: '20px',
            height: '20px',
            padding: '0px',
            margin: '2px',
        },
        switchBase: {
            padding: '0px',
        },
        track: {
            height: '12px',
            width: '34px',
            borderRadius: '6px',
            padding: '0px',
            margin: '6px',
        },
    })(OtherSwitch);
};
export class Switch extends React.Component {
    constructor(props) {
        super(props);
        this.render = () => {
            if (Global.shouldLogOnRender)
                console.log('SwitchRender (' + new Date().getSeconds() + ')');
            return (React.createElement("div", { style: Object.assign({
                    display: 'inline-flex',
                    width: '100%',
                    padding: '6px 0px',
                    direction: this.props.flip ? 'rtl' : 'ltr'
                }, this.props.style), ref: this.props.ref, onMouseOver: this.props.onMouseOver, onMouseOut: this.props.onMouseOut },
                React.createElement("div", { title: this.props.tooltip || '', style: {
                        minWidth: this.props.labelWidth || '68px',
                        lineHeight: '24px',
                        textAlign: 'center',
                        margin: '0px 12px',
                    } },
                    React.createElement(this.StyledSwitch, { color: 'primary', inputProps: { style: { height: '24px' } }, checked: this.state.value, onChange: (event) => {
                            this.setState({ value: event.currentTarget.checked });
                            this.props.saveValue(event.currentTarget.checked);
                        } })),
                React.createElement("div", { style: { width: '100%', textAlign: this.props.flip ? 'right' : 'left', margin: 'auto 6px' } }, this.props.label)));
        };
        this.handleMetadataChange = () => { this.setState({ value: this.props.getValue() }); };
        this.handleThemeChange = () => {
            this.StyledSwitch = getStyledSwitch();
            this.forceUpdate();
        };
        // Will be called automatically when the component is mounted
        this.componentDidMount = () => {
            Global.metadata.getMetadataChanged().connect(this.handleMetadataChange);
            Global.themeManager.themeChanged.connect(this.handleThemeChange);
        };
        // Will be called automatically when the component is unmounted
        this.componentWillUnmount = () => {
            Global.themeManager.themeChanged.disconnect(this.handleThemeChange);
            Global.metadata.getMetadataChanged().disconnect(this.handleMetadataChange);
        };
        this.shouldComponentUpdate = (nextProps, nextState) => {
            try {
                if (JSON.stringify(this.props) != JSON.stringify(nextProps))
                    return true;
                if (JSON.stringify(this.state) != JSON.stringify(nextState))
                    return true;
                if (Global.shouldLogOnRender)
                    console.log('SuppressedRender');
                return false;
            }
            catch (error) {
                return true;
            }
        };
        this.StyledSwitch = getStyledSwitch();
        this.state = { value: this.props.getValue() };
    }
}
