import * as React from 'react';
interface IProps {
    minValue: number;
    maxValue: number;
    getValue: () => number;
    saveValue: (value: number) => void;
    color: string;
    style?: React.CSSProperties;
    label?: string;
    labelWidth?: string;
    styledUnit?: (value: number) => string;
    styledValue?: (value: number) => string;
    unstyledValue?: (value: number, unit: string) => number;
    showUnit?: boolean;
    scale?: (x: number) => number;
    unscale?: (x: number) => number;
    marks?: any[];
    step?: any;
    alwaysDisplayUnit?: boolean;
}
interface IState {
    value: number;
    typing: boolean;
    hovered: boolean;
    weGotADot: string;
}
export declare class Slider extends React.Component<IProps, IState> {
    _isMounted: boolean;
    textField: React.RefObject<HTMLInputElement>;
    StyledSlider: any;
    StyledValueLabel: any;
    StyledOutlinedInput: any;
    StyledInputLabel: any;
    min: number;
    max: number;
    static defaultProps: Partial<IProps>;
    constructor(props: IProps);
    private getStyledSlider;
    private getStyledValueLabel;
    private getStyledOutlinedInput;
    private getStyledInputLabel;
    private ValueLabelComponent;
    private handleTextBoxChange;
    private handleChange;
    private handleChangeCommitted;
    private formatTextForSmallBox;
    private delay;
    private slowDownSaveValue;
    private parseTextAndSetValue;
    private startTyping;
    private stopTyping;
    private startHover;
    private stopHover;
    render: () => JSX.Element;
    private handleMetadataChange;
    private handleThemeChange;
    componentDidMount: () => void;
    componentWillUnmount: () => void;
    shouldComponentUpdate: (nextProps: IProps, nextState: IState) => boolean;
    private checkAndSetState;
}
export {};
